<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;"> 
    <div class="col-md-7  col-sm-7" style="padding:0px">
    
        <div class="form-group">
            <label class="col-lg-3 control-label">CUSTOMER NAME</label>
            <div class="col-lg-3">
                <select id="select_customer" class="form-control select_box"  style="width:100%" onchange = "getCustomerLedgerList()">
                        <option value="">SELECT CUSTOMER</option>
                </select>
            </div> 
        
            <div class="col-lg-2">
                <button type="button" class="btn btn-primary" id="get_customer_ledger_datatable" onclick="getCustomerLedgerList()" >
                    SEARCH
                </button>
            </div>
            
            <div class="col-lg-2">
                <button type="button" class="btn btn-success" id="download_customer_ledger_excel" onclick="getCustomerLedgerExcel()" >
                    <span class="fa fa-file-excel-o" ></span>&nbsp;&nbsp;Download
                </button>
            </div>
	    <div class="col-lg-2">
                <button type="button" class="btn btn-success" id="download_parent_customer_ledger_excel" onclick="getParentCustomerLedgerExcel()" >
                    <span class="fa fa-file-excel-o" ></span>&nbsp;&nbsp;Summary
                </button>
            </div>
        </div>
    </div>
</div>


<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="customerLedgerList_table">
    <thead>
        <tr>
            <th>DATE</th>
            <th>BILL TYPE</th>
            <th>REFERENCE<br> NUMBER</th>
            <th>CREDIT<br> AMOUNT</th>
            <th>DEBIT <br> AMOUNT</th>
            <th>BALANCE<br> AMOUNT</th>	
        </tr>
    </thead>		
</table>

<script>
    getCustomerList()

    function IndianCurrency(rupees){
        
        rupees=parseFloat (rupees)
        
        if(isNaN(rupees) || rupees == 'NaN'){
            return '';
        }
		return rupees.toLocaleString ('en-IN',
										{minimumFractionDigits : 2,
										maximumFractionDigits : 2}
                                    );
                                    
       
	}

  function getCustomerList(){

    $.ajax({
        "url": "<?=base_url()?>Web_api/getVendorList/",
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            
            $.each(data.result, function (i, d) { // loop through data returned from ajax
                var a = '<option value="'+data.result[i].vendor_id+'">'+data.result[i].vendor_name+'</option>';
                $("#select_customer").append(a)
            })
        },
        "error": function (){
            toastr.error("Failed to get Customer List")
        }
    })
}

    function getCustomerLedgerList(){

        var customer_id = $("#select_customer").val()

        if(customer_id == '' || customer_id == null || customer_id == '0'){
            alert('Please Select a Customer');
            return false
        }

        customerLedgerList_table = $('#customerLedgerList_table').DataTable({
                                "paging":true,
                                "destroy":true,
                                "searching":true,
                                "processing": true,
                                "serverSide": false,  
                                "scrollY": 390,
                                "scrollX": true,
                                "scrollCollapse": true,
                                //"autoWidth": false,
                                "aaSorting": [],
                                "ajax": {
                                    "url": "<?php echo base_url(); ?>admin/Ledger/getCustomerLedgerList",
                                    "data": { "customer_id": customer_id},
                                    "type": "GET",
                                    "dataSrc": "data"
                                },
                                "columns": [
                                   
                                    { "data": "date" },	
                                    { "data": "bill_type" },	
                                    { "data": "invoice_no" },
                                    { "data": "",
                                        "render": function(data, type, row){
                                            return IndianCurrency(row.credit)
                                        } 
                                    },
                                    { "data": "",
                                        "render": function(data, type, row){
                                            return IndianCurrency(row.debit)
                                        } 
                                    },
                                    { "data": "",
                                        "render": function(data, type, row){
                                            return IndianCurrency(row.balance)
                                        } 
                                    },
                                ]
                });

       
    }

    function getCustomerLedgerExcel(){

        var customer_id = $("#select_customer").val()

        if(customer_id == '' || customer_id == null || customer_id == '0' || customer_id == 'null'){
            alert("Please select Customer")
            return false
        }

        window.open("<?=base_url()?>admin/Ledger/getCustomerLedgerExcel?customer_id="+customer_id, '_blank')

    }

    function getParentCustomerLedgerExcel(){

        var customer_id = $("#select_customer").val()

        if(customer_id == '' || customer_id == null || customer_id == '0' || customer_id == 'null'){
            alert("Please select Customer")
            return false
        }

        window.open("<?=base_url()?>admin/Ledger/getParentCustomerLedgerExcel?customer_id="+customer_id, '_blank')

    }
</script>