<!DOCTYPE html>
<html>
<meta charset="utf-8">
<title><?= lang('invoice') ?></title>

<head>
    <style type="text/css">
        font-face {
            font-family: "Source Sans Pro", sans-serif;
        }

        .clearfix:after {
            content: "";
            display: table;
            clear: both;
        }

        a {
            color: #0087C3;
            text-decoration: none;
        }

        body {
            color: #222222;
            background: #FFFFFF;
            font-size: 9px;
            font-family: "Source Sans Pro", sans-serif;
            width: 100%;
            margin: 0;
        }

        #header_logo {
            float: left;
        }

        #header_title {
            float: right;
        }

        #client_address p {
            margin: 0;
        }

        #ship_to p {
            margin: 0;
        }


        #client_detail_table td {
            width: 110px;
            border-bottom: 0.5px solid grey;
            text-align: left;
            padding-top: 0;
            padding-bottom: 0;
        }

        .left {
            text-align: left;
        }

        .right {
            text-align: right !important;
        }

        .center {
            text-align: center;
        }

        #invoice_table {
            width: 100%;
            margin-left: 2px;
            margin-right: 2px;
        }

        #invoice_table th,
        td,
        tr {
            border-bottom: 0.5px solid grey;
            padding-top: 4px;
            padding-bottom: 2px;
            margin: 0;
        }

        #invoice_table .footer_table {
            font-weight: bold;
        }

        #invoice_table th {
            border-top: 0.5px solid grey;
        }

        header {
            position: fixed;
            top: -20px;
            left: 0px;
            right: 0px;
            height: 20px;
            width: 100%;

        }

        footer {
            position: fixed;
            bottom: 0;
            left: 0px;
            right: 0px;
            height: 20px;
            border-top: 1px solid #AAAAAA;
            color: #777777;
            width: 100%;
            padding: 8px 0;
            text-align: center;
        }

        .rupee::before {
            padding-left: 5px;
            white-space: nowrap;
        }


        .footer_margin {
            margin-bottom: 0;
            margin-left: 1px;
            position: absolute;
            bottom: 0;
            float: right;
            font-size: 12px;
        }

        .signature {
            margin-bottom: 40px;
            margin-left: 1px;
            position: absolute;
            bottom: 0;
            float: right;
            font-size: 12px;
        }

        .container td {
            border-bottom: none;
        }
        .uppercase {
            text-transform: uppercase;
        }

        .hidden {
             display: none !important;
        }
    </style>
</head>

<body>
    <header>

    </header>

    <footer id="footer"><span style="font-weight:bold;">SLOYD VENTURES (P) LTD,</span> <?php echo $billing_from_address['address'] ?>, IN.<p style="margin:0;">|| CIN: U52390TG2012PTC083950 | PAN: AASCS2801C | Tel: +91-40-27900059 | Email: accounts@sloyd.in | web: www.sloyd.in ||</p>
    </footer>
    <div class="footmargin"></div>
    <table id="heading" style="text-align:center;width:100%;border-bottom:none;margin-top:-30px;">
        <!-- <div id="header_logo"> -->
        <tr style="border-bottom:none;">
            <td style="align-content:left;text-align:left;border-bottom:none;"><img src="<?php base_url(); ?>assets/img/logo_invoice.png" height="50px" width="140px"></td>
            <!-- </div>
            <div style="display:inline;font-size:20px;font-weight:700;padding-top:100px"> -->
            <td style="text-align:left;border-bottom:none;">
                <h1>Tax Invoice</h1>
            </td>
            <!-- </div>
            <div id="header_title" style="font-size:20px;font-weight:700;"> -->
            <td style="border-bottom:none;">
                <div style="font-size:14px;font-weight:700;text-align:right;"><?= $type ?></div>
            </td>
        </tr>
        <!-- </div> -->
    </table>
    <table class="container" style="width:100%;">
        <tr>
            <td style="width:30%;vertical-align:top;">
                <div id="client_address">
                    <p class="uppercase">
                        <span style="font-weight:bold;">Billing From</span><br>
                    <p>SLOYD VENTURES (P) LTD</p>
                    <!--<p> 1-11-251/19A. 4th Floor, Jayalakshmi Towers</p>-->
                    <!--<p> Motilal Nehru Nagar, Begumpet</p>-->
                    <!--<p>Hyderabad</p>-->
                    <!--<p>Telangana</p>-->
                    <!--<p>INDIA 500016</p>-->
                    <!--<p>GST  CIN: U52390TG2012PTC083950</p>-->
                    <!--<p>PAN AASCS2801C</p>-->
                    
                    <p class="uppercase"> <?php echo $billing_from_address['address'] ?></p>
                    <p class="uppercase">INDIA</p>
                    <p class="uppercase">GST  CIN: U52390TG2012PTC083950</p>
                    <p class="uppercase">PAN AASCS2801C</p>
                    
                </div>
            </td>
            <td style="width:30%;vertical-align:top; padding-left: 15px;">
                <div id="client_address">
                    <p class="uppercase">
                        <span style="font-weight:bold;">Billing To</span><br>
                    <p class="uppercase"><?= $company ?></p>
                    <p class="uppercase"><?= $vendor_code ?></p>
                    <p class="uppercase"><?= $address ?></p>
                    <p class="uppercase"><?= $city ?></p>
                    <p class="uppercase"><?= $state ?></p>
                    <p>INDIA <?= $pincode ?></p>
                    <?php if ($gst_no != '' || $gst_no != null) { ?>
                        <p class="uppercase"> GSTIN: <?= $gst_no; ?>
                        <?php } ?>
                        <?php if ($pan_no != '' || $pan_no != null) { ?>
                        <p class="uppercase"> PAN: <?= $pan_no; ?>
                        <?php } ?>
                        </p>
                </div>
            </td>
            <td style="width:33%;vertical-align:top;">
                <div id="client_details">
                    <table id="client_detail_table">
                        <tr>
                            <td class="left" style="text-align: left;">GSTIN</td>
                            <td class="left">36AASCS2801C1ZI</td>
                        </tr>
                        <tr>
                            <td class="left uppercase">Invoice Number</td>
                            <td class="left"><?= $invoice_code ?></td>
                        </tr>
                        <tr>
                            <td class="left uppercase">Invoice Date</td>
                            <td class="left"><?= $date ?></td>
                        </tr>
                        <tr>
                            <td class="left uppercase">Payment Type</td>
                            <td class="left uppercase"><?= $payment_mode ?></td>
                        </tr>
                        <!-- <tr>
                            <td class="left uppercase">Place of Supply</td>
                            <?php //if (!empty($place_supply)) { ?>
                                <td class="left uppercase"><?php //echo substr($gst_no, 0, 2) . ' - ' . $place_supply ?></td>
                            <?php //} else { ?>
                                <td class="left uppercase"><?php //echo $state_id . '-' . $state ?></td>
                            <?php //} ?>
                        </tr> -->
                        
                        <tr>
                            <td class="left uppercase">Currency</td>
                            <td class="left uppercase">INR</td>
                        </tr>
                    </table>
                </div>
            </td>
        
        </tr>
    </table>

    <p style="clear:both;"></p><br>


    <div id="invoice_div">
        <table id="invoice_table" style="width:100%;" cellspacing="0">
            <thead style="text-align: center;font-size:9px;">
                <tr>
                    <th style="text-align:left;white-space:nowrap;">Description</th>
                    <th style="text-align:left;white-space:nowrap;">HSN Code</th>
                    <th style="width: 10px;">Qty</th>
                    <th class="right">Price</th>
                    <th class="right">Taxable<p style="margin:0px;">Amount</p>
                    </th>
                    <th class="right">Exempt<p style="margin:0px;">Amount</p>
                    </th>
                    <th class="right">Tax<p style="margin:0px;">Rate</p>
                    </th>
                    <th class="right">Tax<p style="margin:0px;">Amount</p>
                    </th>
                </tr>
            </thead>
            <tbody>

                <?php 
                $total_quantity = 0;
                $total_price = 0;
                $total_taxable = 0;
                $total_exempt = 0;
                $total_tax = 0;

                foreach ($rows as $obj) { 
                    $total_quantity += $obj['quantity'];
                    $total_price += $obj['price'];
                    $total_taxable += $obj['taxable_amount'];
                    $total_exempt += $obj['exempt_amount'];
                    $total_tax += $obj['tax_amount'];
                    ?>
                    <tr style="line-height:15px;">
                        <td style="text-align:left;padding-bottom:2px;padding-top:2px;"><?= $obj['description'] ?></td>
                        <td style="text-align:left;padding-bottom:2px;padding-top:2px;"><?= $obj['hsn_code'] ?></td>
                        <td style="text-align:center;padding-bottom:2px;padding-top:2px;"><?= $obj['quantity'] ?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= $obj['price'] ?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= $obj['taxable_amount']  ?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= $obj['exempt_amount'] ?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= $obj['tax_rate'] ?></td>
                        <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($obj['tax_amount']) ?></td>
                    </tr>
                <?php } ?>

                <?php if (!empty($rows)) {
                    // $total_units = 0;
                    // $total_taxable = 0;
                    // $total_exempt = 0;

                    $total_smartphone_units = 0;
                    $total_accessory_units = 0;
                    $total_smartphone_taxable = 0;
                    $total_accessory_taxable = 0;
                    $total_smartphone_exempt = 0;
                    $total_accessory_exempt = 0;
                    $total_accessory_amount = 0;
                    $total_smartphone_amount = 0;
                    $taxable_cat = TAXABLE_CATEGORY;


                    foreach ($rows as $rowValue) {
			
                        if($rowValue['product_type'] == "Accessories"){

                            $total_accessory_amount+=$rowValue['price'];
                            $tax_type = $rowValue['tax_type'];
                            if (in_array($sales_channel, MARGINAL_NOT_ALLOWED_CHANNELS)) {
                                $category = ucwords(strtolower($rowValue['category']));
                                $taxable = $rowValue['price'] / 1.18;
                                $exempt = "0.00";
                            } else {
                                if (in_array($rowValue['category'], $taxable_cat)) {
                                    $category = ucwords(strtolower($rowValue['category']));
                                    $taxable = $rowValue['price'] / 1.18;
                                    $exempt = "0.00";
                                } else {
                                    $category = 'Pre-owned';
                                    $exempt = $rowValue['unit_price'] + $rowValue['unit_price_tax'];
                                    $taxable = ($rowValue['price'] - $exempt) / 1.18;


                                    if ($exempt > $rowValue['price']) {
                                        $exempt = $rowValue['price'];
                                        $taxable = 0;
                                    }
                                }
                            }
                            $total_accessory_exempt += $exempt;
                            $total_accessory_taxable += $taxable;
                            $productname = ucwords(strtolower($rowValue['product_name']));
                            $total_accessory_units++;
                            $invoice_accessory_category = $category . ' '. $rowValue['product_type'];
                            $accessory_hsn = $this->db->get_where('tbl_device_type',array("name"=>$rowValue['product_type']))->row()->hsn_code;
                        
                        } else if($rowValue['product_type'] == "Smartphone") {
                            $total_smartphone_amount+=$rowValue['price'];
                            $tax_type = $rowValue['tax_type'];
                            if (in_array($sales_channel, MARGINAL_NOT_ALLOWED_CHANNELS)) {
                                $category = ucwords(strtolower($rowValue['category']));
                                $taxable = $rowValue['price'] / 1.18;
                                $exempt = "0.00";
                            } else {
                                if (in_array($rowValue['category'], $taxable_cat)) {
                                    $category = ucwords(strtolower($rowValue['category']));
                                    $taxable = $rowValue['price'] / 1.18;
                                    $exempt = "0.00";
                                } else {
                                    $category = 'Pre-owned';
                                    $exempt = $rowValue['unit_price'] + $rowValue['unit_price_tax'];
                                    $taxable = ($rowValue['price'] - $exempt) / 1.18;


                                    if ($exempt > $rowValue['price']) {
                                        $exempt = $rowValue['price'];
                                        $taxable = 0;
                                    }
                                }
                            }
                            $total_smartphone_exempt += $exempt;
                            $total_smartphone_taxable += $taxable;
                            $productname = ucwords(strtolower($rowValue['product_name']));
                            $total_smartphone_units++;
                        }
                        $invoice_smartphone_category = $category . ' '. $rowValue['product_type'];
                        $smartphone_hsn = $this->db->get_where('tbl_device_type',array("name"=>$rowValue['product_type']))->row()->hsn_code;
                        }
                    }

                    $totalExmpt = $total_accessory_exempt+ $total_smartphone_exempt;
                    if($total_amount <= $totalExmpt){
                        $total_smartphone_taxable = 0;
                        $total_accessory_taxable = 0;
                    }

                    $accessory_tax = ($total_accessory_taxable * 18) / 100;
                    $smartphone_tax = ($total_smartphone_taxable * 18) / 100;
                ?>
		
                <?php 
		
                    if($total_accessory_units > 0 && $total_smartphone_units > 0){ ?>
                        <tr style="line-height:15px;">
                            <td style="text-align:left;padding-bottom:2px;padding-top:2px;"><?= $invoice_accessory_category ?></td>
                            <td style="text-align:left;padding-bottom:2px;padding-top:2px;"><?= $accessory_hsn ?></td>
                            <td style="text-align:center;padding-bottom:2px;padding-top:2px;"><?= $total_accessory_units ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_accessory_amount, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_accessory_taxable, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_accessory_exempt, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;">18%</td>
                            <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($accessory_tax) ?></td>
                        </tr>
                        <tr style="line-height:15px;">
                            <td style="text-align:left;padding-bottom:2px;padding-top:2px;"><?= $invoice_smartphone_category ?></td>
                            <td style="text-align:left;padding-bottom:2px;padding-top:2px;"><?= $smartphone_hsn ?></td>
                            <td style="text-align:center;padding-bottom:2px;padding-top:2px;"><?= $total_smartphone_units ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_smartphone_amount, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_smartphone_taxable, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_smartphone_exempt, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;">18%</td>
                            <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($smartphone_tax) ?></td>
                        </tr>
		    
                    <?php  } else if ($total_smartphone_units > 0) { ?>
			
                        <tr style="line-height:15px;">
                            <td style="text-align:left;padding-bottom:2px;padding-top:2px;"><?= $invoice_smartphone_category ?></td>
                            <td style="text-align:left;padding-bottom:2px;padding-top:2px;"><?= $smartphone_hsn ?></td>
                            <td style="text-align:center;padding-bottom:2px;padding-top:2px;"><?= $total_smartphone_units ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_smartphone_amount, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_smartphone_taxable, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_smartphone_exempt, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;">18%</td>
                            <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($smartphone_tax) ?></td>
                        </tr>
                    <?php  } else if ($total_accessory_units > 0) { ?>
                        <tr style="line-height:15px;">
                            <td style="text-align:left;padding-bottom:2px;padding-top:2px;"><?= $invoice_accessory_category ?></td>
                            <td style="text-align:left;padding-bottom:2px;padding-top:2px;"><?= $accessory_hsn ?></td>
                            <td style="text-align:center;padding-bottom:2px;padding-top:2px;"><?= $total_accessory_units ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_accessory_amount, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_accessory_taxable, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_accessory_exempt, 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;">18%</td>
                            <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($accessory_tax) ?></td>
                        </tr>

                    <?php } ?>

                    <?php 
                        if($total_amount <= $totalExmpt){
                            
                            $added_discount = $totalExmpt - $total_amount;
                            if($added_discount <= 0) $added_discount = 0;
                            $discount_tax = 0;
                            $tax = 0;
                            $gross_tax = 0;
                            $discount_amount = $totalExmpt - $total_amount;
                            $discount_amount = 0;
                        }
                    ?>

            <tfoot class="footer_table">

                <?php if ($total_amount != $amount) { ?>
                    <tr style="line-height:15px;">
                        <td colspan="2">Gross Value</td>
                        <td></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($amount, 2)) ?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_accessorry_taxable + $total_smartphone_taxable, 2)) ?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_accessorry_exempt + $total_smartphone_exempt, 2)) ?></td>
                        <td colspan="2" class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($tax) ?></td>
                    </tr>
                <?php } ?>
                <?php if ($discount_total > 0) { ?>
                    <tr style="line-height:15px;">
                        <td colspan="2">Less: Discount</td>
                        <td></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($discount_total, 2)) ?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($discount_amount, 2)) ?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($added_discount, 2)) ?></td>
                        <td class="right">18%</td>
                        <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($discount_tax) ?></td>
                    </tr>
                <?php } ?>
                <?php if ($freight_total > 0) { ?>
                    <tr style="line-height:15px;">
                        <td colspan="2">Add: Freight</td>
                        <td></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($freight_total, 2)) ?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($freight_amount, 2)) ?></td>
                        <td class="right" colspan="2">18%</td>
                        <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($freight_tax) ?></td>
                    </tr>
                <?php } ?>
                <?php if ($insurance_total > 0) { ?>

                    <tr style="line-height:15px;">
                        <td colspan="2">Add: Insurance</td>
                        <td></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($insurance_total, 2)) ?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($insurance_amount, 2)) ?></td>
                        <td class="right" colspan="2">18%</td>
                        <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($insurance_tax) ?></td>
                    </tr>
                <?php } ?>
                <?php if ($tcs_total > 0) { ?>
                    <tr style="line-height:15px;">
                        <td colspan="2">Add: TCS @ <?= $tcs_percent ?> %</td>
                        <td></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($tcs_total, 2)) ?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round(0, 2)) ?></td>
                        <td class="right" colspan="2">-</td>
                        <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format(0) ?></td>
                    </tr>
                <?php } ?>

                <?php 
                    // $total_taxable_amount = ($total_accessory_taxable + $total_smartphone_taxable);
                    $gross_taxable = $total_taxable - $discount_amount + $freight_amount + $insurance_amount; 
                    if($gross_taxable<0) {
                        $total_exempt = $total_exempt - abs($gross_taxable + $gross_tax);
                        $gross_taxable = 0;
                    }
		    
                    if($gross_tax<0) $gross_tax = 0;
                ?>

                <tr style="line-height:15px;">
                    <td>Net Value</td>
                    <td></td>
                    <td style="text-align:center;padding-bottom:2px;padding-top:2px;"><?= $total_quantity ?></td>
                    <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_amount, 2)) ?></td>
                    <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($gross_taxable, 2))?></td>
                    <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_exempt - $added_discount), 2) ?></td>
                    <td colspan="2" class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($gross_tax) ?></td>
                </tr>

                <tr style="line-height:15px;">
                    <td colspan="3"><?= $amount_words ?></td>
                    <td></td>
                    
                    <?php if ($tax_type == 'IGST18') { ?>
                        <td colspan="2" class="right">Tax Break-Up</td>
                        <td colspan="2" class="right" style="padding-bottom:2px;padding-top:1px;">IGST <span class="rupee"><?= IND_money_format($gross_tax) ?></td>
                    <?php } else { ?>
                        <td colspan="2" class="right">Tax Break-up</td>
                        <td colspan="2" class="right" style="padding-bottom:2px;padding-top:1px;">
                            CGST <span class="rupee"><?= IND_money_format(round($gross_tax / 2, 2)) ?>
                                &nbsp;| SGST <span class="rupee"><?= IND_money_format(round($gross_tax / 2, 2)) ?> </td>
                    <?php } ?>
                </tr>


            </tfoot>
        </table>

    </div>
    <p></p><br>
    <p></p>

    <div style="font-size:10px;">
        <p>
        <div style="page-break-inside:avoid;">
            <div style="float:left;page-break-inside:avoid;width:60%;height:40px;">
                <p style="font-weight: bold;">Notes</p>
                <p> 
                    <?php if ($sales_channel) { ?> Sales Channel: <?= $sales_channel ?><?php } ?>
                </p>
                
                <p style="position:relative;font-weight:bold;text-align:right;">Thank you for your Business.</p>
            </div>
            <div style="float:right;page-break-inside:avoid;">
                <br>
                <span style="font-weight:700;">For Sloyd Ventures (P) Ltd.,</span>
                <p style="width:50px;height:50px;"></p>
                <p>Authorised Signature</p>
            </div>
        </div>
        
    </div>

    <p style="clear:both;">
    <br />

    <div style="margin-top: 30px;">
        <?php if (!empty($qr_code) && !empty($irn)) { ?>
            <table id="heading" style="text-align:center;width:100%;border-bottom:none;margin-top:-30px;">

                <tr style="border-bottom:none;">
                    <td style="align-content:left;text-align:left;border-bottom:none;">
                        IRN: <?= $irn ?>
                    </td>
                    <td style="border-bottom:none;">
                        <image src="<?php base_url() ?><?= $filename ?>" style="width:150px;height:150px;">
                    </td>
                </tr>
            </table>
        <?php } ?>
    </div>



    <div class="signature">
    </div>
</body>

</html>

<?php
function IND_money_format($number)
{
    $decimal = (string)($number - floor($number));
    $money = floor($number);
    $length = strlen($money);
    $delimiter = '';
    $money = strrev($money);

    for ($i = 0; $i < $length; $i++) {
        if (($i == 3 || ($i > 3 && ($i - 1) % 2 == 0)) && $i != $length) {
            $delimiter .= ',';
        }
        $delimiter .= $money[$i];
    }

    $result = strrev($delimiter);
    $decimal = preg_replace("/0\./i", ".", $decimal);
    $decimal = substr($decimal, 0, 3);

    if ($decimal != '0') {
        $result = $result . $decimal;
    }
    if ($decimal == "0") {
        $result = $result . '.00';
    }

    return $result;
}
?>