<!DOCTYPE html>
<html>
<meta charset="utf-8">
<title><?= lang('invoice') ?></title>

<head>
    <style type="text/css">
        font-face {
            font-family: "Source Sans Pro", sans-serif;
        }

        .clearfix:after {
            content: "";
            display: table;
            clear: both;
        }
        .hidden {
            display: none;
        }
        a {
            color: #0087C3;
            text-decoration: none;
        }

        body {
            color: #222222;
            background: #FFFFFF;
            font-size: 9px;
            font-family: "Source Sans Pro", sans-serif;
            width: 100%;
            margin: 0;
        }

        #header_logo {
            float: left;
        }

        #header_title {
            float: right;
        }


        .left {
            text-align: left;
        }

        .right {
            text-align: right !important;
        }

        .center {
            text-align: center;
        }
        .fw_normal {
            font-weight: normal;
        }
        .fw_bold {
            font-weight: bold;
        }

        #invoice_table {
            width: 100%;
            margin-left: 2px;
            margin-right: 2px;
        }

        table#invoice_table,
        #invoice_table th,
        #invoice_table td {
            border: 1px solid black;
            border-collapse: collapse;
        }
        table#invoice_table_hsnwise,
        #invoice_table_hsnwise th,
        #invoice_table_hsnwise td {
            border: 1px solid black;
            border-collapse: collapse;
        }

        #invoice_table th {
            border-top: 0.5px solid grey;
            padding: 10px 3px;
        }
        #invoice_table tbody tr > td,
        #invoice_table .footer_table tr > td {
            padding: 3px 10px 3px 5px;
        }

        #invoice_table_hsnwise th {
            border-top: 0.5px solid grey;
            padding: 5px 3px;
        }
        #invoice_table_hsnwise tr > td {
            padding: 3px 10px 3px 5px;
        }

        header {
            position: fixed;
            top: -20px;
            left: 0px;
            right: 0px;
            height: 20px;
            width: 100%;
        }

        footer {
            position: fixed;
            bottom: 0;
            left: 0px;
            right: 0px;
            height: 20px;
            border-top: 1px solid #AAAAAA;
            color: #777777;
            width: 100%;
            padding: 8px 0;
            text-align: center;
        }

        .rupee::before {
            padding-left: 5px;
            white-space: nowrap;
        }


        .footer_margin {
            margin-bottom: 0;
            margin-left: 1px;
            position: absolute;
            bottom: 0;
            float: right;
            font-size: 12px;
        }

        .signature {
            margin-bottom: 40px;
            margin-left: 1px;
            position: absolute;
            bottom: 0;
            float: right;
            font-size: 12px;
        }

        .container td {
            border-bottom: none;
        }

        body table.show_border, 
        body th.show_border, 
        body td.show_border {
            border: 1px solid black;
            border-collapse: collapse;
        }
        body table.no_border, 
        body th.no_border, 
        body td.no_border {
            border: none;
        }

        
        .letter_head,
        .invoice_div {
            text-transform: uppercase;
        }

        .letter_header_main_tr > td {
            vertical-align: top;
        }

        
        table.address_block,
        table.address_block  tr.addr_tr > td {
            border: 1px solid black;
            border-collapse: collapse;
            border-left: none;
            border-right: none;
            border-top: none;
            border-bottom: none;
        }
        table.address_block tr.addr_tr:nth-of-type(n+2) > td {
            border-top: 1px solid black;
            border-collapse: collapse;
        }
        table.address_block  tr.addr_tr > td {
            padding: 3px 5px 0;
        }
        table.address_block .inner_table1 td.addr_heading {
            width: 25%;
            vertical-align: top;
            font-weight: 600;
            margin-bottom: 5px;
        }
        table.address_block .inner_table1 td.addr_body {
            width: 75%;
            vertical-align: top;
        }
        table.address_block .addr_body p {
            margin: 0;
            margin-bottom: 3px;
        }
        
        .invoice_main_dtls {
            width: 100%;
        }
        .invoice_main_dtls .fields_block_row > td.field_row {
            width: 50%;
        }
        .invoice_main_dtls td.field_row .field_lbl {
            display: block;
            font-size: 11px;
            margin-bottom: 5px;
        }
        .invoice_main_dtls td.field_row .field_val {
            display: block;
            font-size: 12px;
            font-weight: 600;
        }
        .invoice_main_dtls .field_row .field_inline > * {
            display: inline-block !important;
        }
        .invoice_main_dtls td {
            padding: 4px 6px;
        }
        table.invoice_main_dtls,
        table.invoice_main_dtls td {
            border: 1px solid black;
            border-collapse: collapse;
            border-left: none;
            border-right: none;
            border-top: none;
            border-bottom: none;
        }
        table.invoice_main_dtls td {
            vertical-align: top;
        }
        table.invoice_main_dtls td.lf {
            border-right: 1px solid black;
            border-collapse: collapse;
        }
        table.invoice_main_dtls tr:nth-of-type(n+2) td {
            border-top: 1px solid black;
            border-collapse: collapse;
        }
        table.invoice_main_dtls.type2 tr:nth-of-type(n+1) td {
            border-top: 1px solid black;
            border-collapse: collapse;
        }
        
        @media (print) {
            
        }

        /* .letter_head {
            position: fixed;
            top: 0;
            left: 0px;
            right: 0px;
            width: 100%;
        } */


    </style>
</head>

<!-- <body style="max-width:800px;margin:auto;border:1px solid #ccc;"> -->
<body>
    <header>
        <!-- <h3>Hello Hai</h3> -->
    </header>

    <footer id="footer"><span style="font-weight:bold;">SLOYD VENTURES (P) LTD,</span> 1-11-251/19A. 4th Floor, Jayalakshmi Towers,
        Motilal Nehru Nagar, Begumpet, Hyderabad, Telangana, 500016, IN.<p style="margin:0;">|| CIN: U52390TG2012PTC083950 | PAN: AASCS2801C | Tel: +91-40-27900059 | Email: accounts@sloyd.in | web: www.sloyd.in ||</p>
    </footer>
    <div class="footmargin"></div>

    <div class="letter_head">
        <table id="heading" class="no_border" style="text-align:center;width:100%;border-bottom:none;margin-top:-30px;">
            
            <tr class="no_border" style="border-bottom:none;">
                <!-- <td style="align-content:left;text-align:left;border-bottom:none;"><img src="<?php //echo base_url(); ?>assets/img/logo_invoice.png" height="50px" width="140px"></td> -->
                <td class="no_border" style="text-align:center;border-bottom:none;">
                    <h1>Commercial Invoice</h1>
                    <p style="text-transform: uppercase;font-size: 11px;font-weight: 600;">(Supply meant for Export / Supply to SEZ Unit or SEZ Developer for authorised<br/> operations under bond or letter of undertaking without payment of IGST)</p>
                </td>
                <!-- <td style="border-bottom:none;">
                    <div style="font-size:14px;font-weight:700;text-align:right;"><?php //echo $type ?></div>
                </td> -->
            </tr>
        </table>

        <table class="letter_header_main show_border" style="width:100%;">
            <tr class="letter_header_main_tr">
                <td class="address_block_td">
                    <table class="address_block" style="width:100%;">
                        <tr class="addr_tr">
                            <td>
                                <table class="inner_table1" style="width:100%;">
                                    <tr>
                                        <td class="addr_heading">Billing From</td>
                                        <td class="addr_body">
                                            <div>
                                                <p>SLOYD VENTURES (P) LTD</p>
                                                <p>Jayalakshmi Towers, 4th Floor, </p>
                                                <p>1-11-251/19/A, Motilal Nehru Nagar</p>
                                                <p>Begumpet, Hyderabad,</p>
                                                <p>Telangana</p>
                                                <!-- <p>INDIA 500016</p> -->
                                                <p>GSTIN/UIN: 36AASCS2801C1ZI</p>
                                                <p>State Name: Telangana, Code: 36</p>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr><td></td></tr>
                        <tr><td></td></tr>

                        <tr class="addr_tr">
                            <td>
                                <table class="inner_table1" style="width:100%;">
                                    <tr>
                                        <td class="addr_heading">Shipping From</td>
                                        <td class="addr_body">
                                            <div>
                                                <p><?= $shipping_from_address['seller'] ?></p>
                                                <p><?= $shipping_from_address['address'] ?></p>
                                                <p><?= $shipping_from_address['city'] ?>, <?= $shipping_from_address['state'] ?></p>
                                                <p>INDIA <?= $shipping_from_address['pincode'] ?></p>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr><td></td></tr>
                        <tr><td></td></tr>

                        <tr class="addr_tr">
                            <td>
                                <table class="inner_table1" style="width:100%;">
                                    <tr>
                                        <td class="addr_heading">Billing To</td>
                                        <td class="addr_body">
                                            <div>
                                                <p><?= $company ?></p>
                                                <p><?= $address ?></p>
                                                <p><?= $city ?></p>
                                                <p><?= $state ?></p>
                                                <p><?= $country ?></p>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr><td></td></tr>
                        <tr><td></td></tr>
                        
                        <tr class="addr_tr">
                            <td>
                                <table class="inner_table1" style="width:100%;">
                                    <tr>
                                        <td class="addr_heading">Shipping To</td>
                                        <td class="addr_body">
                                            <div>
                                                <p><?= $shipping_address['company'] ?></p>
                                                <p><?= $shipping_address['address'] ?></p>
                                                <p><?= $shipping_address['city'] ?></p>
                                                <p><?= $shipping_address['state'] ?></p>
                                                <p><?= $shipping_address['country'] ?> <?php echo isset($shipping_address['pincode'])? ' - ' . $shipping_address['pincode'] : ''; ?></p>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>

                <td class="inv_block_td show_border" style="width:50%;vertical-align:top;">
                    
                    <table class="fields_block invoice_main_dtls type1">
                        <tr class="fields_block_row">
                            <td class="field_row lf">
                                <span class="field_lbl">Invoice Number</span>
                                <span class="field_val"><?= $invoice_code ?></span>
                            </td>
                            <td class="field_row rt">
                                <span class="field_lbl">Invoice Date</span>
                                <span class="field_val"><?= $invoice_cdate ?></span>
                            </td>
                        </tr>
                        <tr>
                            <td class="field_row lf">
                                <span class="field_lbl">Buyer Order Number</span>
                                <span class="field_val"><?= $saleschannel_ref_id ?></span>
                            </td>
                            <td class="field_row rt">
                                <span class="field_lbl">Ordered Date</span>
                                <span class="field_val"><?php echo ' ' //$salesorder_cdate ?></span>
                            </td>
                        </tr>
                        <tr>
                            <td class="field_row lf" colspan="2" style="border-right: none;">
                                <span class="field_lbl">Other References</span>
                                <span class="field_val">C & F</span>
                            </td>
                            <!-- <td class="field_row rt">
                                <span class="field_lbl"></span>
                                <span class="field_val"><?php //echo '' ?></span>
                            </td> -->
                        </tr>
                    </table>

                    <table class="fields_block invoice_main_dtls type2">
                        <tr>
                            <td class="field_row">
                                <div class="field_inline">
                                    <span class="field_lbl">Country :</span>
                                    <span class="field_val"><?= $country ?></span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td class="field_row">
                                <div class="field_inline" style="margin-bottom: 0px;">
                                    <span class="field_lbl">LUT/Bond No. : </span>
                                    <span class="field_val">AD360323014358A</span>
                                </div>
                                <div class="field_inline">
                                    <span class="field_lbl">From : </span>
                                    <span class="field_val">25-03-2023</span>
                                    &nbsp;
                                    &nbsp;
                                    <span class="field_lbl">To : </span>
                                    <span class="field_val">25-04-2024</span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td class="field_row" style="padding-bottom: 20px;">
                                <span class="field_lbl">Terms of Delivery :</span>
                                <span class="field_val"><?= $terms_of_delivery ?></span>
                            </td>
                        </tr>
                    </table>
                    
                </td>
                
            </tr>
        </table>
    </div>

    <p style="clear:both;"></p><br>


    <div class="invoice_div" id="invoice_div">
        <table id="invoice_table" style="width:100%;" cellspacing="0">
            <thead style="text-align: center;font-size:9px;">
                <tr>
                    <th style="width: 15px;">Sno</th>
                    <th class="left" style="width: 250px;">Description of Goods</th>
                    <th class="center">HSN / SAC</th>
                    <th class="center">Quantity</th>
                    <th class="center">Rate</th>
                    <th class="center">per</th>
                    <th class="center">Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php 

                $total_quantity = 0;
                foreach ($rows as $key => $item) {
                    $prod_desc = $item['product_name'];
                    $prod_desc .= (isset($item['ram']) && ($item['ram'] != 'NA'))? ' '. $item['ram'] : '';
                    $prod_desc .= (isset($item['rom']) && ($item['rom'] != 'NA'))? ' '. $item['rom'] : '';
                    // $prod_desc .= (isset($item['color']) && ($item['color'] != 'NA'))? ' '. $item['color'] : '';

                    $total_quantity += $item['quantity'];
                ?>
                    <tr style="line-height:15px;">
                        <td colspan="1" class="center"><?= ($key+1) ?></td>
                        <td class="left" style="padding: 5px 15px;">
                            <p style="margin: 0;"><?= $prod_desc ?></p>
                            <p style="margin: 0;margin-left: 50px; color: #555; letter-spacing: 0.5px;">
                                <?php if (isset($item['device_actv_status'])) { ?>
                                    (<?php echo $item['device_actv_status'] ?>)
                                <?php } ?>
                            </p>
                        </td>
                        <td class="center"><?= $item['hsn_code'] ?></td>
                        <td class="center"><?= $item['quantity'] . ' NOS' ?></td>
                        <td class="center"><?= $exchange_currency_type . ' ' . $item['price_exch'] ?></td>
                        <td class="center">NOS</td>
                        <td class="right rupee"><?= $exchange_currency_type . ' ' . IND_money_format(round($item['t_amount_exch'], 2)) ?></td>
                    </tr>
                
                <?php } ?>
            </tbody>

            <tfoot class="footer_table">
                
                <?php if ($gross_amount_exch != $total_amount_exch) { ?>
                    <tr class="fw_bold" style="line-height:15px;">
                        <td colspan="6" class="center">Gross Value</td>
                        <td class="right rupee"><?= $exchange_currency_type . ' ' .  IND_money_format(round($gross_amount_exch, 2)) ?></td>
                    </tr>
                <?php } ?>
                
                <?php if ($discount_total > 0) { ?>
                    <tr style="line-height:15px;">
                        <td colspan="1"></td>
                        <td colspan="5">Less: Discount</td>
                        <td class="right rupee"><span style="float:left;">( - )</span> <?= $exchange_currency_type . ' ' .  IND_money_format(round($discount_total_exch, 2)) ?></td>
                    </tr>
                <?php } ?>
                <?php if ($freight_total > 0) { ?>
                    <tr style="line-height:15px;">
                        <td colspan="1"></td>
                        <td colspan="5">Add: Freight</td>
                        <td class="right rupee"><span style="float:left;">( + )</span> <?= $exchange_currency_type . ' ' .  IND_money_format(round($freight_total_exch, 2)) ?></td>
                    </tr>
                <?php } ?>
                <?php if ($insurance_total > 0) { ?>
                    <tr style="line-height:15px;">
                        <td colspan="1"></td>
                        <td colspan="5">Add: Insurance</td>
                        <td class="right rupee"><span style="float:left;">( + )</span> <?= $exchange_currency_type . ' ' .  IND_money_format(round($insurance_total_exch, 2)) ?></td>
                    </tr>
                <?php } ?>
                <?php //if ($tcs_total > 0) { ?>
                    <!-- <tr style="line-height:15px;">
                        <td colspan="1"></td>
                        <td colspan="5">Add: TCS @ <?php //echo $tcs_percent ?> %</td>
                        <td class="right rupee"><?php //echo $exchange_currency_type . ' ' .  IND_money_format(round($tcs_total_exch, 2)) ?></td>
                    </tr> -->
                <?php //} ?>

                <?php $gross_taxable = $total_taxable - $discount_amount + $freight_amount + $insurance_amount; 
                    if($gross_taxable<0) {
                        $total_exempt = $total_exempt - abs($gross_taxable + $gross_tax);
                        $gross_taxable = 0;
                    }

                    if($gross_tax<0) $gross_tax = 0;
                ?>

                <tr class="fw_bold" style="line-height:15px;">
                    <td colspan="3" class="center">Total</td>
                    <td class="center"><?= $total_quantity . ' NOS' ?></td>
                    <td colspan="2"></td>
                    <td class="right rupee" style="font-weight: 900;"><?= $exchange_currency_type . ' ' .  IND_money_format(round($total_amount_exch, 2)) ?></td>
                </tr>

            </tfoot>
        </table>
        <h4 style="float: right; margin-top: 5px;">E. & O.E &nbsp;</h4>

        <p>Amount Chargeable (in words)</p>
        <h3 class="left"><?= $amount_words_exch ?></h3>
        <br /> <br />

        <table id="invoice_table_hsnwise" style="width:100%;" cellspacing="0">
            <thead>
                <tr>
                    <th class="center">HSN / SAC</th>
                    <th class="center">Taxable Value</th>
                    <th class="center">Tax Rate</th>
                    <th class="center">Tax Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($rows_hsnWise as $key => $item) { ?>
                    <tr>
                        <td class="left"><?= $item['hsn_code'] ?></td>
                        <td class="right"><?= IND_money_format(round($item['t_amount_hsnWise'], 2)) ?></td>
                        <td class="center">0%</td>
                        <td class="center">0</td>
                    </tr>
                <?php } ?>

                <tr>
                    <td class="right"><b>Total</b></td>
                    <td class="right"><b><?= IND_money_format(round($gross_amount_hsnWise, 2)) ?></b></td>
                    <td class="center"></td>
                    <td class="center"></td>
                </tr>
            </tbody>
        </table>

        <p>Tax Amount (in words): &nbsp;<b>NIL</b></p>

    </div>
    
    <p style="width:50px;height:50px;"></p>

    <div style="font-size:10px;">
        <div style="page-break-inside:avoid;">
            <div style="float:left;page-break-inside:avoid;width:40%;height:40px;">
                <p style="width:50px;height:50px;"></p>
                <p style="text-decoration: underline;text-decoration-color: #333;margin-bottom: 5px;">Declaration:</p>
                <p style="margin-top: 0;">We declare that this invoice shows the actual price of the goods described and that all particulars are true and correct.</p>
            </div>
            <div style="float:right;page-break-inside:avoid;width:50%;text-align: right;border: 1px dashed black; padding: 5px">
                <span style="font-weight:700;">For Sloyd Ventures (P) Ltd.,</span>
                <p style="width:50px;height:50px;"></p>
                <p>Authorised Signature</p>
            </div>
        </div>
        
        <div class="hidden">
            <p style="clear:both;"><br>
            <p style="font-weight: bold;">Terms & Conditions:</p>
            <p> 1. All products sold by Seltrue are either pre-owned or unboxed or refurbished unless it is explicitly stated</p>
            <p>2. Please check the products for their specifications, physical damages and functional defects if any prior to acceptance</p>
            <p>3. Please validate the IMEI/Serial numbers of the products as printed on this invoice against the devices received by you. However device IMEI/Serial numbers may not match with numbers mentioned on the box.</p>
            <p>4. Goods once sold will not be taken back or exchanged</p>
            <p>5. Warranties will be honored by respective manufacturer if it is applicable</p>
            <p>6. If the products are sold with warranty void terms, we are not obliged to serve any warranty claims</p>
            <p>7. Any warranties extended by company are subjected to terms and conditions as published from time to time</p>
            <p>8. We are not responsible for transit damages or loss if any</p>
            <p>9. Pre-owned mobile phones are secondhand goods fully/partly exempted under rule 32(5) of CGST Rules, 2017</p>
            <p>10. Subject to Hyderabad/Secunderabad Jurisdiction. E&OE</p>
            </p>
        </div>

    </div>

    <?php if (!empty($qr_code) && !empty($irn)) { ?>
        <table id="heading" style="text-align:center;width:100%;border-bottom:none;margin-top:-30px;">

            <tr style="border-bottom:none;">
                <td style="align-content:left;text-align:left;border-bottom:none;">
                    IRN: <?= $irn ?>
                </td>
                <td style="border-bottom:none;">
                    <image src="<?php base_url() ?><?= $filename ?>" style="width:150px;height:150px;">
                </td>
            </tr>
        </table>
    <?php } ?>


    <div class="signature">
    </div>
    
</body>

</html>

<?php
function IND_money_format($number)
{
    $decimal = (string)($number - floor($number));
    $money = floor($number);
    $length = strlen($money);
    $delimiter = '';
    $money = strrev($money);

    for ($i = 0; $i < $length; $i++) {
        if (($i == 3 || ($i > 3 && ($i - 1) % 2 == 0)) && $i != $length) {
            $delimiter .= ',';
        }
        $delimiter .= $money[$i];
    }

    $result = strrev($delimiter);
    $decimal = preg_replace("/0\./i", ".", $decimal);
    $decimal = substr($decimal, 0, 3);

    if ($decimal != '0') {
        $result = $result . $decimal;
    }
    if ($decimal == "0") {
        $result = $result . '.00';
    }

    return $result;
}
?>