
<div class="nav-tabs-custom nav_tabs_custom" style="margin-left:10px">

    <ul class="nav nav-pills">
        <li class=""><a href="#packing_box_info" data-toggle="tab">Packing Details</a></li>
        <li class="active"><a href="#bulk_packing_box_info" data-toggle="tab">Bulk Packing Details</a></li>
    </ul>
    
    <div class="tab-content bg-white">
        <div class="tab-pane" id="packing_box_info">
            <div>
                <div class="form-group table-responsive">

                    <hr style="border: 3px solid #e4eaec">

                    <table class="form-group table-responsive table" style="margin-left:10px;">
                        <tr>
                            <td>UPLOAD</td>
                            <td>
                                <select id="box_invoice_select" class="form-control select_box" style="width: 100%;">
                                    <option value="">SELECT INVOICE</option>
                                </select>
                            </td>
                            <td><input type="file" class="form-control-file custom-file-input" name="boxFileUpload" id="boxFileUpload"></td>
                            <td colspan="9"><input type="button" class="btn btn-green" value="Upload" onclick="uploadBoxDetails()" /></td>
                        <tr>
                            <td>Device Id</td>
                            <td>
                                <input type="text" class="form-control" id="box_device_id" name="box_device_id" placeholder="Device Id">
                            </td>
                            <td> <input type="number" class="form-control" id="box_box_no" name="box_box_no" placeholder="Box No"></td>
                            <td>
                                <input type="button" class="btn btn-info" id="box_add" value="Add">
                            </td>
                        </tr>

                    </table>

                    <hr style="border: 3px solid #e4eaec">

                    <!-- Table with Device id, Box Number, Delete -->
                    <table class="form-group table-responsive table" style="margin-left:10px;">
                        <tr>
                            <th>Device Id</th>
                            <th>Box No</th>
                            <th>Delete</th>
                        </tr>
                        <tbody id="box_table">

                        </tbody>
                    </table>

                </div>
            </div>
        </div>

        <div class="tab-pane active" id="bulk_packing_box_info">

            <div class="form_bulkupload form_bulk_packing_details">

                <table class="form-group table-responsive table" style="margin-left:10px;">
                    <tr>
                        <td colspan="4">UPLOAD</td>
                        <td colspan="1">
                            <input type="file" class="form-control-file custom-file-input" name="input_bulk_packing_details" id="input_bulk_packing_details">
                        </td>
                        <td colspan="1">
                            <button type="button" class="btn btn-green" onclick="bulkUpload_PackingDetails('.form_bulk_packing_details')">Bulk Upload</button>
                        </td>
                        <td colspan="4">
                            <a type="button" href="<?php echo base_url(); ?>assets/sample/bulk_packing_details_template.csv" class="btn btn-primary" >Sample Template</a>
                        </td>
                    </tr>
                </table>
                
            </div>

        </div>

    </div>
</div>


<script type="text/javascript">
    var responseData;
    getInvoiceNO()

    function uploadBoxDetails() {
        debugger
        var boxArr = [];
        var invoice_id = $("#box_invoice_select").val()

        if (invoice_id == '') {
            toastr.error("Please Select Invoice Number")
            return false
        }

        var fileUpload = document.getElementById("boxFileUpload");
        var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;
        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof(FileReader) != "undefined") {
                var reader = new FileReader();
                reader.onload = function(e) {

                    var rows = e.target.result.split("\n");
                    for (var i = 1; i < rows.length; i++) {
                        var cells = rows[i].split(",");
                        if (cells.length > 1) {
                            let row_det = {
                                "device_id": cells[0],
                                "box_no": cells[1]
                            }
                            boxArr.push(row_det);
                        }
                    }

                    var post_data = {
                        "invoice_data": boxArr,
                        "invoice_id": invoice_id
                    }

                    var jsonObject = JSON.stringify(post_data)
                    $.ajax({
                        url: "<?php echo base_url(); ?>admin/Invoice/addPackingBoxDetails",
                        dataType: 'json',
                        data: jsonObject,
                        type: 'POST',
                        success: function(response) {

                            if (response.status != 1) {

                                if (response.msg != undefined) {
                                    toastr.error(response.msg)
                                } else {
                                    toastr.error("Failed to add Box numbers")
                                }
                                return false
                            }
                            toastr.success("Box Numbers Added Successfully")
                            return true
                        },

                        error: function(data) {
                            toastr.error("Failed to add Box numbers")
                        }
                    });
                }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

    function getInvoiceNO() {

        var options = ''
        var get_data = {
            "status": "INVOICED"
        }
        $.ajax({
            url: "<?php echo base_url(); ?>admin/Invoice/getInvoiceNoDropdown",
            dataType: 'json',
            data: get_data,
            type: 'GET',
            success: function(data) {

                if (data.status != 1) {
                    return false
                }

                $.each(data.result, function(i, v) {
                    options += '<option value="' + data.result[i].invoice_id + '">' + data.result[i].invoice_no + '</option>'
                })

                $("#box_invoice_select").append(options)
            }
        })
    }

    
	function bulkUpload_PackingDetails(form_id) {
		var columns_allowed = 3;
		form_id = (typeof form_id == 'object')? form_id : $(form_id);
		var isValid = true;

		var devices = [];
		
		var fileUpload = document.getElementById("input_bulk_packing_details");
        var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;

        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
		        var reader = new FileReader();
                reader.onload = function (e) {
				    var rows = e.target.result.split("\n");
					for (var i = 1; i < rows.length; i++) {
						var cells = rows[i].split(",");

						
                    	if (cells.length > 1) {
							if (cells.length != columns_allowed) {
								alert("Total "+ columns_allowed +" columns should be there in uploading file");
								isValid = false;
								return false;
							}

							devices.push({
								'deviceid': cells[0].toUpperCase(),
								'box_number': cells[1].replace('\r', ''),
								'invoice_code': cells[2].replace('\r', '')
							});
						}
					}
					if (!isValid) return false;

					$.each(devices, function(i, v) {
						if (v.deviceid == '') {
							alert('"Device ID" Error at row no: ' + (i+2));
							isValid = false;
						}

						if (!isValid) return false;   // Break Loop
					});
					if (!isValid) return false;   // Break Function

					let req_data = {
						'packing_details': devices
					}
					
					$.ajax({
						url: '<?php echo base_url(); ?>admin/Invoice/bulk_addPackingBoxDetails',
						type: 'POST',
						data: JSON.stringify(req_data),
						dataType: 'json',
						success:function(data){
							if (data.status) {
								toastr.success(data.message);

                                form_id.find('input').val('');
                                fileUpload.files = [];
							} else {
								toastr.error(data.message);
							}
						},
						error:function(data){
							alert('Upload failed.');
						}			
					});
		        }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

</script>