<style>
    .invoiceid_td_cls {
        font-size: 0;
        background-position: center;
    }

    .tr_tfoot_alias th {
        text-align: center;
    }
</style>
<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;">
    <div class="col-md-6  col-sm-6 col-xs-6" style="padding:0px">

        <div class="form-group">
            <label class="col-lg-4 control-label">SELECT ALIAS</label>
            <div class="col-lg-7">
                <select id="select_vendor_alias" class="form-control select_box" style="width:100%" onchange="getInvoiceByAliasList()">
                    <option value="">SELECT ALIAS</option>
                </select>
            </div>

        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">SELECT REF ID</label>
            <div class="col-lg-7">
                <select id="select_invoice_ref_id_alias" class="form-control select_box" style="width:100%" onchange="getInvoiceByAliasList('yes')">
                    <option value="">SELECT REF ID</option>
                </select>
            </div>

        </div>
    </div>
</div>

<div class="table-responsive scrolledTable">
    <table class="table table-striped DataTables" id="alias_invoice_list_table" cellspacing="0" style="width:1047px" width="90%">
        <thead>
            <tr>
                <th>&nbsp;</th>
                <th>INVOICE CODE</th>
                <th>VENDOR NAME</th>
                <th>SALES ORDER NO</th>
                <th>PARENT <br> ENTITY</th>
                <th>SALES CHANNEL</th>
                <th>SALESCHANNEL<br>REF<br>ID</th>
                <th>QUANTITY</th>
                <th>AMOUNT</th>
                <th>TAX</th>
                <th>Amount Exc. Tax</th>
                <th>DISCOUNT</th>
                <th>FREIGHT</th>
                <th>INSURANCE</th>
                <th>TCS</th>
                <th>NET INVOICE<br>AMOUNT</th>
                <th>LAST UPDATE DATE</th>
            </tr>
        </thead>
        <tfoot>
            <tr class="tr_tfoot_alias">
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
              
            </tr>
        </tfoot>
        <tbody>
        </tbody>
    </table>
</div>

<script>
    getAliasList()
    var alias_invoice_list_table;

    function getAliasList() {
        $.ajax({
            "url": "<?= base_url() ?>admin/Tools/getVendorAliases",
            "method": "GET",
            "data": {},
            "dataType": "json",
            "success": function(data) {
                var options = ''
                $.each(data.result, function(i, v) {

                    options += '<option value="' + data.result[i].alias_name + '">' + data.result[i].alias_name + '</option>'
                })

                $("#select_vendor_alias").append(options)
            }
        })
    }
    

    function getInvoiceByAliasList(ref_wise_list = '') {

        var alias_name = $("#select_vendor_alias").val()
        var ref_id = $("#select_invoice_ref_id_alias").val()
        if (ref_wise_list != 'yes') {
            getSaleschannelRefIdByAlias(alias_name)
            return false
        }

        if (alias_name == '' || alias_name == null || alias_name == undefined) {
            return false
        }
        alias_invoice_list_table = $("#alias_invoice_list_table").DataTable({
            "footerCallback": function(row, data, start, end, display) {
                var api = this.api(),
                    data;

                // converting to interger to find total
                var intVal = function(i) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '') * 1 :
                        typeof i === 'number' ?
                        i : 0;
                };

                // computing column Total of the complete result 
                var QuantityTotal = api
                    .column(7)
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                var AmountTotal = api
                    .column(8)
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                var TaxTotal = api
                    .column(9)
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                var AmountExcTotal = api
                    .column(10)
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                var DiscountTotal = api
                    .column(11)
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                var FleightTotal = api
                    .column(12)
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);
                var InsuranceTotal = api
                    .column(13)
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);
                var TcsTotal = api
                    .column(14)
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);
                var NetInvoiceTotal = api
                    .column(15)
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Update footer by showing the total with the reference of the column index 
                $(api.column(7).footer()).html(QuantityTotal);
                $(api.column(8).footer()).html(AmountTotal.toFixed(2));
                $(api.column(9).footer()).html(TaxTotal.toFixed(2));
                $(api.column(10).footer()).html(AmountExcTotal.toFixed(2));
                $(api.column(11).footer()).html(DiscountTotal.toFixed(2));
                $(api.column(12).footer()).html(FleightTotal.toFixed(2));
                $(api.column(13).footer()).html(InsuranceTotal.toFixed(2));
                $(api.column(14).footer()).html(TcsTotal.toFixed(2));
                $(api.column(15).footer()).html(NetInvoiceTotal.toFixed(2));
            },

            "paging": true,
            "destroy": true,
            "searching": true,
            "processing": true,
            "serverSide": false,
            //"scrollY": 390,
            //"scrollX": true,
            //"scrollCollapse": true,
            //"autoWidth": false,
            "aaSorting": [],
            "ajax": {
                "url": "<?php echo base_url(); ?>admin/Tools/getInvoiceListByAlias",
                "data": {
                    "alias_name": alias_name,
                    "ref_id": ref_id
                },
                "type": "GET",
                "dataSrc": "data"
            },
            "dom": 'Bfrtip',
            "buttons": [
                        {
                            extend: 'csv',
                            text: '<i class="fa fa-file-excel-o"></i> CSV',
                            className: 'btn btn-sm btn-success',
                        }
                    ],
            "columns": [{
                    "className": 'details-control invoiceid_td_cls',
                    "data": "invoice_id"
                },
                {
                    "data": "invoice_code"
                },
                {
                    "data": "vendor_name"
                },
                {
                    "data": "sales_code"
                },
                {
                    "data": "alias_name"
                },
                {
                    "data": "sales_channel"
                },
                {
                    "data": "saleschannel_ref_id"
                },

                {
                    "data": "quantity"
                },
                {
                    "data": "amount"
                },
                {
                    "data": "tax"
                },
                {
                    "data": "amount_ex_tax"
                },
                {
                    "data": "discount_amount"
                },
                {
                    "data": "freight_amount"
                },
                {
                    "data": "insurance_amount"
                },
                {
                    "data": "tcs_amount"
                },
                {
                    "data": "net_invoice_amount"
                },
               
                {
                    "data": "LAST_UPDATE_DATE"
                }
            ]
        })
    }

    $('#alias_invoice_list_table tbody').on('click', 'td.details-control', function() {
        var tr = $(this).closest('tr');
        var row = alias_invoice_list_table.row(tr);
        if (row.child.isShown()) {
            row.child.hide();
            tr.removeClass('shown');
        } else {
            row.child(alias_child_list(row.data())).show();
            tr.addClass('shown');
        }
    });


    function alias_child_list(d) {
        // `d` is the original data object for the row
        var childtable = '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
        $.ajax({
            url: encodeURI("<?php echo base_url(); ?>admin/invoice/get_invoicedetails?invoice_id=" + d.invoice_id),
            type: "GET",
            dataType: 'json',
            async: false,
            success: function(data) {
                if (data.result == null) {
                    childtable += '<tr><td>No Records Found</td></tr>';
                    responseData = null;
                } else {
                    responseData = data.result
                    childtable += '<th>Inwardid</th><th>Product Name</th><th>SKU</th><th>CATEGORY</th><th>PRICE</th><th>TAXABLE AMOUNT</th><th>EXEMPT AMOUNT</th>';
                    childtable += '<th>Tax Amount</th><th>SALES TERMS</th><th>GRADE</th><th>TAX TYPE</th><th>BILL TYPE</th>';
                    $.each(data.result, function(i, d) { // loop through data returned from ajax 
                        childtable += '<tr>' +
                            '<td>' + data.result[i].inward_id + '</td>' +
                            '<td>' + data.result[i].product_name + '</td>' +
                            '<td>' + data.result[i].nhmod + '-' + data.result[i].ram + '-' + data.result[i].rom + '-' + data.result[i].color_code + '</td>' +
                            '<td>' + data.result[i].category + '</td>' +
                            '<td>' + data.result[i].price + '</td>' +
                            '<td>' + data.result[i].taxable + '</td>' +
                            '<td>' + data.result[i].unit_price + '</td>' +
                            '<td>' + data.result[i].tax_amount + '</td>' +
                            '<td>' + data.result[i].sales_terms + '</td>' +
                            '<td>' + data.result[i].grade + '</td>' +
                            '<td>' + data.result[i].tax_type + '</td>' +
                            '<td>' + data.result[i].bill_type + '</td>' +
                            '</tr>';
                    });
                }
            }
        });

        childtable += '</table>';
        //childtable += '<button class="btn btn-info" onclick="downloadTraceBulkDevice()">Download</button>'
        childtable += getSOFilesList(d.invoice_id)
        childtable += in_remarks_table(d.invoice_id)
        return childtable
    }

    function getSaleschannelRefIdByAlias(alias_name = '') {
        $("#select_invoice_ref_id_alias").empty()
        $("#select_invoice_ref_id_alias").append("<option value = ''>SELECT REF ID</option>")
        $("#select_invoice_ref_id_alias").change()
        if (alias_name == '') {
            return false
        }

        $.ajax({
            "url": "<?= base_url() ?>admin/Tools/getSaleschannelRefIdByAlias",
            "method": "GET",
            "data": {
                "alias_name": alias_name
            },
            "dataType": "json",
            "success": function(data) {

                var options = ''
                $.each(data.result, function(i, v) {

                    options += '<option value="' + data.result[i].saleschannel_ref_id + '">' + data.result[i].saleschannel_ref_id + '</option>'
                })

                $("#select_invoice_ref_id_alias").append(options)
            }

        })
    }
</script>