<div class="col-md-12" style="align-items: center;">
    <div class="tabel-responsive" style="width:90%">
        <table class="table table-bordered" style="margin: auto;">
            <thead>
                <tr>
                    <th>S.No</th>
                    <th style="min-width: 250px;">Order No</th>
                    <th style="min-width: 250px;">TDID / IMEI / WSN NO</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody class="tbody_inv_rows">
                <tr class="invoice_rows" id="invoice_row_1">
                    <td>
                        <span class="invoice_row_no">1</span>
                    </td>
                    <td>
                        <input type="text" class="form-control order_no" name="order_no[]" placeholder="Order No" onchange="onOrderChange(this)">
                    </td>
                    <td>
                        <input type="text" class="form-control tdid_imei_wsn_no" name="tdid_imei_wsn_no[]" placeholder="TDID / IMEI / WSN NO" onchange="addDeviceId(this)">
                    </td>
                    <td>
                        <span class="fa fa-trash remove_row" style="cursor:pointer;"></span>
                        &nbsp;&nbsp;&nbsp;
                        <span class="fa fa-plus" style="cursor:pointer; color:green;" onclick="addInvoiceRow()"></span>
                    </td>
                    <input type="hidden" name="device_id[]" class="device_id" value="">
                    <input type="hidden" name="order_id[]" class="order_id" value="">
                </tr>
            </tbody>
        </table>
        <div class="col-md-12" style="text-align: center; margin:15px">
            <button type="button" class="btn btn-green" onclick="submitBulkInvoice()">Submit</button>
            &nbsp;&nbsp;&nbsp;
            <button type="button" class="btn btn-grey" onclick="location.replace('<?= base_url() ?>admin/Finance/create_invoice')">Back</button>
        </div>
    </div>
</div>

<script>
    let bulk_invoice_devices = [];

    function addInvoiceRow() {
        let html = $("#invoice_row_1").html();
        $(".tbody_inv_rows").append('<tr class="invoice_rows">' + html + '</tr>');
        $(".tbody_inv_rows tr:last-child").find(".order_no").focus();
        $(".tbody_inv_rows tr:last-child").find(".remove_row").attr("onclick", "removeInvoiceRow(this)").css("color", "red");
        addSerialNo();
    }

    function removeInvoiceRow(obj) {
        $(obj).closest('tr').remove();
        addSerialNo();
    }

    function addSerialNo() {
        $(".invoice_rows").each(function(i, v) {
            $(this).find(".invoice_row_no").text(i + 1);
        });
    }

    function checkNullUndefined(entity, msg) {
        if (entity == null || entity == undefined || entity == "") {
            return msg;
        }
        return '';
    }

    function addDeviceId(e) {
        $(e).closest('tr').find('.device_id').val('');
        $(e).closest('tr').find('.order_id').val('');
        let tdid_imei_wsn_no = $(e).val();
        let order_no = $(e).closest('tr').find('.order_no').val();
        let fields_required = ''

        fields_required += checkNullUndefined(order_no, 'Order No, ');
        fields_required += checkNullUndefined(tdid_imei_wsn_no, 'TDID / IMEI / WSN NO');

        if (fields_required != '') {
            toastr.error(fields_required + ' is required');
            return false;
        }

        let jsonObject = {
            'order_no': order_no,
            'tdid_imei_wsn_no': tdid_imei_wsn_no
        };

        $.ajax({
            url: '<?php echo base_url(); ?>admin/Invoice/checkDeviceForBulkInvoice',
            type: 'POST',
            data: JSON.stringify(jsonObject),
            dataType: 'json',
            success: function(response) {
                if (response.status != 1) {
                    toastr.error(response.message);
                    return false
                }
                if (bulk_invoice_devices.indexOf(tdid_imei_wsn_no) != -1) {
                    toastr.error('TDID / IMEI / WSN NO already added');
                    return false
                }
                $(e).closest('tr').find('.device_id').val(response.data.device_id);
                $(e).closest('tr').find('.order_id').val(response.data.salesorder_id);
                bulk_invoice_devices.push(response.device_id);
                addInvoiceRow()
            },
            error: function(error) {
                toastr.error('Failed to get Order Details');
            }
        });
    }

    function onOrderChange(e) {
        let order_no = $(e).val();
        $(e).closest('tr').find('.device_id').val('');
        $(e).closest('tr').find('.order_id').val('');
        $(e).closest('tr').find('.tdid_imei_wsn_no').val('');
        $(e).closest('tr').find('.tdid_imei_wsn_no').focus();
    }

    function submitBulkInvoice() {
        let fields_required = '';
        let order_dets = {}

        $(".tbody_inv_rows tr").each(function() {
            let order_no = $(this).find('.order_no').val();
            let order_id = $(this).find('.order_id').val();
            let tdid_imei_wsn_no = $(this).find('.tdid_imei_wsn_no').val();
            let device_id = $(this).find('.device_id').val();

            if (order_no == '' || order_no == null) {
                return true
            }
            if(order_dets[order_id] != undefined) {
                order_dets[order_id].push(device_id);
            }else{
                order_dets[order_id] = [device_id];
            }
        });

        let jsonObject = JSON.stringify(order_dets);

        $.ajax({
            url: '<?php echo base_url(); ?>admin/Invoice/submitBulkInvoice',
            type: 'POST',
            data: jsonObject,
            dataType: 'json',
            success: function(response) {
                if (response.status != 1) {
                    toastr.error(response.message);
                    return false
                }
                toastr.success(response.message);
                setTimeout(function() {
                    window.location.href = '<?php echo base_url(); ?>admin/Finance/create_invoice';
                }, 1000);
            }
        });
    }
</script>