<?php echo message_box('success'); ?>
<?php echo message_box('error'); ?>
<?php echo message_box('warning'); ?>

<div class="table-responsive">
		<table class="table table-striped DataTables" id="advance_payment" cellspacing="0"  >
			<thead>
			<tr>
				<th style="width:50px"></th>
				<th style="width:100px">DATE</th>
				<th style="width:150px" >RECEIPT #</th>
				<th style="width:100px" >VENDOR CODE</th>
				<th style="width:100px" >NAME</th>
				<th style="width:100px" >GST NO</th>
				<th style="width:100px" >MOBILE</th>
				<th style="width:100px" >CASH</th>
				<th style="width:100px" >ONLINE</th> 
				<th style="width:100px" >CHEQUE</th>  
				<th style="width:100px" >CARD</th>  
				<th style="width:100px" >TOTAL</th>      
				<th style="width:200px" ><?= lang('action') ?></th>
			</tr>
			</thead>
			<tbody> 
				<?php 
					foreach($result as $value)
					{
				?>
					<tr>
						<td></td>
						<td><?= strftime(config_item('date_format'), strtotime($value->created_date)) ?></td>
						<td>
						<?php 
							$userLocation=$this->Common_model->getFieldValue('location','tbl_account_details','user_id',$value->user_id);
							
							if($userLocation=='BANGALORE')
							{
								echo "NHBAP-".$this->Common_model->getSeriesForInvoiceCode($value->payment_id);
							}
							else
							{
								echo "NHDAP-".$this->Common_model->getSeriesForInvoiceCode($value->payment_id);
							} 
						?></td> 
						<td><?php echo $value->vendor_code; ?></td> 
						<td><?php echo $value->name; ?></td> 
						<td><?php echo $value->gst; ?></td> 
						<td><?php echo $value->mobile; ?></td> 
						<td><?php echo $value->cash; ?></td> 
						<td><?php echo $value->online; ?></td> 
						<td><?php echo $value->cheque; ?></td>    
						<td><?php echo $value->card; ?></td>  
						<td><?php echo $value->total; ?></td>       
						<td > 
							 <a href="<?php echo base_url(); ?>admin/print-advancepayment-receipt/<?php echo $value->payment_id; ?>" class="btn btn-danger btn-xs" title="" data-toggle="tooltip" data-placement="top" data-original-title="PRINT"><i class="fa fa-print"></i></a>
							 
							 <a href="<?php echo base_url(); ?>admin/Finance/manage_advancepayment/<?php echo $value->payment_id; ?>/2" class="btn btn-primary btn-xs" title="" data-toggle="tooltip" data-placement="top" data-original-title="Edit"><i class="fa fa-pencil-square-o"></i></a>
																 
							 <a href="<?php echo base_url(); ?>admin/Finance/deleteAdvancePayment/<?php echo $value->payment_id; ?>" class="btn btn-danger btn-xs" title="" data-toggle="tooltip" data-placement="top" onclick="return confirm('You are about to delete a record. This cannot be undone. Are you sure?');" data-original-title="Delete"><i class="fa fa-trash-o"></i></a>
						 
						 </td>
					</tr> 
					<?php } ?>
			</tbody>
			 <tfoot>
            <tr>
				<th colspan="7" style="text-align:right;color:#4bc14d">TOTAL:</th>    
				<th colspan="1" style="text-align:center;color:#4bc14d"></th> 
				<th colspan="1" style="text-align:center;color:#4bc14d"></th> 
				<th colspan="1" style="text-align:center;color:#4bc14d"></th> 
				<th colspan="1" style="text-align:center;color:#4bc14d"></th> 
				<th colspan="1" style="text-align:center;color:#4bc14d"></th> 
				<th colspan="1" style="text-align:center;color:#4bc14d"></th> 
            </tr>
        </tfoot>
		</table>
	</div>

<script>


$(document).ready(function() {
	
$('#advance_payment').DataTable( {

		 "dom": 'lBfrtip',
		"scrollX":true,
		  "buttons": [
			{
				extend: 'print',
				text: "<i class='fa fa-print'> </i>",
				className: 'btn btn-danger btn-xs mr',
				exportOptions: {
					columns: 'th:not(:first-child),th:not(:last-child)',
				}
			},
			{
				extend: 'print',
				text: '<i class="fa fa-print"> </i> &nbsp;<?= lang('selected')?>',
				className: 'btn btn-success mr btn-xs',
				exportOptions: {
					modifier: {
						selected: true,
						columns: 'th:not(:first-child),th:not(:last-child)', 
					}
				}

			},
			{
				extend: 'excel',
				text: '<i class="fa fa-file-excel-o"> </i>',
				className: 'btn btn-purple mr btn-xs',
				 exportOptions: {
						columns: 'th:not(:first-child),th:not(:last-child)',
					}
			},
			{
				extend: 'csv',
				text: '<i class="fa fa-file-excel-o"> </i>',
				className: 'btn btn-primary mr btn-xs',
				 exportOptions: 
				 {
						columns: 'th:not(:first-child),th:not(:last-child)', 
				 }
			},
			{
				extend: 'pdf',
				text: '<i class="fa fa-file-pdf-o"> </i>',
				className: 'btn btn-info mr btn-xs',
				 exportOptions: {
					columns: 'th:not(:first-child),th:not(:last-child)',
				}
			},
		],
		
		'aoColumnDefs': [ {
		'targets': [ 0 ],
		 'render': function (data, type, full, meta){
			return '<input type="checkbox" name="id[]" value="'+ $('<div/>').text(data).html() + '">';
			}
		},
		
		],
		
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
			 
            // Remove the formatting to get integer data for summation
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            // Total over all pages
			
			cash = api.column( 7, { page: 'current'} ).data().reduce( function (a, b) { return intVal(a) + intVal(b);}, 0 );
			
			online = api.column( 8, { page: 'current'} ).data().reduce( function (a, b) { return intVal(a) + intVal(b);}, 0 );
			
			cheque = api.column( 9, { page: 'current'} ).data().reduce( function (a, b) { return intVal(a) + intVal(b);}, 0 );
			
			card = api.column( 10, { page: 'current'} ).data().reduce( function (a, b) { return intVal(a) + intVal(b);}, 0 );
			
			total = api.column( 11, { page: 'current'} ).data().reduce( function (a, b) { return intVal(a) + intVal(b);}, 0 );

            // Update footer
			
            $( api.column(7).footer() ).html(currencyFormat(cash));
			
            $( api.column(8).footer() ).html(currencyFormat(online));
			
            $( api.column(9).footer() ).html(currencyFormat(cheque));
			
            $( api.column(10).footer() ).html(currencyFormat(card));
			
            $( api.column(11).footer() ).html(currencyFormat(total)); 
        }
    } );
} );
 
</script>