
<label style="margin-left: 10px; padding-right: 10px">
    UPLOAD PRICE SHEET
</label>
<hr>
<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;">
    <div class="col-md-8  col-sm-8 col-lg-8 col-xs-8" style="padding:0px">
        <div class="form-group">
            <label class="col-lg-2 control-label">UPLOAD PRICE SHEET</label>


            <div class="col-lg-3" style="text-align: center;">
                <!-- Upload excel file Button -->
                <input type="file" id="upload_mrp" value="SELECT FILE">
            </div>
            <div class="col-lg-3" style="text-align: center;">
                <input type="text" id="upload_mrp_lot_no" placeholder="Lot No">
            </div>
            <div class="col-lg-3" style="text-align: center;">
                <input type="button" id="upload_mrp_btn" class="btn btn-primary" onclick="uploadMRP()" value="UPLOAD" readonly>
            </div>
            <div class="col-lg-1" style="text-align: center;">
                <!-- Sample File Button -->
                <input type="button" id="sample_mrp_btn" class="btn btn-green" onclick="sampleMRP()" value="SAMPLE FILE" readonly>
            </div>
        </div>
    </div>
</div>

<script>
    function uploadMRP() {
        //disable upload button
        $('#upload_mrp_btn').attr('disabled', true);
        
        //read csv file from input
        var file = $('#upload_mrp').prop('files')[0];

        var lot_no = $( "#upload_mrp_lot_no" ).val();

        if(lot_no == '' || lot_no == undefined){
            alert('Please enter lot no');
            $('#upload_mrp_btn').attr('disabled', false);
            return;
        }

        //check file is csv or not
        if (file.name.split('.').pop() != 'csv') {
            alert('Please select csv file');
            $('#upload_mrp_btn').attr('disabled', false);
            return false;
        }
        //Read the file add first column to as device id and second column as retail price into an object
        var reader = new FileReader();
        reader.onload = function (e) {
            var lines = e.target.result.split('\n');
            var data = [];
            var headers = ['device_id', 'mrp'];
            for (var i = 1; i < lines.length; i++) {
                var obj = {};
                var currentline = lines[i].split(',');
                if(currentline[0] == undefined || currentline[0] == ''){
                    continue;
                }
                if(currentline[1] == undefined || currentline[1] == ''){
                    continue;
                }
                obj = {
                    device_id: currentline[0].trim(),
                    mrp: currentline[1].replace('\r', '').trim(),
                    lot_no: lot_no
                };
                data.push(obj);
            }
            //if data is empty then show error
            if (data.length == 0) {
                toastr.error('Please select csv file');
                $('#upload_mrp_btn').attr('disabled', false);
                return false;
            }
            var jsonObject = JSON.stringify(data);
    
            //send data to server
            $.ajax({
                url: '<?= base_url() ?>admin/Fastcheckout/uploadMRP',
                type: 'POST',
                data: jsonObject,
                dataType: 'JSON',
                success: function (response) {
		    
                    if(response.status == 1){
                        toastr.success(response.message);
                        window.location.replace('<?= base_url() ?>admin/Fastcheckout/manage_fastcheckout');
                    }else{
                        toastr.error(response.message);
                        $('#upload_mrp_btn').attr('disabled', false);
                        return false
                    }

                },
                error: function (error) {
		    
                    toastr.error('Failed to Update MRP');
                    $('#upload_mrp_btn').attr('disabled', false);
                }
            });
        }
        reader.readAsText(file);
        ;
    }

    function sampleMRP() {
        window.open('<?php echo base_url(); ?>assets/sample/sample_price_sheet.csv');
    }
</script>