<style>
    /*form styles*/
    #msform {
        width: 100%;
        margin: 20px auto;
        text-align: center;
        position: relative;
    }

    #msform fieldset {
        background: white;
        border: 0 none;
        border-radius: 3px;
        box-shadow: 0 0 15px 1px rgba(0, 0, 0, 0.4);
        padding: 20px 30px;
        box-sizing: border-box;
        width: 80%;
        margin: 0 10%;

        /*stacking fieldsets above each other*/
        position: relative;
    }

    /*Hide all except first fieldset*/
    #msform fieldset:not(:first-of-type) {
        display: none;
    }

    /*inputs*/
    #msform input,
    #msform textarea {
        padding: 15px;
        border: 1px solid #ccc;
        border-radius: 3px;
        margin-bottom: 10px;
        width: 100%;
        box-sizing: border-box;
        font-family: montserrat;
        color: #2C3E50;
        font-size: 13px;
    }

    /*buttons*/
    #msform .action-button {
        width: 100px;
        background: #27AE60;
        font-weight: bold;
        color: white;
        border: 0 none;
        border-radius: 1px;
        cursor: pointer;
        padding: 10px 5px;
        margin: 10px 5px;
    }

    #msform .action-button:hover,
    #msform .action-button:focus {
        box-shadow: 0 0 0 2px white, 0 0 0 3px #27AE60;
    }

    #msform .add-button {
        width: 110px;
        background: #9784b5;
        font-weight: bold;
        color: white;
        border: 0 none;
        border-radius: 1px;
        cursor: pointer;
        padding: 10px 5px;
        margin: 10px 5px;
    }

    /*headings*/
    .fs-title {
        font-size: 15px;
        text-transform: uppercase;
        color: #2C3E50;
        margin-bottom: 10px;
    }

    .fs-subtitle {
        font-weight: normal;
        font-size: 13px;
        color: #666;
        margin-bottom: 20px;
    }

    /*progressbar*/
    #progressbar {
        margin-bottom: 30px;
        overflow: hidden;
        /*CSS counters to number the steps*/
        counter-reset: step;
    }

    #progressbar li {
        list-style-type: none;
        color: black;
        text-transform: uppercase;
        font-size: 9px;
        width: 18%;
        float: left;
        position: relative;
    }

    #progressbar li:before {
        content: counter(step);
        counter-increment: step;
        width: 20px;
        line-height: 20px;
        display: block;
        font-size: 10px;
        color: #333;
        background: white;
        border-radius: 3px;
        margin: 0 auto 5px auto;
    }

    /*progressbar connectors*/
    #progressbar li:after {
        content: '';
        width: 100%;
        height: 2px;
        background: green;
        position: absolute;
        left: -50%;
        top: 9px;
        z-index: -1;
        /*put it behind the numbers*/
    }

    #progressbar li:first-child:after {
        /*connector not needed before the first step*/
        content: none;
    }

    /*marking active/completed steps green*/
    /*The number of the step and the connector before it = green*/
    #progressbar li.active:before,
    #progressbar li.active:after {
        background: #27AE60;
        color: green;
    }
</style>

<input type="button" class="btn btn-success" id="upload" value="Shipping To" data-toggle="modal" onclick="shippingModel()" />
<!-- multistep form -->
<div id="msform">
    <!-- progressbar -->
    <ul id="progressbar">
        <li class="active">Select Customer</li>
        <li>Enter Order Details</li>
        <li>Add Products</li>
        <li>Add Payment Details</li>
        <li>Review Order</li>
    </ul>
    <!-- Customer Information -->
    <fieldset>
        <h2 class="fs-title">Select Customer</h2>
        <h3 class="fs-subtitle">Step 1 of 5</h3>
        <!-- Add Two Buttons to Select Existing Customer or New Customer -->
        <div class="btn-group btn-toolbar" data-toggle="buttons">
            <label class="btn btn-primary active" style="margin: 50px;">
                <input type="radio" name="customer_options" id="btn_existing_customer" value="existing_number">EXISTING CUSTOMER
            </label>
            <!-- <label class="btn btn-primary" style="margin: 50px;" disabled>
                <input type="radio" name="customer_options" id="btn_new_customer" value="new_customer">NEW CUSTOMER
            </label> -->
            <input type="hidden" name="customer_options" id="customer_options" value="existing_customer">
        </div>

        <br>
        <div class="row" style="display: block;">
            <div class="form-group">
                <div class="col-sm-4">
                    <label style="margin-right: 10px;">Select Alias Name</label>
                </div>
                <div class="col-sm-4">
                    <!-- <input type="email" class="form-control" id="input_alias"> -->
                    <input type="text" class="form-control" id="input_alias" list="aliasList" style="width: 350px;" placeholder="Parent Entity">
                    <datalist id="aliasList">

                    </datalist>
                </div>
            </div>
        </div>
        <br>
        <!-- Customer Existing Modal -->
        <div class="row" id="customerExistingDiv" style="display:block;">
            <!-- Select Customer Id -->
            <div class="form-group">
                <!-- Payment Mode -->
                <div class="col-sm-4">

                    <label for="customer_id" style="margin-right: 10px;">Select Customer</label>
                </div>
                <div class="col-sm-4">

                    <select class="form-control select_box" id="customer_id" name="customer_id" style="width: 350px;">
                        <option value="">Select Customer</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-horizontal" id="customerNewDiv" style="display: none;">
            <div class="form-group" style="margin: 20px;">
                <!-- Customer Name -->
                <div class="col-sm-4">
                    <input type="text" name="customer_company" id="customer_name" class="form-control" placeholder="Customer Company Name" />
                </div>
                <!-- Customer Name -->
                <div class="col-sm-4">
                    <input type="text" name="customer_name" id="customer_name" class="form-control" placeholder="Customer Name" />
                </div>
                <!-- Customer Mobile -->
                <div class="col-sm-4">
                    <input type="text" name="customer_mobile" id="customer_mobile" class="form-control" placeholder="Customer Mobile" />
                </div>
            </div>
            <!-- Add Customer Address -->
            <div class="form-group" style="margin: 20px;">
                <div class="col-sm-4">
                    <input type="text" name="customer_address" id="customer_address" class="form-control" placeholder="Customer Address" />
                </div>
                <!-- Customer City -->
                <div class="col-sm-4">
                    <input type="text" name="customer_city" id="customer_city" class="form-control" placeholder="Customer City" />
                </div>
                <!-- Customer State -->
                <div class="col-sm-4">
                    <select name="customer_state" id="customer_state" class="form-control select_box" style="width: 100%;">
                        <option value="">Select State</option>
                    </select>
                </div>
            </div>

            <!-- Add Customer PINCODE, GSTIN and PAN -->
            <div class="form-group" style="margin: 20px;">
                <!-- Customer PIN -->
                <div class="col-sm-4">
                    <input type="number" name="customer_pincode" id="customer_pincode" maxlength="6" class="form-control" placeholder="PIN CODE" />
                </div>
                <div class="col-sm-4">
                    <input type="text" name="customer_gstin" id="customer_gstin" class="form-control" placeholder="Customer GSTIN" />
                </div>
                <!-- Customer PAN -->
                <div class="col-sm-4">
                    <input type="text" name="customer_pan" id="customer_pan" class="form-control" placeholder="Customer PAN" />
                </div>

            </div>

            <div class="form-group" style="margin: 20px;">
                <!-- Customer PIN -->
                <div class="col-sm-4">
                    <input type="text" name="customer_email" id="customer_email" class="form-control" placeholder="Email" />
                </div>

            </div>
        </div>
        <br>
        <input type="button" name="next" class="next action-button" value="Next" id="customer_next_btn" />

    </fieldset>
    <fieldset>
        <h2 class="fs-title">Enter Order Details</h2>
        <h3 class="fs-subtitle">Step 2 of 5</h3>
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-horizontal">
            <div class="form-group" style="margin: 20px;">
                <div class="col-sm-4">
                    <select name="sales_executive_id" id="sales_executive_id" class="form-control">
                        <option value="">Sales Executive</option>
                    </select>
                </div>

                <div class="col-sm-4">
                    <select name="sub_category_id" id="sub_category_id" class="form-control">
                        <option value="">Sub Category</option>
                    </select>
                </div>
                <!-- Payment Mode -->
                <div class="col-sm-4">
                    <select name="payment_mode" id="payment_mode" class="form-control">
                        <option value="">Payment Mode</option>
                    </select>
                </div>
            </div>
            <!-- Add Sales Channel Ref Id, Remarks -->
            <div class="form-group" style="margin: 20px;">
                <!-- Sales Channel Ref Id -->
                <div class="col-sm-4">
                    <input type="text" name="sales_channel_ref_id" id="sales_channel_ref_id" class="form-control" placeholder="Sales Channel Ref Id" />
                </div>
                <!-- Remarks/Text Area -->
                <div class="col-sm-4">
                    <textarea name="remarks" id="remarks" class="form-control" placeholder="Remarks"></textarea>
                </div>
                <div class="col-sm-4">
                    <!--<select name="shipping_from" id="shippingFrom" class="form-control select_box">-->
                    <!--    <option value="">Select Shipping From</option>-->
                    <!--</select>-->
                    <select name="shipping_from" id="shippingFrom" class="form-control select_box" style="width:100%">
                        <option value="">Shipping From</option>
                    </select>
                </div>
            </div>
        </div>
        <br>
        <input type="button" name="previous" class="previous action-button" value="Previous" />
        <input type="button" name="next" class="next action-button" id="order_det_next_btn" value="Next" />

    </fieldset>
    <fieldset>
        <h2 class="fs-title">Add Products</h2>
        <h3 class="fs-subtitle">Step 3 of 5</h3>


        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-horizontal">
            <div class="form-group" style="margin: 20px;">
                <div class="col-sm-4" style="height: fit-content;">
                    <input type="file" name="fc_file_upload" id="fc_file_upload" />
                </div>

                <div class="col-sm-3">
                    <button class="add-button" type="button" style="width: 100px; background-color:indianred" onclick="uploadProducts()">Upload</button>
                </div>
            </div>
            <div class="form-group" style="margin: 20px;">
                <div class="col-sm-3">
                    <select name="sales_terms" id="sales_terms" class="form-control">
                        <option value="">SALES TERMS</option>
                        <option value="ASIS">AS IS</option>
                        <option value="POWER ON">POWER ON</option>
                        <option value="FULL QC" selected>FULL QC</option>
                    </select>
                </div>
                <div class="col-sm-3">
                    <input type="text" name="tdid" id="tdid" maxlength="13" class="form-control" placeholder="Scan Product TDID" />
                </div>
            </div>

        </div>
        <hr style="border-top: 1px solid #ccc;">
        <!-- Table for the Product List contains TDID, product Name, SKU, Grade, Price, and Delete/Trash Icon-->
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-horizontal" style="width: 100%; ">
            <div class="form-group" style="margin: 20px;">
                <div class="col-sm-12" style=" overflow-x:auto;">
                    <table class="table table-bordered table-hover" id="product_list">
                        <thead>
                            <tr>
                                <th>Action</th>
                                <th>TDID</th>
                                <th>Product Name</th>
                                <th>SKU</th>
                                <th>Grade</th>
                                <th>Price</th>
                                <th>Category</th>
                                <th>Sales Terms</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>

            </div>
            <!-- Table With Particular, Amount -->
            <div class="col-sm-8" style="overflow-x: auto; margin: 20px;">
                <table class="table table-bordered table-hover" id="product_total_tbl">
                    <thead>
                        <tr>
                            <th>Particular</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Total Quantity</td>
                            <td id="total_quantity"></td>
                        </tr>
                        <tr>
                            <td>Total Amount</td>
                            <td id="total_amount"></td>
                        </tr>
                    </tbody>
                    <tr>
                        <td id="create_td_discount_text">Discount</td>
                        <td class="row">
                            <div style="display: inline-flex;">
                                <input type="text" class="form-control" value="0" id="create_td_discount_val" style="width: 100px;" onchange="getNetAmount()" />
                                <select class="form-control" id="create_td_discount_type_select" style="width: 100px;" onchange="getNetAmount()" >
                                    <option value="percentage">%</option>
                                    <option value="amount">Amt</option>
                                </select>
                            </div>
                        </td>
                        <td><span id="create_td_discount_amount"></span></td>
                    </tr>
                    <tr>
                        <td id="create_td_discount_text">Freight</td>
                        <td class="row">
                                <input type="text" class="form-control" value="0" id="create_td_freight_val" style="width: 100px;" onchange="getNetAmount()" />
                               
                        </td>
                    </tr>
                    <tr>
                        <td id="create_td_discount_text">Net Amount(Excl TCS)</td>
                        <td class="row">
                            <span id="create_excl_tcs_net_amount"></span>
                        </td>
                    </tr>
                        <td id="create_td_tcs_text"></td>
                        <td class="row">
                            <span id="create_td_tcs_value"></span>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>Total Invoice Value</td>
                        <td class="row">
                            <span id="create_gross_invoice_amount"></span>
                        </td>
                    </tr>

                    <input type="hidden" id="tcs_value">
                    <input type="hidden" id="tcs_percentage">
                </table>
            </div>
        </div>
        <br>
        <input type="button" name="previous" class="previous action-button" value="Previous" />
        <input type="button" name="next" class="next action-button" id="items_next_btn" value="Next" />

    </fieldset>
    <fieldset>
        <h2 class="fs-title">Enter Payment Details</h2>
        <h3 class="fs-subtitle">Step 4 of 5</h3>
        <div class="form-group" style="margin: 20px;">
            <div class="table-responsive scrolledTable">
                <table class="table">
                    <tr>
                        <td>
                            Select Existing Receipt
                        </td>
                        <td>
                            <select id="select_receipt" class="form-control select_box" style="width: 300px;">
                                <option value="">SELECT RECEIPT</option>
                            </select>
                        </td>
                        <td style="text-align: left;">
                            <button class="add-button" type="button" onclick="addReceipt()">Add</button>
                        </td>
                    </tr>
                </table>

            </div>

            <!-- 
            <hr style="width:90%; border-color:#CCC;">
            <h5 style="text-align: left;">New Receipt</h5>
            <div class="col-sm-4">
                <select name="receipt_type" id="receipt_type" class="form-control">
                    <option value="">Receipt Type</option>
                </select>
            </div>
            <div class="col-sm-4">
                <input type="number" name="receipt_amount" id="receipt_amount" class="form-control" placeholder="Payment Amount" />
            </div>
            <div class="col-sm-4">
                <input type="date" name="receipt_date" id="receipt_date" class="form-control" placeholder="Payment Date" />
            </div>
        </div>

        <div class="form-group" style="margin: 20px;">
            <div class="col-sm-4">
                <select name="bank_account" id="bank_account" class="form-control" />
                <option value="">Bank Account</option>
                </select>
            </div>
            <div class="col-sm-4">
                <input type="text" name="receipt_ref_no" id="receipt_ref_no" class="form-control" placeholder="Reference No" />
            </div>
            <div class="col-sm-4">
                <input type="text" name="verified By" id="verified_by" class="form-control" placeholder="Received or Verified By" />
            </div>
        </div>

        <div class="form-group" style="margin: 20px;">
            <div class="col-sm-12" style="text-align: center;">
                <input type="button" class="add-button" value="Add New Receipt" onclick="addNewReceipt()" />
            </div>
        </div>
        ---->
        </div>
        <table id="t_receipt_details" class="table" style="margin-left:15px;width:100%;">
            <thead>
                <th>Receipt No</th>
                <th>Receipt Type</th>
                <th>Account No</th>
                <th>Reference No</th>
                <th>Received Amount</th>
                <th>Available Amount</th>
                <th>Received Date</th>
                <th>Adjusted Amount</th>
            </thead>
            <tbody id="receipt_table_tbody">
            </tbody>
        </table>
        <input type="button" name="previous" class="previous action-button" value="Previous" />
        <input type="button" name="next" id="receipt_next_btn" class="next action-button" value="Next" />
    </fieldset>
    <fieldset>
        <h2 class="fs-title">Review Order</h2>
        <h3 class="fs-subtitle">Step 5 of 5</h3>

        <!-- Table With Particular, Amount -->
        <div class="col-sm-12" style="overflow-x: auto; margin: 20px;">
            <table class="table table-bordered table-hover" id="review_tbl">
                <thead>
                    <tr>
                        <th>Particular</th>
                        <th>Value</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Customer Name</td>
                        <td id="td_review_customer_name"></td>
                    </tr>
                    <tr>
                        <td>Total Quantity</td>
                        <td id="td_review_qty"></td>
                    </tr>
                </tbody>
                <tr>
                    <td>Invoice Amount</td>
                    <td id="td_review_invoice_amount"></td>
                </tr>
                <tr>
                    <td>Freight Amount</td>
                    <td id="td_review_freight_amount"></td>
                </tr>
                <tr>
                    <td>Discount Amount</td>
                    <td id="td_review_discount_amount"></td>
                </tr>

                <tr>
                    <td>TCS Amount</td>
                    <td id="td_review_tcs_amount"></td>
                </tr>

                <tr>
                    <td>Net Amount</td>
                    <td id="td_review_net_invoice_amount"></td>
                </tr>

                <tr>
                    <td>GST Amount</td>
                    <td id="td_review_gst_amount"></td>
                </tr>

            </table>
        </div>
        <br>

        <input type="button" name="previous" class="previous action-button" value="Previous" />
        <input type="button" name="submit" class="submit action-button" id="submit_btn_final" value="Submit" onclick="submitForm()" />
    </fieldset>
</div>

<!-- Shipping to address model start -->
<div class="modal fade" id="shippingModal" role="dialog" aria-labelledby="shippingModalLabel" data-backdrop="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
        
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel"><b style="font-size:14px;"><b>Shipping To</b> </b><span style="text-transform: lowercase;"><b>(Please click here if shipping to same vendor address)</b>  <input type="checkbox" class="shipping_to_checkbox" id="shippingToAddress" style="height:18px;width:18px;"></span> </h5>
        </div>
    
      <div class="modal-body">
        <form>
          <div class="form-group" id="customerCheck" style="display:none">
            <label for="city-text" class="col-form-label">Customer:</label>
            <select class="form-control select_box" id="select_customer" style="width: 100%; height:32px;" onchange="getCustomerDetails()">
                <option value="">SELECT CUSTOMER</option>
				<?php 
								$nameResult=$this->db->query("select vendor_id,company, vendor_code from tbl_vendor where user_type IN ('INDIVIDUAL', 'DEALER') AND used_type = 'buyer' order by company asc")->result();
								
								if(!empty($nameResult))
								{
									foreach($nameResult as $nameResultKey=>$nameResultValue)
									{
							 ?>
										<option value="<?php echo strtoupper($nameResultValue->vendor_id); ?>"><?php echo strtoupper($nameResultValue->company.' / '.$nameResultValue->vendor_code); ?></option>    

							<?php
									}
								}
							?>
			</select>
          </div>
          <div class="form-group">
            <label for="address-name" class="col-form-label">Address: <span style="color:red; font-size:15px">*</span></label>
            <textarea type="text" class="form-control" id="shipping_to_address" required></textarea>
          </div>
          <div class="form-group">
            <label for="city-text" class="col-form-label">City: <span style="color:red; font-size:15px">*</span></label>
            <input type="text" class="form-control" id="shipping_to_city" required>
          </div>
          <div class="form-group">
            <label for="sate-text" class="col-form-label">State: <span style="color:red; font-size:15px">*</span></label>
           <select class="form-control" id="shipping_to_state" style="width: 100%;" required>
				<option value="">SELECT STATE</option>
			</select>
          </div>
          <div class="form-group">
            <label for="pincode-text" class="col-form-label">Pincode: <span style="color:red; font-size:15px">*</span></label>
            <input type="number" class="form-control" id="shipping_to_pincode" required>
          </div>
        </form>
      </div>
      
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-success" id="shipping_submit" value= "submit" onclick = "shippingData()">ADD</button>
      </div>
    </div>
  </div>
</div>
<!-- End -->


<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.3/jquery.easing.min.js"></script>
<script>
    
    // Shipping script start
    $(document).ready(function(){
        
        $.ajax({
            url: "<?php echo base_url(); ?>admin/SalesOrder/fetch_state",
            method: "GET",
            data: {},
            dataType: 'json',
            success: function(data) {
                
                $.each(data, function(i, v) {

                    $("#shipping_to_state").append("<option value=" + data[i].state_id + ">" + data[i].name + "</option>");
                    //$("#shippingFrom").addClass("select_box");
                    
                })
            },

        });
        
        $.ajax({
            url: "<?php echo base_url(); ?>admin/SalesOrder/shippingFromAddress",
            method: "GET",
            data: {},
            dataType: 'json',
            success: function(data) {
                
                $.each(data, function(i, v) {

                    $("#shippingFrom").append("<option value=" + data[i].shipping_from_id + ">" + data[i].state + ' / ' + data[i].city + ' - ' + data[i].pincode + "</option>");
                    
                })
            },

        });
        
    });
    
    function shippingModel() {

		$('#shippingModal').modal('show');
		
	}
	
	$('#shippingToAddress').click(function() {
        if ($('input.shipping_to_checkbox').is(':checked')) {
            $("#customerCheck").show();
            
        } else{
            $("#customerCheck").hide();
            $("#shipping_to_address").val("");
            $("#shipping_to_city").val("");
            $("#shipping_to_state").val("");
            $("#shipping_to_pincode").val("");
        }
    });
    
    function getCustomerDetails(){
    
		var customer_id = $("#select_customer").val()
		$.ajax({
			"url":"<?=base_url()?>admin/SalesOrder/getCustomerDetails",
			"method": "GET",
			"data": { "customer_id": customer_id},
			"dataType": "json",
			"success": function(data){
			   
						if(data.status == 0){
							return false
						}
						
						$("#shipping_to_address").val(data.address);
                        $("#shipping_to_city").val(data.city);
                        $("#shipping_to_state").val(data.state);
                        $("#shipping_to_pincode").val(data.pincode);
						
					}
		})
	}
    
    var shipping_address = [];
    
    function shippingData(){
        
        var to_address = $("#shipping_to_address").val();
        var to_city = $("#shipping_to_city").val();
        var to_state = $("#shipping_to_state").val();
        var to_pincode = $("#shipping_to_pincode").val();
        
        var fieldsRequired = '';

		fieldsRequired += checkNull(to_address, 'Shipping to Address ');
		fieldsRequired += checkNull(to_city, 'Shipping to city ');
		fieldsRequired += checkNull(to_state, 'Shipping to state ');
		fieldsRequired += checkNull(to_pincode, 'Shipping to Pincode ');
		if (fieldsRequired != '') {
            toastr.error("Fields Required: " + fieldsRequired)
            return false
        }
		shipping_address.push({
						    'to_address':to_address,
							'to_city':to_city,
							'to_state':to_state,
							'to_pincode':to_pincode
						});
		if(shipping_address.length != 0){
		    toastr.success("Shipping To Addesss added successfully");
		} else{
		    toastr.error("Failed to add shipping To Address");
		}
		$('#shippingModal').modal('toggle');
		
    }
    
    // Shipping script end

    //jQuery time
    var current_fs, next_fs, previous_fs; //fieldsets
    var left, opacity, scale; //fieldset properties which we will animate
    var animating; //flag to prevent quick multi-click glitches
    var nhdin_arr = []
    var applied_receipts = []
    getVendorList()
    getStates()
    getNewDropdown('DEVICE_SUB_CATEGORY', 'sub_category_id')
    getNewDropdown('PAYMENT_MODE', 'payment_mode')
    getNewDropdown('RECEIPT_TYPE', 'receipt_type')
    getNewDropdown('BANK_ACCOUNTS', 'bank_account')
    getSalesReps()
    getVendorAliases()

    function checkNull(entity, message = '') {
        if (entity == '' || entity == null || entity == undefined || entity == 'undefined') {
            return message
        }
        return ''
    }

    $("#input_alias").on('change', function() {
        var alias = $("#input_alias").val()
        $('#customer_id')
            .find('option')
            .remove()
            .end()
            .append('<option value="">Select Customer</option>')
            .val('')
            .change()
        getVendorList(alias = alias)
    })

    $("#customer_next_btn").click(function() {

        //check which radio button is selected with the name customer_options
        var fieldsRequired = ''
        var customer_options = document.querySelector('#customer_options').value;

        if (customer_options == "new_customer") {
            var customer_name = $("#customer_name").val()
            var customer_mobile = $("#customer_mobile").val()
            var customer_address = $("#customer_address").val()
            var customer_state = $("#customer_state").val()
            var customer_city = $("#customer_city").val()
            var customer_gstin = $("#customer_gstin").val()
            var customer_pan = $("#customer_pan").val()
            var customer_pincode = $("#customer_pincode").val()
            var customer_email = $("#customer_email").val()
            let gstin_regex = new RegExp(/\d{2}[A-Z]{5}\d{4}[A-Z]{1}[A-Z\d]{1}[Z]{1}[A-Z\d]{1}/gm);
            let pan_regex = new RegExp(/[A-Z]{3}[ABCFGHLJPTF]{1}[A-Z]{1}[0-9]{4}[A-Z]{1}/gm)
            let mobile_regex = new RegExp(/^[6-9]\d{9}$/gm)
            let email_regex = new RegExp(/^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/gm)

            fieldsRequired += checkNull(customer_name, 'Customer Name, ')
            fieldsRequired += checkNull(customer_mobile, 'Customer Mobile, ')
            fieldsRequired += checkNull(customer_address, 'Customer Address, ')
            fieldsRequired += checkNull(customer_state, 'Customer State, ')
            fieldsRequired += checkNull(customer_city, 'Customer City, ')
            fieldsRequired += checkNull(customer_pincode, 'Customer Pin Code, ')
            let gst_check = checkNull(customer_gstin, 'Customer GSTIN, ')
            let pan_check = checkNull(customer_pan, 'Customer PAN, ')
            let email_check = checkNull(customer_email, 'Customer Email, ')
            //check gstin
            if (gst_check == '' && (!gstin_regex.test(customer_gstin))) {
                toastr.error('Invalid GSTIN')
                return false
            }
            if (pan_check == '' && (!pan_regex.test(customer_pan))) {
                toastr.error('Invalid PAN No')
                return false
            }
            if (mobile_regex.test(customer_mobile)) {
                fieldsRequired += checkNull(customer_mobile, 'Customer Mobile, ')
            } else {
                toastr.error('Invalid Mobile No')
                return false
            }
            if (email_check == '' && (!email_regex.test(customer_email))) {
                toastr.error('Invalid Email')
                return false
            }

        } else {
            var customer_id = $("#customer_id").val()
            fieldsRequired += checkNull(customer_id, 'Customer ID, ')
        }

        if (fieldsRequired != '') {
            toastr.error(fieldsRequired + 'is/are required')
            return false
        }

        getCustomerTCSValue()
        getReceiptDataforSOCreate()

        nextScreen(this)
    });

    $("#order_det_next_btn").click(function() {
        var fieldsRequired = ''
        //Order Details
        var sales_executive = $("#sales_executive_id").val()
        var device_sub_category = $("#sub_category_id").val()
        var payment_mode = $("#payment_mode").val()
        var saleschannel_ref_id = $("#sales_channel_ref_id").val()
        var remarks = $("#remarks").val()
        var shipping_from_id = $("#shippingFrom").val()
        fieldsRequired += checkNull(sales_executive, 'Sales Executive, ')
        fieldsRequired += checkNull(device_sub_category, 'Device Sub Category, ')
        fieldsRequired += checkNull(payment_mode, 'Payment Mode, ')
        fieldsRequired += checkNull(shipping_from_id, 'Shipping From ');

        if (fieldsRequired != '') {
            toastr.error(fieldsRequired + 'is/are required')
            return false
        }

        nextScreen(this)
    })

    $("#items_next_btn").click(function() {
        var fieldsRequired = ''
        //item Details
        var item_details = []
        var gross_amount = 0
        var check = false
        $('#product_list tbody tr').each(function() {
            let grnreport_id = $(this).closest('tr').find('.grnreport_id').val();
            let price = $(this).closest('tr').find('.td_price').text();
            let nhdin = $(this).closest('tr').find('.td_nhdin').text();
            if (grnreport_id > 0) {
                item_details.push({
                    'grnreport_id': grnreport_id,
                    'price': price,
                    'nhdin': nhdin
                })
            } else {
                toastr.error("Invalid Device ID " + nhdin)
                check = true
                return false
            }
            if (price <= 0) {
                toastr.error("Invalid Price " + nhdin)
                check = true
                return false
            }
            gross_amount += parseFloat(price)
        });

        if (check) {
            return false
        }

        if (item_details.length <= 0) {
            toastr.error('Please Add atleast one item')
            return false
        }

        if (fieldsRequired != '') {
            toastr.error(fieldsRequired + 'is/are required')
            return false
        }
        calculateTax()
        nextScreen(this)
    })

    $("#receipt_next_btn").click(function() {

        var total_adjusted_amount = 0
        //Total Receipt Amount
        $(".tr_receipt_details").each(function() {
            var adjusted_amount = $(this).find('input.receipt_input_adjusted_amount').val()
            if (adjusted_amount > 0) {
                total_adjusted_amount += parseFloat(adjusted_amount)
            }
        });

        $(".tr_new_receipt_details").each(function() {
            var adjusted_amount = $(this).find('input.receipt_input_adjusted_amount').val()
            if (adjusted_amount > 0) {
                total_adjusted_amount += parseFloat(adjusted_amount)
            }
        });

        var invoice_amount = $("#create_gross_invoice_amount").text()
        if (parseFloat(total_adjusted_amount) < (parseFloat(invoice_amount) - 5)) {

            toastr.error("Adjusted Amount Less than Sales Order Amount")
            return false
        }
        if (parseFloat(total_adjusted_amount) > (parseFloat(invoice_amount) + 5)) {

            toastr.error("Adjusted Amount exceeds Sales Order Amount")
            return false
        }
        getReviewDetails()
        nextScreen(this)
    })

    $(".previous").click(function() {
        if (animating) return false;
        animating = true;

        current_fs = $(this).parent();
        previous_fs = $(this).parent().prev();

        //de-activate current step on progressbar
        $("#progressbar li").eq($("fieldset").index(current_fs)).removeClass("active");

        //show the previous fieldset
        previous_fs.show();
        //hide the current fieldset with style
        current_fs.animate({
            opacity: 0
        }, {
            step: function(now, mx) {
                //as the opacity of current_fs reduces to 0 - stored in "now"
                //1. scale previous_fs from 80% to 100%
                scale = 0.8 + (1 - now) * 0.2;
                //2. take current_fs to the right(50%) - from 0%
                left = ((1 - now) * 50) + "%";
                //3. increase opacity of previous_fs to 1 as it moves in
                opacity = 1 - now;
                current_fs.css({
                    'left': left
                });
                previous_fs.css({
                    'transform': 'scale(' + scale + ')',
                    'opacity': opacity,
                    'position': 'relative'
                });
            },
            duration: 800,
            complete: function() {
                current_fs.hide();
                animating = false;
            },
            //this comes from the custom easing plugin
            easing: 'easeInOutBack'
        });
    });

    //next Function
    function nextScreen(d) {
        if (animating) return false;
        animating = true;

        current_fs = $(d).parent();
        next_fs = $(d).parent().next();

        //activate next step on progressbar using the index of next_fs
        $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

        //show the next fieldset
        next_fs.show();
        //hide the current fieldset with style
        current_fs.animate({
            opacity: 0
        }, {
            step: function(now, mx) {
                //as the opacity of current_fs reduces to 0 - stored in "now"
                //1. scale current_fs down to 80%
                scale = 1 - (1 - now) * 0.2;
                //2. bring next_fs from the right(50%)
                left = (now * 50) + "%";
                //3. increase opacity of next_fs to 1 as it moves in
                opacity = 1 - now;
                current_fs.css({
                    'transform': 'scale(' + scale + ')',
                    'position': 'absolute'
                });
                next_fs.css({
                    'left': left,
                    'opacity': opacity
                });
            },
            duration: 800,
            complete: function() {
                current_fs.hide();
                animating = false;
            },
            //this comes from the custom easing plugin
            easing: 'easeInOutBack'
        });
    }

    $("#btn_existing_customer").change(function() {
        $("#customerExistingDiv").css({
            "display": "block"
        })
        $("#customerNewDiv").css({
            "display": "none"
        })
        $("#customer_options").val("existing_customer")
    })
    $("#btn_new_customer").change(function() {
        $("#customerNewDiv").css({
            "display": "block"
        })
        $("#customerExistingDiv").css({
            "display": "none"
        })
        $("#customer_options").val("new_customer")
    })

    //Get Vendor List 
    function getVendorList(alias = '') {

        $.ajax({
            url: "<?php echo base_url(); ?>Web_api/getVendorList",
            method: "GET",
            data: {
                'used_type': 'buyer',
                'alias': alias
            },
            dataType: "json",
            success: function(data) {
                //loop data.result and append in to customer list
                $.each(data.result, function(key, value) {
                    if (value.user_type == 'ONLINE' || value.user_type == 'FULFILLMENT') {
                        return true
                    }
                    $('#customer_id').append('<option value="' + value.vendor_id + '">' + value.vendor_name + '|' + value.vendor_code + '</option>');
                });
            },
            error: function(data) {
                toastr.error('Error While Getting Vendor Name');
            }
        });
    }

    function getStates() {
        $.ajax({
            "url": "<?= base_url() ?>admin/Fastcheckout/getStateList",
            "dataType": "json",
            "data": {},
            "method": "GET",
            "success": function(data) {
                if (data.status != 1) {
                    toastr.error("Error: Failed to Get State Names")
                    return false
                }
                var a = ''
                $.each(data.result, function(i, v) {
                    a += '<option value="' + v['state_id'] + '">' + v['state_name'] + '</option>'
                })
                $("#customer_state").append(a)
            },
            "error": function(error) {
                toastr.error("Error: Couldn't get State Names")
                return false
            }
        })
    }

    function getNewDropdown(type, select_id) {
        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>admin/DropDownItems/getItems?type=" + type,
            data: {},
            dataType: "json",
            success: function(data) {

                $.each(data, function(i, v) {
                    let selected = ''
                    if (select_id == 'sub_category_id' && data[i].name == 'SG100') {
                        selected = 'selected'
                    }
                    if (select_id == 'payment_mode' && data[i].name == 'PREPAID') {
                        selected = 'selected'
                    }
                    $("#" + select_id).append('<option value="' + data[i].name + '" ' + selected + '>' + data[i].name + '</option>')
                })
            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
    }

    //Get Sales Reps
    function getSalesReps() {
        $.ajax({
            url: "<?php echo base_url(); ?>Web_api/getSalesreps",
            method: "GET",
            data: {},
            dataType: "json",
            success: function(data) {
                //loop data.result and append in to customer list
                $.each(data.result, function(key, value) {
                    $('#sales_executive_id').append('<option value="' + value.user_id + '">' + value.name + '</option>');
                });
            },
            error: function(data) {
                toastr.error('Error While Getting Sales Reps');
            }
        });
    }

    function getCustomerTCSValue() {

        //gET CUSTOMER ID
        var customer_id = $('#customer_id').val();
        $("#tcs_value").val(0)
        $("#tcs_percentage").val(0)

        //check if customer_id is not empty
        if (customer_id == '') {
            getTCSAmount()
            return false;
        }

        $.ajax({
            "url": "<?= base_url() ?>admin/SalesOrder/getCustomerTCSValue",
            "method": "GET",
            "data": {
                "customer_id": customer_id
            },
            "dataType": "json",
            "success": function(data) {
                if (data.status != 1) {
                    return false
                }

                $("#tcs_value").val(data.tcs_value)
                $("#tcs_percentage").val(data.tcs_percentage)
                getTCSAmount()
            }
        })
    }

    function getTCSAmount() {

        var net_amount = parseFloat($("#create_excl_tcs_net_amount").text());
        var tcs_value = parseFloat($("#tcs_value").val())
        var tcs_percentage = parseFloat($("#tcs_percentage").val())

        if(tcs_value > 5000000){
		  
            $("#create_td_tcs_text").text("TCS @ " + tcs_percentage + "%")
		tcs_amount = 0

		tcs_amount = Math.round(net_amount*tcs_percentage/100)
		$("#create_td_tcs_value").text(tcs_amount.toFixed(2))
		} else{
		    
		    if(net_amount + tcs_value > 5000000){
		        var diff_amount = (net_amount + tcs_value) - 5000000;
		        $("#create_td_tcs_text").text("TCS @ " + tcs_percentage + "%")
		        tcs_amount = 0;
		        tcs_amount = Math.round(diff_amount*tcs_percentage/100);
			$("#create_td_tcs_value").text(tcs_amount.toFixed(2))
 			 } else{
		        	$("#create_td_tcs_text").text('')
     				$("#create_td_tcs_value").text('')
     			}
	}
        getInvoiceGrossAmount()
    }

    function getInvoiceGrossAmount() {
        var net_amount = parseFloat($("#create_excl_tcs_net_amount").text());
        var tcs_amount = parseFloat($("#create_td_tcs_value").text())
        $("#create_gross_invoice_amount").text(0)

        if (isNaN(tcs_amount)) {
            tcs_amount = 0;
        }
        var total_invoice_gross_amount = net_amount + tcs_amount
        $("#create_gross_invoice_amount").text(total_invoice_gross_amount)
    }

    $('#tdid').on('change', function() {

        if ($(this).val().length == 13) {
            //call ajax function
            add_product();
        }
    });

    $("#sales_terms").on('change', function() {
        if ($("#tdid").val().length == 13) {
            add_product();
        }
    });

    //add_product function with ajax
    function add_product() {
        //get the value of tdid
        var tdid = $('#tdid').val();
        var sales_terms = $('#sales_terms').val();
        var sub_category = $('#sub_category_id').val();
        if (sub_category == '') {
            toastr.error('Please Select Sub Category');
            return false;
        }

        //Check for Duplicates
        if (nhdin_arr[tdid] != true) {
            //conver tdid to upper case
            tdid = tdid.toUpperCase();
            nhdin_arr[tdid] = true
        } else {
            toastr.error(tdid + 'Already Added')
            return false
        }
        var taxable_cat = <?= json_encode(TAXABLE_CATEGORY) ?>;
        //check if tdid is not empty
        if (tdid != '') {
            //ajax call
            $.ajax({
                url: "<?php echo base_url(); ?>admin/Fastcheckout/getMRP",
                method: "GET",
                data: {
                    device_id: tdid,
                    device_sub_category: sub_category
                },
                dataType: "json",
                success: function(data) {
                    //if status is not 1 show toastr error message
                    if (data.status != 1) {
                        toastr.error(data.message);
                        nhdin_arr[tdid] = false
                        return false
                    }
                    //if data.result.category in taxable_cat
                    if (taxable_cat.indexOf(data.result.category) == -1) {
                        if (sales_terms == '') {
                            toastr.error('Please Select Sales Terms');
                            nhdin_arr[tdid] = false
                            return false;
                        }
                    }
                    if (data.result.mrp <= 0) {
                        toastr.error('Price is Not Available for this TDID');
                        nhdin_arr[tdid] = false
                        return false;
                    }
                    let row = ''
                    // Add data.result fields into product list table with grnreport_id as hidden input field
                    row += '<tr class="product_row">'
                    row += '<td><input type="hidden" class="grnreport_id" name="grnreport_id[]" value="' + data.result.grnreport_id + '"><a href="javascript:void(0)" class="delete_product" id="' + data.result.grnreport_id + '"><i class="fa fa-trash"></i></a></td>'
                    row += '<td class="td_nhdin">' + data.result.nhdin + '</td>'
                    row += '<td>' + data.result.device_name + '</td>'
                    row += '<td>' + data.result.sku + '</td>'
                    row += '<td>' + data.result.certification_grade + '</td>'
                    row += '<td class="td_price">' + data.result.mrp + '</td>'
                    row += '<td>' + data.result.category + '</td>'
                    row += '<td>' + sales_terms + '</td>'
                    row += '</tr>'

                    $('#product_list tbody').append(row);

                    $('#tdid').val('');
                    $('#sub_category_id').attr('disabled', true);

                    //Total Quantity and Amount
                    var total_quantity = 0;
                    var total_amount = 0;
                    $('.td_price').each(function() {
                        total_amount += parseFloat($(this).text());
                        total_quantity += 1;
                    });
                    $('#total_quantity').text(total_quantity);
                    $('#total_amount').text(total_amount);
                    getNetAmount()
                    //focus on tdid
                    $('#tdid').focus();

                },
                error: function(data) {
                    toastr.error('Error While Adding TDID');
                    nhdin_arr[tdid] = false
                }
            });
        }
    }
    //delete product when click on delete icon
    $(document).on('click', '.delete_product', function() {

        var grnreport_id = $(this).attr('id');
        var tdid = $(this).closest('tr').find('.td_nhdin').text();
        $(this).closest('tr').remove();

        var total_quantity = 0;
        var total_amount = 0;
        $('#product_list tbody tr').each(function() {
            total_quantity += 1;
            total_amount += parseInt($(this).find('td.td_price').text());
        });
        $('#total_quantity').text(total_quantity);
        $('#total_amount').text(total_amount);
        nhdin_arr[tdid] = false
        getNetAmount()
        if (total_quantity == 0) {
            $('#sub_category_id').attr('disabled', false);
        }
    });


    function getReceiptDataforSOCreate() {

        var customer_id = $("#customer_id").val()
        var customer_options = $("#customer_options").val();

        if (customer_options == 'new_customer') {
            return false
        }

        if (customer_id == '' || customer_id == null || customer_id == '0') {
            toastr.error("Invalid Customer")
            return false
        }

        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>admin/Receipt/getReceiptDataByVendor",
            data: {
                "vendor_id": customer_id
            },
            dataType: "json",
            success: function(data) {

                if (data.status != '1') {
                    return false
                }

                $.each(data.result, function(i, v) {

                    var adjusted_amount_float = parseFloat(data.result[i].adjusted_amount)

                    if (isNaN(adjusted_amount_float)) {
                        adjusted_amount_float = 0
                    }
                    var available_amount = parseFloat(data.result[i].received_amount) - parseFloat(adjusted_amount_float)

                    if (available_amount > 0) {
                        var opt = '<option value="' + data.result[i].receipt_id + '">'
                        opt += data.result[i].receipt_no + '/' + data.result[i].received_date + '/' + data.result[i].received_amount
                        opt += '</option>'
                        $("#select_receipt").append(opt)
                    }

                })

            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
    }

    function addReceipt() {

        var receipt_id = $("#select_receipt").val()
        var total_amount = $("#update_so_net_amount").val()

        if (receipt_id == '0' || receipt_id == '' || receipt_id == null || receipt_id == undefined) {
            toastr.error("Please select a Receipt")
            return false
        }


        $.ajax({
            "url": '<?= base_url() ?>admin/Receipt/getReceiptHeader',
            "data": {
                "receipt_id": receipt_id
            },
            "type": "GET",
            "dataType": "json",
            "success": function(data) {

                if (data.status != '1') {
                    toastr.error("Error: Failed to fetch Receipt Data")
                    return false
                }

                var result = data.data

                var adjusted_amount_float = parseFloat(result.adjusted_amount)

                if (isNaN(adjusted_amount_float)) {
                    adjusted_amount_float = 0
                }
                var available_amount = parseFloat(result.received_amount) - parseFloat(adjusted_amount_float)

                if (parseFloat(total_amount) <= available_amount) {
                    adjusted_amount = total_amount
                } else {
                    adjusted_amount = available_amount
                }

                var receiptRow = '<tr class="tr_receipt_details">'
                receiptRow += '<td class="td_receipt_no">' + result.receipt_no + '</td>'
                receiptRow += '<td>' + result.receipt_type + '</td>'
                receiptRow += '<td>' + result.account_no + '</td>'
                receiptRow += '<td>' + result.reference_no + '</td>'
                receiptRow += '<td>' + result.received_amount + '</td>'
                receiptRow += '<td class="td_receipt_available_amount">' + available_amount.toFixed(2) + '</td>'
                receiptRow += '<td>' + result.received_date + '</td>'
                receiptRow += '<td><input type="text" class="receipt_input_adjusted_amount" value="' + adjusted_amount + '"></td>'

                receiptRow += '<td onclick="delete_receipt_row(this)" class="bg-secondary delete">'
                receiptRow += '<img src="<?php echo base_url(); ?>assets/img/delete.png">'
                receiptRow += '</td>';

                receiptRow += '<input type="hidden" class="receipt_input_received_amount" value="' + result.received_amount + '">'
                receiptRow += '<input type="hidden" class="receipt_input_receipt_id" value="' + result.receipt_id + '">'

                receiptRow += '</tr>'

                $("#receipt_table_tbody").append(receiptRow)

                applied_receipts[result.receipt_id] = $('#select_receipt option:selected')[0].outerHTML
                // var optionselected =  $("#update_select_receipt").val($("#name option[selected]").val());
                $('#select_receipt option:selected').remove();
                $('#select_receipt').val('');
                $('#select_receipt').change();

            }
        })
    }

    function addNewReceipt() {
        var fieldsRequired = ''
        //Receipt Details
        var receipt_type = $("#receipt_type").val()
        var receipt_amount = $("#receipt_amount").val()
        var receipt_date = $("#receipt_date").val()
        var bank_account = $("#bank_account").val()
        var receipt_ref_no = $("#receipt_ref_no").val()
        var received_or_verified_by = $("#verified_by").val()

        fieldsRequired += checkNull(receipt_type, 'Receipt Type, ')
        fieldsRequired += checkNull(receipt_amount, 'Receipt Amount, ')
        fieldsRequired += checkNull(receipt_date, 'Receipt Date, ')
        if (receipt_type != 'CASH' && receipt_type != 'CREDIT') {
            fieldsRequired += checkNull(bank_account, 'Bank Account, ')
            fieldsRequired += checkNull(receipt_ref_no, 'Receipt No, ')
        }

        if (fieldsRequired != '') {
            toastr.error("Fields Required:" + fieldsRequired)
            return false
        }

        var receiptRow = '<tr class="tr_new_receipt_details">'
        receiptRow += '<td>New Receipt</td>'
        receiptRow += '<td class="td_receipt_type">' + receipt_type + '</td>'
        receiptRow += '<td class="td_bank_account">' + bank_account + '</td>'
        receiptRow += '<td class="td_receipt_ref_no">' + receipt_ref_no + '</td>'
        receiptRow += '<td class="td_receipt_amount">' + receipt_amount + '</td>'
        receiptRow += '<td class="td_receipt_available_amount">' + receipt_amount + '</td>'
        receiptRow += '<td class="td_receipt_date">' + receipt_date + '</td>'
        receiptRow += '<td><input type="text" class="receipt_input_adjusted_amount" value="' + receipt_amount + '"></td>'

        receiptRow += '<td onclick="delete_receipt_row(this)" class="bg-secondary delete">'
        receiptRow += '<img src="<?php echo base_url(); ?>assets/img/delete.png">'
        receiptRow += '</td>';

        receiptRow += '<input type="hidden" class="td_received_or_verified_by" value="' + received_or_verified_by + '">'

        receiptRow += '</tr>'

        $("#receipt_table_tbody").append(receiptRow)

        //clear fields
        $("#receipt_type").val('')
        $("#receipt_amount").val('')
        $("#receipt_date").val('')
        $("#bank_account").val('')
        $("#receipt_ref_no").val('')
        $("#verified_by").val('')
        $("#receipt_type").change()
    }

    function delete_receipt_row(btn) {

        var yes = confirm("Do you want to delete the record?")

        if (yes) {
            var receipt_id = $(btn).closest("tr").find('.receipt_input_receipt_id').val()
            if (receipt_id > 0) {
                var option = applied_receipts[receipt_id]
                $('#update_select_receipt').append(option)
            }
            $(btn).closest("tr").remove();
        }
    }

    function getReviewDetails() {
        var customer_id = $("#customer_id").val()
        if (customer_id > 0) {
            var customer_name = $("#customer_id option:selected").text()
        } else {
            var customer_name = $("#customer_name").val()
        }
        var total_qty = $("#total_quantity").text()
        var total_amount = $("#total_amount").text()
        var net_amount = $("#create_gross_invoice_amount").text()
        var tcs_value = parseInt($("#create_td_tcs_value").text())

        var discount_amount = parseFloat($("#create_td_discount_amount").text())

        //Freight Charge
        var freight_charge = parseFloat($("#create_td_freight_val").val())

        if (isNaN(tcs_value)) {
            tcs_value = 0
        }

        if (isNaN(freight_charge)) {
            freight_charge = 0
        }

        if (isNaN(discount_amount)) {
            discount_amount = 0
        }

        //Add it to review table
        $("#td_review_customer_name").text(customer_name)
        $("#td_review_qty").text(total_qty)
        $("#td_review_invoice_amount").text(total_amount)
        $("#td_review_freight_amount").text(freight_charge)
        $("#td_review_discount_amount").text(discount_amount)
        $("#td_review_tcs_amount").text(tcs_value)
        $("#td_review_net_invoice_amount").text(net_amount)
    }

    function submitForm() {

        $("#submit_btn_final").attr('disabled', true)
        var customer_id = $("#customer_id").val()
        if(shipping_address.length == 0){
            toastr.error("Add Shipping to address ")
            return false;
        }
        var fieldsRequired = ''
        if (customer_id == '') {
            var customer_name = $("#customer_name").val()
            var customer_mobile = $("#customer_mobile").val()
            var customer_address = $("#customer_address").val()
            var customer_state = $("#customer_state").val()
            var customer_city = $("#customer_city").val()
            var customer_gstin = $("#customer_gstin").val()
            var customer_pan = $("#customer_pan").val()
            var customer_pincode = $("#customer_pincode").val()
            var customer_alias = $("#input_alias").val()
            var customer_email = $("#customer_email").val()

        }

        //Order Details
        var sales_executive = $("#sales_executive_id").val()
        var shipping_from_id = $("#shippingFrom").val()
        var device_sub_category = $("#sub_category_id").val()
        var payment_mode = $("#payment_mode").val()
        var saleschannel_ref_id = $("#sales_channel_ref_id").val()

        let discount_type = $("#create_td_discount_type_select").val()
        let discount_value = parseFloat($("#create_td_discount_val").val())

        let freight_amount = parseFloat($("#td_review_freight_amount").text())
        let discount_amount = parseFloat($("#td_review_discount_amount").text())

        if (isNaN(freight_amount)) {
            freight_amount = 0
        }

        if (isNaN(discount_amount)) {
            discount_amount = 0
        }

        var remarks = $("#remarks").val()

        //Receipt Details
        var check = 0;
        var receipt_details = [];
        var receiptDuplicates = [];
        var new_receipt_details = [];
        var receipt_amount = 0

        $.each($(".tr_receipt_details"), function() {

            var receipt_id = $(this).find("input.receipt_input_receipt_id").val();
            var receipt_no = $(this).find(".td_receipt_no").text();
            var received_amount = $(this).find("input.receipt_input_received_amount").val();
            var adjusted_amount = $(this).find("input.receipt_input_adjusted_amount").val();
            var available_amount = $(this).find(".td_receipt_available_amount").text()

            if (parseFloat(adjusted_amount) > parseFloat(available_amount)) {
                toastr.error("Adjusted Amount exceeds Available Amount for " + receipt_no)
                check = 1;
                return false;
            }

            if (receiptDuplicates[receipt_id] == true) {
                toastr.error("Duplicate Record Added for " + receipt_no)
                check = 1;
                return false;
            } else {
                receiptDuplicates[receipt_id] = true;
            }

            if (parseFloat(adjusted_amount) > 0) {
                receipt_details.push({
                    "receipt_id": receipt_id,
                    "receipt_amount": received_amount,
                    "adjusted_amount": adjusted_amount
                })
                receipt_amount += parseFloat(adjusted_amount)
            }
        });
        //return false
        if (check == 1) {
            $("#submit_btn_final").attr('disabled', false)
            return false
        }

        // $.each($(".tr_new_receipt_details"), function() {
        //     var receipt_type = $(this).find(".td_receipt_type").text();
        //     var bank_account = $(this).find(".td_bank_account").text();
        //     var receipt_ref_no = $(this).find(".td_receipt_ref_no").text();
        //     var receipt_amount = $(this).find(".td_receipt_amount").text();
        //     var receipt_date = $(this).find(".td_receipt_date").text();
        //     var adjusted_amount = $(this).find("input.receipt_input_adjusted_amount").val()
        //     var received_or_verified_by = $(this).find("input.td_received_or_verified_by").val()

        //     if (parseFloat(adjusted_amount) > parseFloat(receipt_amount)) {
        //         toastr.error("Adjusted Amount exceeds Available Amount for " + receipt_no)
        //         check = 1;
        //         return false;
        //     }

        //     if (parseFloat(adjusted_amount) > 0) {
        //         new_receipt_details.push({
        //             "receipt_type": receipt_type,
        //             "bank_account": bank_account,
        //             "receipt_ref_no": receipt_ref_no,
        //             "adjusted_amount": adjusted_amount,
        //             "receipt_amount": receipt_amount,
        //             "adjusted_amount": adjusted_amount,
        //             "receipt_date": receipt_date,
        //             "received_or_verified_by": received_or_verified_by
        //         })
        //     }
        // });

        //item Details
        var item_details = []
        var gross_amount = 0
        var check = false
        $('#product_list tbody tr').each(function() {
            let grnreport_id = $(this).closest('tr').find('.grnreport_id').val();
            let price = $(this).closest('tr').find('.td_price').text();
            let nhdin = $(this).closest('tr').find('.td_nhdin').text();
            if (grnreport_id > 0) {
                item_details.push({
                    'grnreport_id': grnreport_id,
                    'price': price,
                    'nhdin': nhdin
                })
            } else {
                toastr.error("Invalid Device ID " + nhdin)
                check = true
                return false
            }
            gross_amount += parseFloat(price)
        });

        if (check) {
            $("#submit_btn_final").attr('disabled', false)
            return false
        }

        if (item_details.length <= 0) {
            toastr.error('Please Add atleast one item')
            $("#submit_btn_final").attr('disabled', false)
            return false
        }

        //Tcs Details
        var tcs_percentage = $("#tcs_percentage").val()
        var tcs_value = parseInt($("#create_td_tcs_value").text())

        if (tcs_value <= 0 || isNaN(tcs_value)) {
            tcs_percentage = 0;
            tcs_value = 0
        }
        var net_amount = parseFloat($("#td_review_net_invoice_amount").text())
        //Difference between gross amount and receipt amount must be less than or equal to 5
        var difference = net_amount - receipt_amount
        if (difference > 5) {
            toastr.error('Receipt Amount is less than Net Amount')
            $("#submit_btn_final").attr('disabled', false)
            return false
        }
        //Add Everything in to object
        var data = {
            "customer_id": customer_id,
            "customer_details": {
                "customer_name": customer_name,
                "customer_mobile": customer_mobile,
                "customer_address": customer_address,
                "customer_city": customer_city,
                "customer_state": customer_state,
                "customer_pincode": customer_pincode,
                "customer_gstin": customer_gstin,
                "customer_pan": customer_pan,
                "customer_alias": customer_alias,
                "customer_email": customer_email
            },

            "sales_executive": sales_executive,
            "device_sub_category": device_sub_category,
            "payment_mode": payment_mode,
            "saleschannel_ref_id": saleschannel_ref_id,
            "remarks": remarks,
            "shipping_from_id" : shipping_from_id,
            "receipt_details": receipt_details,
            "new_receipt_details": new_receipt_details,
            "items": item_details,
            "tcs_percentage": tcs_percentage,
            "tcs_value": tcs_value,
            "discount_value": discount_value,
            "discount_type": discount_type,
            "freight_amount": freight_amount,
            'shipping_data':shipping_address
        }

        var jsonObject = JSON.stringify(data)
        //Call Ajax on createInvoice
        $.ajax({
            url: "<?= base_url() ?>admin/Fastcheckout/createInvoice",
            type: "POST",
            data: jsonObject,
            dataType: "JSON",
            success: function(response) {
                if (response.status != 1) {
                    toastr.error("Error: " + response.message)
                    $("#submit_btn_final").attr('disabled', false)
                    return false
                }
                toastr.success("Invoice Created Successfully")
                window.location.replace("<?= base_url() ?>admin/Finance/create_invoice")
            },
            error: function(error) {
                toastr.error('Error: Failed to Create Invoice')
                $("#submit_btn_final").attr('disabled', false)
            }
        })
    }

    function getVendorAliases() {

        $.ajax({
            "url": "<?= base_url() ?>admin/Tools/getVendorAliases/",
            "type": "GET",
            "dataType": "json",
            "async": false,
            "success": function(data) {

                $.each(data.result, function(i, d) { // loop through data returned from ajax
                    var a = '<option value="' + data.result[i].alias_name + '">';
                    $("#aliasList").append(a)
                })
            },
            "error": function() {
                toastr.error("Failed to get Alias List")
            }
        })
    }

    function uploadProducts() {
        var response_products = []
        var device_sub_category = $("#sub_category_id").val()
        var select_sales_terms = $("#sales_terms").val()

        if (checkNull(device_sub_category, 'Sub Category') != "") {
            toastr.error("Please Select Device Sub Category")
            return false
        }

        if (checkNull(select_sales_terms, 'Sales Terms') != "") {
            toastr.error("Please Select Sales Terms")
            return false
        }
        //read csv file from input
        var file = $('#fc_file_upload').prop('files')[0];

        //check file is csv or not
        if (file.name.split('.').pop() != 'csv') {
            toastr.error('Please select csv file');
            return false;
        }
        $("#fc_file_upload").val(null)
        //Read the file add first column to as device id and second column as retail price into an object
        var reader = new FileReader();
        reader.onload = function(e) {
            var lines = e.target.result.split('\n');
            var data = [];
            var items = []
            var headers = ['device_id', 'price'];
            for (var i = 1; i < lines.length; i++) {
                var currentline = lines[i].split(',');
                if (currentline[0] == undefined || currentline[0] == '') {
                    continue;
                }

                items.push(currentline[0].replace('\r', '').trim());
            }
            //if data is empty then show error
            if (items.length == 0) {
                toastr.error('Please select a valid csv file');
                return false;
            }
            var exempt_cat = <?= json_encode(EXEMPT_CATEGORY) ?>;
            if(device_sub_category == "BUNDLE"){
                var cntrl_method = "getGroupByBundle";
            } else{
                var cntrl_method = "getGroupBySKU";
            }
            $.ajax({
                url: "<?php echo base_url(); ?>admin/device/" + cntrl_method,
                dataType: 'json',
                data: JSON.stringify(items),
                type: 'POST',
                success: function(res) {
                    if(res.status == 0){
                        toastr.error(res.msg);
                    }
                    var response = res.data;
                    var k = true
                    for (x = 0; x < response.length; x++) {
                        var data = response[x];
                        device_id = data.nhdin;
                        grnreport_id = data.grnreport_id;
                        device_name = data.device_name;
                        sku = data.SKU;
                        category = data.stock_type;
                        grade = data.certification_grade;
                        quantity = 1;
                        status = data.status;
                        price = data.mrp;
                        amount = 0.0;

                        if (status != 'RFS') {
                            toastr.error('Device ' + device_id + ' is not in RFS status')
                            k = false
                            return false
                        }

                        if (isNaN(price) || price <= 0) {
                            toastr.error("Invalid Price for " + device_id)
                            k = false
                            return false
                        }

                        if (exempt_cat.indexOf(category) >= 0) {
                            sales_term = select_sales_terms;
                        } else {
                            sales_term = '';
                        }
                        if(device_sub_category != "BUNDLE"){
                            if (device_sub_category != data.device_sub_category) {
                                toastr.error("Error: " + device_id + " is not a " + device_sub_category + " device")
                                k = false
                                return false
                            } 
                        }
                        

                        response_products.push(device_id.toLowerCase())

                        if (nhdin_arr[device_id] != true) {
                            //conver tdid to upper case
                            tdid = device_id.toUpperCase();
                            nhdin_arr[tdid] = true
                        } else {
                            toastr.error(device_id + 'Already Added')
                            return false
                        }

                        let row = ''
                        // Add data.result fields into product list table with grnreport_id as hidden input field
                        row += '<tr class="product_row">'
                        row += '<td><input type="hidden" class="grnreport_id" name="grnreport_id[]" value="' + grnreport_id + '"><a href="javascript:void(0)" class="delete_product" id="' + grnreport_id + '"><i class="fa fa-trash"></i></a></td>'
                        row += '<td class="td_nhdin">' + device_id + '</td>'
                        row += '<td>' + device_name + '</td>'
                        row += '<td>' + sku + '</td>'
                        row += '<td>' + grade + '</td>'
                        row += '<td class="td_price">' + price + '</td>'
                        row += '<td>' + category + '</td>'
                        row += '<td>' + sales_term + '</td>'
                        row += '</tr>'

                        $('#product_list tbody').append(row);

                    }
                    if(device_sub_category != "BUNDLE"){
                       for (i = 0; i < items.length; i++) {

                        if (response_products.indexOf(items[i].toLowerCase()) == -1) {
                            toastr.error("Error: " + items[i] + " is not a valid device")
                            k = false
                            return false
                        }
                    }
    
                    if (k == false) {
                        return false
                    }   
                    }
                    
                    
                    $('#sub_category_id').attr('disabled', true);

                    //Total Quantity and Amount
                    var total_quantity = 0;
                    var total_amount = 0;
                    $('.td_price').each(function() {
                        total_amount += parseFloat($(this).text());
                        total_quantity += 1;
                    });
                    $('#total_quantity').text(total_quantity);
                    $('#total_amount').text(total_amount);
                     if(device_sub_category == "BUNDLE"){
                        if(res.discount_type == "percent"){
                            $('#create_td_discount_type_select').val("percentage")
                        } else if(res.discount_type == "amount"){
                          $('#create_td_discount_type_select').val("amount")  
                        }
                        
                        $('#create_td_discount_val').val(res.value)
                    } 
                    
                    getNetAmount()
                   
                    
                },
                error: function(data) {
                    
                    console.log('device not found ' + deviceid);
                }
            });
        }
        reader.readAsText(file);;

    }


    function calculateTax() {
        //get All values from input[name=grnreport_id[]]
        var grn_array = []
        $("input[name='grnreport_id[]']").each(function() {
            var grnreport_id = $(this).val();
            grn_array.push(grnreport_id);
        });

        var jsonObject = JSON.stringify(grn_array);
        $.ajax({
            "url": "<?php echo base_url(); ?>admin/Fastcheckout/getTax",
            "dataType": "json",
            "type": "POST",
            'data': jsonObject,
            "success": function(data) {
                if (data.status != 1) {
                    toastr.error(data.message)
                    return false
                }
                let tax = data.result.total_tax.toFixed(0)

                let freight = parseFloat($("#create_td_freight_val").val())
                let discount = parseFloat($("#create_td_discount_amount").text())

                if(isNaN(freight)){
                    freight = 0
                }

                if(isNaN(discount)){
                    discount = 0
                }

                let freight_tax = freight - freight/1.18
                let discount_tax = discount - discount/1.18

                let net_tax = (+tax + freight_tax - discount_tax)

                $('#td_review_gst_amount').text(net_tax.toFixed(2))
            },
        })
    }

    function getNetAmount(){
        //Discount
        var total_amount = parseFloat($("#total_amount").text());
        var discount_type = $("#create_td_discount_type_select").val()
        var discount_value = parseFloat($("#create_td_discount_val").val())
        var discount_amount = 0;
        
        if(isNaN(discount_value) || discount_value == null){
            discount_value = 0;
        }

        if (discount_type == 'amount') {
            discount_amount = discount_value
            if (discount_amount > total_amount) {
                toastr.error('Discount amount cannot be greater than total amount')
                return false
            }
        }

        if (discount_type == 'percentage') {
            if (discount_value > 100) {
                $("#create_td_discount_val").val('0')
                toastr.error('Discount Percentage should be less than 100')
                return false
            }
	    var actual_percent = (100 + discount_value); 
            discount_amount = (total_amount * discount_value) / 100
	    //discount_amount = (total_amount * discount_value) / actual_percent

        }

        $("#create_td_discount_amount").text(discount_amount.toFixed(2))

        //Freight Charge
        var freight_charge = parseFloat($("#create_td_freight_val").val())

        if(isNaN(freight_charge) || freight_charge == null){
            freight_charge = 0
        }

        let net_amount = total_amount - discount_amount + freight_charge
        $("#create_excl_tcs_net_amount").text(net_amount.toFixed(2))

        getTCSAmount()
    }
</script>