<!-- Create a Combo box for the customer List -->
<h4 style="margin-left: 20px;">Customer Details</h4>
<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-horizontal">
    <div class="form-group" style="margin: 20px;">
        <div class="col-sm-4 col-md-4 col-lg-4">
            <select name="customer_id" id="customer_id" class="form-control select_box">
                <option value="">New Customer</option>
            </select>
        </div>
        <!-- Customer Name -->
        <div class="col-sm-4">
            <input type="text" name="customer_name" id="customer_name" class="form-control" placeholder="Customer Name" />
        </div>
        <!-- Customer Mobile -->
        <div class="col-sm-4">
            <input type="text" name="customer_mobile" id="customer_mobile" class="form-control" placeholder="Customer Mobile" />
        </div>
    </div>
    <!-- Add Customer Address -->
    <div class="form-group" style="margin: 20px;">
        <div class="col-sm-4">
            <input type="text" name="customer_address" id="customer_address" class="form-control" placeholder="Customer Address" />
        </div>
        <!-- Customer City -->
        <div class="col-sm-4">
            <input type="text" name="customer_city" id="customer_city" class="form-control" placeholder="Customer City" />
        </div>
        <!-- Customer State -->
        <div class="col-sm-4">
            <select name="customer_state" id="customer_state" class="form-control select_box">
                <option value="">Select State</option>
            </select>
        </div>
    </div>

    <!-- Add Customer PINCODE, GSTIN and PAN -->
    <div class="form-group" style="margin: 20px;">
        <!-- Customer PIN -->
        <div class="col-sm-4">
            <input type="number" name="customer_pincode" id="customer_pincode" maxlength="6" class="form-control" placeholder="PIN CODE" />
        </div>
        <div class="col-sm-4">
            <input type="text" name="customer_gstin" id="customer_gstin" class="form-control" placeholder="Customer GSTIN" />
        </div>
        <!-- Customer PAN -->
        <div class="col-sm-4">
            <input type="text" name="customer_pan" id="customer_pan" class="form-control" placeholder="Customer PAN" />
        </div>

    </div>

    <h4 style="margin: 20px;">Order Details</h4>

    <!-- Add Sales Executive, Sub Category, Payment Mode -->
    <div class="form-group" style="margin: 20px;">
        <div class="col-sm-4">
            <select name="sales_executive_id" id="sales_executive_id" class="form-control">
                <option value="">Sales Executive</option>
            </select>
        </div>

        <div class="col-sm-4">
            <select name="sub_category_id" id="sub_category_id" class="form-control">
                <option value="">Sub Category</option>
            </select>
        </div>
        <!-- Payment Mode -->
        <div class="col-sm-4">
            <select name="payment_mode" id="payment_mode" class="form-control">
                <option value="">Payment Mode</option>
            </select>
        </div>
    </div>
    <!-- Add Sales Channel Ref Id, Remarks -->
    <div class="form-group" style="margin: 20px;">
        <!-- Sales Channel Ref Id -->
        <div class="col-sm-4">
            <input type="text" name="sales_channel_ref_id" id="sales_channel_ref_id" class="form-control" placeholder="Sales Channel Ref Id" />
        </div>
        <!-- Remarks/Text Area -->
        <div class="col-sm-4">
            <textarea name="remarks" id="remarks" class="form-control" placeholder="Remarks"></textarea>
        </div>
    </div>
    <!-- hr line -->
    <hr style="width:90%; border-color:#CCC;">
    <h4 style="margin: 20px;">Payment Details</h4>
    <!-- Payment Details -->
    <div class="form-group" style="margin: 20px;">
        <!-- Payment Mode -->
        <div class="col-sm-4">
            <select name="receipt_type" id="receipt_type" class="form-control">
                <option value="">Receipt Type</option>
            </select>
        </div>
        <!-- Payment Amount -->
        <div class="col-sm-4">
            <input type="number" name="receipt_amount" id="receipt_amount" class="form-control" placeholder="Payment Amount" />
        </div>
        <!-- Payment Date -->
        <div class="col-sm-4">
            <input type="date" name="receipt_date" id="receipt_date" class="form-control" placeholder="Payment Date" />
        </div>
    </div>

    <!-- Add Bank Details -->
    <div class="form-group" style="margin: 20px;">
        <div class="col-sm-4">
            <select name="bank_account" id="bank_account" class="form-control" />
            <option value="">Bank Account</option>
            </select>
        </div>
        <div class="col-sm-4">
            <input type="text" name="receipt_ref_no" id="receipt_ref_no" class="form-control" placeholder="Receipt No" />
        </div>
        <div class="col-sm-4">
            <input type="text" name="verified By" id="verified_by" class="form-control" placeholder="Received or Verified By" />
        </div>
    </div>

    <!-- hr line -->
    <hr style="width:90%; border-color:#CCC;">
    <h4 style="margin: 20px;">Product Details</h4>
    <!-- Scan Product TDID -->
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-horizontal">
        <div class="form-group" style="margin: 20px;">
            <div class="col-sm-3">
                <select name="sales_terms" id="sales_terms" class="form-control">
                    <option value="">SALES TERMS</option>
                    <option value="ASIS">AS IS</option>
                    <option value="POWER ON">POWER ON</option>
                    <option value="FULL QC" selected>FULL QC</option>
                </select>
            </div>
            <div class="col-sm-3">
                <input type="text" name="tdid" id="tdid" maxlength="13" class="form-control" placeholder="Scan Product TDID"  />
            </div>

            

        </div>
    </div>

    <!-- Table for the Product List contains TDID, product Name, SKU, Grade, Price, and Delete/Trash Icon-->
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-horizontal" style="width: 100%; ">
        <div class="form-group" style="margin: 20px;">
            <div class="col-sm-8" style=" overflow-x:auto;">
                <table class="table table-bordered table-hover" id="product_list">
                    <thead>
                        <tr>
                            <th>Action</th>
                            <th>TDID</th>
                            <th>Product Name</th>
                            <th>SKU</th>
                            <th>Grade</th>
                            <th>Price</th>
                            <th>Category</th>
                            <th>Sales Terms</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
            <!-- Table With Particular, Amount -->
            <div class="col-sm-4" style="overflow-x: auto;">
                <table class="table table-bordered table-hover" id="product_total_tbl">
                    <thead>
                        <tr>
                            <th>Particular</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Total Quantity</td>
                            <td id="total_quantity"></td>
                        </tr>
                        <tr>
                            <td>Total Amount</td>
                            <td id="total_amount"></td>
                        </tr>
                    </tbody>
                    <tr>
                        <td id="create_td_tcs_text"></td>
                        <td class="row">
                            <span id="create_td_tcs_value"></span>
                        </td>
                    </tr>
                    <tr>
                        <td>Total Invoice Value</td>
                        <td class="row">
                            <span id="create_gross_invoice_amount"></span>
                        </td>
                    </tr>

                    <input type="hidden" id="tcs_value">
                    <input type="hidden" id="tcs_percentage">
                </table>

                <!-- Submit Button -->
                <div class="form-group" style="margin: 20px;">
                    <div class="col-sm-12">
                        <button type="submit" class="btn btn-primary" id="submit_button" onclick="submitFastCheckout()">Submit</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    getVendorList()
    getSalesReps()
    getNewDropdown('DEVICE_SUB_CATEGORY', 'sub_category_id')
    getNewDropdown('PAYMENT_MODE', 'payment_mode')
    getNewDropdown('RECEIPT_TYPE', 'receipt_type')
    getNewDropdown('BANK_ACCOUNTS', 'bank_account')
    getStates()
    nhdin_arr = []
    //add Event Listener on scan tdid input field call a function when length  is equal to 13
    $('#tdid').on('change', function() {

        if ($(this).val().length == 13) {
            //call ajax function
            add_product();
        }
    });

    $("#sales_terms").on('change', function() {
        if ($("#tdid").val().length == 13) {
            add_product();
        }
    });

    function checkNull(entity, message) {
        if (entity == null || entity == undefined || entity == '' || entity.length < 0 || entity == 'undefined') {
            return message
        }
        return ''
    }

    //add_product function with ajax
    function add_product() {
        //get the value of tdid
        var tdid = $('#tdid').val();
        var sales_terms = $('#sales_terms').val();
        var sub_category = $('#sub_category_id').val();
        if (sub_category == '') {
            toastr.error('Please Select Sub Category');
            return false;
        }

        //Check for Duplicates
        if (nhdin_arr[tdid] != true) {
            //conver tdid to upper case
            tdid = tdid.toUpperCase();
            nhdin_arr[tdid] = true
        } else {
            toastr.error(tdid + 'Already Added')
            return false
        }
        var taxable_cat = <?= json_encode(TAXABLE_CATEGORY) ?>;
        //check if tdid is not empty
        if (tdid != '') {
            //ajax call
            $.ajax({
                url: "<?php echo base_url(); ?>admin/Fastcheckout/getMRP",
                method: "GET",
                data: {
                    device_id: tdid,
                    device_sub_category: sub_category
                },
                dataType: "json",
                success: function(data) {
                    //if status is not 1 show toastr error message
                    if (data.status != 1) {
                        toastr.error(data.message);
                        nhdin_arr[tdid] = false
                        return false
                    }
                    if(taxable_cat.indexOf(data.result.category) == -1){
                        if (sales_terms == '') {
                            toastr.error('Please Select Sales Terms');
                            nhdin_arr[tdid] = false
                            return false;
                        }
                    }
                    
                    if (data.result.mrp <= 0) {
                        toastr.error('Price is Not Available for this TDID');
                        nhdin_arr[tdid] = false
                        return false;
                    }
                    let row = ''
                    // Add data.result fields into product list table with grnreport_id as hidden input field
                    row += '<tr class="product_row">'
                    row += '<td><input type="hidden" class="grnreport_id" name="grnreport_id[]" value="' + data.result.grnreport_id + '"><a href="javascript:void(0)" class="delete_product" id="' + data.result.grnreport_id + '"><i class="fa fa-trash"></i></a></td>'
                    row += '<td class="td_nhdin">' + data.result.nhdin + '</td>'
                    row += '<td>' + data.result.device_name + '</td>'
                    row += '<td>' + data.result.sku + '</td>'
                    row += '<td>' + data.result.certification_grade + '</td>'
                    row += '<td class="td_price">' + data.result.mrp + '</td>'
                    row += '<td>' + data.result.category + '</td>'
                    row += '<td>' + sales_terms + '</td>'
                    row += '</tr>'

                    $('#product_list tbody').append(row);

                    $('#tdid').val('');
                    $('#sub_category_id').attr('disabled', true);

                    //Total Quantity and Amount
                    var total_quantity = 0;
                    var total_amount = 0;
                    $('.td_price').each(function() {
                        total_amount += parseFloat($(this).text());
                        total_quantity += 1;
                    });
                    $('#total_quantity').text(total_quantity);
                    $('#total_amount').text(total_amount);
                    getTCSAmount()
                    //focus on tdid
                    $('#tdid').focus();

                },
                error: function(data) {
                    toastr.error('Error While Adding TDID');
                    nhdin_arr[tdid] = false
                }
            });
        }
    }
    //delete product when click on delete icon
    $(document).on('click', '.delete_product', function() {

        var grnreport_id = $(this).attr('id');
        var tdid = $(this).closest('tr').find('.td_nhdin').text();
        $(this).closest('tr').remove();

        var total_quantity = 0;
        var total_amount = 0;
        $('#product_list tbody tr').each(function() {
            total_quantity += 1;
            total_amount += parseInt($(this).find('td.td_price').text());
        });
        $('#total_quantity').text(total_quantity);
        $('#total_amount').text(total_amount);
        nhdin_arr[tdid] = false
        getTCSAmount()
        if (total_quantity == 0) {
            $('#sub_category_id').attr('disabled', false);
        }
    });

    //Get Vendor List 
    function getVendorList() {
        $.ajax({
            url: "<?php echo base_url(); ?>Web_api/getVendorList",
            method: "GET",
            data: {
                'used_type': 'buyer'
            },
            dataType: "json",
            success: function(data) {
                //loop data.result and append in to customer list
                $.each(data.result, function(key, value) {
                    if (value.user_type == 'ONLINE' || value.user_type == 'FULFILLMENT') {
                        return true
                    }
                    $('#customer_id').append('<option value="' + value.vendor_id + '">' + value.vendor_name + '|' + value.vendor_code + '</option>');
                });
            },
            error: function(data) {
                toastr.error('Error While Getting Vendor Name');
            }
        });
    }

    //Add Event Listener on customer_id on change
    $('#customer_id').on('change', function() {
        //get the value of customer_id
        var customer_id = $(this).val();
        //check if customer_id is not empty
        if (customer_id == '') {
            //Enable All customer fields
            $('#customer_name').prop('disabled', false);
            $('#customer_address').prop('disabled', false);
            $('#customer_mobile').prop('disabled', false);
            $('#customer_email').prop('disabled', false);
            $('#customer_gstin').prop('disabled', false);
            $('#customer_pan').prop('disabled', false);
            $('#customer_city').prop('disabled', false);
            $('#customer_state').prop('disabled', false);
            $('#customer_aadhar').prop('disabled', false);
            $('#customer_pincode').prop('disabled', false);
        } else {
            //Disable All customer fields
            $('#customer_name').prop('disabled', true);
            $('#customer_address').prop('disabled', true);
            $('#customer_mobile').prop('disabled', true);
            $('#customer_email').prop('disabled', true);
            $('#customer_gstin').prop('disabled', true);
            $('#customer_pan').prop('disabled', true);
            $('#customer_city').prop('disabled', true);
            $('#customer_state').prop('disabled', true);
            $('#customer_aadhar').prop('disabled', true);
            $('#customer_pincode').prop('disabled', true);
        }
        getCustomerTCSValue()

    })

    //Get Sales Reps
    function getSalesReps() {
        $.ajax({
            url: "<?php echo base_url(); ?>Web_api/getSalesreps",
            method: "GET",
            data: {},
            dataType: "json",
            success: function(data) {
                //loop data.result and append in to customer list
                $.each(data.result, function(key, value) {
                    $('#sales_executive_id').append('<option value="' + value.user_id + '">' + value.name + '</option>');
                });
            },
            error: function(data) {
                toastr.error('Error While Getting Sales Reps');
            }
        });
    }

    function getNewDropdown(type, select_id) {
        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>admin/DropDownItems/getItems?type=" + type,
            data: {},
            dataType: "json",
            success: function(data) {

                $.each(data, function(i, v) {
                    $("#" + select_id).append('<option value="' + data[i].name + '">' + data[i].name + '</option>')
                })
            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
    }

    function getCustomerTCSValue() {

        //gET CUSTOMER ID
        var customer_id = $('#customer_id').val();
        $("#tcs_value").val(0)
        $("#tcs_percentage").val(0)

        //check if customer_id is not empty
        if (customer_id == '') {
            getTCSAmount()
            return false;
        }

        $.ajax({
            "url": "<?= base_url() ?>admin/SalesOrder/getCustomerTCSValue",
            "method": "GET",
            "data": {
                "customer_id": customer_id
            },
            "dataType": "json",
            "success": function(data) {
                if (data.status != 1) {
                    return false
                }

                $("#tcs_value").val(data.tcs_value)
                $("#tcs_percentage").val(data.tcs_percentage)
                getTCSAmount()
            }
        })
    }

    function getTCSAmount() {

        var total_amount = parseFloat($("#total_amount").text());
        var tcs_value = parseFloat($("#tcs_value").val())
        var tcs_percentage = parseFloat($("#tcs_percentage").val())

        if (total_amount + tcs_value > 5000000) {

            $("#create_td_tcs_text").text("TCS @ " + tcs_percentage + "%")
            tcs_amount = 0

            tcs_amount = Math.round(total_amount * tcs_percentage / 100)
            $("#create_td_tcs_value").text(tcs_amount.toFixed(2))
        } else {
            $("#create_td_tcs_text").text('')
            $("#create_td_tcs_value").text('')
        }
        getInvoiceGrossAmount()
    }

    function getInvoiceGrossAmount() {
        var total_amount = parseFloat($("#total_amount").text());
        var tcs_amount = parseFloat($("#create_td_tcs_value").text())
        $("#create_gross_invoice_amount").val(0)

        if (isNaN(tcs_amount)) {
            tcs_amount = 0;
        }
        var total_invoice_gross_amount = total_amount + tcs_amount
        $("#create_gross_invoice_amount").text(total_invoice_gross_amount)
    }

    function getStates() {
        $.ajax({
            "url": "<?= base_url() ?>admin/Fastcheckout/getStateList",
            "dataType": "json",
            "data": {},
            "method": "GET",
            "success": function(data) {
                if (data.status != 1) {
                    toastr.error("Error: Failed to Get State Names")
                    return false
                }
                var a = ''
                $.each(data.result, function(i, v) {
                    a += '<option value="' + v['state_id'] + '">' + v['state_name'] + '</option>'
                })
                $("#customer_state").append(a)
            },
            "error": function(error) {
                toastr.error("Error: Couldn't get State Names")
                return false
            }
        })
    }

    //Submit Form
    function submitFastCheckout() {

        var customer_id = $("#customer_id").val()
        var fieldsRequired = ''
        if (customer_id == '') {
            var customer_name = $("#customer_name").val()
            var customer_mobile = $("#customer_mobile").val()
            var customer_address = $("#customer_address").val()
            var customer_state = $("#customer_state").val()
            var customer_city = $("#customer_city").val()
            var customer_gstin = $("#customer_gstin").val()
            var customer_pan = $("#customer_pan").val()
            var customer_pincode = $("#customer_pincode").val()
            let gstin_regex = new RegExp(/\d{2}[A-Z]{5}\d{4}[A-Z]{1}[A-Z\d]{1}[Z]{1}[A-Z\d]{1}/gm);
            let pan_regex = new RegExp(/[A-Z]{3}[ABCFGHLJPTF]{1}[A-Z]{1}[0-9]{4}[A-Z]{1}/gm)

            fieldsRequired += checkNull(customer_name, 'Customer Name, ')
            fieldsRequired += checkNull(customer_mobile, 'Customer Mobile, ')
            fieldsRequired += checkNull(customer_address, 'Customer Address, ')
            fieldsRequired += checkNull(customer_state, 'Customer State, ')
            fieldsRequired += checkNull(customer_city, 'Customer City, ')
            fieldsRequired += checkNull(customer_pincode, 'Customer Pin Code, ')
            let gst_check = checkNull(customer_gstin, 'Customer GSTIN, ')
            let pan_check = checkNull(customer_pan, 'Customer PAN, ')
            //check gstin
            if (gst_check == '' && (!gstin_regex.test(customer_gstin))) {
                toastr.error('Invalid GSTIN')
                return false
            }
            if (pan_check == '' && (!pan_regex.test(customer_pan))) {
                toastr.error('Invalid PAN No')
                return false
            }
        }

        //Order Details
        var sales_executive = $("#sales_executive_id").val()
        var device_sub_category = $("#sub_category_id").val()
        var payment_mode = $("#payment_mode").val()
        var saleschannel_ref_id = $("#sales_channel_ref_id").val()

        var remarks = $("#remarks").val()

        fieldsRequired += checkNull(sales_executive, 'Sales Executive, ')
        fieldsRequired += checkNull(device_sub_category, 'Device Sub Category, ')
        fieldsRequired += checkNull(payment_mode, 'Payment Mode, ')

        //Receipt Details
        var receipt_type = $("#receipt_type").val()
        var receipt_amount = $("#receipt_amount").val()
        var receipt_date = $("#receipt_date").val()
        var bank_account = $("#bank_account").val()
        var receipt_no = $("#receipt_ref_no").val()
        var received_or_verified_by = $("#verified_by").val()

        fieldsRequired += checkNull(receipt_type, 'Receipt Type, ')
        fieldsRequired += checkNull(receipt_amount, 'Receipt Amount, ')
        fieldsRequired += checkNull(receipt_date, 'Receipt Date, ')
        if (receipt_type != 'CASH' && receipt_type != 'CREDIT') {
            fieldsRequired += checkNull(bank_account, 'Bank Account, ')
            fieldsRequired += checkNull(receipt_no, 'Receipt No, ')
        }

        if (fieldsRequired != '') {
            toastr.error("Fields Required:" + fieldsRequired)
            return false
        }

        //item Details
        var item_details = []
        var gross_amount = 0
        var check = false
        $('#product_list tbody tr').each(function() {
            let grnreport_id = $(this).closest('tr').find('.grnreport_id').val();
            let price = $(this).closest('tr').find('.td_price').text();
            let nhdin = $(this).closest('tr').find('.td_nhdin').text();
            if (grnreport_id > 0) {
                item_details.push({
                    'grnreport_id': grnreport_id,
                    'price': price,
                    'nhdin': nhdin
                })
            } else {
                toastr.error("Invalid Device ID " + nhdin)
                check = true
                return false
            }
            gross_amount += parseFloat(price)
        });

        if (check) {
            return false
        }

        if (item_details.length <= 0) {
            toastr.error('Please Add atleast one item')
            return false
        }

        //Tcs Details
        var tcs_percentage = $("#tcs_percentage").val()
        var tcs_value = parseInt($("#create_td_tcs_value").text())

        if (tcs_value <= 0 || isNaN(tcs_value)) {
            tcs_percentage = 0;
            tcs_value = 0

        }
        //Difference between gross amount and receipt amount must be less than or equal to 5
        var difference = gross_amount - receipt_amount
        if (difference > 5) {
            toastr.error('Receipt Amount is less than Gross Amount')
            return false
        }
        //Add Everything in to object
        var data = {
            "customer_id": customer_id,
            "customer_details": {
                "customer_name": customer_name,
                "customer_mobile": customer_mobile,
                "customer_address": customer_address,
                "customer_city": customer_city,
                "customer_state": customer_state,
                "customer_pincode": customer_pincode,
                "customer_gstin": customer_gstin,
                "customer_pan": customer_pan
            },

            "sales_executive": sales_executive,
            "device_sub_category": device_sub_category,
            "payment_mode": payment_mode,
            "saleschannel_ref_id": saleschannel_ref_id,
            "remarks": remarks,
            "receipt_details": {
                "receipt_type": receipt_type,
                "receipt_amount": receipt_amount,
                "receipt_date": receipt_date,
                "bank_account": bank_account,
                "receipt_no": receipt_no,
                "received_or_verified_by": received_or_verified_by
            },
            "items": item_details,
            "tcs_percentage": tcs_percentage,
            "tcs_value": tcs_value
        }

        var jsonObject = JSON.stringify(data)
        //Call Ajax on createInvoice
        $.ajax({
            url: "<?= base_url() ?>admin/Fastcheckout/createInvoice",
            type: "POST",
            data: jsonObject,
            dataType: "JSON",
            success: function(response) {
                if (response.status != 1) {
                    toastr.error("Error: " + response.message)
                    return false
                }
                toastr.success("Invoice Created Successfully")
                window.location.replace("<?= base_url() ?>admin/Finance/create_invoice")
            },
            error: function(error) {
                toastr.error('Error: Failed to Create Invoice')
            }
        })

    }
</script>