<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 th, td { white-space: nowrap; }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	
    <div class="btn-group btn-toolbar" data-toggle="buttons">
        <label class="btn btn-primary">
            <input type="radio" name="options" id="paymentmode_button_cod">COD
        </label>
        <label class="btn btn-primary">
            <input type="radio" name="options" id="paymentmode_button_prepaid" active>PREPAID
        </label>
        <label class="btn btn-primary">
            <input type="radio" name="options" id="paymentmode_button_credit">CREDIT
        </label>

        <label class="btn"></label>

        <label class="btn btn-info">
            <input type="radio" name="options" id="status_button_pending">PENDING
        </label>
        <label class="btn btn-info">
            <input type="radio" name="options" id="status_button_approved">APPROVED
        </label>
        <label class="btn btn-info">
            <input type="radio" name="options" id="status_button_rejected">FINANCE REJECTED
        </label>
        <label class="btn btn-info">
            <input type="radio" name="options" id="status_button_wh_rejected">WAREHOUSE REJECTED
        </label>
        <label class="btn btn-info">
            <input type="radio" name="options" id="status_button_invoiced" active>INVOICED
        </label>
        <label class="btn btn-info">
            <input type="radio" name="options" id="status_button_canceled">CANCELED
        </label>
        <label class="btn btn-info">
            <input type="radio" name="options" id="status_button_void">VOID
        </label>
        
    </div>
</div>
<p style="line-height:10px;"></p>

<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="paymentsList_table">
	<thead>
		<tr>
            <th></th>
            <th>SALESORDER NO</th>
            <th>CUSTOMER NAME</th>
            <th>SALES CHANNEL</th>
            <th>SALES CHANNEL Ref Id.</th>
            <th>STATUS</th>
            <th>PAYMENT MODE</th>
            <th>SALESORDER AMOUNT</th>
			<th>CREATION DATE</th>					
		</tr>
	</thead>		
</table>
							
<script>
var payments_table;
var department_id = getUserdata('department_id')

function payments_childtable ( d ) {
	// `d` is the original data object for the row
	var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/Payments/getPaymentDetails?salesorder_id="+d.salesorder_id),
		type:"GET",
		dataType: 'json',
		async: false,
		success: function ( data ) {
			if(data.result==null){
				childtable+='<tr><td>No Records Found</td></tr>';
			}else{
				childtable += '<th>BANK ACCOUNT</th><th>REF. NUMBER</th><th>PAYMENT DATE</th><th>AMOUNT</th>'

				$.each(data.result, function (i, d) { // loop through data returned from ajax 
				childtable+='<tr>'+
					'<td>'+data.result[i].bank_account+'</td>'+
					'<td>'+data.result[i].reference_number+'</td>'+
					'<td>'+data.result[i].payment_date+'</td>'+
					'<td>'+data.result[i].amount+'</td>'+					
					'</tr>';
				});
			}
		}
	} );
		
	childtable+='</table>';
	return childtable
}

function getUserdata(attribute){
    
    var a='';
    $.ajax({
        "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            a = data.result;
        }
    })
     return a;
}


$(document).ready(function(){

    getPaymentList()

    function getPaymentList(){
        payments_table = $('#paymentsList_table').DataTable({
                        "paging":true,
                        "destroy":true,
                        "searching":true,
                        "processing": true,
                        "serverSide": false,  
                        "scrollY": 390,
                        "scrollX": true,
                        "scrollCollapse": true,
                        //"autoWidth": false,
                        "aaSorting": [1, 'asc'],
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Payments/getPaymentsList?payment_mode=COD",
                            "type": "GET",
                            "dataSrc": "data"
                        },
                        "columns": [
                            {
                                    "className":      "details-control",
                                    "orderable":      false,
                                    "data":           null,
                                    "defaultContent": ''
                            },
                            { "data": "salesorder_code", "type":"any-number"},
                            { "data": "vendor_name" },	
                            { "data": "sales_channel" },	
                            { "data": "saleschannel_ref_id" },
                            { "data": "status" },
                            { "data": "payment_mode" },								
                            { "data": "total_amount" },									
                            { "data": "creation_date" },
                        ]
        });

    } 

    $('#paymentsList_table tbody').on('click', 'td.details-control', function () {
        
        var tr = $(this).closest('tr');
        var row = payments_table.row( tr );

        if ( row.child.isShown() ) {

            row.child.hide();
            tr.removeClass('shown');

        }else {
            row.child( payments_childtable(row.data()) ).show();
            tr.addClass('shown');
        }
    }) ;


    $('#paymentmode_button_cod').change(function(){
        payments_table.ajax.url('<?php echo base_url(); ?>admin/Payments/getPaymentsList?payment_mode=COD').load().draw();
    });
    
    $('#paymentmode_button_prepaid').change(function(){
        payments_table.ajax.url('<?php echo base_url(); ?>admin/Payments/getPaymentsList?payment_mode=PREPAID').load().draw();
    });
    
    $('#paymentmode_button_credit').change(function(){
        payments_table.ajax.url('<?php echo base_url(); ?>admin/Payments/getPaymentsList?payment_mode=CREDIT').load().draw();
    });



    $('#status_button_pending').change(function(){
        payments_table.ajax.url('<?php echo base_url(); ?>admin/Payments/getPaymentsList?status=FINANCE_PENDING').load().draw();
    });
    
    $('#status_button_approved').change(function(){
        payments_table.ajax.url('<?php echo base_url(); ?>admin/Payments/getPaymentsList?status=FINANCE_APPROVED').load().draw();
    });
    
    $('#status_button_rejected').change(function(){
        payments_table.ajax.url('<?php echo base_url(); ?>admin/Payments/getPaymentsList?status=FINANCE_REJECTED').load().draw();
    });
    
    $('#status_button_invoiced').change(function(){
        payments_table.ajax.url('<?php echo base_url(); ?>admin/Payments/getPaymentsList?status=INVOICED').load().draw();
    });
    
    $('#status_button_canceled').change(function(){
        payments_table.ajax.url('<?php echo base_url(); ?>admin/Payments/getPaymentsList?status=CANCELED').load().draw();
    });

    $('#status_button_wh_rejected').change(function(){
        payments_table.ajax.url('<?php echo base_url(); ?>admin/Payments/getPaymentsList?status=WAREHOUSE_REJECTED').load().draw();
    });

    $('#status_button_void').change(function(){
        payments_table.ajax.url('<?php echo base_url(); ?>admin/Payments/getPaymentsList?status=VOID').load().draw();
    });

})

</script>
	 
