<style>
    td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
        font-size: 0px;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
    }

    tr {
        height: 30px;
    }

    #EcomInvoiceList_table {
        all: unset;
    }

    EcomInvoiceList_table th,
    td {
        white-space: nowrap;
    }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
    <label class="btn btn-primary active">
        <input type="radio" name="options" id="invoice_button_new">NEW
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="invoice_button_active">ACTIVE
    </label>

    <label class="btn btn-primary">
        <input type="radio" name="options" id="invoice_button_cancelled">CANCELLED
    </label>
</div>

<p style="line-height:10px;"></p>
<div style="overflow-x: auto;">
    <table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="EcomInvoiceList_table">
        <thead>
            <tr>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>INVOICE NO</th>
                <th>Sales Channel</th>
                <th>CUSTOMER<br>NAME</th>
                <th>INVOICE DATE</th>
                <th>INVOICE STATUS</th>
                <th>IRN NO</th>
                <th>IRN STATUS</th>
            </tr>
        </thead>
    </table>
</div>

<script>
    var sr_table;
    var department_id = getUserdata('department_id')

    function getUserdata(attribute) {

        var a = '';
        $.ajax({
            "url": "<?= base_url() ?>Web_api/getUserData/" + attribute,
            "type": "GET",
            "dataType": "json",
            "async": false,
            "success": function(data) {
                a = data.result;
            }
        })
        return a;
    }

    $(document).ready(function() {

        function getEcomInvoiceList(status = '') {

            st_invoice_table = $('#EcomInvoiceList_table').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "aaSorting": [],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Invoice/getEInvoiceList",
                    "type": "GET",
                    "dataSrc": "data",
                    "data": {
                        "status": status,
                    },
                    "async": false,
                },
                "columns": [{
                        "className": "details-control einvoice_id",
                        "orderable": false,
                        "data": "invoice_id",
                    },
                    {
                        "data": function(data) {

                            var a = ''
                            if (data.irn_status == 'NEW' && (department_id == '6' || department_id == '5')) {
                                a += '<a href="#" class="fa fa-check-square-o" style="color:green; font-size:15px;" onClick="postEinvoice('+data.invoice_id+')"></a>'
                            } else if (data.irn_status == 'ACT' && department_id == '6' ) {
                                a += '<a href="#" class="fa fa-times-circle-o" style="color:red; font-size:15px;" onclick="postCancelEinvoice('+data.invoice_id+')"></a>'
                            }

                            return a
                        }
                    },
                    {
                        "data": "invoice_no",
                    },
                    {
                        "data": "sales_channel",
                    },
                    {
                        "data": "vendor_name",
                    },
                    {
                        "data": "invoice_date",
                    },
                    {
                        "data": "invoice_status",
                    },
                    {
                        "data": "irn_no",
                    },
                    {
                        "data": "irn_status",
                    }
                ]
            });


        }

        getEcomInvoiceList('NEW')

        $('#invoice_button_new').change(function() {
            getEcomInvoiceList('NEW')
        });

        $('#invoice_button_active').change(function() {
            getEcomInvoiceList('ACT')
        });

        $('#invoice_button_cancelled').change(function() {
            getEcomInvoiceList('CNL')
        });

        //Expand the details
        $('#EcomInvoiceList_table tbody').on('click', 'td.details-control', function() {
            var tr = $(this).closest('tr');
        var row = st_invoice_table.row( tr );
        if ( row.child.isShown() ) {
            row.child.hide();
            tr.removeClass('shown');
        }else {
            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
        });

        function format(d){
        var invoice_id = d.invoice_id;
        var a = '';
        $.ajax({
            "url": "<?= base_url() ?>admin/Invoice/getEinvoiceLog/" + invoice_id,
            "type": "GET",
            "dataType": "json",
            "async": false,
            "success": function(data) {
                
                a += '<table class="table table-striped" style="margin-left:5px; width:100%;">'
                a += '<tr>'
                a += '<th>API</th>'
                a += '<th>Response</th>'
                a += '<th>Updated Date</th>'
                a += '<th>Updated BY</th>'
                a += '</tr>'
                $.each(data.data, function(index, value) {
                    a += '<tr>'
                    a += '<td>' + value.api + '</td>'
                    a += '<td>' + value.response + '</td>'
                    a += '<td>' + value.updated_date + '</td>'
                    a += '<td>' + value.updated_by + '</td>'
                    a += '</tr>'
                })
                a += '</table>'
                $('#EcomInvoiceList_table tbody tr.shown td.details-control').html(a)
            }
        })
        return a;
        
    }

    });

    

    function postEinvoice(invoice_id) {

        if (invoice_id > 0) {

            $.ajax({
                "url": "<?= base_url() ?>admin/Invoice/posteinvoice/" + invoice_id,
                "type": "GET",
                "dataType": "json",
                "data": '',
                "async": false,
                "success": function(data) {
                    if (data.status) {
                        toastr.success(data.message)
                        $('#invoice_button_active').click()
                        return false
                    } else {
                        toastr.error(data.message)
                        return false
                    }
                },
                "error": function(data) {
                    toastr.error("Something went wrong")
                    return false
                }
            })
        }
    }

    function postCancelEinvoice(invoice_id){

            let cancel_reason = confirm('Are you sure to cancel this invoice?')
            if(cancel_reason != true){
                return false
            }

            
            if (invoice_id > 0) {
    
                $.ajax({
                    "url": "<?= base_url() ?>admin/Invoice/postcancel_einvoice/" + invoice_id,
                    "type": "GET",
                    "dataType": "json",
                    "data": '',
                    "async": false,
                    "success": function(data) {
                        if (data.status == 1) {
                            toastr.success(data.msg)
                            $('#invoice_button_cancelled').click()
                            return false
                        } else {
                            toastr.error(data.msg)
                            return false
                        }
                    },
                    "error": function(data) {
                        toastr.error("Something went wrong")
                        return false
                    }
                })
            }
    }
</script>