<style>
	.fnsku_stn_choices .inner_block {
		background-color: #fff;
		padding: 20px 30px;
	}
	.fnsku_stn_choices .inner_block.view_block {
		background-color: #27c24c;
		color: #fff;
		padding: 20px 30px;
	}
	.fnsku_stn_choices .selected_stn_list {
		font-weight: 700;
		list-style: none;
	}
	.fnsku_stn_choices table {
		margin: auto;
	}
	.fnsku_stn_choices table tbody tr > td {
		padding: 5px 15px;
	}
	.fnsku_stn_choices table tbody tr > td:first-of-type {
		text-align: right;
	}
	.fnsku_stn_choices table tbody tr > td:last-of-type {
		text-align: left;
	}
	.fnsku_stock_info .fnsku_locn_info {
		background-color: #ff910059;
		border-radius: 10px;
		padding: 15px 15px 5px;
		margin-bottom: 15px;
		text-align: center;
		font-size: 14px;
		text-transform: capitalize;
	}
	.device_stock_info .device_locn_info {
		background-color: #ffff0059;
		border-radius: 10px;
		padding: 15px 15px;
		margin-bottom: 15px;
		text-align: center;
		font-size: 14px;
		text-transform: capitalize;
	}
	.stn_locations_block .stn_locations {
		border: 3px dashed #ddd;
		border-radius: 10px;
		padding: 15px 15px;
		display: flex;
		justify-content: center;
		align-items: center;
		flex-wrap: wrap;
	}
	.stn_locations_block .stn_locn {
		display: flex;
		align-items: center;
		margin: 10px 10px;
		font-size: 12px;
		letter-spacing: 0.5px;
		font-weight: 700;
	}
	.stn_locations_block .stn_locn.arrow:before {
		content: "\f178";
		display: inline-block;
		font: normal normal normal 14px/1 FontAwesome;
		font-size: inherit;
		text-rendering: auto;
		-webkit-font-smoothing: antialiased;
		-moz-osx-font-smoothing: grayscale;
		position: relative;
		left: -12px;
		font-size: 20px;
	}
	.stn_locations_block .stn_locn > span.warehouse {
		display: inline-block;
		color: #333;
		background-color: #88c987;
		border: 1px solid #88c987;
		border-radius: 5px;
		padding: 4px 8px;
		min-width: 60px;
	}
	.stn_locations_block .stn_locn.non_editable > span.warehouse {
		background-color: #c1d4c1;
		border: 2px solid #c1d4c1;
		text-align: center;
	}
	.stn_locations_block .stn_locn > span.warehouse {
		margin-right: 5px;
	}
	.stn_locations_block .stn_locn .btn_remove {
		color: #f00;
		cursor: pointer;
		position: relative;
		right: -3px;
	}
</style>


<div>
	<div class="col-md-12">
		<div class="heading_block custom_inline mb_0">
			<h3 class="block_heading">Fulfillment Invoice</h3>

			<!-- <div class="btns_div">
				<a class="btn btn-success btn_nav_link" href="<?php //echo base_url() ?>admin/Ecom_invoice/manage_ecom_invoice/2/2">New Invoice with -- <b>FNSKU</b></a>
			</div> -->
		</div>
	</div>
	<hr style="border: 3px solid #e4eaec">

	<div class="col-md-12">
		<div class="form-group table-responsive">

			<table class="table table-bordered table-stripped" style="margin-left:15px">
				<tbody>
					<tr>
						<td>Customer</td>
						<td style="width:300px;display:flex;">
							<select class="form-control select_box" id="new_customer_select" name="customerList" style="width:300px">
								<option value="">SELECT CUSTOMER</option>
							</select>
							&nbsp;&nbsp;<a href="<?= base_url(); ?>admin/vendor/manage_vendor/buyer#new"><img src="<?= base_url(); ?>assets/img/details_open.png"></a>
						</td>
						<td>Sales Represnetive</td>
						<td style="width:300px">
							<input type="hidden" id="sellerList" value="<?= $this->session->userdata('user_id'); ?>">
							<input type="text" class="form-control" id="sellerName" value="<?= $this->session->userdata('user_name'); ?>" readonly>
						</td>
					</tr>
					<tr>
						<td>Payment Mode</td>
						<td style="width:300px">
							<select class="form-control select_box" id="paymentList" name="paymentList" style="width:300px;text-transform:uppercase;">
								<option value="">SELECT PAYMENT METHOD</option>
								<option value="cod">COD</option>
								<option value="prepaid">PREPAID</option>
								<option value="credit">CREDIT</option>
							</select>
						</td>
						<td>Sales Channel</td>
						<td style="width:300px">
							<select class="form-control select_box" id="saleschannelList" name="saleschannelList" style="width:300px;text-transform:uppercase;" onchange="hideWarehouses()">
								<option value="">SALES CHANNEL</option>
							</select>
						</td>
					</tr>
					<tr>
						<td>Warehouse</td>
						<td style="width:300px">
							<select class="form-control select_box select_warehouse" id="warehouseList" name="warehouseList" style="width:300px;text-transform:uppercase;">
							</select>
						</td>

						<td>FBA INVOICE REFERNCE ID</td>
						<td>
							<input type="text" class="form-control" name="invoice_ref_id_input" id="invoice_ref_id_input">
						</td>
					</tr>
					<tr>
						<td>SALES CHANNEL REFERNCE ID</td>
						<td><input type="text" class="form-control" name="saleschannel_ref_id_input" id="saleschannel_ref_id_input" value="<?php echo $order_id; ?>" disabled></td>

						<td>Order Received Date</td>
						<td style="text-align: left;">
							<input type="date" class="form-control" id="sale_date_input" value="<?= date('Y-m-d') ?>">
						</td>
					</tr>
					<tr>
						<td>Source Invoice Date</td>
						<td style="text-align: left;">
							<input type="date" class="form-control" id="source_invoice_date_input" value="<?= date('Y-m-d') ?>">
						</td>
						<td>REMARKS</td>
						<td>
							<textarea class="form-control" id="remark_textarea"></textarea>
						</td>
					</tr>
				</tbody>
			</table>
		</div>

		<h4 style="padding-left:10px;">Add Products</h4>
		<p style="line-height: 10px;"></p>

		<div id="add_sku_div" class="tab-pane active table-responsive dataTables_scroll ffi_device_info_block" style="overflow-x:auto;">
			<table class="table table-bordered" style="margin-left:15px">
				<tr>
					<td>
						<select class="form-control select_box category" style="width:150px" type="text" id="category" placeholder="CATEGORY">
							<option value="0">CATEGORY</option>
							<option value="OPEN BOX">OPEN BOX</option>
							<option value="PREXO">PREXO</option>
							<option value="PRELOVED">PRELOVED</option>
							<option value="BUY BACK">BUY BACK</option>
							<option value="DEMO">DEMO</option>
							<option value="NEW">NEW</option>
							<option value="INSURANCE">INSURANCE</option>
						</select>
					</td>
					<td>
						<input type="text" style="width:200px;height:32px;border-color:white;" class="fnsku" id="fnsku" placeholder="FNSKU" onchange="FNSKU_changed()">
					</td>
					<td>
						<input type="text" style="width:200px;height:32px;border-color:white;" class="imei" id="imei" placeholder="IMEI" onchange="checkDeviceDetails_usingIMEI()">
						<span class="availability_status">
							<i class="fa fa-refresh fa_verify" style="cursor: pointer; color: #00f;" aria-hidden="true" onclick="checkDeviceDetails_usingIMEI()"></i>
							<i class="fa fa-spinner fa_spinner" style="cursor: not-allowed; display: none;" aria-hidden="true"></i>
							<i class="fa fa-check-circle fa_correct yes" style="display: none;" aria-hidden="true"></i>
							<i class="fa fa-times-circle fa_wrong no" style="display: none;" aria-hidden="true"></i>
						</span>
					</td>
					<td>
						<input type="text" style="width:100px;height:32px;border-color:white;" class="quantity" id="quantity" onkeypress="return isNumberKey(event)" placeholder="QTY">
					</td>
					<td>
						<input type="text" style="width:150px;height:32px;border-color:white;" class="price" id="price" onkeypress="return isNumberKey(event)" placeholder="PRICE">
					</td>
					<td>
						<button type="button" id="btn_add" class="btn btn-danger btn_add" onclick="AddRows()" >Add</button>
					</td>

				</tr>
			</table>

			<div class="col-md-12">
				<div class="fnsku_stock_info"></div>
				<div class="device_stock_info"></div>
				<div class="stn_locations_block"></div>
			</div>
		</div>

		<div class="form-group table-responsive">
			<h4 style="margin-left:15px">INVOICE DETAILS</h4>
			<table class="table table-bordered table-stripped" style="margin-left:15px" id="bulkOrder">
				<thead class="priceIcon">
					<tr>
						<th>FNSKU</th>
						<th>IMEI</th>
						<th>PRODUCT NAME</th>
						<th>SKU</th>
						<th>CATEGORY</th>
						<th>PRICE</th>
						<th>Quantity</th>
						<th>Amount</th>
						<th>ACTION</th>
					</tr>
				</thead>
				<tbody class="tbody_device_rows">

				</tbody>
				<tfoot>
					<tr>
						<td></td>
						<td>
							Invoice Total Quantity
						</td>
						<td>
							<span id="total_qty_span"></span>
						</td>
						<td>
							Invoice Total Amount
						</td>
						<td>
							<span id="total_amount_span"></span>
						</td>
					</tr>

				</tfoot>
			</table>

		</div>
		<div style="text-align: center;">
			<button type="button" class="btn btn-grey" id="back_invoice">BACK</button>&nbsp;&nbsp;
			<button type="button" class="btn btn-primary" id="submit_invoice" onclick="checkDuplicate()">SUBMIT</button>
		</div>
	</div>
</div>


<script>
	var sno = 2;
	var Temp_arr = [];
	var warehouse_options = [];
	var FnskuWise_stn_objs = {};
	var Fnsku_stn_obj = {};
	var product_rem_qty = 0;
	getCustomerList();
	getWarehouseList();
	getNewDropdown('ECOM_SALESCHANNEL', 'saleschannelList');

	function getCustomerList() {
		var opt = ''
		$.ajax({
			"url": "<?= base_url() ?>Web_api/getVendorList",
			"method": "GET",
			"data": {
				"type": "FULFILLMENT"
			},
			"dataType": "json",
			"success": function(data) {

				$.each(data.result, function(i, v) {
					opt += '<option value="' + data.result[i].vendor_id + '">' + data.result[i].vendor_name + ' / ' + data.result[i].vendor_code + '</option>'
				})
				$("#new_customer_select").append(opt)
			}
		})
	}

	function hideWarehouses() {
		var sales_channel = $("#saleschannelList").val().toLowerCase()
		var sales_channel_split = sales_channel.split("-")
		$("#warehouseList").empty()
		$("#warehouseList").append("<option value='0' >SELECT WAREHOUSE</option>")

		$(warehouse_options).each(function(i, v) {

			if (sales_channel_split[0] == v.warehouse.toLowerCase()) {
				var a = "<option value='" + v.short_code + "' >" + v.warehouse + '-' + v.short_code + "</option>"
				$("#warehouseList").append(a);
			}
		})
		$("#warehouseList").trigger('change')
	}

	function getWarehouseList() {
		$.ajax({
			url: "<?php echo base_url(); ?>web_api/getWareHouse",
			type: "GET",
			dataType: 'json',
			async: false,
			success: function(data) {
				warehouse_options = data.result

			},
			error: function(errorThrown, textStatus, jqXHR) {
				alert("Error: " + jqXHR + " " + data.message);
			}
		});
	}

	function getNewDropdown(type, select_id) {
		$.ajax({
			type: "GET",
			url: "<?= base_url() ?>admin/DropDownItems/getItems?type=" + type,
			data: {},
			dataType: "json",
			success: function(data) {

				$.each(data, function(i, v) {
					$("#" + select_id).append('<option value="' + data[i].name + '">' + data[i].name + '</option>')
				})
			},
			error: function(error) {
				alert(error.responseJSON.message);
			}
		});
	}

	function getTotal() {
		var q = 0;
		var total_amount = 0.00
		$("#total_qty_span").text(0)
		$("#total_amount_span").text(0.00)

		$("tr.product_rows").each(function() {
			var imei = $(this).find(".td_imei").text()
			if (imei.length > 0) {
				q++;
				total_amount += parseFloat($(this).find(".td_amount").text());
			}

		})
		$("#total_qty_span").text(q)
		$("#total_amount_span").text(total_amount)
	}

	function checkDuplicate() {
		$('#submit_invoice').attr('disabled', true);

		var saleschannel_ref_id = $("#saleschannel_ref_id_input").val()
		var fields_required = ''
		fields_required += checkNull(saleschannel_ref_id, 'Saleschannel Ref ID, ')
		if (fields_required != '') {
			$('#submit_invoice').attr('disabled', false);
			toastr.error("Please Enter Saleschannel Ref Id")
			return false
		}

		$.ajax({
			"url": "<?= base_url() ?>admin/Ecom_invoice/checkDuplicate",
			"method": "GET",
			"data": {
				"saleschannel_ref_id": saleschannel_ref_id
			},
			"dataType": "json",
			"success": function(data) {
				if (data.status != 1) {
					// let user_confirm = window.confirm("An Invoice already Exists with this Order Id. Do you want to Continue?")
					toastr.error("An Invoice already Exists with this Order Id.")
					
					$('#submit_invoice').attr('disabled', false);
				} else {
					submitNewInvoice();
				}
			}
		});
	}

	function submitNewInvoice() {
		$('#submit_invoice').attr('disabled', true);
		$("#warehouseList").attr('disabled', false)

		var customer_id = $("#new_customer_select").val()
		var payment_mode = $("#paymentList").val()
		var warehouse = $("#warehouseList").val()
		var sales_channel = $("#saleschannelList").val()
		var saleschannel_ref_id = $("#saleschannel_ref_id_input").val()
		var invoice_ref_id = $("#invoice_ref_id_input").val()
		var sale_date = $("#sale_date_input").val()
		var source_invoice_date_input = $("#source_invoice_date_input").val()
		var remarks = $("#remark_textarea").val()
		var data = []
		var devices = []
		var fields_required = ''
		var k = false
		$("#warehouseList").attr('disabled', true)

		fields_required += checkNull(customer_id, 'Customer Name, ')
		fields_required += checkNull(payment_mode, 'Payment Mode, ')
		fields_required += checkNull(warehouse, 'Warehouse, ')
		fields_required += checkNull(sales_channel, 'Sales Channel, ')
		fields_required += checkNull(saleschannel_ref_id, 'Saleschannel Ref ID, ')
		fields_required += checkNull(sale_date, 'Sale date, ')
		fields_required += checkNull(source_invoice_date_input, 'Source Invoice date, ')

		if (fields_required != '') {
			toastr.error("Fields Required: " + fields_required);
			$('#submit_invoice').attr('disabled', false);
			return false
		}

		$("tr.product_rows").each(function() {

			let st_invoice_id = gvv($(this).data('st_invoice_id'), null);
			let device_id = gvv($(this).data('device_id'), null);
			let imei = $(this).find(".td_imei").text()
			let fnsku = $(this).find(".td_fnsku").text()
			let price = $(this).find(".td_price").text()
			let quantity = $(this).find(".td_quantity").text()
			let category = $(this).find(".td_category").text()

			if (isNaN(parseFloat(price)) || parseFloat(price) <= 0) {
				toastr.error("Please Enter Valid Price For " + fnsku)
				k = true;
				$('#submit_invoice').attr('disabled', false);
				return false
			}
			devices.push({
				"st_invoice_id": st_invoice_id,
				"device_id": device_id,
				"imei": imei,
				"fnsku": fnsku,
				"price": price,
				"category": category,
				"quantity": quantity,
			})
		})

		if (k == true) {
			$('#submit_invoice').attr('disabled', false);
			return false
		}
		if (devices.length == 0) {
			$('#submit_invoice').attr('disabled', false);
			toastr.error("No Devices Added")
			return false
		}

		var data = {
			"vendor_id": customer_id,
			"sales_channel": sales_channel,
			"saleschannel_ref_id": saleschannel_ref_id,
			"invoice_ref_id": invoice_ref_id,
			"warehouse": warehouse,
			"payment_mode": payment_mode,
			"sale_date": sale_date,
			"source_invoice_date": source_invoice_date_input,
			"remarks_header": remarks,
			"rows": devices,
			"FnskuWise_stn_objs": FnskuWise_stn_objs
		}
		var jsonObject = JSON.stringify(data);
		console.log(jsonObject);
		// return false;

		$.ajax({
			"url": "<?= base_url() ?>admin/Ecom_invoice/createEcomInvoiceByDevice",
			"method": "POST",
			"data": jsonObject,
			"dataType": "json",
			"success": function(data) {

				if (data.status) {
					toastr.success(data.message);
					
					setTimeout(function() {
						window.location.replace(base_url + "admin/Ecom_invoice/manage_ecom_invoice");
					}, 2000);
					
				} else {
					$('#submit_invoice').attr('disabled', false);
					toastr.error(data.message);
				}
			},
			"error": function(data) {
				$('#submit_invoice').attr('disabled', false);
			}
		});
	}

	function checkNull(entity, message) {
		if (entity == '' || entity == '0' || entity == undefined || entity == null) {
			return message
		}
		return ''
	}
	
	$('.ffi_device_info_block .quantity').on('change', function() {
		Fnsku_stn_obj = {};
		checkDeviceDetails_usingIMEI();
	})
	function FNSKU_changed() {
		Fnsku_stn_obj = {};
		checkDeviceDetails_usingIMEI();
	}
	
	function getStockDetails_usingFNSKU(fn){
		$(".fnsku_stock_info").html('');

		var fnsku = $("#fnsku").val().trim();
		var category = $("#category").val();
		var warehouse = $("#warehouseList").val()
		var sales_channel = $("#saleschannelList").val()
		
		if (sales_channel == '' || sales_channel == undefined || sales_channel == '0') {
			toastr.error("Please Select Sales Channel")
			return false
		}
		if (warehouse == '' || warehouse == undefined || warehouse == '0') {
			toastr.error("Please Select Warehouse")
			return false
		}
		if (category == '' || category == undefined || category == '0') {
			toastr.error("Please Select Product Category")
			return false
		}
		if (fnsku == '') {
			toastr.error("Please Enter FNSKU")
			return false
		}


		var data = {
			"fnsku": fnsku,
			"category": category,
			"warehouse": warehouse,
			"sales_channel": sales_channel
		}

		$.ajax({
			"url": "<?= base_url() ?>admin/Ecom_invoice/getAvailableStock",
			"type": "POST",
			"data": JSON.stringify(data),
			"dataType": 'json',
			"success": function(data) {

				if(data.status != 1){
					toastr.error("Failed to get Stock Info")
					return false
				}
				
				if (data.status == 1) {
					show_FnskuStock_Info(data);

					if (typeof(fn) == 'function' && (!($.isEmptyObject(Fnsku_stn_obj)) || product_rem_qty <= 0)) {
						fn(data);
					}
				}

				return true;
			}
		});

	}

	function checkDeviceDetails_usingIMEI(fn, create_st_note = false) {
		// alert($.isEmptyObject(Fnsku_stn_obj));
		$(".fnsku_stock_info, .device_stock_info, .stn_locations_block").html('');
		$(".availability_status .fa").hide();
		$(".availability_status .fa.fa_verify").show();

		if ($("#imei").val().trim() == '') {
			$('#quantity').attr('disabled', false);
			getStockDetails_usingFNSKU();
			return false
		}
		Fnsku_stn_obj = {};

		var category = $("#category").val();
		var imei = $("#imei").val().trim();
		var fnsku = $("#fnsku").val().trim();
		var warehouse = $("#warehouseList").val()
		var sales_channel = $("#saleschannelList").val()

		if (sales_channel == '' || sales_channel == undefined || sales_channel == '0') {
			toastr.error("Please Select Sales Channel")
			return false
		}
		if (warehouse == '' || warehouse == undefined || warehouse == '0') {
			toastr.error("Please Select Warehouse")
			return false
		}
		if (category == '' || category == undefined || category == '0') {
			toastr.error("Please Select Product Category")
			return false
		}
		if (fnsku == '') {
			toastr.error("Please Enter FNSKU")
			return false
		}


		var data = {
			"imei": imei,
			"fnsku": fnsku,
			"category": category,
			"warehouse": warehouse,
			"sales_channel": sales_channel,
			"create_st_note": create_st_note
		}
		
		$(".availability_status .fa").hide();
		$(".availability_status .fa.fa_spinner").show();

		$.ajax({
			"url": "<?= base_url() ?>admin/Ecom_invoice/checkDeviceDetails_usingIMEI",
			"type": "POST",
			"data": JSON.stringify(data),
			"dataType": 'json',
			"success": function(data) {
				$(".availability_status .fa").hide();

				if (create_st_note && (data.status == 1)) {
					toastr.success("Stock Transfer Note Created Successfully");

				} else if (create_st_note && (data.status == -1)) {
					$(".availability_status .fa.fa_verify").show();
					toastr.error("Something went wrong");
					return false

				} else if (data.status == -1) {
					$(".availability_status .fa.fa_verify").show();
					show_DeviceVerification_Error(data);

					show_StockTransferNotes(data);
					return false
				}

				if (data.status != 1) {
					$(".availability_status .fa.no").show();
					toastr.error(data.message);
					return false
				}

				if (data.status == 1) {
					$('#quantity').val('1').attr('disabled', true);
					$(".availability_status .fa.yes").show();
					show_StockTransferNotes(data);

					if (typeof(fn) == 'function') {
						fn(data);
					}
				}
				
				return true;
			}
		});
	}

	function show_FnskuStock_Info(data) {
		let product_required_qty = parseInt(gvv($('.ffi_device_info_block .quantity').val(), 0));
		let product_avble_qty = parseInt(data.sel_warehouse_avbl_cnt);
		product_rem_qty = product_required_qty - product_avble_qty;

		var html = '<div class="fnsku_locn_info" >';
		html += '<p>Available Stock at <b>' + ($("#warehouseList").val()) + '</b> location is: &nbsp;&nbsp;<b>' + product_avble_qty + '</b></p>';
		
		if (product_rem_qty > 0) {
			html += '<p>Do you wants to make a Stock Transfer Note based on FNSKU ?</p>';
			
			html += '<div class="fnsku_stn_choices">';
			html += '  <div class="inner_block edit_block">';
			html += '      <table><tbody><tr><td><label>Please select From Location:</label></td><td><table class="stn_from_block"><tbody>';
			$.each(data.stock_details, function(i,v) {
				let qty = gvv(Fnsku_stn_obj[i], 0);
				let is_chkd = (qty > 0)? 'checked':'';
				let is_disabled = (qty > 0)? '':'disabled';
				let qty_val = (qty > 0 && qty <= v.avbl_cnt)? qty:'';

				if (v.avbl_cnt >= 1) {
					html += '<tr class="stn_from"><td>';
					html += '  <input type="checkbox" id="from_locn_'+ i +'" class="stn_from_locn" name="stn_from_locn" value="'+ i +'" '+ is_chkd +'>';
					html += '  <label style="margin-left: 10px;" for="from_locn_'+ i +'">'+ i + ' <span style="font-size: 12px; margin-left: 5px;">(Available Stock: '+ v.avbl_cnt +')</span></label><br>';
					html += '</td>';
					html += '<td>';
					html += '  <input type="text" class="qty" onkeypress="return isNumberKey(event)" placeholder="Qty" style="width: 60px;" value="'+ qty_val +'" '+ is_disabled +' data-locn="'+ i + '" data-max_qty="'+ v.avbl_cnt +'">';
					html += '</td></tr>';
				}
			});
			html += '      </tbody></table></td></tr>';
			html += '        <tr><td><label>To Location:</label></td><td><b>'+ data.sel_warehouse +'</b></td></tr>';
			html += '      </tbody></table>';
			html += '      <button type="button" class="btn btn-sm btn-success btn_stn_fnsku" >Create STN using FNSKU</button>'
			html += '  </div>';
			html += '  <div class="inner_block view_block" style="display:none;">';
			html += '  </div>';
			html += '</div>';
		}
		html += '</div>';

		$('.fnsku_stock_info').html(html);

		show_STN_obj();
		
		$('.stn_from .stn_from_locn').on('change', function() {
			let id = $(this).parents('tr.stn_from').find('.qty');
			if ($(this).is(':checked')) {
				id.val('').attr('disabled', false);
			} else {
				id.val('').attr('disabled', true);
			}
		});
		$('.stn_from .qty').on('keyup', function() {
			let id = $(this).parents('tr.stn_from').find('.qty');
			let val = gvv($(this).val(), 0);
			let max_qty = parseInt($(this).data('max_qty'));
			if (val > max_qty) {
				alert("Quantity shouldn't exceed available limit");
				$(this).val('');
			}
		});
		$('.fnsku_stn_choices .btn_stn_fnsku').on('click', function() {
			let req_total_qty = $('.ffi_device_info_block .quantity').val();
			if (!isValidString(req_total_qty)) {
				toastr.error("Please enter Total Quantity in Add Products Row");
				return false;
			}

			let stn_from = $(this).parents('.fnsku_stn_choices').find('.stn_from_block .stn_from');

			let qty_cnt = 0;
			let temp = {};
			stn_from.each(function() {
				let val = $(this).find('.qty').val();
				if (isValidString(val)) {
					temp[$(this).find('.qty').data('locn')] = val;
					qty_cnt += parseInt(gvv(val, 0));
				}
			});

			if ((qty_cnt > 0) && (qty_cnt == product_required_qty)) {
				Fnsku_stn_obj = temp;
				console.log(JSON.stringify(Fnsku_stn_obj));
				console.log(JSON.stringify(FnskuWise_stn_objs));
			} else {
				toastr.error("Sum of Quantities entered here should be equal to " + product_required_qty);
				return false;
			}

			show_STN_obj();
		});
	}

	function show_STN_obj() {
		if ($.isEmptyObject(Fnsku_stn_obj)) {
			$('.fnsku_stn_choices .inner_block').hide();
			$('.fnsku_stn_choices .inner_block.edit_block').show();
		} else {
			$('.fnsku_stn_choices .inner_block').hide();
			$('.fnsku_stn_choices .inner_block.view_block').show();

			var html = '<ul class="selected_stn_list">';
			$.each(Fnsku_stn_obj, function(i, v) {
				html += '<li><span>'+ i +'</span>&nbsp;&nbsp;-&nbsp;&nbsp;<span>'+ v +'</span></li>';
			});
			html += '</ul>';
			
			$('.fnsku_stn_choices .inner_block.view_block').html(html);
		}
	}

	function show_DeviceVerification_Error(data) {
		var html = '<div class="device_locn_info" >';
		html += '<p>This device is at <b>' + (data.warehouse_loc) + '</b> location. Do you want to create a Stock Transfer Note from <b>' + (data.warehouse_loc) + '</b> to <b>' + (data.new_warehouse_loc) + '</b> ?</p>';
		html += '<button type="button" class="btn btn-sm btn-success btn_create_stn" >Create STN</button>'
		html += '</div>';

		$(".device_stock_info").html(html);
	}
	$(".device_stock_info").on('click', '.device_locn_info .btn_create_stn', function() {
		$res = confirm('Are you sure, Do you want to create Stock Transfer Note');
		if ($res) {
			checkDeviceDetails_usingIMEI(null, true);
		}
	});
	
	function show_StockTransferNotes(data) {
		var html = '<div class="stn_locations" data-stocktransfer_invoice_id="'+ data.stocktransfer_invoice_id +'">';
		html += '<div class="stn_locn non_editable"><span class="warehouse">'+ data.stn_from_loc +'</span></div>';
		html += '<div class="stn_locn non_editable arrow"><span class="warehouse">'+ data.stn_to_loc +'</span></div>';

		let stn_cnt = (data.stn_notes).length;
		var is_deletable = '';
		$.each(data.stn_notes, function(i,v) {
			is_deletable = (stn_cnt == i+1)? '<i class="fa fa-times-circle btn_remove" aria-hidden="true"></i>' : '';
			html += '<div class="stn_locn arrow" data-stocktransfer_note_id="'+ v.stocktransfer_note_id +'"><span class="warehouse">'+ v.to_loc +' '+ is_deletable +'</span></div>';
		});
		html += '</div>';

		$(".stn_locations_block").html(html);
	}
	
	$(".stn_locations_block").on('click', '.stn_locn .btn_remove', function() {
		let stocktransfer_invoice_id = $(this).parents('.stn_locations').data('stocktransfer_invoice_id');
		let stocktransfer_note_id = $(this).parents('.stn_locn').data('stocktransfer_note_id');

		var req_obj = {
			stocktransfer_invoice_id: stocktransfer_invoice_id,
			stocktransfer_note_id: stocktransfer_note_id
		};

		let status = confirm('Are you sure, Do you want to delete this Stock Transfer Note ?');
		if (status) {
			delete_StockTransferNote(req_obj);
		}
	});

	function delete_StockTransferNote(req_obj) {
		$.ajax({
			"url": "<?= base_url() ?>admin/Ecom_invoice/deleteStockTransferNote",
			"type": "POST",
			"data": JSON.stringify(req_obj),
			"dataType": 'json',
			"success": function(data) {

				if (data.status != 1) {
					toastr.error(data.message);
					return false
				}
				toastr.success(data.message);

				checkDeviceDetails_usingIMEI();
			}
		});
	}
	
	function AddRows() {
		var category = $("#category").val();
		var imei = $("#imei").val().trim();
		var fnsku = $("#fnsku").val().trim();
		var quantity = parseInt($("#quantity").val());
		var price = parseFloat($("#price").val());
		var warehouse = $("#warehouseList").val()
		var sales_channel = $("#saleschannelList").val()

		if (sales_channel == '' || sales_channel == undefined || sales_channel == '0') {
			toastr.error("Please Select Sales Channel")
			return false
		}
		if (warehouse == '' || warehouse == undefined || warehouse == '0') {
			toastr.error("Please Select Warehouse")
			return false
		}
		if (category == '' || category == undefined || category == '0') {
			toastr.error("Please Select Product Category")
			return false
		}
		if (fnsku == '') {
			toastr.error("Please Enter FNSKU")
			return false
		}
		
		if ($("#imei").val().trim() == '') {
			let status = confirm("Are you sure to go without IMEI ?");
			if (!status) {
				return false;
			}
			getStockDetails_usingFNSKU(addNewRow);
		} else {
			checkDeviceDetails_usingIMEI(addNewRow);
		}
	}

	function addNewRow(data) {
		
		var category = $("#category").val();
		var imei = $("#imei").val().trim();
		var fnsku = $("#fnsku").val().trim();
		var quantity = parseInt($("#quantity").val());
		var price = parseFloat($("#price").val());
		var warehouse = $("#warehouseList").val()
		var sales_channel = $("#saleschannelList").val()

		if (sales_channel == '' || sales_channel == undefined || sales_channel == '0') {
			toastr.error("Please Select Sales Channel")
			return false
		}
		if (warehouse == '' || warehouse == undefined || warehouse == '0') {
			toastr.error("Please Select Warehouse")
			return false
		}
		if (category == '' || category == undefined || category == '0') {
			toastr.error("Please Select Product Category")
			return false
		}
		if (fnsku == '') {
			toastr.error("Please Enter FNSKU")
			return false
		}
		
		if (isNaN(quantity) || quantity <= 0) {
			toastr.error("Please enter Quantity");
			return false;
		}
		if (isNaN(price) || price <= 0) {
			toastr.error("Please Enter Valid Price");
			return false;
		}

		if (imei == '') {
			if (Temp_arr[fnsku] == true) {
				toastr.error("Duplicate FNSKUs not Allowed")
				return false
			}
		} else {
			if (isNaN(quantity) || quantity != 1) {
				toastr.error("Quantity should be one");
				return false;
			}
			if (Temp_arr[imei] == true) {
				toastr.error("Duplicate IMEIs not Allowed")
				return false
			}
		}

		let amount = price * quantity
		let tr = '<tr class="product_rows" data-st_invoice_id="' + gvv(data.stocktransfer_invoice_id, null) + '" data-device_id="' + gvv(data.device_id, null) + '" >'
		tr += '<td class="td_fnsku" data-fnsku="'+ fnsku +'">' + fnsku + '</td>'
		tr += '<td class="td_imei" data-imei="'+ imei +'">' + imei + '</td>'
		tr += '<td>' + data.device_name + '</td>'
		tr += '<td>' + data.sku + '</td>'
		tr += '<td class="td_category">' + category + '</td>'
		tr += '<td class="td_price">' + price + '</td>'
		tr += '<td class="td_quantity">' + quantity + '</td>'
		tr += '<td class="td_amount">' + amount + '</td>'
		tr += '<td><span class="fa fa-trash" onclick="deleteRow(this)"></span></td>'
		tr += '</tr>'

		$(".tbody_device_rows").append(tr)
		getTotal()
		$("#warehouseList").attr('disabled', true);
		$("#imei").val('');
		$("#fnsku").val('');
		$("#quantity").val('').attr('disabled', false);
		$("#price").val('');
		$(".fnsku_stock_info, .device_stock_info, .stn_locations_block").html('');
		$(".availability_status .fa").hide();
		$(".availability_status .fa.fa_verify").show();

		
		if (imei == '') {
			Temp_arr[fnsku] = true;
			FnskuWise_stn_objs[fnsku] = Fnsku_stn_obj;
			Fnsku_stn_obj = {};
			console.log(JSON.stringify(FnskuWise_stn_objs));
		} else {
			Temp_arr[imei] = true;
		}
		
		return true;
	}
	
	function deleteRow(btn) {
		result = confirm("Are You sure? you want to confirm delete.");

		if (result) {
			$(btn).closest('tr').remove();
			let fnsku = $(btn).closest('tr').find('.td_fnsku').data('fnsku');
			let imei = $(btn).closest('tr').find('.td_imei').data('imei');
			
			if (imei == '') {
				Temp_arr[fnsku] = false;
				FnskuWise_stn_objs[fnsku] = {};
			} else {
				Temp_arr[imei] = false;
			}

			getTotal()
			if ($(".product_rows").length <= 0) {
				$("#warehouseList").attr('disabled', false)
			}
		} else {
			return false;
		}
	}

	$(".select_warehouse").on('change', function() {
		$(".availability_status .fa").hide();
		$(".availability_status .fa.fa_verify").show();
	});
	
	$(".availability_status .fa.no").on('click', function() {
		$(this).parents('td').find('.imei').val('');
		$(this).hide();
		$(".availability_status .fa.fa_verify").show();
	});

</script>
