<div class="table-responsive scrolledTable">
		<hr style="border: 3px solid #e4eaec">
        <input type="hidden" id="edit_new_ecom_invoice_id" value="<?php echo $edit_ecom_invoice_id;?>">
        <h4>Order Details</h4>
        <table class="table table-striped DataTables" id="edit_ecom_invoice_table" cellspacing="0" align="left" style="white-space:nowrap;">
		<thead>
            <tr>
                <th>ECOM<br>INVOICE NO</th>
                <th>CUSTOMER NAME</th>
                <th>SALESCHANNEL</th>
                <th>SALESCHANNEL <br> REF. ID</th>
                <th>INVOICE <br> REF. ID</th>
                <th>SALE DATE</th>
                <th>SOURCE<br>INVOIC DATE</th>
                <th>PAYMENT MODE</th>
                <th>WAREHOUSE</th>
                <th>STATUS</th>
                <th>CREATED BY</th>
                <th>UPDATED BY</th>
                <th>CREATION DATE</th> 
            </tr>
        </thead>
    </table>
    <hr style="border: 3px solid #e4eaec">
	<h4>Remarks</h4>
    <table class="table table-stripped DataTables" id="remarks_table">
		<tr>
            <td>REMARKS</td>
            <td><textarea id="remarks_header" class="form-control" name="remarks_header" maxlength="200" ></textarea></td>
        </tr>
    </table>
</div>

<hr style="border: 3px solid #e4eaec">
    <div class="table-responsive scrolledTable">
        <h4>Product Details</h4>
        <table class="table table-bordered table-stripped DataTables " cellspacing="0" id="editProduct_details">
			<thead>
                <tr>
                <th>SKU</th>
                <th>Product Name</th>
                <th>CATEGORY</th>
                <th>FNSKU</th>
                <th>PRICE</th>
                <th>TAXABLE AMOUNT</th>
                <th>EXEMPT AMOUNT</th>
                <th>Tax Amount</th>
                <th>TAX TYPE</th>
            </tr>              
            </thead>
            <tbody class="edit_tbody">

            </tbody>
            <tfoot>
                <tr style="font-weight:700;">
                   <td colspan="2">Total Qty</td><td colspan="2" id = "edit_total_quantity"></td>
                   <td colspan="2">Total Amount</td><td colspan="2" id = "edit_total_amount"></td>
                </tr>
            </tfoot>
        </table>
        
        <table style="width: 100%;">
            <tr>
                <td style="text-align: center;">
                    <button class="btn btn-primary" id="edit_submit_approve" name="action" onclick="submitEditForm()" value="submit" >SUBMIT</button>
                    &nbsp;&nbsp;&nbsp;&nbsp;<button class="btn btn-red" id="cancel" type="button" onclick="window.location.replace('<?=base_url()?>admin/Ecom_invoice/manage_ecom_invoice')">BACK</button>
                </td>
            </tr>
	    </table>
    </div>

<script>
    var edit_ecom_invoice_id = $("#edit_new_ecom_invoice_id").val()
    var headerdata = []
    $(document).ready(function(){

        if(!isNaN(parseInt(edit_ecom_invoice_id))){
            getEditInvoiceHeader()
        }
        function getEditInvoiceHeader(){
            edit_st_table = $('#edit_ecom_invoice_table').DataTable({
                            "paging":true,
                            "destroy":true,
                            "searching":true,
                            "processing": true,
                            "serverSide": false,  
                            "scrollY": 380,
                            "scrollX":true,
                            "scrollCollapse": true,
                            "autoWidth": false,
                            "ajax": {
                                "url": "<?php echo base_url(); ?>admin/Ecom_invoice/getEcomInvoiceHeader/"+edit_ecom_invoice_id,
                                "dataSrc" : "data"
                            },
                            "columns": [
                                { "data": "ecom_invoice_no"},
                                { "data": "vendor_name" },
                                { "data": "sales_channel" },
                                { "data":function(data){
                                  return '<input type="text" class="form-control" id="edit_saleschannel_ref_id" value="'+data.saleschannel_ref_id+'">'  
                                } },
                                { "data":function(data){
                                  return '<input type="text" class="form-control" id="edit_invoice_ref_id" value="'+data.invoice_ref_id+'">'  
                                } },
                                { "data":function(data){
                                  return '<input type="date" class="form-control" id="edit_sale_date" value="'+data.sale_date+'">'  
                                } },
                                { "data":function(data){
                                  return '<input type="date" class="form-control" id="edit_source_invoice_date" value="'+data.source_invoice_date+'">'  
                                } },
                                
                                { "data":function(data){
                                  let a = '<select class="form-control select_box" id="edit_payment_mode">'
                                  a += '<option value="cod" '+(data.payment_mode == 'COD'?'selected':'')+'>COD</option>'  
                                  a += '<option value="prepaid" '+(data.payment_mode == 'PREPAID'?'selected':'')+'>PREPAID</option>'  
                                  a += '<option value="credit" '+(data.payment_mode == 'CREDIT'?'selected':'')+'>CREDIT</option>'
                                  a += '</select>' 
                                  return a
                                } },
                                { "data": "warehouse" },
                                { "data": "status" },
                                { "data": "created_by" },
                                { "data": "last_updated_by" },
                                { "data": "creation_date" },                            
                            ],
                        "initComplete": function(settings, json){
                            headerdata = json
                            edit_invoice_rows()
                        }

            });

        }

        function edit_invoice_rows () {
            // `d` is the original data object for the row
            var childtable= '';
                $.ajax( {
                url: encodeURI("<?php echo base_url(); ?>admin/Ecom_invoice/getEcomInvoiceDetails?ecom_invoice_id="+edit_ecom_invoice_id),
                type:"GET",
                dataType: 'json',
                async: false,
                success: function ( data ) {
                    if(data.result==null){
                        childtable+='<tr><td>No Records Found</td></tr>';
                    }else{


                        $.each(data.result, function (i, d) { // loop through data returned from ajax 
                            childtable +='<tr>'+
                                '<td>'+data.result[i].sku+'</td>'+
                                '<td>'+data.result[i].device_name+'</td>'+
                                '<td>'+data.result[i].stock_type+'</td>'+
                                '<td>'+data.result[i].fnsku+'</td>'+
                                '<td>'+data.result[i].price+'</td>'+
                                '<td>'+data.result[i].taxable_amount+'</td>'+
                                '<td>'+data.result[i].exempt_amount+'</td>'+
                                '<td>'+data.result[i].tax_amount+'</td>'+
                                '<td>'+data.result[i].bill_type+'</td>'+
                                '</tr>';
                        });
                    }
                }
            } );
                
            $(".edit_tbody").append(childtable)
            $("#edit_total_quantity").text(headerdata.data[0].quantity)
            $("#edit_total_amount").text(headerdata.data[0].total_amount)
        }
    })

    function submitEditForm(){
        

        if(edit_ecom_invoice_id == '' || isNaN(parseInt(edit_ecom_invoice_id)) || edit_ecom_invoice_id == 0){
            toastr.error("No Invoice Id Found")
            return false
        }

        var remarks_header = $("#remarks_header").val()
        var saleschannel_ref_id = $("#edit_saleschannel_ref_id").val()
        var invoice_ref_id = $("#edit_invoice_ref_id").val()
        var sale_date = $("#edit_sale_date").val()
        var source_invoice_date = $("#edit_source_invoice_date").val()
        var payment_mode = $("#edit_payment_mode").val()
        var fields_required = ''

        fields_required += checkNull(saleschannel_ref_id, 'Sales channel Ref ID, ')
        fields_required += checkNull(invoice_ref_id, 'Invoice Ref ID, ')
        fields_required += checkNull(sale_date, 'Sale Date, ')
        fields_required += checkNull(source_invoice_date, 'Source Invoice Date, ')
        fields_required += checkNull(payment_mode, 'Payment Mode')
        
        if(fields_required != ''){
            toastr.error("Field Required: "+ fields_required)
            return false
        }
        var data = {
            "ecom_invoice_id": edit_ecom_invoice_id,
            "remarks_header": remarks_header,
            "saleschannel_ref_id": saleschannel_ref_id,
            "invoice_ref_id": invoice_ref_id,
            "sale_date": sale_date,
            "source_invoice_date": source_invoice_date,
            "payment_mode": payment_mode,
        }
        var jsonObject = JSON.stringify(data)
        $("#edit_submit_approve").attr("disabled", true)
        $("#edit_submit_reject").attr("disabled", true)
        $.ajax({
            "url": "<?=base_url()?>admin/Ecom_invoice/editEcomInvoice",
            "method": "POST",
            "data": jsonObject,
            "dataType": "json",
            "success": function(data){
                if(data.status != 1){
                    toastr.error("Failed to Edit Invoice")
                    return false
                    $("#edit_submit_approve").attr("disabled", false)
                    $("#edit_submit_reject").attr("disabled", false)
                }

                toastr.success("invoice Updated Successfully")
                window.location.replace("<?=base_url()?>admin/Ecom_invoice/manage_ecom_invoice")
            }


        })
    }

    function checkNull(entity, message) {

        if (entity == '' || entity == '0' || entity == undefined || entity == null) {
            return message
        }
        return ''
    }

</script>