<table class="table table-bordered table-stripped" style="margin-left:15px">
	<tr>
	<td>Warehouse</td>
		<td style="width:300px">
			<select class="form-control select_box"  id="warehouseList_bulk" name="warehousList" style="width:300px;text-transform:uppercase;">
			</select>
		</td>
</tr>
	<tr>
		<td>Sales Channel</td>
		<td style="width:300px">
			<select class="form-control select_box"  id="saleschannelList_bulk" name="saleschannelList" style="width:300px;text-transform:uppercase;">
				<option value="">SALES CHANNEL</option>
			</select>
		</td>
	</tr>
	<tr>
		<td>UPLOAD</td>
		<td><input type="file" class="form-control-file custom-file-input" name="input_bulk_ecom_invoice" id="input_bulk_ecom_invoice"></td>
	</tr>
	<tr>
	<td colspan="9"><input type="button" class="btn btn-primary" value="Upload invoices" onclick="uploadBulkInvoice()" /></td>
	</tr>
</table>
<table class="form-group table-responsive table" style="margin-left:10px;">
	
</table>



<hr style="border: 3px solid #e4eaec"/>
<script type = "text/javascript" 
         src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js">
      </script>

<script type="text/javascript" language="javascript">

	getWarehouseList_bulk()
    getNewDropdown('ECOM_SALESCHANNEL','saleschannelList_bulk')
	
	function uploadBulkInvoice(){
		var invoice_rows = [];
		var sale_date_error = 0
		var saleschannel_id = ''
		
		var fileUpload = document.getElementById("input_bulk_ecom_invoice");
        var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;
        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
		        var reader = new FileReader();
                reader.onload = function (e) {
				    var rows = e.target.result.split("\r\n");
					for (var i = 0; i < rows.length; i++) {
						if(i != 0){
							var cells = rows[i].split(",");
							if (cells.length > 1) {
								invoice_rows.push({
									'vendor_no': cells[0],
									'saleschannel_ref_id': cells[1],
									'invoice_ref_id': cells[2],
									'fnsku': cells[3],
									'price':cells[4],
									'sale_date':cells[5],
									'remarks':cells[6],
								});

								if(cells[5] == '' || cells[5] == null || cells[5] == 'null'){
									sale_date_error++;
									saleschannel_id = cells[1]
									return false;
								}	
							}
						}
					}
					if(sale_date_error > 0){
						toastr.error("No Saledate for "+saleschannel_id)
						return false
					}
					sumbitBulkEcomInvoice(invoice_rows);
		        }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }
 
	function sumbitBulkEcomInvoice(invoice_rows){

		var warehouse = $("#warehouseList_bulk").val()
		var sales_channel = $("#saleschannelList_bulk").val()

		var data = {
					"warehouse": warehouse,
					"sales_channel": sales_channel,
					"rows": invoice_rows
				}
		$.ajax({
			url: '<?php echo base_url(); ?>admin/Ecom_invoice/createBulkEcomInvoice',
			type: 'POST',
			data: JSON.stringify(data),
			dataType: 'json',
			success:function(data){
							if(data.status != 1){
								toastr.error("Error: "+data.msg)
								return false
							}

							toastr.success("Success: Invoices created successfully")
							window.location.replace("<?=base_url()?>admin/Ecom_invoice/manage_ecom_invoice")
							return true
					},
			error:function(data){
							toastr.error("Error: "+data.msg)
							return false
			}			
		});
		
	}

	function getWarehouseList_bulk(){
        $.ajax({
			url: "<?php echo base_url(); ?>web_api/getWareHouse",
			type: "GET",
			dataType: 'json',
            async: false,
			success: function (data){
				$("#warehouseList").append("<option value=\"0\" >SELECT WAREHOUSE</option>")
				$.each(data.result,function(index,value){
					var a="<option value=\""+data.result[index].short_code+"\">"+data.result[index].warehouse+'-'+data.result[index].short_code+"</option>"
					$("#warehouseList_bulk").append(a);
				})
			},
			error: function (errorThrown, textStatus, jqXHR){
				alert("Error: "+jqXHR+" "+data.message); 
			}
		});
    }

	function getNewDropdown_bulk(type,select_id){
		$.ajax({
			type: "GET",
			url: "<?=base_url()?>admin/DropDownItems/getItems?type="+type,
			data: {},
			dataType:"json",
			success: function(data){

				$.each(data,function(i,v){
					$("#"+select_id).append('<option value="'+data[i].name+'">'+data[i].name+'</option>')
				})
			},
			error: function(error) {
				alert(error.responseJSON.message);
			}
		});
	}
</script>