<!-- Form with a file upload option -->

<div class="col-sm-12 col-md-12 col-lg-12">
    <h4 style="text-transform: capitalize;">Attach Devices to the Ecom Invoices</h4>

    <div class="col-md-12  col-sm-12 col-xs-12" style="padding:10px">
        <div class="form-group" style="padding:10px;">
            <label class="col-md-3 control-label">Upload IMEIs Info (CSV)</label>
            <div class="col-md-4">
                <input type="file" name="imei_invoice_file" id="imei_invoice_file" class="form-control">
            </div>
            <div class="col-lg-3">
                <button type="button" class="btn btn-primary" id="approve_invoice_pending_file_upload" onclick="validateUploadInvoiceFile()">Upload</button>
            </div>
        </div>
    </div>
</div>

<script>

    function validateUploadInvoiceFile(){
		var sales_list = [];
		
		var fileUpload = document.getElementById("imei_invoice_file");
        var regex = /^([a-zA-Z0-9\s_\\.\-:()])+(.csv|.txt)$/;
        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
                var reader = new FileReader();
                reader.onload = function (e) {
					var rows = e.target.result.split("\n");

                    for (var i = 1; i < rows.length; i++) {
                        if(rows[i] == ''){
                            continue;
                        }
						var cells = rows[i].split(",");
                        // console.log(JSON.stringify(cells));
                        
                        if (cells.length > 0) {
                            sale_obj = {
                                ecom_invoice_no: cells[0],
                                saleschannel_ref_id: cells[1],
                                fnsku: cells[2],
                                imei: cells[3],
                                warehouse: cells[4].replace('\r', ''),
                                sku: cells[5].replace('\r', '')
                            }
                            sales_list.push(sale_obj);
						}
					}	
					
					if(sales_list.length > 0){
                        Bulk_AttachDevicesToEcomInvoices(sales_list)
                    }else{
                        toastr.error("Invalid File")
                        return false
                    }
		        }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

    function Bulk_AttachDevicesToEcomInvoices(sales_list){

        if(sales_list == null){
            toastr.error("Invalid File")
            return false
        }

        jsonObejct = JSON.stringify(sales_list);

        $.ajax({
            url: "<?=base_url()?>admin/Ecom_invoice/Bulk_AttachDeviceTo_EcomInvoice",
            type: "POST",
            data: jsonObejct,
            dataType: 'json',
            success: function (data) {
                if (data.status == 1) {
                    toastr.success("IMEIs linked to Ecom Invoices Successfully")
                    setTimeout(function () {
                        window.location.reload()
                    }, 2000)
                    return true
                } else {
                    if(data.message != undefined){
                        toastr.error(data.message)
                    }else{
                        toastr.error("Failed to link IMEIs to Ecom Invoices")
                    }
                    return false
                }
            },
            error: function (data) {
                toastr.error("Failed to link IMEIs to Ecom Invoices")
                return false
            }
        })
    }

    
</script>