<style>
    .wait_info {
        text-align: center;
    }
    .wait_info .info {
        color: red;
    }
    .wait_info .stop_next_call {
        text-align: center;
    }
    .resp_info {
        color: red;
    }
    .pending_integrations ul.pendings_list {
        display: flex;
        flex-wrap: wrap;
        list-style: none;
    }
    .pending_integrations ul.pendings_list li {
        margin: 5px 8px;
    }
</style>


<div class="nav-tabs-custom nav_tabs_custom" style="margin-left:10px">

    <ul class="nav nav-pills">
        <li class="active"><a href="#bulk_approve" data-toggle="tab">Bulk Approve</a></li>
        <li class=""><a href="#integrate_with_hb" data-toggle="tab">Integrate with HB</a></li>
    </ul>

    <div class="tab-content bg-white">
        <div class="tab-pane active" id="bulk_approve">

            <div class="col-sm-12 col-md-12 col-lg-12">
                <div class="col-md-12  col-sm-12 col-xs-12" style="padding:10px">
                    <div class="form-group" style="padding:10px;">
                        <label class="col-lg-2 control-label">Upload Invoice (CSV)</label>
                        <div class="col-lg-3">
                            <input type="file" name="approve_invoice_file" id="approve_invoice_file" class="form-control">
                        </div>
                        <div class="col-lg-2">
                            <button type="button" class="btn btn-primary" id="approve_invoice_pending_file_upload" onclick="validateBulkUploadInvoiceFile()">Upload</button>
                        </div>
                        <div class="col-lg-2">
                            <button type="button" class="btn btn-danger" id="approve_invoice_pending_file_download" onclick="downloadPendingOrders()">Download Pending Orders</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        
        <div class="tab-pane" id="integrate_with_hb">

            <div class="" style="text-transform: initial;">
                <div class="pending_integrations" style="margin-bottom: 30px;">
                    <p>Total Pendings Invoices for HB Integration: <span class="total_pendings"></span></p>
                    <ul class="pendings_list" style="max-height: 110px; overflow-y: scroll;"></ul>
                </div>

                <div class="btns_div text-center">
                    <button type="button" class="btn btn-primary btn_integrate">Do Pending Integrations</button>
                </div>

                <div class="integration_response_div">
                    <h4>Response:</h4>

                    <p class="resp_info" style="display: none;"></p>
                    <p class="wait_info" style="display:none;"><span class="info">Integration is in progress. Please wait...</span> <span class="btn btn-sm btn-danger stop_next_call">Stop Next Call</span></p>

                    <ul class="integration_response" style="max-height: 300px; overflow-y: scroll;">
                        <!-- <li style="margin-bottom: 20px;">
                            <p style="margin-bottom: 3px;">Integreation</p>
                            <p>Invoices Integrated are: </p>
                        </li> -->
                    </ul>

                    <p>API Calls Count: <label class="api_calls_count">0</label></p>

                    
                </div>
            </div>

        </div>
    </div>
</div>

<br/>

<!-- Form with a file upload option -->

<!-- Bulk Approve Script -->
<script>
    function downloadPendingOrders() {
        window.open("<?=base_url()?>admin/Ecom_invoice/getPendingOrdersCSV", "_blank")
    }

    function validateBulkUploadInvoiceFile(){
		var orderObject = [];
		
		var fileUpload = document.getElementById("approve_invoice_file");
        var regex = /^([a-zA-Z0-9\s_\\.\-:()])+(.csv|.txt)$/;
        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
                var reader = new FileReader();
                reader.onload = function (e) {
					var rows = e.target.result.split("\n");

                    for (var i = 1; i < rows.length; i++) {
                        if(rows[i] == ''){
                            continue
                        }
						var cells = rows[i].split(",");
                        
                        if (cells[0].length > 1) {
                            
                            order_obj = {
                                ecom_invoice_no:cells[0],
                                status: cells[11].replace('\r', ''),
                                remarks: cells[12].replace('\r', '')
                            }
                            orderObject.push(order_obj)
						}
					}	
					
					if(orderObject.length>0){
                        updateBulkEcomInvoice(orderObject)
                    }else{
                        toastr.error("Invalid File")
                        return false
                    }
		        }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

    function updateBulkEcomInvoice(orderObject){

        if(orderObject == null){
            toastr.error("Invalid File")
            return false
        }

        jsonObejct = JSON.stringify(orderObject);
        $.ajax({
            url: "<?=base_url()?>admin/Ecom_invoice/updateBulkEcomInvoice",
            type: "POST",
            data: jsonObejct,
            dataType: 'json',
            success: function (data) {
                if (data.status == 1) {
                    toastr.success("Invoices Updated Successfully")
                    setTimeout(function () {
                        window.location.reload()
                    }, 2000)
                    return true
                } else {
                    if(data.msg != undefined){
                        toastr.error(data.msg)
                    }else{
                        toastr.error("Failed to Update Invoices")
                    }
                    return false
                }
            },
            error: function (data) {
                toastr.error("Failed to Update Invoices")
                return false
            }
        })
    }

    
</script>

<!-- Integrate with HB Script -->
<script>

    var Proceed_ajax_Calls = false;

    var Api_Calls_count = 0;

    $(function() {
        pending_integrations_with_HB();

        $('.btn_integrate').on('click', function() {
            Proceed_ajax_Calls = true;
            integrate_with_HB();
        });

        $('.stop_next_call').on('click', function() {
            Proceed_ajax_Calls = false;
            $('.resp_info').text('Please wait for the last response').show();
            $('.wait_info').hide();
        });
    });

    function integrate_with_HB() {
        if (!Proceed_ajax_Calls) {
            return false;
        }

        $('.resp_info').hide();
        $('.wait_info').show();
        
        $('.btn_integrate').attr('disabled', true);

        Api_Calls_count++;
        $.ajax({
            url: "<?=base_url()?>admin/Ecom_invoice/integrate_with_HB",
            type: "POST",
            dataType: 'json',
            success: function (data) {
                $('.btn_integrate').attr('disabled', false);
                $('.wait_info').hide();

                if (data.status) {
                    // let html = '<li style="margin-bottom: 20px;">'
                    //         + '    <label style="margin-bottom: 3px;">'+ data.message +'</label>'
                    //         + '    <p><b>Invoices Integrated are: </b>'+ JSON.stringify(data.integrated_inv_ids) +'</p>'
                    //         + '</li>';
                    // $('.integration_response').append(html);

                    $('.api_calls_count').text(Api_Calls_count);

                    if (!Proceed_ajax_Calls) {
                        $('.resp_info').text('Remaining calls are Stopped successfully').show();
                        return false;
                    } else {
                        integrate_with_HB();
                    }
                } else {
                    Proceed_ajax_Calls = false;
                    $('.resp_info').text(data.message);
                    $('.resp_info').show();
                }
            },
            error: function (data) {
                Proceed_ajax_Calls = false;
                $('.btn_integrate').attr('disabled', false);
                $('.wait_info').hide();
                toastr.error("Failed to load Response while Integrating to HB");
                return false;
            }
        });
    }
    
    function pending_integrations_with_HB() {
        $.ajax({
            url: "<?=base_url()?>admin/Ecom_invoice/pending_integrations_with_HB",
            type: "GET",
            dataType: 'json',
            success: function (data) {
                if (data.status) {
                    $('.pending_integrations .total_pendings').text(data.pendings_count);
                    
                    var html = '';
                    $.each(data.pending_inv_nos, function(i, v) {
                        html += '<li>'+ v +'</li>';
                    })
                    $('.pending_integrations .pendings_list').html(html);
                }
            },
            error: function (data) {
                console.log("Failed in fetching the Non-HB integrated Invoice No.s");
                return false;
            }
        });
    }

</script>