<div>
    <div class="form-group table-responsive">
        <hr style="border: 3px solid #e4eaec">
        <table class="table table-stripped" style="margin-left:15px; margin-right:15px;width:90%;">
            <tbody>
                <tr>
                    <td>Customer Type</td>
                    <td>
                        <input type="text" class="form-control" id="nv_customer_type" value="FULFILLMENT" readonly>
                    </td>
                    <td>NAME</td>
                    <td>
                        <input type="text" class="form-control" id="nv_vendor_name">
                    </td>
                    <td>Company</td>
                    <td>
                        <input type="text" class="form-control" id="nv_company">
                    </td>
                </tr>
                <tr>
                    <td>Address</td>
                    <td>
                        <input type="text" class="form-control" id="nv_address">
                    </td>
                    <td>City</td>
                    <td>
                        <input type="text" class="form-control" id="nv_city">
                    </td>
                    <td>State</td>
                    <td>
                        <select type="text" class="form-control select_box" id="nv_state_select" style="width: 100%;">
                            <option value="">SELECT STATE</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>Pincode</td>
                    <td>
                        <input type="text" class="form-control" id="nv_pincode">
                    </td>
                    <td>Country</td>
                    <td>
                        <input type="text" class="form-control" id="nv_country" value="INDIA" readonly>
                    </td>

                    <td>Email</td>
                    <td>
                        <input type="text" class="form-control" id="nv_email" value="ecom@sloyd.in" readonly>
                    </td>
                </tr>
                <tr>
                
                    <td>Mobile</td>
                    <td>
                        <input type="text" class="form-control" id="nv_mobile" value="9177898555" readonly>
                    </td>
                </tr>
                
            </tbody>
        </table>
    </div>
    <div style="text-align: center; margin-bottom :12px;">
		<button type="button" class="btn btn-primary" id="nv_submit_customer" onclick="submitNewCustomer()">SUBMIT</button>
	</div>
</div>

<script>
    getStatesList()
    function getStatesList(){
        $.ajax({
            "url":"<?=base_url()?>Web_api/getStatesList",
            "data":{},
            "method":"GET",
            "dataType":"json",
            "success": function(data){

                var a = ''
                $.each(data.result, function(i,v){
                    a += '<option value="'+v.state_id+'">'+v.state_name+'</option>'
                })

                $("#nv_state_select").append(a)
            }
        })
    }

    function checkNull(entity = '', message = ''){
        if(entity == null || entity == '' || entity == undefined || entity == 'undefined'){
            return message
        }
        return ''
    }
    function submitNewCustomer(){
        var customer_type = $("#nv_customer_type").val()
        var customer_name = $("#nv_vendor_name").val()
        var company_name = $("#nv_company").val()
        var address = $("#nv_address").val()
        var city = $("#nv_city").val()
        var state = $("#nv_state_select").val()
        var pincode = $("#nv_pincode").val()
        var country = $("#nv_country").val()
        var mobile = $("#nv_mobile").val()
        var email = $("#nv_email").val()

        var required_fields = ''
        required_fields += checkNull(customer_name, 'Name, ')
        required_fields += checkNull(company_name, 'Company Name, ')
        required_fields += checkNull(address, 'Address, ')
        required_fields += checkNull(city, 'City, ')
        required_fields += checkNull(state, 'State, ')
        required_fields += checkNull(pincode, 'Pin Code, ')

        if(required_fields != ''){
            toastr.error("Error: Fields Required" + required_fields)
            return false
        }

        var data = {
            "customer_type":customer_type,
            "customer_name":customer_name,
            "company_name":company_name,
            "address":address,
            "city":city,
            "state":state,
            "pincode":pincode,
            "country":country,
            "mobile":mobile,
            "email":email,
        }

        $.ajax({
            "url":"<?=base_url()?>admin/Vendor/createFFVendor",
            "method": "POST",
            "data":JSON.stringify(data),
            "dataType":"json",
            "success":function(result){
                if(result.status != 1){
                    toastr.error("Failed to Register Customer")
                    return false
                }
                toastr.success(result.msg)
                setTimeout(function () {
                window.location.replace("<?=base_url()?>admin/Ecom_invoice/manage_ecom_invoice")
                , 2000})
                return true
            }
        })
    }
</script>