<!-- Create the form -->
<div class="form-horizontal">
    <div class="col-md-12 col-sm-12 col-xs-12" style="padding:0px">
        <div class="col-md-6  col-sm-10 col-xs-12" style="padding:0px">
            <div class="form-group">
                <label class="control-label col-md-4 col-sm-4 col-xs-4">Category</label>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <select class="form-control" id="new_rule_category">
                        <option value="">Select Category</option>
                        <option value="bundle">BUNDLE</option>
                        <option value="openbox">OPEN BOX</option>
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-md-4 col-sm-4 col-xs-4">Bundle Type</label>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <select class="form-control" id="new_rule_bundle_type">
                        <option value="">Select Bundle type</option>
                        <option value="ALL">ALL</option>
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-md-4 col-sm-4 col-xs-4">Discount Criteria</label>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <select class="form-control" id="new_rule_discount_criteria">
                        <option value="">Select Discount Criteria</option>
                        <option value="value">ON VALUE</option>
                        <option value="quantity">ON QUANTITY</option>
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-md-4 col-sm-4 col-xs-4">Discount Type</label>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <select class="form-control" id="new_rule_discount_type">
                        <option value="">Select Discount Type</option>
                        <option value="amount">IN AMOUNT</option>
                        <option value="percent">IN PERCENTAGE</option>
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-md-4 col-sm-4 col-xs-4">Minimum Invoice Amount</label>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <input type="number" class="form-control" id="new_rule_min_invoice_amount" placeholder="Minimum Invoice Amount">
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-md-4 col-sm-4 col-xs-4">Minimum Quantity</label>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <input type="number" class="form-control" id="new_rule_min_quantity" placeholder="Minimum Quantity">
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-md-4 col-sm-4 col-xs-4">Discount Amount</label>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <input type="number" class="form-control" id="new_rule_discount_amount" placeholder="Discount Amount">
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-md-4 col-sm-4 col-xs-4">Discount Percent</label>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <input type="number" class="form-control" id="new_rule_discount_percent" placeholder="Discount Percent">
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-md-4 col-sm-4 col-xs-4">Maximum Discount Amount</label>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <input type="number" class="form-control" id="new_rule_maximum_discount_amount" placeholder="Maximum Discount Amount">
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-md-4 col-sm-4 col-xs-4">Start Date</label>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <input type="date" class="form-control" id="new_rule_start_date" placeholder="Start Date">
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-md-4 col-sm-4 col-xs-4">End Date</label>
                <div class="col-md-8 col-sm-8 col-xs-8">
                    <input type="date" class="form-control" id="new_rule_end_date" placeholder="End Date">
                </div>
            </div>

            <!-- Submit/Back Button -->
            <div class="form-group">
                <div class="col-md-12 col-sm-12 col-xs-12" style="text-align: center;">
                    <button type="button" class="btn btn-primary" id="new_rule_submit" onclick="submitNewRule()">Submit</button>
                    <button type="button" class="btn btn-default" id="new_rule_back">Back</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
   // getDropdownItems('BUNDLE_TYPE', 'new_rule_bundle_type');

    function checkInput(entity = '', message = '') {
        if (entity == '' || entity == null || entity == undefined) {
            return message;
        }
        return '';
    }

    // If discount criteria = 'amount' then new_rule_min_invoice_amount is enabled, else readonly
    $('#new_rule_discount_criteria').change(function() {
        if ($(this).val() == 'value') {
            $('#new_rule_min_invoice_amount').removeAttr('readonly');
            $('#new_rule_min_quantity').attr('readonly', 'readonly');
        } else {
            $('#new_rule_min_invoice_amount').attr('readonly', 'readonly');
            $('#new_rule_min_quantity').removeAttr('readonly');
        }
    });

    // If discount type = 'amount' then new_rule_discount_amount is enabled, else readonly
    $('#new_rule_discount_type').change(function() {
        if ($(this).val() == 'amount') {
            $('#new_rule_discount_amount').removeAttr('readonly');
            $('#new_rule_discount_percent').attr('readonly', 'readonly');
        } else {
            $('#new_rule_discount_amount').attr('readonly', 'readonly');
            $('#new_rule_discount_percent').removeAttr('readonly');
        }
    });

    // if new_rule_category = 'BUNLDE' then enable new_rule_bundle_type, else readonly
    $('#new_rule_category').change(function() {
        if ($(this).val() == 'bundle') {
            $('#new_rule_bundle_type').removeAttr('readonly');
            $('#new_rule_bundle_type').css('pointer-events', 'auto');
        } else {
            $('#new_rule_bundle_type').attr('readonly', 'readonly');
            $('#new_rule_bundle_type').css('pointer-events', 'none');
        }
    });

    function getDropdownItems(type = '', id = '') {
        $.ajax({
            "url": "<?= base_url() ?>admin/DropDownItems/getItems/",
            "type": "GET",
            "data": {
                "type": type
            },
            "dataType": "json",
            "async": false,
            "success": function(data) {
                $.each(data, function(i, d) { // loop through data returned from ajax
                    var a = '<option value="' + data[i].name + '">' + data[i].name + '</option>';
                    $("#" + id).append(a)
                })
            },
            "error": function() {
                toastr.error("Failed to get Tax List")
            }
        })
    }

    function submitNewRule() {
        $('#new_rule_submit').attr('disabled', true);
        let category = $('#new_rule_category').val();
        let discount_criteria = $('#new_rule_discount_criteria').val();
        let bundle_type = $('#new_rule_bundle_type').val();
        let discount_type = $('#new_rule_discount_type').val();
        let min_invoice_amount = $('#new_rule_min_invoice_amount').val();
        let min_quantity = $('#new_rule_min_quantity').val();
        let discount_amount = $('#new_rule_discount_amount').val();
        let discount_percent = $('#new_rule_discount_percent').val();
        let maximum_discount_amount = $('#new_rule_maximum_discount_amount').val();
        let start_date = $('#new_rule_start_date').val();
        let end_date = $('#new_rule_end_date').val();
        let required_fields = '';
        let date_valid_message = '';

        required_fields += checkInput(category, 'Category, ');
        required_fields += checkInput(discount_criteria, 'Discount Criteria, ');
        required_fields += checkInput(discount_type, 'Discount Type, ');
        required_fields += checkInput(start_date, 'Start Date, ');
        required_fields += checkInput(end_date, 'End Date, ');

        //if discount_criteria = 'value' then min_invoice_amount is required, else min_quantity is required
        if (discount_criteria == 'value') {
            required_fields += checkInput(min_invoice_amount, 'Minimum Invoice Amount, ');
        } else {
            required_fields += checkInput(min_quantity, 'Minimum Quantity, ');
        }

        // if discount_type = 'amount' then discount_amount is required, else discount_percent is required
        if (discount_type == 'amount') {
            required_fields += checkInput(discount_amount, 'Discount Amount, ');
        } else {
            required_fields += checkInput(discount_percent, 'Discount Percent, ');
        }

        // if category = 'bundle' then bundle_type is required, else bundle_type = ''
        if (category == 'bundle') {
            required_fields += checkInput(bundle_type, 'Bundle Type, ');
        } else {
            bundle_type = '';
        }

        if (required_fields != '') {
            toastr.error('Please fill in the following fields: ' + required_fields);
            $('#new_rule_submit').attr('disabled', false);
            return false;
        }
        let today_obj = new Date();

        // get today's date in yyyy-mm-dd format with padding 0s
        let today_date = today_obj.getFullYear() + '-' + ('0' + (today_obj.getMonth() + 1)).slice(-2) + '-' + ('0' + today_obj.getDate()).slice(-2);

        // start date should be greater than or equal to current date
        if (new Date(start_date).toUTCString() < new Date(today_date).toUTCString()) {
            date_valid_message += 'Start Date should be greater than or equal to current date, ';
        }

        // check whether start date and end date are valid dates or not
        if (new Date(start_date) > new Date(end_date)) {
            date_valid_message += 'End Date should be greater than Start Date. ';
        }

        if (date_valid_message != '') {
            toastr.error(date_valid_message);
            $('#new_rule_submit').attr('disabled', false);
            return false;
        }

        let data = {
            'category': category,
            'discount_criteria': discount_criteria,
            'discount_type': discount_type,
            'min_invoice_amount': min_invoice_amount,
            'min_quantity': min_quantity,
            'discount_amount': discount_amount,
            'discount_percent': discount_percent,
            'maximum_discount_amount': maximum_discount_amount,
            'bundle_type': bundle_type,
            'start_date': start_date,
            'end_date': end_date
        };
        let jsonObject = JSON.stringify(data);

        $.ajax({
            url: '<?php echo base_url(); ?>admin/Discounts_dealerapp/addDiscountsRule',
            type: 'POST',
            data: jsonObject,
            contentType: 'application/json',
            dataType: 'json',
            success: function(response) {
                if (response.status != 1) {
                    toastr.error(response.message);
                    $('#new_rule_submit').attr('disabled', false);
                    return false
                }
                
                toastr.success(response.message);
                window.location.href = '<?php echo base_url(); ?>admin/Discounts_dealerapp/manage_discounts_dealerapp';
            },
            error: function(response) {
                toastr.error(response.message);
                $('#new_rule_submit').attr('disabled', false);
                return false
            }
        });
    }
</script>