<style>
    td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
        font-size: 0px;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
    }

    tr {
        height: 30px;
    }

    td.discount_rule_id {
        font-size: 0px;
    }

    #discount_rules_list {
        padding: 5px;
    }

    #discount_rules_list .table-responsive {
        overflow-x: hidden;
    }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
    <label class="btn btn-primary active">
        <input type="radio" name="options" id="discount_rule_list_inactive">INACTIVE
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="discount_rule_list_active">ACTIVE
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="discount_rule_list_expired">EXPIRED
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="discount_rule_list_cancelled">CANCELLED
    </label>
</div>

<p style="line-height:10px;"></p>
<div class="col-sm-12" style="width: 100%;">
    <table id="discount_rules_list" class="table table-striped DataTable" style="width: 100%; overflow-x:auto">
        <thead>
            <tr>
                <th></th>
                <th></th>
                <th>Discount No</th>
                <th>Category</th>
                <th>Bundle Type</th>
                <th>Discount Type</th>
                <th>Criteria</th>
                <th>Min Invoice Amount</th>
                <th>Min Invoice Quantity</th>
                <th>Discount Amount</th>
                <th>Discount Percentage</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Maximum Discount Amount</th>
                <th>Status</th>
            </tr>
        </thead>
    </table>
</div>

<!-- Modal with Discount No, Category,  Discount Type, Criteria, Min Invoice Amount, Min Invoice Quantity, Discount Amount, Discount Percentage, Start Date, End Date, Maximum Discount Amount -->
<div class="modal fade" id="approve_discount_rule_modal" data-backdrop="false" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel">Invoice Details</h4>
            </div>
            <div class="modal-body">
                <table class="table table-striped">
                    <tr>
                        <th>Discount No</th>
                        <td id="modal_discount_no"></td>
                    </tr>
                    <tr>
                        <th>Category</th>
                        <td id="modal_category"></td>
                    </tr>
                    <tr>
                        <th>Bundle Type</th>
                        <td id="modal_bundle_type"></td>
                    </tr>
                    <tr>
                        <th>Discount Type</th>
                        <td id="modal_discount_type"></td>
                    </tr>
                    <tr>
                        <th>Criteria</th>
                        <td id="modal_criteria"></td>
                    </tr>
                    <tr>
                        <th>Min Invoice Amount</th>
                        <td id="modal_min_invoice_amount"></td>
                    </tr>
                    <tr>
                        <th>Min Invoice Quantity</th>
                        <td id="modal_min_invoice_quantity"></td>
                    </tr>
                    <tr>
                        <th>Discount Amount</th>
                        <td id="modal_discount_amount"></td>
                    </tr>
                    <tr>
                        <th>Discount Percentage</th>
                        <td id="modal_discount_percentage"></td>
                    </tr>
                    <tr>
                        <th>Start Date</th>
                        <td id="modal_start_date"></td>
                    </tr>
                    <tr>
                        <th>End Date</th>
                        <td id="modal_end_date"></td>
                    </tr>
                    <tr>
                        <th>Maximum Discount Amount</th>
                        <td id="modal_maximum_discount_amount"></td>
                    </tr>
                </table>
            </div>
            <div class="modal-footer" style="text-align: center;">
                <input type="hidden" id="modal_discount_id" value="">
                <button type="button" class="btn btn-success" id="modal_approve_btn" onclick="approveDiscountRule()">Approve</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {

        function getDiscountRulesList(status) {
            credinote_table = $('#discount_rules_list').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "lengthChange": true,

                "aaSorting": [],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Discounts_dealerapp/getDiscountRulesList",
                    "type": "GET",
                    "data": {
                        status: status
                    },
                    "dataSrc": "data",
                    "async": false,
                },
                "columns": [{
                        "data": "discount_rule_id",
                        "className": "discount_rule_id",
                    },
                    {
                        "data": function(data) {
                            let a = '<div style="display: flex; justify-content: space-between;">';
                            
                            if (data.status == 'INACTIVE') {
                                a += '<a style="color:green;" onclick="openApproveModal(this)" title="Approve"><i class="fa fa-check"></i></a>'
                            }
                            
                            if (data.status != 'CANCELLED') {
                                a += '&nbsp;&nbsp;&nbsp;<a style="color:red;" onclick="cancelDiscountRule(this)" title="Cancel"><i class="fa fa-times"></i></a>'
                            }
                            
                            a += '</div>';
                            return a;
                        }
                    },
                    {
                        "data": "discount_rule_no",
                        "className": "discount_rule_no"
                    },
                    {
                        "data": "category",
                        "className": "category"
                    },
                    {
                        "data": "bundle_type",
                        "className": "bundle_type"
                    },
                    {
                        "data": "discount_type",
                        "className": "discount_type"
                    },
                    {
                        "data": "discount_criteria",
                        "className": "discount_criteria"
                    },
                    {
                        "data": "min_invoice_amount",
                        "className": "min_invoice_amount"
                    },
                    {
                        "data": "min_quantity",
                        "className": "min_quantity"
                    },
                    {
                        "data": "discount_amount",
                        "className": "discount_amount"
                    },
                    {
                        "data": "discount_percent",
                        "className": "discount_percent"
                    },
                    {
                        "data": "start_date",
                        "className": "start_date"
                    },
                    {
                        "data": "end_date",
                        "className": "end_date"
                    },
                    {
                        "data": "maximum_discount_amount",
                        "className": "maximum_discount_amount"
                    },
                    {
                        "data": "status",
                    }
                ],
            });
        }

        getDiscountRulesList("INACTIVE")

        $("#discount_rule_list_inactive").change(function() {
            getDiscountRulesList("INACTIVE")
        })

        $("#discount_rule_list_active").change(function() {
            getDiscountRulesList("ACTIVE")
        })

        $("#discount_rule_list_cancelled").change(function() {
            getDiscountRulesList("CANCELLED")
        })
    })

    function openApproveModal(e) {
        let discount_rule_id = $(e).closest('tr').find('.discount_rule_id').text();

        $("#modal_discount_id").val(discount_rule_id)
        $("#modal_discount_no").text($(e).closest('tr').find('.discount_rule_no').text())
        $("#modal_category").text($(e).closest('tr').find('.category').text())
        $("#modal_bundle_type").text($(e).closest('tr').find('.bundle_type').text())
        $("#modal_discount_type").text($(e).closest('tr').find('.discount_type').text())
        $("#modal_criteria").text($(e).closest('tr').find('.discount_criteria').text())
        $("#modal_min_invoice_amount").text($(e).closest('tr').find('.min_invoice_amount').text())
        $("#modal_min_invoice_quantity").text($(e).closest('tr').find('.min_quantity').text())
        $("#modal_discount_amount").text($(e).closest('tr').find('.discount_amount').text())
        $("#modal_discount_percentage").text($(e).closest('tr').find('.discount_percent').text())
        $("#modal_start_date").text($(e).closest('tr').find('.start_date').text())
        $("#modal_end_date").text($(e).closest('tr').find('.end_date').text())
        $("#modal_maximum_discount_amount").text($(e).closest('tr').find('.maximum_discount_amount').text())
        $('#approve_discount_rule_modal').modal('show');
    }

    // close approve modal
    $("#approve_discount_rule_modal").on("hidden.bs.modal", function() {
        $("#modal_discount_id").val("")
        $("#modal_discount_no").text("")
        $("#modal_category").text("")
        $("#modal_bundle_type").text("")
        $("#modal_discount_type").text("")
        $("#modal_criteria").text("")
        $("#modal_min_invoice_amount").text("")
        $("#modal_min_invoice_quantity").text("")
        $("#modal_discount_amount").text("")
        $("#modal_discount_percentage").text("")
        $("#modal_start_date").text("")
        $("#modal_end_date").text("")
        $("#modal_maximum_discount_amount").text("")
    })

    function approveDiscountRule() {
        let discount_rule_id = $("#modal_discount_id").val()
        let data = {
            discount_rule_id: discount_rule_id,
            status: "ACTIVE"
        }

        $.ajax({
            url: "<?php echo base_url(); ?>admin/Discounts_dealerapp/updateDiscountStatus",
            type: "POST",
            data: JSON.stringify(data),
            dataType: "json",
            success: function(response) {
                
                if (response.status == 1) {
                    toastr.success(response.message)
                    $('#approve_discount_rule_modal').modal('hide');
                    getDiscountRulesList("INACTIVE")
                    return true;
                }
                toastr.error(response.message)
                return false;
            },
            error: function(error) {
                toastr.error("Something went wrong")
                return false;
            }
        })
    }

    function cancelDiscountRule(e) {
        let discount_rule_id = +$(e).closest('tr').find('.discount_rule_id').text();

        if (discount_rule_id <= 0 || isNaN(discount_rule_id)) {
            toastr.error("Invalid Discount Id")
            return false;
        }

        let confirmation = window.confirm("Are you sure you want to cancel this discount rule?")
        
        if (!confirmation) {
            return false;
        }

        let data = {
            discount_rule_id: discount_rule_id,
            status: "CANCELLED"
        }

        $.ajax({
            url: "<?php echo base_url(); ?>admin/Discounts_dealerapp/updateDiscountStatus",
            type: "POST",
            data: JSON.stringify(data),
            dataType: "json",
            success: function(response) {
                if (response.status == 1) {
                    toastr.success(response.message)
                    $("#discount_rule_list_inactive").click()
                    return true;
                }
                toastr.error(response.message)
                return false;
            },
            error: function(error) {
                toastr.error("Something went wrong")
                return false;
            }
        })




    }
</script>