<div class="form-horizontal">
    <div class="col-md-12 col-sm-12 col-xs-12" style="padding:0px">
        <div class="col-md-6  col-sm-6 col-xs-6" style="padding:0px">

            <div class="form-group">
                <label class="col-lg-3 control-label">SELECT CUSTOMER</label>
                <div class="col-lg-9">
                    <select class="form-control select_box" id="cn_customerList" style="width:100%;">
                        <option value="">SELECT CUSTOMER</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-lg-3 control-label">SELECT TAX</label>
                <div class="col-lg-4">
                    <select class="form-control " id="cn_tax_type" style="width: 100%;" onchange="getNetDiscount()">
                        <option value="">SELECT TAX TYPE</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-lg-3 control-label">SELECT DATE</label>
                <div class="col-lg-4">
                    <input type="date" class="form-control" id="cn_date" placeholder="SELECT DATE" style="width: 100%;" />
                </div>
            </div>
            <div class="form-group">
                <label class="col-lg-3 control-label">Creditnote Type</label>
                <div class="col-lg-9">
                    <div class="radio-inline" style="padding-top:0px; padding-left:3px;">
                        <label class="radio-inline">
                            <input type="radio" name="discount_type" id="cn_discount_type_volume" value="VOLUME">VOLUME DISCOUNT
                        </label>
                        <label class="radio-inline">
                            <input type="radio" name="discount_type" id="cn_discount_type_other" value="OTHER">OTHER DISCOUNT
                        </label>
                    </div>
                </div>
            </div>
            <div class="cn_volume">
                <div class="col-md-12  col-sm-12 col-xs-12" style="padding:0px">
                    <div class="form-group">
                        <label class="col-lg-3 control-label">SELECT CATEGORY</label>
                        <div class="col-lg-4">
                            <select class="form-control  category_cls" id="cn_volume_input_category" style="width: 100%;">
                                <option value="">SELECT CATEGORY</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-lg-3 control-label">Select Period</label>
                        <div class="col-lg-9">
                            <div class="col-lg-5">
                                <input type="date" id="cn_from_date" class="form-control" style="width: 100%; margin-left:-10px;">
                            </div>
                            <div class="col-lg-5">
                                <input type="date" id="cn_to_date" class="form-control" style="width: 100%;">
                            </div>
                            <div class="col-lg-2">
                                <input type="button" class="btn btn-green" value="GET SALES" onclick="getNetPeriodSales()">
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
            </div>
        </div>

        <table class="table table-striped DataTables cn_volume" style="margin-left:5px; width:90%;" id="customerLedgerList_table">
            <thead>
                <tr>
                    <th>QUANTITY</th>
                    <th>SALES<br>AMOUNT</th>
                    <th>DISCOUNT</th>
                    <th>GST</th>
                    <th>NET DISCOUNT</th>
                    <th>TOTAL DISCOUNT</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td id="cn_volume_qty_td">
                    </td>
                    <td id="cn_volume_amount_td">
                    </td>
                    <td style="display: flex;">
                        <input type="number" id="cn_volume_discount" class="form-control" style="width:100px;" onchange="getNetDiscount()">
                        <select class="form-control " id="cn_volume_disc_mode" onchange="getNetDiscount()">
                            <option value="percent">In (%)</option>
                            <option value="amount">In (Rs.)</option>
                        </select>
                    </td>
                    <td id="cn_volume_disc_tax">
                    </td>
                    <td id="cn_volume_net_disc">
                    </td>
                    <td id="cn_volume_total_disc">
                    </td>
                </tr>
            </tbody>
        </table>

        <!-- other discounts -->

        <div class="cn_other">
            <div class="col-md-12 col-sm-12 col-xs-12" style="padding:0px">
                <div class="col-md-6  col-sm-6 col-xs-6" style="padding:0px">
                    <div class="form-group">
                        <label class="col-lg-3 control-label">SELECT PURPOSE</label>
                        <div class="col-lg-4">
                            <select class="form-control " id="cn_purpose" style="width: 100%;">
                                <option value="">SELECT PURPOSE</option>
                            </select>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <table class="table table-striped DataTables cn_other" style="margin-left:2px; width:100%;" id="customerLedgerList_tables">
            <thead>
                <tr>
                    <th>CATEGORY</th>
                    <th>INVOICE NO</th>
                    <th>QUANTITY</th>
                    <th>NET SALE</th>
                    <th>DISCOUNT</th>
                    <th>GST</th>
                    <th>NET DISCOUNT</th>
                </tr>
            </thead>
            <tbody id="cn_other_tbody">
                <tr class="cn_other_disc_rows" id="cn_other_disc_rows_id">
                    <td>
                        <select class="form-control cn_other_input_category" id="cn_other_input_category" style="width: fit-content;" onchange="getNetOtherSales(this)">
                            <option value="">SELECT CATEGORY</option>
                        </select>
                    </td>
                    <td>
                        <input type="text" class="cn_other_invoice_no" class="form-control" onchange="getNetOtherSales(this)">
                    </td>
                    <td class="cn_other_qty_td">
                    </td>
                    <td class="cn_other_net_amount_td">
                    </td>
                    <td style="display: flex;">
                        <input type="number" class="form-control cn_other_discount" style="width:100px;" onchange="getNetDiscountOther(this)">
                        <select class="form-control cn_other_disc_mode" style="width:100px;" onchange="getNetDiscountOther(this)">
                            <option value="percent">In (%)</option>
                            <option value="amount">In (Rs.)</option>
                        </select>
                    </td>
                    <td class="cn_other_disc_tax">
                    </td>
                    <td class="cn_other_net_disc">
                    </td>
                    <td class="cn_other_total_disc">
                    </td>
                    <input type="hidden" class="cn_other_invoice_id">
                </tr>
            </tbody>
        </table>

    </div>
    <div style="width: 100%; text-align:center;">
        <input type="button" value="CREATE" class="btn btn-primary" style="text-align: center;" onclick="submitCreditnote()">
        <input type="button" value="BACK" class="btn btn-grey" style="text-align: center;" onclick="goBack()">
    </div>
</div>

<script>
    getCustomerList()
    getDropdownItems('CN_DISCOUNT_TAX_TYPE', 'cn_tax_type')
    getDropdownItems('CN_DISCOUNT_PURPOSE', 'cn_purpose')
    getDropdownItems('CATEGORY', 'cn_volume_input_category')
    getDropdownItems('CATEGORY', 'cn_other_input_category')
    $('.cn_volume').hide();
    $('.cn_other').hide();

    function goBack() {
        window.location.replace("<?= base_url() ?>admin/Discounts/manage_discounts")
    }

    function checkNull(entity = '', message = '') {
        if (entity == '' || entity == null || entity == undefined) {
            return message
        }
        return ''
    }

    function addNewRow(btn) {
        var row = document.getElementById("cn_other_disc_rows_id").outerHTML
        $("#cn_other_tbody").append(row)

        getNetOtherSales(btn)
    }

    $(document).ready(function() {

        $("#cn_discount_type_volume").on("click", function() {
            $('.cn_other').hide()
            $('.cn_volume').show()
        })


        $("#cn_discount_type_other").on("click", function() {
            $('.cn_volume').hide()
            $('.cn_other').show()
        })
    })

    function getCustomerList() {

        $.ajax({
            "url": "<?= base_url() ?>Web_api/getVendorList/",
            "type": "GET",
            "dataType": "json",
            "data": {
                "used_type": "buyer"
            },
            "async": false,
            "success": function(data) {

                for( i in data.result) {
                    let a = '<option value="' + data.result[i].vendor_id + '">' + data.result[i].vendor_name + ' | '+data.result[i].vendor_code+'</option>';
                    $("#cn_customerList").append(a)
                }
            },
            "error": function() {
                toastr.error("Failed to get Customer List")
            }
        })
    }

    function getDropdownItems(type = '', id = '') {

        $.ajax({
            "url": "<?= base_url() ?>admin/DropDownItems/getItems/",
            "type": "GET",
            "data": {
                "type": type
            },
            "dataType": "json",
            "async": false,
            "success": function(data) {

                $.each(data, function(i, d) { // loop through data returned from ajax
                    var a = '<option value="' + data[i].name + '">' + data[i].name + '</option>';
                    $("#" + id).append(a)
                })

            },
            "error": function() {
                toastr.error("Failed to get Tax List")
            }
        })
    }

    function getNetPeriodSales() {
        var vendor_id = parseInt($("#cn_customerList").val())
        var category = $("#cn_volume_input_category").val()
        var from_date = $("#cn_from_date").val()
        var to_date = $("#cn_to_date").val()
        var fields_required = ''

        fields_required += checkNull(vendor_id, "Vendor Id, ")
        fields_required += checkNull(from_date, "From date, ")
        fields_required += checkNull(to_date, "To date, ")
        fields_required += checkNull(category, "category ")

        if (fields_required != '') {
            toastr.error("Fields Required: " + fields_required)
            return false
        }

        if (isNaN(vendor_id) || vendor_id <= 0) {
            toastr.error("Please Select a Vendor")
            return false
        }

        var data = {
            "vendor_id": vendor_id,
            "from_date": from_date,
            "to_date": to_date,
            "category": category
        }

        $.ajax({
            "url": "<?= base_url() ?>admin/Discounts/getPeriodNetSales",
            "data": data,
            "method": "GET",
            "dataType": "json",
            "success": function(data) {

                if(data.status == 2){
                    toastr.error("A Discount already exists for this period")
                    return false
                }

                if (data.status != 1) {
                    toastr.error("Failed to get Sales Data")
                    return false
                }

                $("#cn_volume_qty_td").text(data.result.total_quantity)
                $("#cn_volume_amount_td").text(data.result.net_amount)
            }
        })
    }

    function getNetOtherSales(btn) {

        var vendor_id = parseInt($("#cn_customerList").val())
        var category = $(btn).closest("tr").find(".cn_other_input_category").val()
        var invoice_no = $(btn).closest("tr").find(".cn_other_invoice_no").val()

        var fields_required = ''

        fields_required += checkNull(vendor_id, "Vendor Id, ")
        fields_required += checkNull(category, "Category, ")
        fields_required += checkNull(invoice_no, "Invoice No, ")

        if (fields_required != '') {
            toastr.error("Fields Required: " + fields_required)
            return false
        }

        if (isNaN(vendor_id) || vendor_id <= 0) {
            toastr.error("Please Select a Vendor")
            return false
        }

        var data = {
            "vendor_id": vendor_id,
            "invoice_no": invoice_no,
            "category": category
        }

        $.ajax({
            "url": "<?= base_url() ?>admin/Discounts/getNetInvoiceSales",
            "data": data,
            "method": "GET",
            "dataType": "json",
            "success": function(data) {

                if(data.status == 2){
                    toastr.error("A Discount already exists for this Invoice")
                    return false
                }

                if (data.status != 1) {
                    toastr.error(data.message)
                    return false
                }
                console.log(data.result.total_quantity)
                $(btn).closest("tr").find(".cn_other_qty_td").text(data.result.total_quantity)
                $(btn).closest("tr").find(".cn_other_net_amount_td").text(data.result.net_amount.toFixed(2))
                $(btn).closest("tr").find(".cn_other_invoice_id").val(data.result.invoice_id)

            }
        })
    }

    function getNetDiscount() {
        $("#cn_volume_net_disc").text('')
        $("#cn_volume_total_disc").text('')
        $("#cn_volume_disc_tax").text('')

        let discount = parseFloat($("#cn_volume_discount").val())
        let tax_type = $("#cn_tax_type").val()
        let discount_mode = $("#cn_volume_disc_mode").val()
        let total_amount = parseFloat($("#cn_volume_amount_td").text())
        let discount_amount = 0
        let net_discount = 0
        let discount_tax = 0
        var fields_required = ''

        fields_required += checkNull(discount, "discount, ")
        fields_required += checkNull(tax_type, "tax type, ")

        if (fields_required != '') {
            toastr.error("Fields Required: " + fields_required)
            return false
        }

        if (discount_mode == 'percent') {

            if (discount > 100) {
                toastr.error("Discount Should not be greater than 100%")
                return false
            }
            discount_amount = total_amount * discount / 100
        } else {

            if (discount > total_amount) {
                toastr.error("Discount Should not be greater than Total Amount")
                return false
            }
            discount_amount = discount
        }

        if (tax_type == 'NO TAX') {
            net_discount = discount_amount
            discount_tax = 0
        }

        if (tax_type == 'TAX INCLUSIVE') {
            net_discount = discount_amount / 1.18
            discount_tax = discount_amount - net_discount
        }

        if (tax_type == 'TAX EXCLUSIVE') {
            net_discount = discount_amount
            discount_tax = net_discount * 0.18
        }
        let total_disc_amount = net_discount + discount_tax
        $("#cn_volume_net_disc").text(net_discount.toFixed(2))
        $("#cn_volume_total_disc").text(total_disc_amount.toFixed(2))
        $("#cn_volume_disc_tax").text(discount_tax.toFixed(2))
    }

    function getNetDiscountOther(btn) {
        $(btn).closest("tr").find(".cn_other_net_disc").text('')
        $(btn).closest("tr").find(".cn_other_total_disc").text('')
        $(btn).closest("tr").find(".cn_other_disc_tax").text('')

        let discount = parseFloat($(btn).closest("tr").find(".cn_other_discount").val())
        let discount_mode = $(btn).closest("tr").find(".cn_other_disc_mode").val()
        let total_amount = parseFloat($(btn).closest("tr").find(".cn_other_net_amount_td").text())
        let tax_type = $("#cn_tax_type").val()
        let discount_amount = 0
        let net_discount = 0
        let discount_tax = 0
        var fields_required = ''

        fields_required += checkNull(discount, "discount, ")
        fields_required += checkNull(tax_type, "tax type, ")

        if (fields_required != '') {
            toastr.error("Fields Required: " + fields_required)
            return false
        }

        if (discount_mode == 'percent') {

            if (discount > 100) {
                toastr.error("Discount Should not be greater than 100%")
                return false
            }
            discount_amount = total_amount * discount / 100
        } else {

            if (discount > total_amount) {
                toastr.error("Discount Should not be greater than Total Amount")
                return false
            }
            discount_amount = discount
        }

        if (tax_type == 'NO TAX') {
            net_discount = discount_amount
            discount_tax = 0
        }

        if (tax_type == 'TAX INCLUSIVE') {
            net_discount = discount_amount / 1.18
            discount_tax = discount_amount - net_discount
        }

        if (tax_type == 'TAX EXCLUSIVE') {
            net_discount = discount_amount
            discount_tax = net_discount * 0.18
        }
        let total_disc_amount = net_discount + discount_tax
        $(btn).closest("tr").find(".cn_other_net_disc").text(net_discount.toFixed(2))
        $(btn).closest("tr").find(".cn_other_total_disc").text(total_disc_amount.toFixed(2))
        $(btn).closest("tr").find(".cn_other_disc_tax").text(discount_tax.toFixed(2))
    }

    function submitCreditnote() {
        var vendor_id = parseInt($("#cn_customerList").val())
        var category = $("#cn_volume_input_category").val()
        var from_date = $("#cn_from_date").val()
        var to_date = $("#cn_to_date").val()
        var creditnote_type = $("input[name='discount_type']:checked").val()
        var cn_date = $("#cn_date").val()

        let volume_discount = parseFloat($("#cn_volume_discount").val())
        let tax_type = $("#cn_tax_type").val()
        let volume_discount_mode = $("#cn_volume_disc_mode").val()

        let volume_total_amount = parseFloat($("#cn_volume_amount_td").text())
        let volume_net_discount = $("#cn_volume_net_disc").text()
        let volume_total_discount = $("#cn_volume_total_disc").text()
        let volume_discount_tax = $("#cn_volume_disc_tax").text()
        let volume_total_quantity = $("#cn_volume_qty_td").text()

        let other_purpose = $("#cn_purpose").val()

        let data = []
        let other_rows = []
        let volume_row = []
        let fields_required = ''

        if (creditnote_type != 'VOLUME' && creditnote_type != 'OTHER') {
            toastr.error("Select Credit note type")
            return false
        }

        fields_required += checkNull(cn_date, "Creditnote Date, ")

        if (creditnote_type == 'VOLUME') {

            fields_required += checkNull(vendor_id, 'vendor_id, ')
            fields_required += checkNull(volume_discount, 'Discount, ')
            fields_required += checkNull(tax_type, 'Tax Type, ')
            fields_required += checkNull(volume_total_amount, 'Total Amount, ')
            fields_required += checkNull(volume_net_discount, 'Net Discount, ')
            fields_required += checkNull(volume_total_discount, 'Total Discount, ')
            fields_required += checkNull(volume_discount_tax, 'Discount Tax, ')
        }

        if (creditnote_type == 'OTHER') {
            fields_required += checkNull(vendor_id, 'vendor, ')
            fields_required += checkNull(tax_type, 'Tax Type, ')
            fields_required += checkNull(other_purpose, 'Purpose, ')
        }

        if (fields_required != '') {
            toastr.error("Fields Required: " + fields_required)
            return false
        }

        if (creditnote_type == 'OTHER') {
            $(".cn_other_disc_rows").each(function(i, v) {

                let invoice_id = parseInt($(this).find(".cn_other_invoice_id").val())

                if (invoice_id > 0) {
                    let discount_value = $(this).find(".cn_other_discount").val()
                    let discount_type = $(this).find(".cn_other_disc_mode").val()
                    let discount_tax = $(this).find(".cn_other_disc_tax").text()
                    let net_discount_amount = $(this).find(".cn_other_net_disc").text()
                    let total_discount_amount = $(this).find(".cn_other_total_disc").text()
                    let category = $(this).find(".cn_other_input_category").val()
                    let row = {
                        "invoice_id": invoice_id,
                        "discount_value": discount_value,
                        "discount_type": discount_type,
                        "discount_tax": discount_tax,
                        "net_discount_amount": net_discount_amount,
                        "total_discount_amount": total_discount_amount,
                        "category": category,
                        "tax_type": tax_type,
                        "purpose": other_purpose,
                    }

                    other_rows.push(row)
                }

            })
        }

        if (creditnote_type == 'VOLUME') {
            volume_row = {
                "category": category,
                "from_date": from_date,
                "to_date": to_date,
                "tax_type": tax_type,
                "discount_value": volume_discount,
                "discount_type": volume_discount_mode,
                "discount_tax": volume_discount_tax,
                "net_discount_amount": volume_net_discount,
                "total_discount_amount": volume_total_discount,
                "total_amount": volume_total_amount,
                "total_quantity": volume_total_quantity,
            }
        }

        data = {
            "vendor_id": vendor_id,
            "creditnote_type": creditnote_type,
            "cn_date": cn_date,
            "other_rows": other_rows,
            "volume_rows": volume_row
        }

        let jsonObject = JSON.stringify(data)
        $.ajax({
            "url": "<?= base_url() ?>admin/Discounts/submitCreditNote",
            "method": "POST",
            "dataType": "json",
            "data": jsonObject,
            "success": function(data) {

                if (data.status != 1) {
                    toastr.error("Failed to Create Credit Note")
                    return false
                }

                toastr.success("Creditnote Created Successfully")
                window.location.replace("<?=base_url()?>admin/Discounts/manage_discounts")
            },
            "error": function(data) {
                toastr.error("Failed to Create Credit Note")
                return false
            }
        })
    }
</script>