<style>
    td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
        font-size: 0px;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
    }

    tr {
        height: 30px;
    }

    #EcomInvoiceList_table {
        all: unset;
    }

    EcomInvoiceList_table th,
    td {
        white-space: nowrap;
    }

    .creditnote_discount_id_cls {
        font-size: 0px;
    }
</style>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://unpkg.com/jspdf-autotable@3.5.23/dist/jspdf.plugin.autotable.js"></script>
<!-- <div class="btn-group btn-toolbar" data-toggle="buttons">
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="invoice_button_pending">FINANCE PENDING
    </label>
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="invoice_button_approved">FINANCE APPROVED
    </label>
</div> -->
<p style="line-height:10px;"></p>
<div style="overflow-x: auto;">
    <table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="creditnoteListTable">
        <thead>
            <tr>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>CREDITNOTE NO</th>
                <th>VENDOR <br> NAME</th>
                <th>INVOICE<br>NO</th>
                <th>FROM<br>DATE</th>
                <th>TO<br>DATE</th>
                <th>CREDITNOTE <br>TYPE</th>
                <th>CATEGORY</th>
                <th>PURPOSE</th>
                <th>TAX TYPE</th>
                <th>DISCOUNT <br> AMOUNT</th>
                <th>TAX<br> AMOUNT</th>
                <th>TOTAL<br> AMOUNT</th>
                <th>CREATION <br> DATE</th>
                <th>CREATED BY</th>
                <th>LAST <br>UPDATED BY</th>
                <th>LAST UPDATED<br> DATE</th>
            </tr>
        </thead>
    </table>
</div>


<script>
    var department_id = getUserdata('department_id')

    function getUserdata(attribute) {

        var a = '';
        $.ajax({
            "url": "<?= base_url() ?>Web_api/getUserData/" + attribute,
            "type": "GET",
            "dataType": "json",
            "async": false,
            "success": function(data) {
                a = data.result;
            }
        })
        return a;
    }

    $(document).ready(function() {

        function getCreditnoteList(status) {
            credinote_table = $('#creditnoteListTable').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "aaSorting": [],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Discounts/getCreditnoteList",
                    "type": "GET",
                    "data": {
                        "status": status
                    },
                    "dataSrc": "data",
                    "async": false,
                },
                "columns": [{
                        "className": "creditnote_discount_id_cls",
                        "data": "creditnote_discounts_id",
                    },
                    {
                        "data": function(data) {
                            let a = ''
                            // if (data.status == 'FINANCE_PENDING') {
                            //     if (department_id == 6) {
                            //         a += '&nbsp;&nbsp;<a href="<?php //base_url() ?>admin/Discounts/updateCreditnoteForm/' + data.creditnote_discounts_id + '">'
                            //         a += '<span class= "fa fa-edit"></span></a>'
                            //     }
                            // }
                            //pdf icon on click call downloadPDF function
                            a += '&nbsp;&nbsp;<a href="javascript:void(0)" class="fa fa-file-pdf-o" onclick="downloadPDF(' + data.creditnote_discounts_id + ')">'
                            return a
                        }
                    },
                    {
                        "data": "creditnote_discount_no",
                    },
                    {
                        "data": "vendor_name"
                    },
                    {
                        "data": "invoice_code"
                    },
                    {
                        "data": "from_date"
                    },
                    {
                        "data": "to_date"
                    },
                    {
                        "data": "creditnote_type"
                    },
                    {
                        "data": "category"
                    },
                    {
                        "data": "purpose"
                    },
                    {
                        "data": "tax_type"
                    },
                    {
                        "data": "net_discount_amount"
                    },
                    {
                        "data": "discount_tax"
                    },
                    {
                        "data": "total_discount"
                    },
                    {
                        "data": "creation_date"
                    },
                    {
                        "data": "created_by"
                    },
                    {
                        "data": "last_updated_by"
                    },
                    {
                        "data": "last_update_date"
                    },

                ]
            });


        }

        getCreditnoteList('FINANCE_PENDING')

        $('#invoice_button_pending').change(function() {
            getCreditnoteList('FINANCE_PENDING')
        });

        $('#invoice_button_approved').change(function() {
            getCreditnoteList('FINANCE_APPROVED')
        });
    })

    function downloadPDF(creditnote_id = 0) {

        if (creditnote_id <= 0) {
            alert('Please select a creditnote')
            return false
        }

        $.ajax({
            url: "<?= base_url() ?>admin/Discounts/getpdfDetails",
            type: "GET",
            data: {
                discount_id: creditnote_id
            },
            dataType: "json",
            success: function(response) {
                if (response.status == 1) {
                    createPDF(response.data)
                } else {
                    toastr.error("Failed to Generate PDF")
                }
            }
        });

    }


    function createPDF(data) {
        window.jsPDF = window.jspdf.jsPDF;
        var doc = new jsPDF();
        doc.setFontSize(15);
        var y = 5;
        //font color to #ddd
        doc.setTextColor(60, 60, 60);
        //Left side image, middle title and right side text
        doc.addImage('<?= base_url() ?>assets/img/logo_invoice.png', 'PNG', 10, y, 40, 15);
        //set Bold
        doc.setFont("Helvetica", "bold");
        doc.text('CREDIT NOTE', 80, 15);
        doc.setFontSize(10);
        //doc.text('Date: ' + new Date().toLocaleString(), 160, 5);
        doc.setFontSize(7);
        //y = y + image height + 10
        y = y + 15 + 5
        doc.text('Customer Details', 10, y);
        doc.setFont("Helvetica", "normal");
        doc.text(data.vendor_name, 10, y = y + 3);
        doc.text(data.vendor_address, 10, y = y + 3);
        doc.text(data.city, 10, y = y + 3);
        doc.text(data.state_name, 10, y = y + 3);
        doc.text('INDIA ' + data.pincode, 10, y = y + 3);
        if (data.vendor_gstin != '') {
            doc.text('GSTIN: ' + data.vendor_gstin, 10, y = y + 3);
        }

        y = 25
        x = 140
        doc.text('GSTIN', x, y);
        doc.line(x, y = y + 1, x + 30, y);
        y = y + 3
        doc.text('Creditnote No', x, y);
        doc.line(x, y = y + 1, x + 30, y);
        y = y + 3
        doc.text('Creditnote Date', x, y);
        doc.line(x, y = y + 1, x + 30, y);
        y = y + 3

        doc.text('Place of Supply', x, y);
        doc.line(x, y = y + 1, x + 30, y);
        y = y + 3
        doc.text('HSN Code', x, y);
        doc.line(x, y = y + 1, x + 30, y);
        y = y + 3
        doc.text('Currency', x, y);
        doc.line(x, y = y + 1, x + 30, y);


        x = x + 31
        y = 25;
        doc.text('36AASCS2801C1ZI', x, y);
        doc.line(x, y = y + 1, x + 30, y);
        y = y + 3
        doc.text(data.creditnote_discount_no, x, y);
        doc.line(x, y = y + 1, x + 30, y);
        y = y + 3
        doc.text(data.creation_date, x, y);
        doc.line(x, y = y + 1, x + 30, y);
        y = y + 3
        doc.text(data.state_gst_id + ' - ' + data.state_name, x, y);
        doc.line(x, y = y + 1, x + 30, y);
        y = y + 3
        doc.text('851712', x, y);
        doc.line(x, y = y + 1, x + 30, y);
        y = y + 3
        doc.text('INR', x, y);
        doc.line(x, y = y + 1, x + 30, y);

        if (data.gst_type == 'IGST') {
            var tax_breakup = 'IGST ' + data.discount_tax
        } else {
            var tax_breakup = 'CGST ' + (data.discount_tax / 2).toFixed(2) + ' | SGST ' + (data.discount_tax / 2).toFixed(2)
        }

        if (data.tax_type == 'NO TAX') {
            tax_breakup = ''
        }

        y = y + 10
        //create table
        doc.autoTable({
            startY: y,
            margin: {
                top: y,
                left: 10,
                right: 10,
                bottom: 25
            },
            head: [
                ['Product Name', 'Discount\nType', 'Discount\nAmount', 'Tax Rate', 'Tax\nAmount']
            ],
            body: [
                [data.product_name, data.creditnote_type, data.net_discount_amount, data.tax_rate + '%', data.discount_tax],
            ],
            foot: [
                ['Net Value', '', data.total_discount, '', data.discount_tax],
                [{
                    content: data.amount_in_words,
                    colSpan: 2
                }, '', {
                    content: (data.tax_type == 'NO TAX') ? '' : 'Tax-Breakup ' + tax_breakup,
                    colSpan: 2
                }]
            ],
            theme: 'plain',
            styles: {
                overflow: 'linebreak',
                fontSize: 8,
                rowHeight: 10,
                font: "helvetica",
                fontStyle: "normal",
                overflowColumns: false,
                columnWidth: 'wrap'
            },
            footStyles: {
                fontSize: 8,
                rowHeight: 10,
                font: "helvetica",
                fontStyle: "bold",
                overflowColumns: false,
                columnWidth: 'wrap',

            },
            columnStyles: {
                0: {
                    columnWidth: 'auto'
                },
                1: {
                    columnWidth: 'auto'
                },
                2: {
                    columnWidth: 'auto'
                },
                3: {
                    columnWidth: 'auto'
                },
                4: {
                    columnWidth: 'auto'
                },
                5: {
                    columnWidth: 'auto'
                },
            },
            headStyles: {
                fillColor: [255, 255, 255],
                textColor: [0, 0, 0],
                fontStyle: 'bold',
                fontSize: 8,
                font: "helvetica",
                rowHeight: 10,
            },
            bodyStyles: {
                fillColor: [255, 255, 255],
                textColor: [0, 0, 0],
                fontSize: 8,
                rowHeight: 10,
                font: "helvetica",
                overflow: 'linebreak',
                columnWidth: 'wrap'
            },
            showFoot: 'lastPage',
            willDrawCell: function(data) {
                // `data` - object containing the information of your cell, defined in jspdf.autoTable.defaults
                //
                doc.setDrawColor(120, 120, 120)
                doc.setLineWidth(.5);
                if (data.section === 'head') {

                    doc.line(data.cell.x, data.cell.y, data.cell.x + data.cell.width, data.cell.y);
                    switch (data.column.index) {
                        //make the side border of the table invisible
                        case 0:
                            data.cell.styles.halign = 'left';

                            break;
                        case 1:
                            data.cell.styles.halign = 'left';
                            break;
                        case 2:
                            data.cell.styles.halign = 'right';
                            break;
                        case 3:
                            data.cell.styles.halign = 'right';
                            break;
                        case 4:
                            data.cell.styles.halign = 'right';
                            break;

                    }
                }

                //if row == 0
                if (data.section === 'body') {
                    if (data.row.index === 0) {
                        doc.line(data.cell.x, data.cell.y, data.cell.x + data.cell.width, data.cell.y);

                    }
                }

                doc.line(data.cell.x, data.cell.y + data.row.height, data.cell.x + data.cell.width, data.cell.y + data.row.height);

                if (data.section === 'body') {
                    switch (data.column.index) {
                        //make the side border of the table invisible
                        case 0:
                            data.cell.styles.halign = 'left';
                            break;
                        case 1:
                            data.cell.styles.halign = 'left';
                            break;
                        case 2:
                            data.cell.styles.halign = 'right';
                            break;
                        case 3:
                            data.cell.styles.halign = 'right';
                            break;
                        case 4:
                            data.cell.styles.halign = 'right';
                            break;

                    }
                }
                if (data.section === 'foot') {
                    switch (data.column.index) {
                        //make the side border of the table invisible
                        case 0:
                            data.cell.styles.halign = 'left';

                            break;
                        case 2:
                            data.cell.styles.halign = 'right';
                            break;
                        case 3:
                            data.cell.styles.halign = 'right';
                            break;
                        case 4:
                            data.cell.styles.halign = 'right';
                            break;

                    }
                }
            }
        })

        //get table height
        var tableHeight = doc.previousAutoTable.finalY;
        y = tableHeight + 10;
        //set Font Bold
        doc.setFont("Helvetica", "bold");
        doc.setFontSize(8);
        x = 159
        doc.text('For Solyd Ventures (P) Ltd.', x, y);
        doc.setFont("Helvetica", "normal");
        sign_y = y + 30
        doc.text('Authorised Signature', x, sign_y);

        x = 15
        doc.setFont("Helvetica", "bold");
        doc.text('Notes:', x, y);
        doc.setFont("Helvetica", "normal");
        doc.setFontSize(8);
        if (data.creditnote_type == 'VOLUME') {
            doc.text('Period: ' + data.from_date + ' To ' + data.to_date, x, y = y + 5);
            doc.text('Creditnote Date: ' + data.cn_date, x, y = y + 5);
        } else {
            doc.text('Invoice No: ' + data.invoice_code, x, y = y + 5);
            doc.text('Creditnote Date: ' + data.cn_date, x, y = y + 5);
            doc.text('Purpose: ' + data.purpose, x, y = y + 5);
        }


        //Add Footer

        doc.setFont("Helvetica", "normal");
        doc.setFontSize(7);
        for (var i = 1; i <= doc.internal.getNumberOfPages(); i++) {
            //Align Center
            doc.setPage(i);

            var pageSize = doc.internal.pageSize;
            var pageHeight = pageSize.height ?
                pageSize.height :
                pageSize.getHeight();

            doc.setDrawColor(120, 120, 120)
            doc.setLineWidth(.5);
            doc.line(10, pageHeight - 20, 200, pageHeight - 20);
            doc.text("SLOYD VENTURES (P) LTD, 1-11-251/19A. 4th Floor, Jayalakshmi Towers, Motilal Nehru Nagar, Begumpet, Hyderabad, Telangana, 500016, IN. \n|| CIN: U52390TG2012PTC083950 | PAN: AASCS2801C | Tel: +91-40-27900059 | Email: accounts@sloyd.in | web: www.ynew.in ||",
                25,
                pageHeight - 17
            );
            doc.text("Page " + doc.internal.getCurrentPageInfo().pageNumber + " of " + doc.internal.getNumberOfPages(),
                pageSize.width / 2,
                pageHeight - 5
            );
        }


        window.open(doc.output('bloburl', 'discounts.pdf'));
        return false
    }
</script>