<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;">

    <div class="col-md-5  col-sm-5 col-xs-5" style="padding:0px">

        <div class="form-group">
            <label class="col-lg-3 control-label">Physical Device</label>
            <div class="col-lg-8">
                <select id="new_physical_device" class="form-control select_box" style="width: 100%;" onchange="getCustomerName()">
                    <option value="present">Present</option>
                    <option value="notpresent">Not Present</option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Invoice No</label>
            <div class="col-lg-8">
                <select id="new_invoice_no" class="form-control select_box" style="width: 100%;" onchange="getCustomerName()">
                    <option value="">Select Invoice</option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Device ID</label>
            <div class="col-lg-8">
                <input type="text" id="new_device_id" class="form-control" style="width: 100%;" onchange="getDeviceDetails()">
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Escalation Type</label>
            <div class="col-lg-8">
                <select id="new_escalation_type" class="form-control select_box" style="width: 100%;">
                    <option value="">Select Escalation Type</option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Device Damage Issue</label>
            <div class="col-lg-8">
                <select id="new_damage_issue" class="form-control select_box" style="width: 100%;">
                    <option value="">Select Device Damage Issue</option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Customer Remarks</label>
            <div class="col-lg-8">
                <textarea class="form-control" id="new_customer_remarks"></textarea>
            </div>
        </div>

    </div>

    <div class="col-md-5  col-sm-5 col-xs-5" style="padding:0px">

        <div class="form-group">
            <label class="col-lg-3 control-label">Customer Name</label>
            <div class="col-lg-8">
                <input type="text" id="new_customer_name" class="form-control" readonly>
            </div>
        </div>
        <div class="form-group">
            <label class="col-lg-3 control-label">Device Name</label>
            <div class="col-lg-8">
                <input type="text" id="new_device_name" class="form-control" readonly>
            </div>
        </div>
        <div class="form-group">
            <label class="col-lg-3 control-label">Grade</label>
            <div class="col-lg-8">
                <input type="text" id="new_device_grade" class="form-control" readonly>
            </div>
        </div>
        <div class="form-group">
            <label class="col-lg-3 control-label">IMEI1 No</label>
            <div class="col-lg-8">
                <input type="text" id="new_imei1" class="form-control" readonly>
            </div>
        </div>
        <div class="form-group">
            <label class="col-lg-3 control-label">IMEI2 No</label>
            <div class="col-lg-8">
                <input type="text" id="new_imei2" class="form-control" readonly>
            </div>
        </div>
        <div class="form-group">
            <label class="col-lg-3 control-label">Certification Remarks</label>
            <div class="col-lg-8">
                <textarea type="date" id="new_certifications_remarks" class="form-control" readonly></textarea>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Triage Remarks</label>
            <div class="col-lg-8">
                <textarea type="text" id="new_triage_remarks" class="form-control" readonly></textarea>
            </div>
        </div>
    </div>

</div>

<br>
<div class="form-group" style="text-align:center;">
    <button type="button" class="btn btn-primary" id="new_submit" onclick="createNewEscalation()">SUBMIT</button>
    &nbsp;&nbsp;<button type="button" class="btn btn-grey" onclick="window.location.replace('<?= base_url() ?>admin/Customer_escalation/manage_claims')">BACK</button>
</div>

<script>
    getInvoiceList()
    getDropdownList('DEVICE_DAMAGE_ISSUE', 'new_damage_issue')
    getDropdownList('ESCALATION_TYPE', 'new_escalation_type')

    function checkNull(entity, message) {

        if (entity == 0 || entity == '' || entity == null || entity == '0' || entity == 'NaN') {
            return message
        } else {
            return ''
        }
    }

    function getCustomerName(){
        let invoice_text = $("#new_invoice_no option:selected").text()
        let invoice_arr = invoice_text.split("/")
        let customer_name = invoice_arr[1]

        $("#new_customer_name").val(customer_name)
    }

    function getDeviceDetails() {

        $("#new_device_name").val("")
        $("#new_device_grade").val("")
        $("#new_certifications_remarks").val("")
        $("#new_triage_remarks").val("")
        $("#new_imei1").val("")
        $("#new_imei2").val("")

        let invoice_id = $("#new_invoice_no").val()
        let device_id = $("#new_device_id").val()
        let required_fields = ''
        required_fields += checkNull(invoice_id, 'Invoice ID')
        required_fields += checkNull(device_id, 'Device ID')
        if (required_fields != '') {
            return false
        }

        $.ajax({
            "url": "<?= base_url() ?>admin/Customer_escalation/getDeviceDetails",
            "type": "GET",
            "data": {
                "invoice_id": invoice_id,
                "device_id": device_id
            },
            "dataType": "json",
            "success": function(data) {
                if (data.status == 2) {
                    toastr.error("Escalation Already raised for this device")
                    return false
                }
                if (data.status != 1) {
                    toastr.error("Invalid Device / Device not belong to Selected Invoice")
                    return false
                }
                var result = data.result

                $("#new_device_name").val(result.device_name)
                $("#new_device_grade").val(result.grade)
                $("#new_certifications_remarks").val(result.certification_remarks)
                $("#new_triage_remarks").val(result.triage_remarks)
                $("#new_imei1").val(result.imei_1)
                $("#new_imei2").val(result.imei_2)
            }
        })
    }

    function createNewEscalation() {

        let invoice_text = $("#new_invoice_no option:selected").text()
        let invoice_arr = invoice_text.split("/")
        var invoice_no = invoice_arr[0]

        var device_id = $("#new_device_id").val()
        var device_grade = $("#new_device_grade").val()
        var certification_remarks = $("#new_certifications_remarks").val()
        var triage_remarks = $("#new_triage_remarks").val()
        var escalation_type = $("#new_escalation_type").val()
        var damage_device_issue = $("#new_damage_issue").val()
        var customer_remarks = $("#new_customer_remarks").val()
        var physical_device = $("#new_physical_device").val()
        var fileds_required = ''
        var data = []

        fileds_required += checkNull(invoice_no, "Invoice No ")
        fileds_required += checkNull(device_id, "Device Id, ")
        fileds_required += checkNull(customer_remarks, "Customer Remarks ")
        fileds_required += checkNull(damage_device_issue, "Device Damage Issue, ")
        fileds_required += checkNull(escalation_type, "Escalation Type ")
        fileds_required += checkNull(physical_device, "Physical Device ")

        if (fileds_required != '') {
            alert("Fields Required: " + fileds_required)
            return false
        }

        data = {
            "invoice_no": invoice_no,
            "device_id": device_id,
            "escalation_type": escalation_type,
            "device_grade":device_grade,
            "damage_device_issue": damage_device_issue,
            "customer_remarks": customer_remarks,
            "certification_remarks": certification_remarks,
            "triage_remarks": triage_remarks,
            "physical_device": physical_device
        }
        var jsonObject = JSON.stringify(data)
        $("#new_submit").attr("disabled", true)

        $.ajax({
            "url": "<?= base_url() ?>admin/Customer_escalation/createNewEscalation",
            "type": "POST",
            "data": jsonObject,
            "dataType": "json",
            "success": function(data) {

                if (data.status != 1) {

                    $("#new_submit").attr("disabled", false)
                    toastr.error("Failed to create Escalation")
                    return false
                }
                window.location.replace("<?= base_url() ?>admin/Customer_escalation/manage_customer_escalation")
            },
            "error": function(data) {
                $("#new_submit").attr("disabled", false)
                toastr.error("Failed to create Escalation")
                return false
            }
        })
    }

    function getInvoiceList() {

        $.ajax({
            "url": "<?= base_url() ?>admin/Yieldreports/getInvoiceList",
            "type": "GET",
            "dataType": "json",
            "success": function(data) {

                if (data.status != '1') {
                    return false
                }

                $.each(data.result, function(i, v) {
                    var option = '<option value="' + data.result[i].invoice_id + '">'
                    option += data.result[i].invoice_code + ' / ' + data.result[i].vendor_name + '</option>'

                    $("#new_invoice_no").append(option)
                })
            },
            "error": function(data) {
                toast.error("Failed to get Invoice List")
            }
        })
    }

    function getDropdownList(type = '', item_id = '') {

        var opt = ''
        if (type == '' || item_id == '') {
            return false
        }
        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>admin/DropDownItems/getItems",
            data: {
                'type': type
            },
            dataType: "json",
            async: false,
            success: function(data) {
                $.each(data, function(i, v) {
                    opt += '<option value="' + data[i].name + '">' + data[i].name + '</option>'
                })
            },
            error: function(error) {
                alert(error.responseJSON.message);
            }

        });
        $("#" + item_id).append(opt);
    }
</script>