<style>
    tr {
        height: 30px;
    }

    th,
    td {
        white-space: nowrap;
    }


    td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
        background-position-x: left;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
        background-position-x: left;
    }

    td.customer_escl_id {
        font-size: 0;
    }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="button_open">OPEN
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="button_inprogress">IN PROGRESS
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="button_resolved">RESOLVED
    </label>

</div>

<p style="line-height:10px;"></p>
<div class="table-responsive scrolledTable">
    <table class="table table-striped DataTables" style="margin-left:5px;" id="escalationList_table">
        <thead>
            <tr>
                <th>&nbsp;</th>
                <th></th>
                <th>ESCALATION NO</th>
                <th>INVOICE NO</th>
                <th>Customer Name</th>
                <th>DEVICE ID</th>
                <th>DEVICE VARIANT</th>
                <th>GRADE</th>
                <th>Escalation Type</th>
                <th>ISSUE TYPE</th>
                <th>ASSIGNED TO </th>
                <th>CREATED BY</th>
                <th>LAST UPDATED BY</th>
                <th>CREATION<br> DATE</th>
                <th>LAST UPDATE<br> DATE</th>
            </tr>
        </thead>
    </table>
</div>

<script>
    var department_id = getUserdata('department_id')

    function getUserdata(attribute) {

        var a = '';
        $.ajax({
            "url": "<?= base_url() ?>Web_api/getUserData/" + attribute,
            "type": "GET",
            "dataType": "json",
            "async": false,
            "success": function(data) {
                a = data.result;
            }
        })
        return a;
    }

    $(document).ready(function() {

        escalationList('OPEN')

        function escalationList(status) {

            escalationslist_table = $('#escalationList_table').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "scrollY": 390,
                "scrollX": true,
                "scrollCollapse": true,
                //"autoWidth": false,
                "aaSorting": [],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Customer_escalation/getEscalationList",
                    "data": {
                        "status": status
                    },
                    "type": "GET",
                    "dataSrc": "data"
                },
                "columns": [{
                        "className": 'details-control customer_escl_id',
                        "data": "customer_escl_id"
                    },
                    {},
                    {
                        "className": "escl_no",
                        "data": "escl_no"
                    },
                    {
                        "data": "invoice_no"
                    },
                    {
                        "data": "vendor_name"
                    },
                    {
                        "data": "device_id"
                    },
                    {
                        "data": "variant"
                    },
                    {
                        "data": "device_grade"
                    },
                    {
                        "data": "escl_type"
                    },
                    {
                        "data": "device_issue_type"
                    },
                    {
                        "data": "assigned_to"
                    },
                    {
                        "data": "created_by"
                    },
                    {
                        "data": "last_updated_by"
                    },
                    {
                        "data": "creation_date"
                    },
                    {
                        "data": "last_update_date"
                    },
                ],

                "columnDefs": [{
                    "targets": 1,
                    "data": null,
                    "render": function(a, b, data, d) {

                        if (data.status == 'OPEN' || data.status == 'IN_PROGRESS') {

                            if (department_id == 17 && data.assigned_to == 'OPERATIONS') {
                                var a = '<a href="<?= base_url() ?>admin/Customer_escalation/updateOpsEscalationForm/' + data.customer_escl_id + '">'
                                a += '<img src="<?= base_url() ?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
                                a += '</a>'
                                return a
                            }
                            if (department_id == 10 && data.assigned_to == 'CERTIFICATION') {
                                var a = '<a href="<?= base_url() ?>admin/Customer_escalation/updateCertificationEscalationForm/' + data.customer_escl_id + '">'
                                a += '<img src="<?= base_url() ?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
                                a += '</a>'
                                return a
                            }if (department_id == 10 && data.assigned_to == 'TRIAGE') {
                                var a = '<a href="<?= base_url() ?>admin/Customer_escalation/updateTriageEscalationForm/' + data.customer_escl_id + '">'
                                a += '<img src="<?= base_url() ?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
                                a += '</a>'
                                return a
                            } else {
                                return null
                            }
                        } else {
                            return null
                        }
                    }
                }]
            });

        }

        $('#escalationList_table tbody').on('click', 'td.details-control', function() {

            var tr = $(this).closest('tr');
            var row = escalationslist_table.row(tr);
            if (row.child.isShown()) {

                row.child.hide();
                tr.removeClass('shown');

            } else {
                row.child(format(row.data())).show();
                tr.addClass('shown');
            }
        });

        $('#button_inprogress').change(function() {
            escalationList('IN_PROGRESS')
        });

        
        $('#button_open').change(function() {
            escalationList('OPEN')
        });

        $('#button_complete').change(function() {
            escalationList('COMPLETE')
        });

        function format(d) {
            // `d` is the original data object for the row
            var childtable = '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
            $.ajax({
                url: encodeURI("<?php echo base_url(); ?>admin/Customer_escalation/getEscalationRemarks"),
                type: "GET",
                data: {
                    "customer_escl_id": d.customer_escl_id
                },
                dataType: 'json',
                async: false,
                success: function(data) {
                    if (data.result == null) {
                        childtable += '<tr><td>No Records Found</td></tr>';
                    } else {

                        childtable += '<th>Remark Date</th><th>Department</th><th>Remarks</th><th>Remarks BY</th>'
                        $.each(data.result, function(i, d) { // loop through data returned from ajax 
                            childtable += '<tr>' +
                                '<td>' + data.result[i].date + '</td>' +
                                '<td>' + data.result[i].department + '</td>' +
                                '<td>' + data.result[i].remarks + '</td>' +
                                '<td>' + data.result[i].remarks_by + '</td>' +
                                '</tr>';
                        });
                    }
                }
            });

            childtable += '</table>';
            return childtable
        }

    })
</script>