<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;"> 
<input type="hidden" id="received_claim_id" value="<?=$receive_claims_id?>" >

    <div class="col-md-5  col-sm-5 col-xs-5" style="padding:0px">

        <div class="form-group">
            <label class="col-lg-3 control-label">Claim No.</label>
            <div class="col-lg-8">
                <input type="text" id="received_claim_no" class="form-control" readonly>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Incident No.</label>
            <div class="col-lg-8">
                <input type="text" id="received_incident_no" class="form-control" readonly>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Payment Ref. ID</label>
            <div class="col-lg-8">
                <input type="text" id="received_payment_ref_id" class="form-control" readonly>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Account No</label>
            <div class="col-lg-8">
                <select id="received_account_no" class="form-control select_box" style="width: 100%;">
                    <option value="">SELECT ACCOUNT NO</option>
                </select>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Reference No</label>
            <div class="col-lg-8">
                <input type="text" id="received_reference_no" class="form-control" >
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">AMOUNT</label>
            <div class="col-lg-8">
                <input type="text" id="received_amount" class="form-control" >
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Rceived date</label>
            <div class="col-lg-8">
                <input type="date" id="received_date" class="form-control" max="<?=date("Y-m-d")?>" >
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Remarks</label>
            <div class="col-lg-8">
                <textarea class="form-control" id="received_remarks_header"></textarea>
            </div> 
        </div>
    </div>

    <div class="col-md-5  col-sm-5 col-xs-5" style="padding:0px">

        
        <div class="form-group">
            <label class="col-lg-3 control-label">Sales Return No.</label>
            <div class="col-lg-8">
                <input type="text" id="received_salesreturn_no" class="form-control" readonly>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Customer Name</label>
            <div class="col-lg-8">
                <input type="text" id="received_customer_name" class="form-control" readonly>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Sales Channel</label>
            <div class="col-lg-8">
                <input type="text" id="received_sales_channel" class="form-control" readonly>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Sales Channel Ref. Id.</label>
            <div class="col-lg-8">
                <input type="text" id="received_saleschannel_ref_id" class="form-control" readonly>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Claim Amount</label>
            <div class="col-lg-8">
                <input type="text" id="received_claim_amount" class="form-control" readonly>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Approved Amount</label>
            <div class="col-lg-8">
                <input type="text" id="received_approved_amount" class="form-control" readonly>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Claim Date</label>
            <div class="col-lg-8">
                <input type="date" id="received_claim_date" class="form-control" readonly>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">Approved Date</label>
            <div class="col-lg-8">
                <input type="date" id="received_approved_date" class="form-control" readonly>
            </div> 
        </div>

        
    </div>

</div>
<br>

<h4>Remarks</h4>
    <table class="table table-stripped DataTables" id="received_remarks_table">
    </table>
<br>

<div class="form-group" style="text-align:center;">
    <button type="button" class="btn btn-primary" id="received_submit" onclick="receiveClaim()">SUBMIT</button>
    &nbsp;&nbsp;<button type="button" class="btn btn-grey" onclick="window.location.replace('<?=base_url()?>admin/Claims/manage_claims')">BACK</button>
</div>

<script>

    var claims_id = $("#received_claim_id").val()

    getClaimHeader()

    received_getBankAccountList()

    getRemarksUpdate();
    
    function checkNull(entity, message){

        if(entity == 0 || entity == '' || entity == null || entity == '0' || entity == 'NaN'){
        
            return message
        
        }else{
        
            return ''
        }
    }

    function getClaimHeader(){

        var check_claim_id = checkNull(claims_id, 'Claim Id')

        if(check_claim_id != ''){
            return false
        }

        $.ajax({

            "url": "<?=base_url()?>admin/Claims/getClaimHeader",
            "type": "GET",
            "data": { "claims_id": claims_id},
            "dataType": "json",
            "success": function(data){

                if(data.status != 1){

                    toastr.error("Failed to get Claims Data")
                    return false
                }

                var result = data.data

                $("#received_claim_no").val(result.claim_no)
                $("#received_payment_ref_id").val(result.payment_ref_id)
                $("#received_incident_no").val(result.incident_no)
              
                $("#received_salesreturn_no").val(result.salesreturn_no)
                $("#received_customer_name").val(result.vendor_name)
                $("#received_sales_channel").val(result.sales_channel)
                $("#received_saleschannel_ref_id").val(result.saleschannel_ref_id)
                $("#received_claim_date").val(result.claim_date)
                $("#received_claim_amount").val(result.claim_amount)
                $("#received_approved_amount").val(result.approved_amount)
                $("#received_approved_date").val(result.approved_date)
                
                
            }
        })
    }

    function receiveClaim(){

        var reference_no = $("#received_reference_no").val()
        var account_no = $("#received_account_no").val()
        var amount = $("#received_amount").val()
        var received_date = $("#received_date").val()
        var remarks = $("#received_remarks_header").val()
        var fileds_required = ''
        var data = []

        fileds_required += checkNull(reference_no, "Reference No ")
        fileds_required += checkNull(account_no, "Account No ")
        fileds_required += checkNull(amount, "Amount ")
        fileds_required += checkNull(received_date, "Received Date ")

        if(fileds_required != ''){

            alert("Fields Required: "+fileds_required)
            return false
        }

        data = {
                    "claims_id": claims_id,
                    "reference_no": reference_no,
                    "account_no": account_no,
                    "amount": amount,
                    "received_date": received_date,
                    "remarks_header": remarks
                }
        
        var jsonObject = JSON.stringify(data)

        $("#received_submit").attr("disabled", true)

        $.ajax({
            
            "url": "<?=base_url()?>admin/Claims/receiveClaim",
            "type": "POST",
            "data": jsonObject,
            "dataType": "json",
            "success": function(data){

                if(data.status != 1){
                    
                    $("#received_submit").attr("disabled", false)
                    toastr.error("Failed to Receive Claim")
                    return false
                }

                window.location.replace("<?=base_url()?>admin/Claims/manage_claims")
            },
            "error": function(data){
                
                $("#received_submit").attr("disabled", false)
                
                toastr.error("Failed to Receive Claim")
                return false
            }
        })
    }

    function getRemarksUpdate(){

        $.ajax({
            url: encodeURI("<?php echo base_url(); ?>web_api/getRemarks?id="+claims_id)+"&type=claims",
            type:"GET",
            dataType: 'json',
            success: function ( data ) {
                if(data.status==1){
                    var tableData="<thead><th>Date</th><th>By</th><th>Remark</th></thead>"
                    $.each(data.remarks,function(i,v){
                        tableData+="<tr><td>"+data.remarks[i].date+"</td><td>"+data.remarks[i].username+"</td><td>"+data.remarks[i].remark+"</td></tr>";
                    })
                    $("#received_remarks_table").append(tableData)
                }
            }
        })
    }

    function received_getBankAccountList(){

        var opt = ''

            $.ajax({
                type: "GET",
                url: "<?=base_url()?>admin/DropDownItems/getItems",
                data: {'type': 'BANK_ACCOUNTS'},
                dataType:"json",
                async: false,
                success: function(data){
                    $.each(data,function(i,v){
                        opt +='<option value="'+data[i].name+'">'+data[i].name+'</option>'
                    })
                },
                error: function(error) {
                    alert(error.responseJSON.message);
                }
                
            });
            $("#received_account_no").append(opt);
    }
</script>