<style>

	 tr { height: 30px; }
	 th, td { white-space: nowrap; }

     
	td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
        background-position-x: left;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
        background-position-x: left;
    }

    td.ff_claims_id{
        font-size: 0;
    }

   
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_ff_pending">PENDING
	</label>
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_ff_approved">FINANCE PENDING
	</label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_ff_finance_rejected">FINANCE REJECTED
    </label>

	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_ff_rejected">REJECTED
	</label>
	
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_ff_part_settled">PART SETTLED
	</label>

    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_ff_full_settled">FULL SETTLED
	</label>
	
</div>

<p style="line-height:10px;"></p>
<div class="table-responsive scrolledTable">
    <table class="table table-striped DataTables" style="margin-left:5px;" id="ff_claimsList_table">
        <thead>
            <tr>
                <th>&nbsp;</th>
                <th></th>
                <th>CLAIM NO</th>
                <th>INCIDENT NO</th>
                <th>Sales Channel</th>
                <th>STOCK TRANSFER NO</th>
                <th>Removable Id</th>
                <th>CLAIM<br> AMOUNT</th>
                <th>Approved<br> AMOUNT</th>
                <th>CLAIM DATE</th>			
                <th>Approved DATE</th>			
                <th>CREATED BY</th>
                <th>LAST UPDATED BY</th>
                <th>CREATION<br> DATE</th>
                <th>LAST UPDATE<br> DATE</th>
            </tr>
        </thead>		
    </table>
</div>

<div class="modal fade" id="modalReject" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
  aria-hidden="true" data-backdrop="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header text-center">
        <button type="button" class="close" onclick="closeModal()" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
	  </div>
	  <input type="hidden" id="finance_reject_claims_id_modal">
      <div class="modal-body mx-3">
	  <div class="form-group">
            <label class="col-lg-3 control-label">CLAIM NO</label>
            <div class="col-lg-9">
                <span class="form-control" id="finance_reject_claim_no_modal"></span>
            </div> 
		</div><br>
		<div class="form-group">
            <label class="col-lg-3 control-label">REMARKS</label>
            <div class="col-lg-9">
                <textarea class="form-control" id="finance_reject_remarks_modal"></textarea>
            </div> 
        </div>
      </div><br>
      <div class="modal-footer d-flex justify-content-center">
        <button class="btn btn-success" id="finance_reject_submit_modal" CausesValidation="False">Reject</button>
        <button class="btn btn-danger" id="finance_reject_close_modal" CausesValidation="False">Close</button>
      </div>
    </div>
  </div>
</div>
							
<script>

var service_center_list;
var department_id = getUserdata('department_id')

function getUserdata(attribute){
    
    var a='';
    $.ajax({
        "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            a = data.result;
        }
    })
    return a;
}

$(document).ready(function(){

    claimsList_FF('PENDING')

    function claimsList_FF(status){

        ff_claimslist_table = $('#ff_claimsList_table').DataTable({
                        "paging":true,
                        "destroy":true,
                        "searching":true,
                        "processing": true,
                        "serverSide": false,  
                        "scrollY": 390,
                        "scrollX": true,
                        "scrollCollapse": true,
                        //"autoWidth": false,
                        "aaSorting": [2, 'asc'],
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Claims/getFFClaimsList",
							"data": { "status": status},
							"type": "GET",
                            "dataSrc": "data"
                        },
                        "columns": [
                            {"className":'details-control ff_claims_id', "data": "claims_id"},
                            {},
                            { "className": "claim_no", "data": "claim_no", "type":"any-number"},
                            { "data": "incident_no" },	
                            { "data": "sales_channel" },	
                            { "data": "stocktransfer_no" },
                            { "data": "removable_id" },
                            { "data": "claim_amount"},
                            { "data": "approved_amount"},
                            { "data": "claim_date"},
                            { "data": "approved_date"},
                            { "data": "created_by"},
                            { "data": "last_updated_by"},
                            { "data": "creation_date"},
                            { "data": "last_update_date"},
                        ],

                        "columnDefs": [ {
                            "targets": 1,
                            "data": null,
                            "render":function(a,b,data,d){
                                console.log(data.status)
                                    if((data.status == 'PENDING' || data.status == 'FINANCE_REJECTED') && department_id == '8'){
                                       
                                        var a = '<a href="<?=base_url()?>admin/Claims/updateFFClaimForm/'+data.claims_id+'">'
                                            a += '<img src="<?=base_url()?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
                                            a += '</a>'
                                        return a

                                    }else if(data.status == 'APPROVED' && department_id == '6'){

                                        var a = ''
                                            a += '<a href="<?=base_url()?>admin/Claims/receiveFFClaimForm/'+data.claims_id+'">'
                                            a += '<img src="<?=base_url()?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
                                            a += '</a>'

                                            a += '&nbsp;&nbsp;<img src="<?=base_url()?>assets/img/cancel.png" onclick="rejectClaim(this)" alt="cancel" title="cancel" width="16px" height="16px">'
                                        
                                        return a
                                    }else{
                                        return null
                                    }
                                }
                            }
                        ]
        });

    }

    $('#ff_claimsList_table tbody').on('click', 'td.details-control', function () {
    
        var tr = $(this).closest('tr');
        var row = ff_claimslist_table.row( tr );

        if ( row.child.isShown() ) {

            row.child.hide();
            tr.removeClass('shown');

        }else {

            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    }) ;

    $('#button_ff_pending').change(function(){
        claimsList_FF('PENDING')
    });
    
    $('#button_ff_approved').change(function(){
        claimsList_FF('APPROVED')
    });
    
    $('#button_ff_rejected').change(function(){
        claimsList_FF('REJECTED')
    });

    $('#button_ff_finance_rejected').change(function(){
        claimsList_FF('FINANCE_REJECTED')
    });
    
    $('#button_ff_part_settled').change(function(){
        claimsList_FF('PART_SETTLED')
    });

    $('#button_ff_full_settled').change(function(){
        claimsList_FF('FULL_SETTLED')
    });

//Reject Code

    $(document).delegate("#finance_reject_close_modal","click", function(){
		
        $("#finance_reject_claims_id_modal").val('')
		$("#finance_reject_claim_no_modal").text('')
		$("#finance_reject_remarks_modal").val('')
		$("#modalReject").modal('hide');
	})


	$(document).delegate("#finance_reject_submit_modal","click", function(){

		var claims_id_modal = $("#finance_reject_claims_id_modal").val();
		var remarks_modal = $("#finance_reject_remarks_modal").val()
		var data= [];
		data = {
                    "claims_id": claims_id_modal,
                    "remarks_header": remarks_modal
                }
		jsonObject = JSON.stringify(data)
		$.ajax({
			url:"<?=base_url()?>admin/Claims/financeRejectClaim",
			type:"POST",
			dataType:"json",
			data: jsonObject,
			success:function (data){
				
                if(data.status==1){

					toastr.success('Claim Rejected Successfully');
					
                    $("#finance_reject_claims_id_modal").val('')
                    $("#finance_reject_claim_no_modal").text('')
                    $("#finance_reject_remarks_modal").val('')
                    $("#modalReject").modal('hide');

                    claimsList('FINANCE_REJECTED')
				
                }else{
					
                    alert('Failed to Reject the Claim');
				}
			}, error: function(data){
                    
                    alert('Failed to Reject the Claim');
            }
		})
	})


})

    function ff_remarks_table(claims_id){

        var tableData = '<br><p></p>';
            tableData += '<p style="text-align: left; margin-left: 15px; font-weight:700;">Remarks</p>';
            tableData += '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
        $.ajax({
            url:"<?php echo base_url();?>web_api/getRemarks/?id="+claims_id+"&type=ff_claims",
            type: "GET",
            dataType: 'json',
            async:false,
            success: function (data){
                if(data.status==1){
                    tableData+="<thead><th>Date</th><th>By</th><th>Remark</th></thead>"
                    $.each(data.remarks,function(i,v){
                        tableData+="<tr><td>"+data.remarks[i].date+"</td><td>"+data.remarks[i].username+"</td><td>"+data.remarks[i].remark+"</td></tr>";
                    })
                }
            }
        });
        tableData+='</table>'
        return tableData;
    }

    function receipts_table( claims_id ){
       
        var tableData = '<br><p></p>';
            tableData += '<p style="text-align: left; margin-left: 15px; font-weight:700;">Receipts</p>';
            tableData += '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
        
        $.ajax({
            url:"<?php echo base_url();?>admin/Claims/getReceipts/"+claims_id,
            type: "GET",
            dataType: 'json',
            async:false,
            success: function (data){
                if(data.status==1){
                    
                    tableData+="<thead><th>Account No</th><th>Reference No</th><th>Amount</th><th>Received Date</th></thead>"
                    
                    $.each(data.result,function(i,v){

                        tableData += "<tr>"
                        tableData += "<td>"+data.result[i].account_no+"</td>"
                        tableData += "<td>"+data.result[i].reference_no+"</td>"
                        tableData += "<td>"+data.result[i].amount+"</td>"
                        tableData += "<td>"+data.result[i].received_date+"</td>"
                        tableData += "</tr>";
                    })
                }
            }
        });
        tableData+='</table>'
        return tableData;
    }
   

    function format ( d ) {

        // `d` is the original data object for the row
       // var childtable = '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';

            //childtable += '<tr><th>Invoice No</th><th>Sales order No</th><th>Invoice Amount</th></tr>'
            
            //childtable += '<tr>'
            //childtable += '<td>'+d.claims_no+'</td>'
           // childtable += '<td>'+d.stocktransfe_no+'</td>'
           // childtable += '<td>'+d.claims_id+'</td>'
           // childtable += '</tr>'

            //childtable +='</table>';
            //childtable += receipts_table(d.claims_id)
            var childtable = ff_remarks_table(d.claims_id)

        return childtable
    }

    function rejectClaim(btn){

		var claims_id = $(btn).closest("tr").find(".claims_id").text();
		var claim_no = $(btn).closest("tr").find(".claim_no").text();
		if(claims_id > 0){
			$("#finance_reject_claims_id_modal").val(claims_id)
			$("#finance_reject_claim_no_modal").text(claim_no)
			$("#modalReject").modal('show');
		}
	}


</script>
	 
