<style>

	 tr { height: 30px; }
	 th, td { white-space: nowrap; }

     
	td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
        background-position-x: left;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
        background-position-x: left;
    }

    td.claims_id{
        font-size: 0;
    }

   
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_pending">PENDING
	</label>
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_approved">FINANCE PENDING
	</label>
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_rejected">REJECTED
	</label>
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_finance_rejected">FINANCE REJECTED
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_settled">SETTLED
	</label>
	
</div>

<p style="line-height:10px;"></p>
<div class="table-responsive scrolledTable">
    <table class="table table-striped DataTables" style="margin-left:5px;" id="claimsList_table">
        <thead>
            <tr>
                <th>&nbsp;</th>
                <th></th>
                <th>CLAIM NO</th>
                <th>INCIDENT NO</th>
                <th>Sales Channel</th>
                <th>Sales Channel <br> Ref. Id</th>
                <th>SALESRETURN NO</th>
                <th>CUSTOMER NAME</th>
                <th>CLAIM<br> AMOUNT</th>
                <th>Approved<br> AMOUNT</th>
                <th>CLAIM DATE</th>			
                <th>Approved DATE</th>			
                <th>CREATED BY</th>
                <th>LAST UPDATED BY</th>
                <th>CREATION<br> DATE</th>
                <th>LAST UPDATE<br> DATE</th>
            </tr>
        </thead>		
    </table>
</div>

<div class="modal fade" id="modalReject" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
  aria-hidden="true" data-backdrop="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header text-center">
        <button type="button" class="close" onclick="closeModal()" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
	  </div>
	  <input type="hidden" id="finance_reject_claims_id_modal">
      <div class="modal-body mx-3">
	  <div class="form-group">
            <label class="col-lg-3 control-label">CLAIM NO</label>
            <div class="col-lg-9">
                <span class="form-control" id="finance_reject_claim_no_modal"></span>
            </div> 
		</div><br>
		<div class="form-group">
            <label class="col-lg-3 control-label">REMARKS</label>
            <div class="col-lg-9">
                <textarea class="form-control" id="finance_reject_remarks_modal"></textarea>
            </div> 
        </div>
      </div><br>
      <div class="modal-footer d-flex justify-content-center">
        <button class="btn btn-success" id="finance_reject_submit_modal" CausesValidation="False">Reject</button>
        <button class="btn btn-danger" id="finance_reject_close_modal" CausesValidation="False">Close</button>
      </div>
    </div>
  </div>
</div>
							
<script>

var service_center_list;
var department_id = getUserdata('department_id')

function getUserdata(attribute){
    
    var a='';
    $.ajax({
        "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            a = data.result;
        }
    })
    return a;
}

$(document).ready(function(){

    claimsList('PENDING')

    function claimsList(status){

        claimslist_table = $('#claimsList_table').DataTable({
                        "paging":true,
                        "destroy":true,
                        "searching":true,
                        "processing": true,
                        "serverSide": false,  
                        "scrollY": 390,
                        "scrollX": true,
                        "scrollCollapse": true,
                        //"autoWidth": false,
                        "aaSorting": [2, 'asc'],
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Claims/getClaimsList",
							"data": { "status": status},
							"type": "GET",
                            "dataSrc": "data"
                        },
                        "columns": [
                            {"className":'details-control claims_id', "data": "claims_id"},
                            {},
                            { "className": "claim_no", "data": "claim_no", "type":"any-number"},
                            { "data": "incident_no" },	
                            { "data": "sales_channel" },	
                            { "data": "saleschannel_ref_id" },
                            { "data": "salesreturn_no" },
                            { "data": "vendor_name" },	
                            { "data": "claim_amount"},
                            { "data": "approved_amount"},
                            { "data": "claim_date"},
                            { "data": "approved_date"},
                            { "data": "created_by"},
                            { "data": "last_updated_by"},
                            { "data": "creation_date"},
                            { "data": "last_update_date"},
                        ],

                        "columnDefs": [ {
                            "targets": 1,
                            "data": null,
                            "render":function(a,b,data,d){
                                console.log(data.status)
                                    if((data.status == 'PENDING' || data.status == 'FINANCE_REJECTED') && ($.inArray(department_id, [6,8,25]))) {
                                       
                                        var a = '<a href="<?=base_url()?>admin/Claims/updateClaimForm/'+data.claims_id+'">'
                                            a += '<img src="<?=base_url()?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
                                            a += '</a>'
                                        return a

                                    }else if(data.status == 'APPROVED' && department_id == '6'){

                                        var a = ''
                                            a += '<a href="<?=base_url()?>admin/Claims/receiveClaimForm/'+data.claims_id+'">'
                                            a += '<img src="<?=base_url()?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
                                            a += '</a>'

                                            a += '&nbsp;&nbsp;<img src="<?=base_url()?>assets/img/cancel.png" onclick="rejectClaim(this)" alt="cancel" title="cancel" width="16px" height="16px">'
                                        
                                        return a
                                    }else{
                                        return null
                                    }
                                }
                            }
                        ]
        });

    }

    $('#claimsList_table tbody').on('click', 'td.details-control', function () {
    
        var tr = $(this).closest('tr');
        var row = claimslist_table.row( tr );

        if ( row.child.isShown() ) {

            row.child.hide();
            tr.removeClass('shown');

        }else {

            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    }) ;

    $('#button_pending').change(function(){
        claimsList('PENDING')
    });
    
    $('#button_approved').change(function(){
        claimsList('APPROVED')
    });
    
    $('#button_rejected').change(function(){
        claimsList('REJECTED')
    });

    $('#button_finance_rejected').change(function(){
        claimsList('FINANCE_REJECTED')
    });
    
    $('#button_settled').change(function(){
        claimsList('SETTLED')
    });

//Reject Code

    $(document).delegate("#finance_reject_close_modal","click", function(){
		
        $("#finance_reject_claims_id_modal").val('')
		$("#finance_reject_claim_no_modal").text('')
		$("#finance_reject_remarks_modal").val('')
		$("#modalReject").modal('hide');
	})


	$(document).delegate("#finance_reject_submit_modal","click", function(){

		var claims_id_modal = $("#finance_reject_claims_id_modal").val();
		var remarks_modal = $("#finance_reject_remarks_modal").val()
		var data= [];
		data = {
                    "claims_id": claims_id_modal,
                    "remarks_header": remarks_modal
                }
		jsonObject = JSON.stringify(data)
		$.ajax({
			url:"<?=base_url()?>admin/Claims/financeRejectClaim",
			type:"POST",
			dataType:"json",
			data: jsonObject,
			success:function (data){
				
                if(data.status==1){

					toastr.success('Claim Rejected Successfully');
					
                    $("#finance_reject_claims_id_modal").val('')
                    $("#finance_reject_claim_no_modal").text('')
                    $("#finance_reject_remarks_modal").val('')
                    $("#modalReject").modal('hide');

                    claimsList('FINANCE_REJECTED')
				
                }else{
					
                    alert('Failed to Reject the Claim');
				}
			}, error: function(data){
                    
                    alert('Failed to Reject the Claim');
            }
		})
	})


})

    function remarks_table(claims_id){

        var tableData = '<br><p></p>';
            tableData += '<p style="text-align: left; margin-left: 15px; font-weight:700;">Remarks</p>';
            tableData += '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
        $.ajax({
            url:"<?php echo base_url();?>web_api/getRemarks/?id="+claims_id+"&type=claims",
            type: "GET",
            dataType: 'json',
            async:false,
            success: function (data){
                if(data.status==1){
                    tableData+="<thead><th>Date</th><th>By</th><th>Remark</th></thead>"
                    $.each(data.remarks,function(i,v){
                        tableData+="<tr><td>"+data.remarks[i].date+"</td><td>"+data.remarks[i].username+"</td><td>"+data.remarks[i].remark+"</td></tr>";
                    })
                }
            }
        });
        tableData+='</table>'
        return tableData;
    }

    function receipts_table( claims_id ){
       
        var tableData = '<br><p></p>';
            tableData += '<p style="text-align: left; margin-left: 15px; font-weight:700;">Receipts</p>';
            tableData += '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
        
        $.ajax({
            url:"<?php echo base_url();?>admin/Claims/getReceipts/"+claims_id,
            type: "GET",
            dataType: 'json',
            async:false,
            success: function (data){
                if(data.status==1){
                    
                    tableData+="<thead><th>Account No</th><th>Reference No</th><th>Amount</th><th>Received Date</th></thead>"
                    
                    $.each(data.result,function(i,v){

                        tableData += "<tr>"
                        tableData += "<td>"+data.result[i].account_no+"</td>"
                        tableData += "<td>"+data.result[i].reference_no+"</td>"
                        tableData += "<td>"+data.result[i].amount+"</td>"
                        tableData += "<td>"+data.result[i].received_date+"</td>"
                        tableData += "</tr>";
                    })
                }
            }
        });
        tableData+='</table>'
        return tableData;
    }
   

    function format ( d ) {

        console.log(d)

        // `d` is the original data object for the row
        var childtable = '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';

            childtable += '<tr><th>Invoice No</th><th>Sales order No</th><th>Invoice Amount</th></tr>'
            
            childtable += '<tr>'
            childtable += '<td>'+d.invoice_no+'</td>'
            childtable += '<td>'+d.salesorder_no+'</td>'
            childtable += '<td>'+d.invoice_amount+'</td>'
            childtable += '</tr>'

            childtable +='</table>';
            childtable += receipts_table(d.claims_id)
            childtable += remarks_table(d.claims_id)

        return childtable
    }

    function rejectClaim(btn){

		var claims_id = $(btn).closest("tr").find(".claims_id").text();
		var claim_no = $(btn).closest("tr").find(".claim_no").text();
		if(claims_id > 0){
			$("#finance_reject_claims_id_modal").val(claims_id)
			$("#finance_reject_claim_no_modal").text(claim_no)
			$("#modalReject").modal('show');
		}
	}


</script>
	 
