
<div class="btn-group btn-toolbar" data-toggle="buttons">
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="devicevariant_button_new">NEW
    </label>
    <label class="btn btn-primary" active>
	  <input type="radio" name="options" id="devicevariant_button_certified">CERTIFIED
    </label>

</div>
<div style="overflow-x: auto;">
<table class="table table-striped DataTables" style="margin-left:5px;width:100%;" id="deviceVariantChange_table">
        <thead>
            <th></th>
            <th>Device ID</th>
            <th>OLD RAM</th>
            <th>OLD ROM</th>
	    <th>OLD COLOR</th>
            <th>NEW RAM</th>
            <th>NEW ROM</th>
	    <th>NEW COLOR</th>
            <th>IMEI 1</th>
            <th>IMEI 2</th>
            <th>ACTION</th>
        </thead>
    </table>
</div>
<script>


    $(document).ready(function(){

    function deviceVariantChangeList(status){
        deviceVariantChange_table = $('#deviceVariantChange_table').DataTable({
                        "paging":true,
                        "destroy":true,
                        "searching":true,
                        "processing": true,
                        "serverSide": false,  
                        //"scrollY": 380,
                      //  "scrollX":true,
                       // "scrollCollapse": false,
                       // "autoWidth": false,
                        "aaSorting": [],
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Certification/getDeviceVariantChangeList?record_status="+status,
                            "type": "GET",
                            "dataSrc": "data",
                            "async": false,
                        },
                        "columns": [
                            { "data": function(data){
                                    return '<input type="hidden" class="device_variant_change_id" value="'+data.device_variant_change_id+'">'
                                } 
                            },
                            { "data": "nhdin"},
                            { "data": "old_ram"},
                            { "data": "old_rom" },
			    { "data": "old_color" },
                            { "data": function(data){
                                    if(data.record_status == 'NEW'){
                                        return '<input class="form-control new_ram" type="text" value="'+data.new_ram+'">'
                                    }else{
                                        return data.new_ram
                                    }
                                } 
                            },
                            { "data": function(data){
                                    if(data.record_status == 'NEW'){
                                        return '<input class="form-control new_rom" type="text" value="'+data.new_rom+'">'
                                    }else{
                                            return data.new_rom
                                    }
                                } 
                            },
			    { "data": function(data){
                                    if(data.record_status == 'NEW'){
                                        return '<input class="form-control new_color" type="text" value="'+data.new_color+'">'
                                    }else{
                                            return data.new_color
                                    }
                                } 
                            },
                            { "data": "imei1_no" },
                            { "data": "imei2_no" },
                            { "data": function(data){
                                var a = ''
                                   
                                    if(data.record_status == 'NEW'){
                                        a += '<div>'
                                        a += '&nbsp;&nbsp;<button class= "btn btn-primary" onclick="updateDeviceVariant(this)">CERTIFY</button>'
                                        a += '&nbsp;&nbsp;<a class= "fa fa-trash-o" style="color:red;font-size:24px;" onclick="deleteVariantRecord(this)"></a>'
                                        a += '</div>'
                                    }
                                    return  a
                                }
                            },
                        ]
        });


    }

    deviceVariantChangeList('NEW')
    
    $('#devicevariant_button_new').change(function(){
        deviceVariantChangeList('NEW')
    });

    $('#devicevariant_button_certified').change(function(){
        deviceVariantChangeList('CERTIFIED')
    });

})

    function updateDeviceVariant(btn){
    
        var new_ram = $(btn).closest('tr').find('.new_ram').val()
        var new_rom = $(btn).closest('tr').find('.new_rom').val()
        var device_variant_change_id = $(btn).closest('tr').find('.device_variant_change_id').val()
        var device = {
                    "device_variant_change_id": device_variant_change_id,
                    "new_ram": new_ram,
                    "new_rom": new_rom
                }
        var jsonObject = JSON.stringify(device)
        $.ajax({
            "url": "<?=base_url()?>admin/Certification/updateDeviceVariantChange/",
            "type": "POST",
            "data": jsonObject,
            "dataType": "json",
            "async": false,
            "success": function(data){
                if(data.status == 1){
                    toastr.success("Success: Device Updated successfully")
                    $('#devicevariant_button_new').click()
                }else if(data.status == 2){
                    
                    toastr.error("Error: Spaces not allowed in RAM/ROM")
                }else if(data.status == 3){
                    toastr.error("Error: Device Status is NOT CIP")
                }else{
                    toastr.error("Error: Failed to Update Device")
                }
            },
            "error": function(){
                toastr.error("Error: Failed to Update Device")
            }
        })
    }

    function deleteVariantRecord(btn){
        var device_variant_change_id = $(btn).closest('tr').find('.device_variant_change_id').val()

        $.ajax({
            "url": "<?=base_url()?>admin/Certification/deleteDeviceVariantChange/",
            "type": "get",
            "data": { "device_variant_change_id": device_variant_change_id},
            "dataType": "json",
            "async": false,
            "success": function(data){
                if(data.status == 1){
                    toastr.success("Success: Record Deleted successfully")
                    $('#devicevariant_button_new').click()
                
                }else{
                    toastr.error("Error: Failed to Delete the Record")
                }
            },
            "error": function(){
                toastr.error("Error: Failed to Update Device")
            }
        })
    }
</script>