<form method="post" class="form-horizontal">
	<div class="form-group table-responsive"> 	  
		<table style="margin-left:5px" id="devicebacTable">
			<thead>
				<tr>
					<th>DEVICE ID</th>
					<th>PRODUCT</th>
					<th>SKU</th>
					<th>STOCK TYPE</th>
					<th>STATUS</th>
					<th>BAC</th>
					<th>BOX</th>
					<th>ADAPTER</th>
					<th>CABLE</th>
					<th>BIN<br>NUMBER</th>
					<th>REMARKS</th>
				</tr>
			</thead>
			<tbody>
				<tr id="devicebacTableRow">
					<td><input name="bac_deviceid" onchange="getbacDeviceDetails(this)" value="" style="width:120px" type="text"></td>
					<td><input name="bac_product" value="" type="text" style="width:160px" disabled></td>
					<td><input name="bac_sku" value="" type="text" style="width:180px" disabled></td>
					<td><input name="bac_stocktype" value="" type="text" style="width:100px" disabled></td>
				    <td><input name="bac_status" value="" type="text" style="width:80px" disabled></td>
					<td><input name="bac_bac_val" value="" type="text" style="width:80px" disabled></td>
					<td><input name="bac_box" value="" type="text" style="width:60px" ></td>
					<td><input name="bac_adapter" value="" type="text" style="width:60px" ></td>
					<td><input name="bac_cable" value="" type="text" style="width:60px" ></td>
					<td><input name="bac_bin_number" value="" type="text" style="width:80px" disabled></td>
					<td><input name="bac_remarks" value="" type="text" style="border: 1" disabled></td>		
				</tr>			
			</tbody>
		</table>
		<br>
	<p style="margin-left:5px" >Total Entries: <span id= "devicebacTotalEntries"></span></p>
</div>
<hr style="border: 3px solid #e4eaec">
<div class="form-group">
	<label class="col-lg-3 control-label"></label>
	<div class="col-lg-6">
		<button type="submit" onclick="updateDevicebac(event)" class="btn btn-sm btn-primary">SUBMIT</button>
	</div>
</div>

</form>


<hr style="border: 3px solid #e4eaec">

<table class="form-group table-responsive table" style="margin-left:10px;">
	<tr>
		<td>BULK BAC UPLOAD</td>
		<td><input type="file" class="form-control-file custom-file-input" name="input_bac_upload" id="input_bac_upload"></td>
		<td colspan="9"><input type="button" class="btn btn-danger" value="UPLOAD" onclick="bulkbacUpload(event)" /></td>
	</tr>
</table>
							
							
<script>
	var i='<?php echo $totalCount; ?>';
	var rowCount = 0;
	
	$(document).ready(function(){
		$('form').keydown(function (e) {
			if (e.keyCode == 13) {
				e.preventDefault();
				return false;
			}
		});	
	});
	
	function addRowTobacTable()
	{ 
		var data = $('#devicebacTableRow').html();
		$('#devicebacTable').find('tbody').append("<tr>"+data+"</tr>");
	}
 
  	function getbacDeviceDetails(x){   
	    console.log(x.value);
		var deviceid = x.value; 
		var row_id = $(x).closest('tr').index();
		
		
		$('input[name$="bac_product"]:eq('+row_id+')').val('');
		$('input[name$="bac_sku"]:eq('+row_id+')').val('');	
		$('input[name$="bac_stocktype"]:eq('+row_id+')').val('');
		$('input[name$="bac_status"]:eq('+row_id+')').val('');	
		$('input[name$="bac_bac_val"]:eq('+row_id+')').val('');	
		$('input[name$="bac_box"]:eq('+row_id+')').val('');	
		$('input[name$="bac_adapter"]:eq('+row_id+')').val('');	
		$('input[name$="bac_cable"]:eq('+row_id+')').val('');	
		$('input[name$="bac_bin_number"]:eq('+row_id+')').val('');	
		$('input[name$="bac_remarks"]:eq('+row_id+')').val('');
				
		
		$.ajax({
			url: "<?php echo base_url(); ?>admin/certification/getDeviceDetails",
			dataType: 'json',
			data: {deviceid:deviceid},
			type: 'POST', 
			error: function(){ 
				$('.nhdinInvoiceLoader').css('display','none');
				toastr.error('Device not found !'); 
				devicebacTotalEntries()			  
			},
			success: function(data){
				$('input[name$="bac_product"]:eq('+row_id+')').val(data.device_name);
				$('input[name$="bac_sku"]:eq('+row_id+')').val(data.SKU);
				$('input[name$="bac_stocktype"]:eq('+row_id+')').val(data.stock_type);
				$('input[name$="bac_status"]:eq('+row_id+')').val(data.status);	
				$('input[name$="bac_bac_val"]:eq('+row_id+')').val(data.bac);					
				$('input[name$="bac_bin_number"]:eq('+row_id+')').val(data.bin_number);
				$('input[name$="bac_remarks"]:eq('+row_id+')').val(data.remark);	
			
				addRowTobacTable();
				rowCount = row_id + 1;			
				$('input[name$="bac_deviceid"]:eq('+(row_id + 1)+')').focus();	
				devicebacTotalEntries()
			}
        });			
	}
	
	
	function updateDevicebac(event){
		event.preventDefault();
		var devices = [];
		var index;
		
		for(index=0;index<rowCount;index++){
			var deviceid = $('input[name$="bac_deviceid"]:eq('+index+')').val();
			var box = $('input[name$="bac_box"]:eq('+index+')').val();
			var adapter = $('input[name$="bac_adapter"]:eq('+index+')').val();
			var cable = $('input[name$="bac_cable"]:eq('+index+')').val();			
			var bac = box +'-'+ adapter+'-'+cable;
			devices.push({'deviceid':deviceid, 'bac':bac});
		}
		sendDevicebac(devices);
	}
	
	function sendDevicebac(devices){   
		var jsonObject = JSON.stringify(devices);
				
		$.ajax({
			url: "<?php echo base_url(); ?>admin/certification/updateDevicebac",
			dataType: 'json',
		    data: jsonObject,
			type: 'POST', 
			error: function(error){ 
				$('.nhdinInvoiceLoader').css('display','none');
				var message = JSON.parse(error.responseText);
				toastr.error(message.status); 				  
			},
			success: function(data){
			   $('.nhdinInvoiceLoader').css('display','none');
			   toastr.info('Device Sale Type updated.'); 					
			}
        });			
	}
	
	function bulkbacUpload(e){
		e.preventDefault();
		var devices = [];
		
		var fileUpload = document.getElementById("input_bac_upload");
        var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;
        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
		        var reader = new FileReader();
                reader.onload = function (e) {
				    var rows = e.target.result.split("\n");
					for (var i = 0; i < rows.length; i++) {
						var cells = rows[i].split(",");
                    	if (cells.length > 1) {
							var box = cells[1];
							var adapter = cells[2];
							var cable = cells[3];
							var bac = box+'-'+ adapter+'-'+cable;
							devices.push({'deviceid':cells[0],'bac':bac.replace(/(\r\n|\n|\r)/gm,"")});						
						}
					}	
					sendDevicebac(devices);
		        }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

	
	function devicebacTotalEntries(){
		var count = 0;
		for(index=0;index<rowCount;index++){
			var product = $('input[name$="bac_product"]:eq('+index+')').val();
			if(product.length > 0){
				count = count+1
			}
		}

		$("#devicebacTotalEntries").text(count)
	}
 
</script>
	 
