<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 th, td { white-space: nowrap; }
</style>

<table class="table table-striped DataTables" style="margin-left:5px" id="deviceListTable">
	<thead>
		<tr>
			<th></th>
			<th>DEVICE ID</th>
			<th>PRODUCT</th>
			<th>SKU</th>					
			<th>STOCK<br>TYPE</th>
			<th>BIN<br>NUMBER</th>
			<th>CERTIFIED<br>GRADE</th>
			<th>ISSUED<br>GRADE</th>			
			<th>ISSUED<br>DATE</th>
			<th>CERTIFIED<br>DATE</th>
		</tr>
	</thead>		
</table>
							
<script>
    var table;
    function format ( d ) {    
	   return '<table cellpadding="0" cellspacing="0" border="1" style="padding-left:50px;">'+
					'<tr><td>IMEI1/IMEI2</td><td>'+d.imei1_no+'/'+d.imei2_no+'</td></tr>'+
					'<tr><td>WH REMARKS</td><td>'+d.remark+'</td></tr>'+
					'<tr><td>Cert. REMARKS</td><td>'+d.checked_by+'</td></tr>'+
			'</table>';
	 }

    function getDevices(status){
		table = $('#deviceListTable').DataTable({
						"paging":true,
						"destroy":true,
						"searching":true,
						"processing": true,
						"serverSide": false,  
						"scrollY": 380,
						"scrollX":true,
						"scrollCollapse": true,
						"ajax": {
							"url": "<?php echo base_url(); ?>admin/certification/getDeviceDetailsByStatus",
							"type": "POST",
							"data":{'status':status},
							"dataSrc": "data"
						},
						"columns": [
						    {
									"className":      'details-control',
									"orderable":      false,
									"data":           null,
									"defaultContent": ''
							},
							{ "data": "nhdin" },
							{ "data": "device_name" },
							{ "data":  function(data){
								         return data.nhmod+'-'+data.ram+'-'+data.rom+'-'+data.color;
									   }
							},							
							{ "data": "stock_type" },
							{ "data": "bin_number" },							
							{ "data": "certification_grade" },
							{ "data": "issued_category" },							
							{ "data": "issued_date" },
							{ "data": "certified_date" }														
						]
		});
		
		
	} 

	 $(document).ready(function(){
		
		$("#devicelist").prepend(buttonGroup());		
		
		$('#button_cip').change(function(){
			getDevices('CIP');
		});
		
		$('#button_certified').change(function(){
			getDevices('CERTIFIED');
		});
		
		$('#button_faulted').change(function(){
			getDevices('FAULTED');
		});
		
		$('#button_triage').change(function(){
			getDevices('TRIAGE');
		});
						
		getDevices('CIP');
		
		$('#deviceListTable tbody').on('click', 'td.details-control', function () {
				var tr = $(this).closest('tr');
				var row = table.row( tr );
		 
				if ( row.child.isShown() ) {
					// This row is already open - close it
					row.child.hide();
					tr.removeClass('shown');
				}
				else {
					// Open this row
					row.child( format(row.data()) ).show();
					tr.addClass('shown');
				}
		});
	 });
	 

	 function buttonGroup(){
		return '<div class="btn-group btn-toolbar" data-toggle="buttons">'+
					'<label class="btn btn-primary active">'+
						'<input type="radio" name="options" id="button_cip" checked>CIP'+
					'</label>'+
				    '<label class="btn btn-primary">'+
					  '<input type="radio" name="options" id="button_certified">CERTIFIED'+
				    '</label>'+
					'<label class="btn btn-primary">'+
					  '<input type="radio" name="options" id="button_faulted">FAULTED'+
				    '</label>'+
					'<label class="btn btn-primary">'+
					  '<input type="radio" name="options" id="button_triage">TRIAGE'+
				    '</label>'+
				'</div><hr>';
	 }
 
</script>
	 
