<style>
	td.details-control {
		background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
		cursor: pointer;
	}

	tr.shown td.details-control {
		background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
	}

	tr {
		height: 30px;
	}

	th,
	td {
		white-space: nowrap;
	}
</style>
<div class="btn-group btn-toolbar" data-toggle="buttons">
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_inward">INWARD
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_in_stock">IN STOCK
	</label>
	<label class="btn btn-primary active">
		<input type="radio" name="options" id="button_cip" checked>CIP
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_certified">CERTIFIED
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_faulted">FAULTED
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_ber">BER
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_triage">TRIAGE
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_hold">HOLD
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_rfs">RFS
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_sold">SOLD
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_return">RETURN
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_service">SERVICE
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_rtv">RTV
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_for_service">FOR SERVICE
	</label>
	<label class="btn btn-primary">
		<input type="radio" name="options" id="button_in_service">IN SERVICE
	</label>
	<label>
		<a class="btn btn-danger dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">DOWNLOAD</a>
		<div class="btn dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuLink">
			<a class="dropdown-item btn btn-info offline" name="ALL" onclick="downloadDeviceListData()">All</a>
			<a class="dropdown-item btn btn-info offline" name="OPEN BOX" onclick="downloadDeviceListData('OPEN BOX')">OPEN BOX</a>
			<a class="dropdown-item btn btn-info offline" name="PREXO" onclick="downloadDeviceListData('PREXO')">PREXO</a>
			<a class="dropdown-item btn btn-info offline" name="PRELOVED" onclick="downloadDeviceListData('PRELOVED')">PRELOVED</a>
			<a class="dropdown-item btn btn-info offline" name="BUY BACK" onclick="downloadDeviceListData('BUY BACK')">BUY BACK</a>
			<a class="dropdown-item btn btn-info offline" name="DEMO" onclick="downloadDeviceListData('DEMO')">DEMO</a>
			<a class="dropdown-item btn btn-info offline" name="NEW" onclick="downloadDeviceListData('NEW')">NEW</a>
			<a class="dropdown-item btn btn-info offline" name="INSURANCE" onclick="downloadDeviceListData('INSURANCE')">NSURANCE</a>
		</div>
	</label>
	<label>
		<a class="btn btn-danger dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Open Box</a>
		<div class="btn dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuLink">
			<a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadDeviceListData('OPEN BOX','OFFLINE')">OFFLINE</a>
			<a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadDeviceListData('OPEN BOX','ONLINE')">ONLINE</a>
			<a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadDeviceListData('OPEN BOX','OTHER')">OTHER</a>
		</div>

	</label>
</div>
<hr>
<table class="table table-striped DataTables" style="margin-left:5px" id="deviceListTable">
	<thead>
		<tr>
			<th></th>
			<th>DEVICE ID</th>
			<th>PRODUCT</th>
			<th>SKU</th>
			<th>STOCK<br>TYPE</th>
			<th>STOCK<br>SUB TYPE</th>
			<th>SALE TYPE</th>
			<th>BIN<br>NUMBER</th>
			<th>AGE<br>(IN DAYS)</th>
			<th>CERTIFICATION AGE<br>(IN DAYS)</th>
			<th>CERTIFIED<br>GRADE</th>
			<th>BAC</th>
			<th>ISSUED<br>GRADE</th>
			<th>ISSUED<br>DATE</th>
			<th>CERTIFIED<br>DATE</th>
		</tr>
	</thead>
</table>

<script>
	var table;
	var deviceStatus;

	function format(d) {
		return '<table cellpadding="0" cellspacing="0" border="1" style="padding-left:50px;">' +
			'<tr><td>IMEI1/IMEI2</td><td>' + d.imei1_no + '/' + d.imei2_no + '</td></tr>' +
			'<tr><td>WH REMARKS</td><td>' + d.remark + '</td></tr>' +
			'<tr><td>Cert. REMARKS</td><td>' + d.checked_by + '</td></tr>' +
			'</table>';
	}

	function getDevices(status) {
		deviceStatus = status;
		table = $('#deviceListTable').DataTable({
			"paging": true,
			"destroy": true,
			"searching": true,
			"processing": true,
			"serverSide": false,
			"scrollY": 380,
			"scrollX": true,
			"scrollCollapse": true,
			"ajax": {
				"url": "<?php echo base_url(); ?>admin/certification/getDeviceDetailsByStatus",
				"type": "POST",
				"data": {
					'status': status
				},
				"dataSrc": "data"
			},
			"columns": [{
					"className": 'details-control',
					"orderable": false,
					"data": null,
					"defaultContent": ''
				},
				{
					"data": "nhdin"
				},
				{
					"data": "device_name"
				},
				{
					"data": function(data) {
						return data.nhmod + '-' + data.ram + '-' + data.rom + '-' + data.color;
					}
				},
				{
					"data": "stock_type"
				},
				{
					"data": "device_sub_category"
				},
				{
					"data": "saletype"
				},
				{
					"data": "bin_number"
				},
				{
					"data": "age"
				},
				{
					"data": function(data) {
						const startDate = data.issued_date;
						const endDate = new Date();

						if (startDate == null)
							return ''

						const diffInMs = new Date(endDate) - new Date(startDate)
						const diffInDays = Math.floor(diffInMs / (1000 * 60 * 60 * 24));
						if (diffInDays == NaN) {
							return ''
						}
						return diffInDays
					}
				},
				{
					"data": "certification_grade"
				},
				{
					"data": "bac"
				},
				{
					"data": "issued_category"
				},
				{
					"data": "issued_date"
				},
				{
					"data": "certified_date"
				}
			]
		});


	}

	$(document).ready(function() {

		$("#devicelist").prepend(buttonGroup());

		$('#button_cip').change(function() {
			getDevices('CIP');
		});

		$('#button_certified').change(function() {
			getDevices('CERTIFIED');
		});

		$('#button_inward').change(function() {
			getDevices('INWARD');
		});

		$('#button_in_stock').change(function() {
			getDevices('IN_STOCK');
		});

		$('#button_faulted').change(function() {
			getDevices('FAULTED');
		});

		$('#button_ber').change(function() {
			getDevices('BER');
		});

		$('#button_rfs').change(function() {
			getDevices('RFS');
		});

		$('#button_triage').change(function() {
			getDevices('TRIAGE');
		});

		$('#button_sold').change(function() {
			getDevices('SOLD');
		});

		$('#button_return').change(function() {
			getDevices('RETURN');
		});

		$('#button_service').change(function() {
			getDevices('SERVICE');
		});

		$('#button_hold').change(function() {
			getDevices('HOLD');
		});
		$('#button_rtv').change(function() {
			getDevices('RTV');
		});
		$('#button_for_service').change(function() {
			getDevices('FOR_SERVICE');
		});

		$('#button_in_service').change(function() {
			getDevices('IN_SERVICE');
		});



		$('#deviceListTable tbody').on('click', 'td.details-control', function() {
			var tr = $(this).closest('tr');
			var row = table.row(tr);

			if (row.child.isShown()) {
				// This row is already open - close it
				row.child.hide();
				tr.removeClass('shown');
			} else {
				// Open this row
				row.child(format(row.data())).show();
				tr.addClass('shown');
			}
		});

	});


	function buttonGroup() {
		return '';
	}

	function downloadDeviceListData(stock_type = '', saletype = '') {
		$.ajax({
			url: "<?php echo base_url(); ?>admin/certification/downloadDeviceDetailsByStatus",
			dataType: 'json',
			data: {
				status: deviceStatus,
				"stock_type": stock_type,
				"saletype": saletype
			},
			type: 'POST',
			success: function(response) {
				responseData = response.data;
				var array = typeof responseData != 'object' ? JSON.parse(responseData) : responseData;
				var str = '';
				str += 'TD ID, CATEGORY,STOCK SUB TYPE, BRAND, MODEL NAME,SKU,CERTIFIED GRADE,SALES TYPE,STATUS,BIN NUMBER,BATCH NUMBER, AGE \r\n';
				for (var i = 0; i < array.length; i++) {
					var line = '';
					for (var index in array[i]) {
						if (line != '')
							line += ','
						var item_val = array[i][index]
						if (array[i][index] == null) {
							item_val = ''
						}
						line += item_val.replace(/(\r\n|\n|\r)/gm, "");;
					}

					str += line + '\r\n';
				}

				var a = document.createElement('a');
				a.href = 'data:attachment/csv,' + encodeURIComponent(str);
				a.target = '_blank';
				a.download = 'devicedetails.csv';

				document.body.appendChild(a);
				a.click();
			}
		});
	}
</script>