<form id="allocateForm" method="post" class="form-horizontal">
	<div class="form-group table-responsive"> 	  
		<table style="margin-left:5px" id="allocateTable">
			<thead>
				<tr>
					<th>DEVICE ID</th>
					<th>PRODUCT</th>
					<th>SKU</th>
					<th>STOCK TYPE</th>
					<th>STATUS</th>
					<th>ISSUED<br>CATEGORY</th>
					<th>IMEI</th>
					<th>BIN NUMBER</th>
					<th>REMARKS</th>
				</tr>
			</thead>
			<tbody>
				<tr id="allocateTableRow" class="allocateTableRow">
					<td><input name="deviceid" onchange="getDeviceDetails(this)" value="" style="width:120px" type="text"></td>
					<td><input name="product" value="" type="text" style="width:140px" disabled></td>
					<td><input name="sku" value="" type="text" style="width:140px" disabled></td>
					<td><input name="stocktype" value="" type="text" style="width:100px" disabled></td>
				    <td><input name="status" value="" type="text" style="width:80px" disabled></td>
					<td><input name="issued_category" style="width:80px" type="text"></td>				
					<td><input name="imei" value="" type="text" style="width:120px" disabled></td>
					<td><input name="bin" value="" type="text" style="border: 1" disabled></td>	
					<td><input name="remarks" value="" type="text" style="border: 1" disabled></td>					
				</tr>			
			</tbody>
		</table>
		<br>
<p  style="margin-left:5px" >Total Entries: <span id= "allocateTotalEntries"></span></p>
</div>
<hr style="border: 3px solid #e4eaec">
<div class="form-group">
	<label class="col-lg-3 control-label"></label>
	<div class="col-lg-6">
		<button type="submit" onclick="updateDeviceStatusToCIP(event)" class="btn btn-sm btn-primary btn_submit">SUBMIT</button>
	</div>
</div>

</form>
							
							<!--second form start for upload excel file-->

<hr style="border: 3px solid #e4eaec">

<table class="form-group table-responsive table" style="margin-left:10px;">
	<tr>
		<td>BULK ALLOCATE TO CERTIFY</td>
		<td><input type="file" class="form-control-file custom-file-input" name="input_bulk_certify_upload" id="input_bulk_certify_upload"></td>
		<td colspan="9"><input type="button" class="btn btn-primary btn_submit_bulk" value="UPLOAD" onclick="bulkallocateUpload(event)" /></td>
	
	</tr>
</table>


<hr style="border: 3px solid #e4eaec">
							
							
<script>
	function bulkallocateUpload(e) {
		e.preventDefault();
		$('.btn_submit_bulk').attr('disabled', true);
		var devices = [];
		var isValid = true;

		let columns_allowed = 2;
		
		var fileUpload = document.getElementById("input_bulk_certify_upload");
        var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;
        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
		        var reader = new FileReader();
                reader.onload = function (e) {
				    var rows = e.target.result.split("\r\n");
					
					for (var i = 1; i < rows.length; i++) {
						var cells = rows[i].split(",");
						
                    	if (cells.length > 1) {
							if (cells.length != columns_allowed) {
								alert("Only "+ columns_allowed +" column should be there in uploading file");
								isValid = false;
								return false;
							}

							let d = cells[0].replace('\r', '').trim().toUpperCase();
							if (d == '') {
								alert('"Device ID" Error at row : ' + (i+1));
								isValid = false;
								return false;
							}

							devices.push({
								'deviceid': d,
							});
						}
					}
					if (!isValid) {
						$('.btn_submit_bulk').attr('disabled', false);
						return false;
					}
					
					$('.nhdinInvoiceLoader').show();

					$.ajax({
						// url: '<?php //echo base_url(); ?>admin/Certification/bulkUpdateStatusToCIP',
						url: '<?php echo base_url(); ?>admin/Certification/bulkUpdateStatusTo_CIP',
						type: 'POST',
						data: JSON.stringify(devices),
						dataType: 'json',
						success:function(data) {
							$('.nhdinInvoiceLoader').hide();
							$('.btn_submit_bulk').attr('disabled', false);

							if (data.status) {
								toastr.success(data.message);
							} else {
								toastr.error(data.message);
							}
						},
						error: function(data) { 
							$('.nhdinInvoiceLoader').hide();
							$('.btn_submit_bulk').attr('disabled', false);
							console.log(JSON.stringify(data));
							toastr.error('Upload failed.');
						},		
					});
		        }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }
 
	var d='<?php echo $totalCount; ?>';
	var rowCount = 0;
	
	$(document).ready(function(){
		$('form').keydown(function (e) {
			if (e.keyCode == 13) {
				e.preventDefault();
				return false;
			}
		});	
	});
	
	function addRowTAllocateTable()
	{ 
		var data = $('#allocateTableRow').html();
		$('#allocateTable').find('tbody').append("<tr>"+data+"</tr>");
	}
 
  	function getDeviceDetails(x){   
	    console.log(x.value);
		var deviceid = x.value; 
		var row_id = $(x).closest('tr').index();
		
		$('input[name$="bin"]:eq('+row_id+')').val('');
		$('input[name$="imei"]:eq('+row_id+')').val('');
		$('input[name$="product"]:eq('+row_id+')').val('');
		$('input[name$="stocktype"]:eq('+row_id+')').val('');
		$('input[name$="remarks"]:eq('+row_id+')').val('');
		$('input[name$="sku"]:eq('+row_id+')').val('');	
		$('input[name$="status"]:eq('+row_id+')').val('');	
		$('input[name$="issued_category"]:eq('+row_id+')').val('');	
		
		$.ajax({
			url: "<?php echo base_url(); ?>admin/certification/getDeviceDetails",
			dataType: 'json',
			data: {deviceid:deviceid},
			type: 'POST', 
			error: function(){ 
				totalAllocateEntries()
				$('.nhdinInvoiceLoader').css('display','none');
				toastr.error('Device not found !'); 				  
			},
			success: function(data){
				if(data.status != 'IN_STOCK' && data.status != 'FAULTED' && data.status != 'BER'  && data.status != 'RETURN' && data.status != 'RFS'){
					$('.nhdinInvoiceLoader').css('display','none');
					toastr.error('Price update pending with Finance.');
					totalAllocateEntries()
					return;
				}
								
				$('input[name$="bin"]:eq('+row_id+')').val(data.bin_number);
				$('input[name$="imei"]:eq('+row_id+')').val(data.imei1_no);
				$('input[name$="product"]:eq('+row_id+')').val(data.device_name);
				$('input[name$="stocktype"]:eq('+row_id+')').val(data.stock_type);
				$('input[name$="remarks"]:eq('+row_id+')').val(data.remark);	
				$('input[name$="status"]:eq('+row_id+')').val(data.status);	
				$('input[name$="issued_category"]:eq('+row_id+')').val(data.certification_grade);	
				
				var sku='';
				if(data.ram){
					sku = sku+'-'+data.ram;
				}
				if(data.rom){
					sku = sku+'-'+data.rom;
				}
				if(data.color){
					sku = sku+'-'+data.color;
				}
								
				$('input[name$="sku"]:eq('+row_id+')').val(data.nhmod+sku);	
				addRowTAllocateTable();
				rowCount = row_id + 1;			
				$('input[name$="deviceid"]:eq('+(row_id + 1)+')').focus();	
				totalAllocateEntries()
			}
        });			
	}
	
	function updateDeviceStatusToCIP(event) {
		event.preventDefault();
		$('.btn_submit').attr('disabled', true);
		
		var devices = [];
		var index;
		
		for(index=0;index<rowCount;index++){
			var deviceid = $('input[name$="deviceid"]:eq('+index+')').val();
			var issued_category = $('input[name$="issued_category"]:eq('+index+')').val();
			devices.push({'deviceid':deviceid, 'issued_category':issued_category});
		}
		
		var jsonObject = JSON.stringify(devices);
		$('.nhdinInvoiceLoader').show();
				
		$.ajax({
			// url: "<?php //echo base_url(); ?>admin/certification/updateDeviceStatusToCIP",
			url: "<?php echo base_url(); ?>admin/certification/bulkUpdateStatusTo_CIP",
			dataType: 'json',
		    data: jsonObject,
			type: 'POST',
			success: function(data) {
				$('.nhdinInvoiceLoader').hide();
				$('.btn_submit').attr('disabled', false);

				if (data.status) {
					toastr.success(data.message);
				} else {
					toastr.error(data.message);
				}
			},
			error: function(data){ 
				$('.nhdinInvoiceLoader').css('display','none');
				$('.btn_submit').attr('disabled', false);
				console.log(JSON.stringify(data));
				toastr.error('Error Occured');
			},
        });			
	}

	function totalAllocateEntries(){
		var count = 0;
		for(index=0;index<rowCount;index++){
			var product = $('input[name$="product"]:eq('+index+')').val();
			if(product.length > 0){
				count = count+1
			}
		}

		$("#allocateTotalEntries").text(count)
	}
 
</script>
	 
