<!-- Create a datatable for bundles -->
<!-- Create a datatable for bundles -->
<div class="col-md-12 col-sm-12 col-lg-12">
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">
                <i class="fa fa-list"></i>
                Update Bundle
            </h3>
        </div>
        <div class="panel-body">
            <div class="row">
                <div class="col-md-12 col-sm-12 table-responsive" style="width: 90%;">
                    <table id="bundle_header" class="table table-bordered table-striped table-actions">
                        <thead>
                            <tr>
                                <th>Bundle No</th>
                                <th>Bundle Type</th>
                                <th>Quantity</th>
                                <th>Amount</th>
                                <th>Category</th>
                                <th>Sub Category</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="panel-heading">
        <h3 class="panel-title">
            Bundle Items
        </h3>
    </div>

    <div style="text-align: center; display:inline-flex;">
        <input type="text" class="form-control" id="upd_device_id" onchange="checkTDID()" style="width: 250px;margin:10px;" placeholder="Scan Device Id">
        <input type="button" class="btn btn-warning" onclick="checkTDID()" value="add" style="width: 100px; margin:10px;">
    </div>

    <div class="panel-body">
        <div class="row">
            <div class="col-md-12 col-sm-12 table-responsive" style="width: 90%;">
                <table id="update_bundle_items" class="table table-bordered table-striped table-actions">
                    <thead>
                        <tr>
                            <th>Device ID</th>
                            <th>Device Name</th>
                            <th>SKU</th>
                            <th>Category</th>
                            <th>Sub Category</th>
                            <th>Grade</th>
                            <th>Price</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="panel-heading">
        <h3 class="panel-title">
            Bundle Remarks
        </h3>
        <textarea id="update_remarks" class="form-control" style="width: 25%;"></textarea>
    </div>
    <!-- Approve And Reject Buttons -->
    <div style="text-align: center;">
        <!-- <input type="button" id="update_bundle_reject" class="btn btn-danger" onclick="submitUpdateForm('reject')" value="Reject" style="margin: 10px;"> -->
        <input type="button" id="update_bundle_approve" class="btn btn-success" value="Packed" style="margin: 10px;" onclick="submitUpdateForm()">
        <input type="button" id="update_bundle_back" class="btn btn-grey" value="Back" style="margin: 10px;" onclick="goBack()">
    </div>
</div>

<script>
    var update_bundle_id = <?php echo $update_bundle_id; ?>;
    var updated_tdid = []

    $(document).ready(function() {
        //get bundle Header
        var header_table = $('#bundle_header').DataTable({
            "processing": true,
            "serverSide": false,
            //remove pagination
            "paging": false,
            //remove entires count
            "info": false,
            "ajax": {
                "url": "<?php echo base_url() . 'admin/bundles/getBundleHeader'; ?>",
                "dataType": "json",
                "type": "GET",
                "data": {
                    'bundle_id': update_bundle_id
                },
                "dataSrc": "data"
            },
            "columns": [{
                    "data": "bundle_no"
                },
                {
                    "data": "type"
                },
                {
                    "data": "quantity"
                },
                {
                    "data": "amount"
                },
                {
                    "data": "category"
                },
                {
                    "data": "sub_category"
                },
                {
                    "data": "status"
                }
            ]

        });
        /*
                //get bundle items
                var item_table = $('#update_bundle_items').DataTable({
                    "processing": true,
                    "serverSide": false,

                    "ajax": {
                        "url": "<?php //echo base_url() . 'admin/bundles/getBundleItems'; 
                                ?>",
                        "dataType": "json",
                        "type": "GET",
                        "data": {
                            'bundle_id': update_bundle_id
                        },
                        "dataSrc": "data"
                    },
                    "columns": [{
                            "data": "nhdin"
                        },
                        {
                            "data": "device_name"
                        },
                        {
                            "data": "sku"
                        },
                        {
                            "data": "category"
                        },
                        {
                            "data": "sub_category"
                        },
                        {
                            "data": "grade"
                        },
                        {
                            "data": "price"
                        }
                    ]

                });
                */
    });

    function submitUpdateForm() {
        var remarks = $('#update_remarks').val();
        let data = {
            'bundle_id': update_bundle_id,
            'remarks': remarks,
            'items': updated_tdid
        }
        var jsonObject = JSON.stringify(data);
        $.ajax({
            url: "<?php echo base_url() . 'admin/bundles/updateBundle'; ?>",
            type: "POST",
            data: jsonObject,
            dataType: "json",
            success: function(data) {
                if (data.status == 1) {
                    toastr.success('Bundle Updated Successfully');
                    window.location.href = "<?php echo base_url() . 'admin/bundles/manage_bundles'; ?>";
                } else {
                    toastr.error(data.message);
                }
            }
        });
    }

    function checkTDID() {
        var device_id = $("#upd_device_id").val();
        if (device_id == undefined || device_id == '' || device_id == null) {
            toastr.error('Please Scan a Device Id');
            return false;
        }

        if (updated_tdid.includes(device_id)) {
            toastr.error('Device Id Already Added');
            return false;
        }
        $("#upd_device_id").val('')
        $.ajax({
            url: "<?php echo base_url() . 'admin/bundles/checkDeviceId'; ?>",
            type: "GET",
            data: {
                device_id: device_id,
                bundle_id: update_bundle_id
            },
            dataType: "json",
            success: function(data) {
                if (data.status != 1) {
                    toastr.error("Invalid TDID or Device is not belong to this bundle");
                    $("#upd_device_id").val(device_id)
                    return false
                }

                //Add the details to update_bundle_items as row
                var row = '<tr>' +
                    '<td>' + data.data.nhdin + '</td>' +
                    '<td>' + data.data.device_name + '</td>' +
                    '<td>' + data.data.sku + '</td>' +
                    '<td>' + data.data.category + '</td>' +
                    '<td>' + data.data.sub_category + '</td>' +
                    '<td>' + data.data.grade + '</td>' +
                    '<td>' + data.data.price + '</td>' +
                    '</tr>';
                $(row).appendTo("#update_bundle_items tbody");
                updated_tdid.push(device_id)
                $("#upd_device_id").focus();
            },
            error: function(data) {
                toastr.error("Failed to Add Device to Bundle");
                $("#upd_device_id").val(device_id)
                return false
            }
        })
    }

    //goback to manage_bundles
    function goBack() {
        window.location.replace("<?php echo base_url() . 'admin/bundles/manage_bundles'; ?>");
    }
</script>