<label style="margin-left: 10px; padding-right: 10px">
    NEW BUNDLE
</label>
<hr>
<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;">
    <div class="col-md-12  col-sm-12 col-lg-12 col-xs-12" style="width:90%">

        <div class="form-group">
            <div class="col-lg-4">
                <input type="text" id="edit_bundle_no" class="form-control" placeholder="Bundle No" readonly>
            </div>
            <div class="col-lg-4">
                <select class="form-control" name="edit_bundle_type" id="edit_bundle_type">
                    <option value="">SELECT TYPE</option>
                </select>
            </div>
            <div class="col-lg-4">
                <select class="form-control" name="edit_bundle_category" id="edit_bundle_category">
                    <option value="">SELECT CATEGORY</option>
                </select>
            </div>

        </div>

        <div class="form-group">
            <div class="col-lg-4">
                <select class="form-control" name="edit_bundle_sub_category" id="edit_bundle_sub_category">
                    <option value="">SELECT SUB CATEGORY</option>
                </select>
            </div>
            <div class="col-lg-4">
                <input type="number" class="form-control" id="edit_bundle_quantity" placeholder="Quantity">
            </div>
            <div class="col-lg-4">
                <input type="number" class="form-control" id="edit_bundle_amount" placeholder="Amount">
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-2 control-label">UPLOAD BUNDLE ITEMS</label>


            <div class="col-lg-3" style="text-align: center;">
                <!-- Upload excel file Button -->
                <input type="file" id="edit_bundle_file" value="SELECT FILE">
            </div>

            <div class="col-lg-1" style="text-align: center;">
                <!-- Sample File Button -->
                <input type="button" id="sample_bundle_file" class="btn btn-green" onclick="sampleMRP()" value="SAMPLE FILE" readonly>
            </div>
        </div>
        <div class="form-group">
            <div class="col-lg-12" style="text-align: center; margin-top:10px;">
                <input type="button" id="edit_add_bundle_btn" class="btn btn-primary" onclick="addBundleEdit()" value="SUBMIT" readonly>
            </div>
        </div>
    </div>

    <!-- Items Table -->
    <div class="panel-body">
        <div class="row">
            <div class="col-md-12 col-sm-12 table-responsive" style="width: 90%;">
                <table id="edit_bundle_items" class="table table-bordered table-striped table-actions">
                    <thead>
                        <tr>
                            <th>Device ID</th>
                            <th>Device Name</th>
                            <th>SKU</th>
                            <th>Category</th>
                            <th>Sub Category</th>
                            <th>Grade</th>
                            <th>Price</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>



<script>
    var edit_bundle_id = <?= $edit_bundle_id ?>;
    $.when(getNewDropdown('DEVICE_SUB_CATEGORY', 'edit_bundle_sub_category'),
        getNewDropdown('BUNDLE_TYPE', 'edit_bundle_type'),
        getNewDropdown('CATEGORY', 'edit_bundle_category')
    ).done(
        getBundleHeaderEdit()
    )


    function checkNull(entity, message = '') {
        if (entity == '' || entity == null || entity == undefined) {
            return message
        }
        return '';
    }

    function addBundleEdit() {
        //disable upload button
        $('#edit_add_bundle_btn').attr('disabled', true);
        let total_price = 0;
        let bundle_amount = +$('#edit_bundle_amount').val();
        let bundle_quantity = +$('#edit_bundle_quantity').val();
        let bundle_type = $('#edit_bundle_type').val();
        let bundle_category = $('#edit_bundle_category').val();
        let bundle_sub_category = $('#edit_bundle_sub_category').val();
        let filedsRequired = ''

        filedsRequired += checkNull(bundle_type, 'Bundle Type, ');
        filedsRequired += checkNull(bundle_category, 'Bundle Category, ');
        filedsRequired += checkNull(bundle_sub_category, 'Bundle Sub Category, ');
        filedsRequired += checkNull(bundle_quantity, 'Bundle Quantity, ');
        filedsRequired += checkNull(bundle_amount, 'Bundle Amount, ');

        if (filedsRequired != '') {
            toastr.error('Please fill the following fields: ' + filedsRequired);
            $('#edit_add_bundle_btn').attr('disabled', false);
            return;
        }

        //read csv file from input
        var file = $('#edit_bundle_file').prop('files')[0];

        //check file is csv or not
        if (file.name.split('.').pop() != 'csv') {
            toastr.error('Please select csv file');
            $('#edit_add_bundle_btn').attr('disabled', false);
            return false;
        }
        //Read the file add first column to as device id and second column as retail price into an object
        var reader = new FileReader();
        reader.onload = function(e) {
            var lines = e.target.result.split('\n');
            var data = [];
            var items = []
            var headers = ['device_id', 'price'];
            for (var i = 1; i < lines.length; i++) {
                var obj = {};
                var currentline = lines[i].split(',');
                if (currentline[0] == undefined || currentline[0] == '') {
                    continue;
                }
                if (currentline[1] == undefined || currentline[1] == '') {
                    continue;
                }
                obj = {
                    device_id: currentline[0].trim(),
                    price: currentline[1].replace('\r', '').trim()
                };
                items.push(obj);
                total_price += +currentline[1].replace('\r', '').trim();
            }
            //if data is empty then show error
            if (items.length == 0) {
                toastr.error('Please select a valid csv file');
                $('#edit_dd_bundle_btn').attr('disabled', false);
                return false;
            }

            if (total_price > (bundle_amount + 5) || total_price < (bundle_amount - 5)) {
                toastr.error('Total price should be equal to bundle amount');
                $('#edit_add_bundle_btn').attr('disabled', false);
                return false;
            }

            data = {
                items: items,
                bundle_type: bundle_type,
                bundle_category: bundle_category,
                bundle_sub_category: bundle_sub_category,
                bundle_quantity: bundle_quantity,
                bundle_amount: bundle_amount
            }

            var jsonObject = JSON.stringify(data);

            //send data to server
            $.ajax({
                url: '<?= base_url() ?>admin/Bundles/addBundle',
                type: 'POST',
                data: jsonObject,
                dataType: 'JSON',
                success: function(response) {
                    if (response.status == 1) {
                        toastr.success(response.message);
                        window.location.replace('<?= base_url() ?>admin/Bundles/manage_bundles');
                    } else {
                        toastr.error(response.message);
                        $('#edit_add_bundle_btn').attr('disabled', false);
                        return false
                    }
                },
                error: function(error) {
                    toastr.error('Failed to Create Bundle');
                    $('#edit_add_bundle_btn').attr('disabled', false);
                }
            });
        }
        reader.readAsText(file);;
    }

    function sampleMRP() {
        window.open('<?php echo base_url(); ?>admin/fastcheckout/sample_mrp', '_blank');
    }

    function getNewDropdown(type, select_id) {
        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>admin/DropDownItems/getItems?type=" + type,
            data: {},
            dataType: "json",
            success: function(data) {

                $.each(data, function(i, v) {

                    $("#" + select_id).append('<option value="' + data[i].name + '">' + data[i].name + '</option>')
                })
                return true
            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
    }

    function getBundleHeaderEdit() {

        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>admin/Bundles/getBundleHeader?bundle_id=" + edit_bundle_id,
            data: {},
            dataType: "json",
            success: function(data) {
                $('#edit_bundle_type').val(data.data[0].type);
                $('#edit_bundle_category').val(data.data[0].category);
                $('#edit_bundle_sub_category').val(data.data[0].sub_category);
                $('#edit_bundle_quantity').val(data.data[0].quantity);
                $('#edit_bundle_amount').val(data.data[0].amount);
                $("#edit_bundle_no").val(data.data[0].bundle_no);
            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
    }
    $(document).ready(function() {
                //get bundle items
                var item_table = $('#edit_bundle_items').DataTable({
                    "processing": true,
                    "serverSide": false,

                    "ajax": {
                        "url": "<?php echo base_url() . 'admin/bundles/getBundleItems'; ?>",
                        "dataType": "json",
                        "type": "GET",
                        "data": {
                            'bundle_id': edit_bundle_id
                        },
                        "dataSrc": "data"
                    },
                    "columns": [{
                            "data": "nhdin"
                        },
                        {
                            "data": "device_name"
                        },
                        {
                            "data": "sku"
                        },
                        {
                            "data": "category"
                        },
                        {
                            "data": "sub_category"
                        },
                        {
                            "data": "grade"
                        },
                        {
                            "data": "price"
                        }
                    ],
                    //download csv
                    dom: 'Bfrtip',
                    buttons: [{
                        extend: 'csv',
                        text: '<span class="btn btn-success"><i class="fa fa-file-excel-o"></i> CSV</span>',
                        filename: 'Bundle Items',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5, 6]
                        }
                    }]

                });

                function getNewBundleItems() {
                    // reaload item_table with new ajax url
                    item_table.ajax.url("<?php echo base_url() . 'admin/bundles/getBundleItems'; ?>?bundle_id=" + edit_bundle_id).load();


                    //read csv file from input
                    var file = $('#bundle_file').prop('files')[0];

                    //check file is csv or not
                    if (file.name.split('.').pop() != 'csv') {
                        toastr.error('Please select csv file');
                        $('#add_bundle_btn').attr('disabled', false);
                        return false;
                    }
                    //Read the file add first column to as device id and second column as retail price into an object
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        var lines = e.target.result.split('\n');
                        var items = []
                        var nhdin_arr = []
                        var price_arr = []
                        var headers = ['device_id', 'price'];
                        for (var i = 1; i < lines.length; i++) {
                            var obj = {};
                            var currentline = lines[i].split(',');
                            if (currentline[0] == undefined || currentline[0] == '') {
                                continue;
                            }
                            if (currentline[1] == undefined || currentline[1] == '') {
                                continue;
                            }
                            obj = {
                                device_id: currentline[0].trim(),
                                price: currentline[1].replace('\r', '').trim()
                            };
                            items.push(obj);
                            nhdin_arr.push(currentline[0].trim());
                            price_arr[currentline[0].trim().toLowerCase()] = currentline[1].replace('\r', '').trim();
                            total_price += +currentline[1].replace('\r', '').trim();
                        }
                        //if data is empty then show error
                        if (items.length == 0) {
                            toastr.error('Please select a valid csv file');
                            $('#add_bundle_btn').attr('disabled', false);
                            return false;
                        }

                        $.ajax({
                                url: "<?php echo base_url(); ?>admin/device/getGroupBySKU",
                                dataType: 'json',
                                data: JSON.stringify(items),
                                type: 'POST',
                                success: function(response) {
                                    var k = true
                                    let item_table_row = []
                                    for (x = 0; x < response.length; x++) {
                                        var data = response[x];
                                        device_id = data.nhdin;
                                        grnreport_id = data.grnreport_id;
                                        device_name = data.device_name;
                                        sku = data.SKU;
                                        category = data.stock_type;
                                        grade = data.certification_grade;
                                        quantity = 1;
                                        status = data.status;     
                                        
                                        response_products.push(device_id.toLowerCase())

                                        let item = [device_id, device_name, sku, category, grade, price_arr[device_id.toLowerCase()]]
                                        item_table_row.push(item)
                                    }

                                    //destroy table
                                    item_table.destroy();
                                    //add item_table_row to item_table
                                    item_table = $('#edit_bundle_items').DataTable({
                                        "processing": true,
                                        "serverSide": false,
                                        "data": item_table_row,
                                        "columns": [{
                                                "data": "nhdin"
                                            },
                                            {
                                                "data": "device_name"
                                            },
                                            {
                                                "data": "sku"
                                            },
                                            {
                                                "data": "category"
                                            },
                                            {
                                                "data": "grade"
                                            },
                                            {
                                                "data": "price"
                                            }
                                        ],
                                        //download csv
                                        dom: 'Bfrtip',
                                        buttons: [{
                                            extend: 'csv',
                                            text: '<span class="btn btn-success"><i class="fa fa-file-excel-o"></i> CSV</span>',
                                            filename: 'Bundle Items',
                                            exportOptions: {
                                                columns: [0, 1, 2, 3, 4, 5]
                                            }
                                        }]
                                    });
                                }
                            })
                        }
                        reader.readAsText(file);
                    }
                })
</script>