function createPDF() {
    window.jsPDF = window.jspdf.jsPDF;
    var doc = new jsPDF();
    doc.setFontSize(15);
    var y = 5;
    var x = 180;

    doc.text(x, y, '1A');
    y = y + 10
    /*
    //create table
    doc.autoTable({
        startY: y,
        margin: {
            top: y,
            left: 10,
            right: 10,
            bottom: 25
        },
        head: [
            ['Product Name', 'Discount\nType', 'Discount\nAmount', 'Tax Rate', 'Tax\nAmount']
        ],
        body: [
            [data.product_name, data.creditnote_type, data.net_discount_amount, data.tax_rate + '%', data.discount_tax],
        ],
        foot: [
            ['Net Value', '', data.total_discount, '', data.discount_tax],
            [{
                content: data.amount_in_words,
                colSpan: 2
            }, '', {
                content: (data.tax_type == 'NO TAX') ? '' : 'Tax-Breakup ' + tax_breakup,
                colSpan: 2
            }]
        ],
        theme: 'plain',
        styles: {
            overflow: 'linebreak',
            fontSize: 8,
            rowHeight: 10,
            font: "helvetica",
            fontStyle: "normal",
            overflowColumns: false,
            columnWidth: 'wrap'
        },
        footStyles: {
            fontSize: 8,
            rowHeight: 10,
            font: "helvetica",
            fontStyle: "bold",
            overflowColumns: false,
            columnWidth: 'wrap',

        },
        columnStyles: {
            0: {
                columnWidth: 'auto'
            },
            1: {
                columnWidth: 'auto'
            },
            2: {
                columnWidth: 'auto'
            },
            3: {
                columnWidth: 'auto'
            },
            4: {
                columnWidth: 'auto'
            },
            5: {
                columnWidth: 'auto'
            },
        },
        headStyles: {
            fillColor: [255, 255, 255],
            textColor: [0, 0, 0],
            fontStyle: 'bold',
            fontSize: 8,
            font: "helvetica",
            rowHeight: 10,
        },
        bodyStyles: {
            fillColor: [255, 255, 255],
            textColor: [0, 0, 0],
            fontSize: 8,
            rowHeight: 10,
            font: "helvetica",
            overflow: 'linebreak',
            columnWidth: 'wrap'
        },
        showFoot: 'lastPage',
        willDrawCell: function(data) {
            // `data` - object containing the information of your cell, defined in jspdf.autoTable.defaults
            //
            doc.setDrawColor(120, 120, 120)
            doc.setLineWidth(.5);
            if (data.section === 'head') {

                doc.line(data.cell.x, data.cell.y, data.cell.x + data.cell.width, data.cell.y);
                switch (data.column.index) {
                    //make the side border of the table invisible
                    case 0:
                        data.cell.styles.halign = 'left';

                        break;
                    case 1:
                        data.cell.styles.halign = 'left';
                        break;
                    case 2:
                        data.cell.styles.halign = 'right';
                        break;
                    case 3:
                        data.cell.styles.halign = 'right';
                        break;
                    case 4:
                        data.cell.styles.halign = 'right';
                        break;

                }
            }

            //if row == 0
            if (data.section === 'body') {
                if (data.row.index === 0) {
                    doc.line(data.cell.x, data.cell.y, data.cell.x + data.cell.width, data.cell.y);

                }
            }

            doc.line(data.cell.x, data.cell.y + data.row.height, data.cell.x + data.cell.width, data.cell.y + data.row.height);

            if (data.section === 'body') {
                switch (data.column.index) {
                    //make the side border of the table invisible
                    case 0:
                        data.cell.styles.halign = 'left';
                        break;
                    case 1:
                        data.cell.styles.halign = 'left';
                        break;
                    case 2:
                        data.cell.styles.halign = 'right';
                        break;
                    case 3:
                        data.cell.styles.halign = 'right';
                        break;
                    case 4:
                        data.cell.styles.halign = 'right';
                        break;

                }
            }
            if (data.section === 'foot') {
                switch (data.column.index) {
                    //make the side border of the table invisible
                    case 0:
                        data.cell.styles.halign = 'left';

                        break;
                    case 2:
                        data.cell.styles.halign = 'right';
                        break;
                    case 3:
                        data.cell.styles.halign = 'right';
                        break;
                    case 4:
                        data.cell.styles.halign = 'right';
                        break;

                }
            }
        }
    })

    //get table height
    var tableHeight = doc.previousAutoTable.finalY;
    y = tableHeight + 10;
    //set Font Bold
    doc.setFont("Helvetica", "bold");
    doc.setFontSize(8);
    x = 159
    doc.text('For Solyd Ventures (P) Ltd.', x, y);
    doc.setFont("Helvetica", "normal");
    sign_y = y + 30
    doc.text('Authorised Signature', x, sign_y);

    x = 15
    doc.setFont("Helvetica", "bold");
    doc.text('Notes:', x, y);
    doc.setFont("Helvetica", "normal");
    doc.setFontSize(8);
    if (data.creditnote_type == 'VOLUME') {
        doc.text('Period: ' + data.from_date + ' To ' + data.to_date, x, y = y + 5);
        doc.text('Creditnote Date: ' + data.cn_date, x, y = y + 5);
    } else {
        doc.text('Invoice No: ' + data.invoice_code, x, y = y + 5);
        doc.text('Creditnote Date: ' + data.cn_date, x, y = y + 5);
        doc.text('Purpose: ' + data.purpose, x, y = y + 5);
    }


    //Add Footer

    doc.setFont("Helvetica", "normal");
    doc.setFontSize(7);
    for (var i = 1; i <= doc.internal.getNumberOfPages(); i++) {
        //Align Center
        doc.setPage(i);

        var pageSize = doc.internal.pageSize;
        var pageHeight = pageSize.height ?
            pageSize.height :
            pageSize.getHeight();

        doc.setDrawColor(120, 120, 120)
        doc.setLineWidth(.5);
        doc.line(10, pageHeight - 20, 200, pageHeight - 20);
        doc.text("SLOYD VENTURES (P) LTD, 1-11-251/19A. 4th Floor, Jayalakshmi Towers, Motilal Nehru Nagar, Begumpet, Hyderabad, Telangana, 500016, IN. \n|| CIN: U52390TG2012PTC083950 | PAN: AASCS2801C | Tel: +91-40-27900059 | Email: accounts@sloyd.in | web: www.ynew.in ||",
            25,
            pageHeight - 17
        );
        doc.text("Page " + doc.internal.getCurrentPageInfo().pageNumber + " of " + doc.internal.getNumberOfPages(),
            pageSize.width / 2,
            pageHeight - 5
        );
    }
    */

    window.open(doc.output('bloburl', 'discounts.pdf'));
    return false
}