<style>
    tr {
        height: 30px;
    }

    th,
    td {
        white-space: nowrap;
    }

    td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
        background-position-x: left;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
        background-position-x: left;
    }

    td.bundle_id {
        font-size: 0;
    }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons" style="margin:5px;">
    <label class="btn btn-primary active status-radio">
        <input type="radio" name="options" id="button_pending">PENDING
    </label>
    <label class="btn btn-primary status-radio">
        <input type="radio" name="options" id="button_active">ACTIVE
    </label>
    <label class="btn btn-primary status-radio">
        <input type="radio" name="options" id="button_inactive">INACTIVE
    </label>
    <label class="btn btn-primary status-radio">
        <input type="radio" name="options" id="button_sold">SOLD
    </label>
    <label class="btn btn-primary status-radio">
        <input type="radio" name="options" id="button_reserve">RESERVED
    </label>
    <label>
        <a class="btn btn-danger dropdown-toggle" style="height:35px" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">REPORT</a>
        <div class="btn dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuLink">
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadBundleReport('ALL')">ALL</a>
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadBundleReport('PENDING')">PENDING</a>
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadBundleReport('ACTIVE')">ACTIVE</a>
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadBundleReport('RESERVED')">RESERVED</a>
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadBundleReport('SOLD')">SOLD</a>
        </div>
    </label>
</div>
<div style="margin: 20px; display:inline-flex;" >
    <input type="text" placeholder="DEVICE ID" class="form-control" id="device_id_search_input">
    <input type="button" class="btn btn-red" id="device_id_search_button" value="SEARCH" style="margin-left: 5px;background-color:red; color:white">
</div>
<p style="line-height:10px;"></p>
<div class="table-responsive scrolledTable">
    <table class="table table-striped DataTables" style="margin-left:5px;" id="bundlesList_table">
        <thead>
            <tr>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>BUNDLE NO</th>
                <th>BUNDLE TYPE</th>
                <th>Quantity</th>
                <th>Amount</th>
                <th>Category</th>
                <th>Sub Category</th>
                <th>Status</th>
                <th>Created By</th>
                <th>LAST UPDATED BY</th>
                <th>CREATION<br> DATE</th>
                <th>LAST UPDATE<br> DATE</th>
            </tr>
        </thead>
    </table>
    <canvas id="barcode" style="width: 5px; height:10px;"></canvas>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://unpkg.com/jspdf-autotable@3.5.23/dist/jspdf.plugin.autotable.js"></script>
<script src="<?php echo base_url(); ?>assets/js/JsBarcode.all.js"></script>
<script>
    var department_id = getUserdata('department_id');

    function getUserdata(attribute) {

        var a = '';
        $.ajax({
            "url": "<?= base_url() ?>Web_api/getUserData/" + attribute,
            "type": "GET",
            "dataType": "json",
            "async": false,
            "success": function(data) {
                a = data.result;
            }
        })
        return a;
    }

    $(document).ready(function() {

        bundleList('PENDING')

        function bundleList(status, search_item = '') {
            bundleslist_table = $('#bundlesList_table').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "scrollY": 390,
                "scrollX": true,
                "scrollCollapse": true,
                //"autoWidth": false,
                "aaSorting": [],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Bundles/getBundlesList",
                    "data": {
                        "status": status
                    },
                    "type": "GET",
                    "dataSrc": "data"
                },
                "columns": [{
                        "className": 'details-control bundle_id',
                        "data": "bundle_id"
                    },
                    {},
                    {
                        "data": "bundle_no",
                    },
                    {
                        "data": "type"
                    },
                    {
                        "data": "quantity"
                    },
                    {
                        "data": "amount"
                    },
                    {
                        "data": "category"
                    },
                    {
                        "data": "sub_category"
                    },
                    {
                        "data": "status"
                    },
                    {
                        "data": "created_by"
                    },
                    {
                        "data": "updated_by"
                    },
                    {
                        "data": "created_date"
                    },
                    {
                        "data": "updated_date"
                    }
                ],

                "columnDefs": [{
                    "targets": 1,
                    "data": null,
                    "render": function(a, b, data, d) {
                        var a = ''
                        if (data.status == 'PENDING' && department_id == '5') {
                            a += '<a href="<?php echo base_url(); ?>admin/Bundles/updateBundleForm/' + data.bundle_id + '"><i class="fa fa-edit"></i></a>'
                        }

                        if (data.status == 'REJECTED' && department_id == '8') {
                            a += '<a href="<?php echo base_url(); ?>admin/Bundles/editBundleForm/' + data.bundle_id + '"><i class="fa fa-edit"></i></a>'
                        }

                            a += '<a href="#" onclick="getPDFData(' + data.bundle_id + ')"><i class="fa fa-file-pdf-o"></i></a>'
                        return a
                    }
                }],
                "initComplete": function(a, b) {
                  //Search with vaiable search_item on column 2
                  if(search_item.length>0 && typeof search_item == 'string'){
                    this.api().column(2).search(search_item).draw()
                    
                    $(".status-radio").each(function(){
                      if($(this).text().trim() == status){
                        $(this).addClass('active')
                      }
                    })
                  }
                },
            })
        }

        $('#bundlesList_table tbody').on('click', 'td.details-control', function() {
            var tr = $(this).closest('tr');
            var row = bundleslist_table.row(tr);

            if (row.child.isShown()) {
                row.child.hide();
                tr.removeClass('shown');
            } else {
                row.child(format(row.data())).show();
                tr.addClass('shown');
            }
        });

        $('#button_pending').change(function() {
            bundleList('PENDING')
        });

        $('#button_active').change(function() {
            bundleList('ACTIVE')
        });

        $('#button_inactive').change(function() {
            bundleList('INACTIVE')
        });

        $('#button_sold').change(function() {
            bundleList('SOLD')
        });

        $('#button_reserve').change(function() {
            bundleList('RESERVE')
        });

        $("#device_id_search_button").on('click',function(){
            let ref_id = $("#device_id_search_input").val()
            $('.btn-primary').removeClass('active')
            $.ajax({
                "url": "<?php echo base_url(); ?>admin/Bundles/getBundleInfoByDeviceId",
                "type": "GET",
                "dataType": "json",
                "data": {
                    "device_id": ref_id
                },
                "success": function(data) {
                    if(data.status == 1){
                        bundleList(data.result.status, data.result.bundle_no)
                    }
                }
            })
        })

        function remarks_table(bundles_id) {

            var tableData = '<br><p></p>';
            tableData += '<p style="text-align: left; margin-left: 15px; font-weight:700;">Remarks</p>';
            tableData += '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
            $.ajax({
                url: "<?php echo base_url(); ?>web_api/getRemarks/?id=" + bundles_id + "&type=bundle",
                type: "GET",
                dataType: 'json',
                async: false,
                success: function(data) {
                    if (data.status == 1) {
                        tableData += "<thead><th>Date</th><th>By</th><th>Remark</th></thead>"
                        $.each(data.remarks, function(i, v) {
                            tableData += "<tr><td>" + data.remarks[i].date + "</td><td>" + data.remarks[i].username + "</td><td>" + data.remarks[i].remark + "</td></tr>";
                        })
                    }
                }
            });
            tableData += '</table>'
            return tableData;
        }


        function format(d) {
            var childtable = '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
            $.ajax({
                url: encodeURI("<?php echo base_url(); ?>admin/Bundles/getBundleItems"),
                type: "GET",
                dataType: 'json',
                data: {
                    "bundle_id": d.bundle_id
                },
                async: false,
                success: function(data) {
                    if (data.data == null) {
                        childtable += '<tr><td>No Records Found</td></tr>';
                    } else {
                        childtable += '<tr><th>Device Id</th><th>Product Name</th><th>SKU</th><th>CATEGORY</th><th>Sub Category</th>';
                        childtable += '<th>Grade</th><th>Price</th><th>Remark</th></tr>';

                        $.each(data.data, function(i, d) { // loop through data returned from ajax 
                            childtable += '<tr>' +
                                '<td>' + data.data[i].nhdin + '</td>' +
                                '<td>' + data.data[i].device_name + '</td>' +
                                '<td>' + data.data[i].sku + '</td>' +
                                '<td>' + data.data[i].category + '</td>' +
                                '<td>' + data.data[i].sub_category + '</td>' +
                                '<td>' + data.data[i].grade + '</td>' +
                                '<td>' + data.data[i].price + '</td>' +
                                '<td>' + data.data[i].remark + '</td>' +
                                '</tr>';
                        });
                    }
                }
            });

            childtable += '</table>';
            childtable += '<br>'
            childtable += remarks_table(d.ecom_invoice_id)
            return childtable
        }

    });

    function getPDFData(bundle_id = 0) {

        if (bundle_id == null || bundle_id == undefined || bundle_id <= 0) {
            return false
        }

        $.ajax({
            url: encodeURI("<?php echo base_url(); ?>admin/Bundles/getPDFData"),
            type: "GET",
            dataType: 'json',
            data: {
                "bundle_id": bundle_id
            },
            async: false,
            success: function(data) {
                if (data.status != 1) {
                    toastr.error("Failed to get Bundle Details")
                    return false
                }
                createPDF(data.result)
            },
            error: function(data) {
                toastr.error("Failed to get Bundle Details")
                return false
            }
        })
    }

    function createPDF(data) {
        let total_mop = 0
        let items = []
        data.items.map(
            function(item) {
                let mop = item.mop
                if (isNaN(mop) || mop == null) {
                    mop = 0
                }
		let price = item.price
		if (isNaN(mop) || mop == null) {
                    price = 0
                }
                total_mop += parseFloat(price)
                items.push([item.sno, item.nhdin, item.device_name, item.ram, item.rom, item.color, price])
                return true
            }
        )

        window.jsPDF = window.jspdf.jsPDF;

        var doc = new jsPDF('l', 'mm', [145, 100]);
        doc.setFontSize(15);

        var y = 10;
        var x = 10;
        var js = JsBarcode("#barcode", data.bundle_no, {
            format: "CODE128",
            width: 1.5,
            height: 60

        });

        doc.setFontSize(15);
        var jpegUrl = $("#barcode")[0].toDataURL("image/jpeg");
        doc.addImage(jpegUrl, 'JPEG', 10, 2, 40, 15);

        x = 80;
        y = 10;
        doc.setFontSize(7);
        doc.text(x, y, data.bundle_date);

        doc.setFontSize(15);
        y = 10;
        x = 130;

        doc.text(x, y, data.bundle_type);
        doc.setFontSize(7);
        y = 17

        //create table
        doc.autoTable({
            startY: y,
            margin: {
                top: y,
                left: 10,
                right: 10,
                bottom: 2
            },
            head: [
                ['S.No', 'Device Id', 'Product Name', 'RAM', 'ROM', 'COLOR', 'MRP(INR)']
            ],
            body: items,
            foot: [
                [{
                    content: 'Total Amount',
                    colSpan: 6,
                }, total_mop.toFixed(2)],

            ],
            theme: 'plain',
            styles: {
                overflow: 'linebreak',
                fontSize: 6,
                rowHeight: 4,
                font: "helvetica",
                fontStyle: "normal",
                overflowColumns: false,
                columnWidth: 'wrap'
            },
            footStyles: {
                fontSize: 6,
                rowHeight: 6,
                font: "helvetica",
                fontStyle: "bold",
                overflowColumns: false,
                columnWidth: 'wrap',

            },
            columnStyles: {
                0: {
                    columnWidth: 'auto'
                },
                1: {
                    columnWidth: 'auto'
                },
                2: {
                    columnWidth: 'auto'
                },
                3: {
                    columnWidth: 'auto'
                },
                4: {
                    columnWidth: 'auto'
                },
                5: {
                    columnWidth: 'auto'
                },
            },
            headStyles: {
                fillColor: [255, 255, 255],
                textColor: [0, 0, 0],
                fontStyle: 'bold',
                fontSize: 6,
                font: "helvetica",
                rowHeight: 5,
            },
            bodyStyles: {
                fillColor: [255, 255, 255],
                textColor: [0, 0, 0],
                fontSize: 6,
                rowHeight: 4,
                font: "helvetica",
                overflow: 'linebreak',
                columnWidth: 'wrap'
            },
            showFoot: 'lastPage',
            willDrawCell: function(data) {
                // `data` - object containing the information of your cell, defined in jspdf.autoTable.defaults
                //
                doc.setDrawColor(120, 120, 120)
                doc.setLineWidth(.5);
                if (data.section === 'head') {

                    doc.line(data.cell.x, data.cell.y, data.cell.x + data.cell.width, data.cell.y);
                    switch (data.column.index) {
                        //make the side border of the table invisible
                        case 0:
                            data.cell.styles.halign = 'left';

                            break;
                        case 1:
                            data.cell.styles.halign = 'left';
                            break;
                        case 2:
                            data.cell.styles.halign = 'left';
                            break;
                        case 3:
                            data.cell.styles.halign = 'left';
                            break;
                        case 4:
                            data.cell.styles.halign = 'left';
                            break;
                        case 5:
                            data.cell.styles.halign = 'left';
                            break;
                        case 6:
                            data.cell.styles.halign = 'right';
                            break;

                    }
                }

                //if row == 0
                if (data.section === 'body') {
                    if (data.row.index === 0) {
                        doc.line(data.cell.x, data.cell.y, data.cell.x + data.cell.width, data.cell.y);
                    }
                }

                doc.line(data.cell.x, data.cell.y + data.row.height, data.cell.x + data.cell.width, data.cell.y + data.row.height);

                if (data.section === 'body') {
                    switch (data.column.index) {
                        //make the side border of the table invisible
                        case 0:
                            data.cell.styles.halign = 'left';
                            break;
                        case 1:
                            data.cell.styles.halign = 'left';
                            break;
                        case 2:
                            data.cell.styles.halign = 'left';
                            break;
                        case 3:
                            data.cell.styles.halign = 'left';
                            break;
                        case 4:
                            data.cell.styles.halign = 'left';
                            break;
                        case 5:
                            data.cell.styles.halign = 'left';
                            break;
                        case 6:
                            data.cell.styles.halign = 'right';
                            break;
                    }
                }
                if (data.section === 'foot') {
                    switch (data.column.index) {
                        //make the side border of the table invisible
                        case 0:
                            data.cell.styles.halign = 'left';
                            break;
                        case 2:
                            data.cell.styles.halign = 'right';
                            break;
                        case 3:
                            data.cell.styles.halign = 'right';
                            break;
                        case 4:
                            data.cell.styles.halign = 'right';
                            break;
                        case 5:
                            data.cell.styles.halign = 'right';
                            break;
                        case 6:
                            data.cell.styles.halign = 'right';
                            break;
                    }
                }
            }
        })
        window.open(doc.output('bloburl', 'discounts.pdf'));
        return false
    }

    function downloadBundleReport(status = ''){
        if(status == '') return false;

        var win = window.open('<?= base_url() ?>admin/Bundles/getBundleData?status=' + status, '_blank');
    }
</script>