<form method="post" class="form-horizontal">
	<div class="form-group table-responsive"> 	  
		<table style="margin-left:5px" id="rfsTable">
			<thead>
				<tr>
					<th>DEVICE ID</th>
					<th>PRODUCT</th>
					<th>SKU</th>
					<th>STOCK TYPE</th>					
					<th>GRADE</th>
					<th>REMARKS</th>
					<th>STATUS</th>
					<th>BIN NUMBER</th>					
					<th>IMEI1</th>
					<th>IMEI2</th>
				</tr>
			</thead>
			<tbody>
				<tr id="rfsRow">
					<td><input name="rfs_deviceid" value="" onchange="getCertifiedDevices(this)" style="width:120px" type="text"></td>
					<td><input name="rfs_product" value="" type="text" style="width:140px" disabled></td>
					<td><input name="rfs_sku" value="" type="text" style="width:140px" disabled></td>
					<td><input name="rfs_stocktype"  value="" type="text" style="width:100px" disabled></td>	
					<td><input name="rfs_grade"  value="" type="text" style="width:60px" disabled></td>	
					<td><input name="rfs_remarks" value="" type="text" style="border: 1" disabled></td>
				    <td><input name="rfs_status" value="" type="text" style="width:80px" disabled></td>
					<td><input name="rfs_bin" value="" type="text" onfocusout="addRowToRfsTable()" style="width:100px"></td>																
					<td><input name="rfs_imei1" value="" type="text" style="border: 1" disabled></td>
					<td><input name="rfs_imei2" value="" type="text" style="border: 1" disabled></td>					
				</tr>			
			</tbody>
		</table>
		<br>
	<p style="margin-left:5px" >Total Entries: <span id= "rfsTotalEntries"></span></p>
</div>
<hr style="border: 3px solid #e4eaec">
<div class="form-group">
	<label class="col-lg-3 control-label"></label>
	<div class="col-lg-6">
		<button type="submit" onclick="updateStatusToRFS(event)" class="btn btn-sm btn-primary">SUBMIT</button>
	</div>
</div>

</form>

<hr style="border: 3px solid #e4eaec">

<table class="form-group table-responsive table" style="margin-left:10px;">
	<tr>
		<td>BULK RFS UPLOAD</td>
		<td><input type="file" class="form-control-file custom-file-input" name="input_bulk_rfs_upload" id="input_bulk_rfs_upload"></td>
		<td colspan="9"><input type="button" class="btn btn-primary" value="UPDATE ONLY RFS" onclick="bulkRFSUpload(event)" /></td>
		<td colspan="9"><input type="button" class="btn btn-danger" value="UPDATE RFS WITH BIN" onclick="bulkBinUpload(event)" /></td>
	</tr>
</table>


<hr style="border: 3px solid #e4eaec">
							
<script>
	var i='<?php echo $totalCount; ?>';
	var rowCount = 0;
	
	function addRowToRfsTable()
	{ 
		var data = $('#rfsRow').html();
		$('#rfsTable').find('tbody').append("<tr>"+data+"</tr>");
		$('input[name$="rfs_deviceid"]:eq('+rowCount+')').focus();	
	}
 
	$(document).ready(function(){
		$('form').keydown(function (e) {
			if (e.keyCode == 13) {
				e.preventDefault();
				return false;
			}
		});	
	});
 
  	function getCertifiedDevices(x){   
	    console.log(x.value);
		var deviceid = x.value; 
		var row_id = $(x).closest('tr').index();
		rowCount = row_id + 1;
		
		$('input[name$="rfs_product"]:eq('+row_id+')').val('');
		$('input[name$="rfs_sku"]:eq('+row_id+')').val('');	
		$('input[name$="rfs_stocktype"]:eq('+row_id+')').val('');	
		$('input[name$="rfs_status"]:eq('+row_id+')').val('');	
		$('input[name$="rfs_imei1"]:eq('+row_id+')').val('');
		$('input[name$="rfs_imei2"]:eq('+row_id+')').val('');
		$('input[name$="rfs_grade"]:eq('+row_id+')').val('');
		$('input[name$="rfs_bin"]:eq('+row_id+')').val('');
		$('input[name$="rfs_remarks"]:eq('+row_id+')').val('');
		
		$.ajax({
			url: "<?php echo base_url(); ?>admin/certification/getDeviceDetails",
			dataType: 'json',
			data: {deviceid:deviceid},
			type: 'POST', 
			error: function(){ 
				$('.nhdinInvoiceLoader').css('display','none');
				toastr.error('Device not found !'); 	
				rfsTotalEntries()			  
			},
			success: function(data){
				if(data.status=='IN_STOCK'){
					// Test pass: IN_STOCK and UC are eligible for RFS
				}else if(data.status != 'IN_STOCK'){
					$('.nhdinInvoiceLoader').css('display','none');
					toastr.error('Device is not in "IN_STOCK" status');
					return;			
				}			
				
				
				$('input[name$="rfs_product"]:eq('+row_id+')').val(data.device_name);
				$('input[name$="rfs_status"]:eq('+row_id+')').val(data.status);
				$('input[name$="rfs_stocktype"]:eq('+row_id+')').val(data.stock_type);
				$('input[name$="rfs_imei1"]:eq('+row_id+')').val(data.imei1_no);
				$('input[name$="rfs_imei2"]:eq('+row_id+')').val(data.imei2_no);				
				$('input[name$="rfs_bin"]:eq('+row_id+')').val(data.bin_number);
				$('input[name$="rfs_remarks"]:eq('+row_id+')').val(data.remark);	
				$('input[name$="rfs_grade"]:eq('+row_id+')').val(data.certification_grade);	
				
				var sku='';
				if(data.ram){
					sku = sku+'-'+data.ram;
				}
				if(data.rom){
					sku = sku+'-'+data.rom;
				}
				if(data.color){
					sku = sku+'-'+data.color;
				}								
				$('input[name$="rfs_sku"]:eq('+row_id+')').val(data.nhmod+sku);	
				$('input[name$="rfs_bin"]:eq('+row_id+')').focus();	
				rfsTotalEntries()					
			}
        });			
	}
	
	function updateStatusToRFS(event){   
		event.preventDefault();
		
		var devices = [];
		var index;
		
		for(index=0;index<rowCount;index++){
			var deviceid = $('input[name$="rfs_deviceid"]:eq('+index+')').val();
			var bin_number = $('input[name$="rfs_bin"]:eq('+index+')').val();
			devices.push({'deviceid':deviceid, 'bin':bin_number});
		}
		
		var jsonObject = JSON.stringify(devices)
				
		$.ajax({
			// url: "<?php //echo base_url(); ?>admin/certification/updateStatusToRFS",
			url: "<?php echo base_url(); ?>admin/certification/bulkUpdateStatusToRFS",
			dataType: 'json',
		    data: jsonObject,
			type: 'POST', 
			error: function(){ 
				$('.nhdinInvoiceLoader').css('display','none');
				toastr.error('Upload failed.');
			},
			success: function(data){
			   	if (data.status) {
					toastr.success(data.message);
				} else {
					toastr.error(data.message);
				}
			}
        });			
	}
</script>
<script type="text/javascript" language="javascript">
	function bulkRFSUpload(e){
		e.preventDefault();
		var devices = [];
		var isValid = true;
		
		var fileUpload = document.getElementById("input_bulk_rfs_upload");
        var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;
        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
		        var reader = new FileReader();
                reader.onload = function (e) {
				    var rows = e.target.result.split("\n");
					for (var i = 1; i < rows.length; i++) {
						var cells = rows[i].split(",");
                    	
                    	if (cells.length > 1) {
							if (cells.length != 2) {
								alert("Only two columns should be there in uploaded file");
								isValid = false;
								return false;
							}

							devices.push({
								'deviceid': cells[0].toUpperCase(),
								'bin': cells[1].replace('\r', '')
							});
						}
					}
					if (!isValid) return false;

					$.each(devices, function(i, v) {
						if (v.deviceid == '') {
							alert('"Device ID" Error at row : ' + (i+1));
							isValid = false;
						} else if (v.bin != 0) {
							alert("Bin no. should be zero at row : " + (i+1));
							isValid = false;
						}
						if (!isValid) return false;   // Break Loop
					});
					if (!isValid) return false;   // Break Function
					
					$.ajax({
						url: '<?php echo base_url(); ?>admin/certification/bulkUpdateStatusToRFS',
						type: 'POST',
						data: JSON.stringify(devices),
						dataType: 'json',
						success:function(data){
							alert('Upload Success.');
						},
						error:function(data){
							alert('Upload failed.');
						}			
					});
		        }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }
 
	function bulkBinUpload(e){
		e.preventDefault();
		var devices = [];
		var isValid = true;
		
		var fileUpload = document.getElementById("input_bulk_rfs_upload");
        var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;
        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
		        var reader = new FileReader();
                reader.onload = function (e) {
				    var rows = e.target.result.split("\n");
					for (var i = 1; i < rows.length; i++) {
						var cells = rows[i].split(",");
						
                    	if (cells.length > 1) {
							if (cells.length != 2) {
								alert("Only two columns should be there in uploaded file");
								isValid = false;
								return false;
							}

							devices.push({
								'deviceid': cells[0].toUpperCase(),
								'bin': cells[1].replace('\r', '')
							});
						}
					}
					if (!isValid) return false;
					
					$.each(devices, function(i, v) {
						if (v.deviceid == '') {
							alert('"Device ID" Error at row : ' + (i+1));
							isValid = false;
						} else if (v.bin == 0) {
							alert("Bin no. shouldn't be zero at row : " + (i+1));
							isValid = false;
						}
						if (!isValid) return false;   // Break Loop
					});
					if (!isValid) return false;   // Break Function
					
					$.ajax({
						// url: '<?php //echo base_url(); ?>admin/certification/bulkUpdateBINNumber',
						url: '<?php echo base_url(); ?>admin/certification/bulkUpdateStatusToRFS',
						type: 'POST',
						data: JSON.stringify(devices),
						dataType: 'json',
						success:function(data){
							alert('Upload Success.');
						},
						error:function(data){
							alert('Upload failed.');
						}			
					});
		        }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

	function rfsTotalEntries(){
		var count = 0;
		for(index=0;index<rowCount;index++){
			var product = $('input[name$="rfs_product"]:eq('+index+')').val();
			if(product.length > 0){
				count = count+1
			}
		}

		$("#rfsTotalEntries").text(count)
	}
 
</script>	 
