<style>
	td.details-control {
		background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
		cursor: pointer;
	}

	tr.shown td.details-control {
		background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
	}

	tr {
		height: 30px;
	}

	th,
	td {
		white-space: nowrap;
	}
</style>
<div style="width: 100%; overflow-x:auto;">
	<table class="table table-striped DataTables" style="margin-left:5px;" id="deviceAgeListTable">
		<thead>
			<tr>
				<th></th>
				<th>DEVICE ID</th>
				<th>PRODUCT TYPE</th>
				<th>Brand</th>
				<th>PRODUCT</th>
				<th>SKU</th>
				<th>CATEGORY</th>
				<th>IS P2P</th>
				<th>SUB CATEGORY</th>
				<th>CATEGORY SUB TYPE</th>
				<th>SALE TYPE</th>
				<th>WSN NO</th>
				<th>BIN <br>NUMBER</th>
				<th>AGE <br>(IN DAYS)</th>
				<th>AGE BRACKET</th>
				<th>Certification AGE <br>(IN DAYS)</th>
				<th>Warehouse</th>
				<th>STATUS</th>
				<th>CERTIFIED <br>GRADE</th>
				<th>BAC</th>
				<th>ISSUED <br>GRADE</th>
				<th>ISSUED <br>DATE</th>
				<th>CERTIFIED <br>DATE</th>
				<th>BATCH NO</th>
				<th>SUB CATEGOTY</th>
			</tr>
		</thead>
	</table>
</div>
<script>
	$(document).ready(function() {
		getDeviceaAge()

		function getDeviceaAge() {
			table = $('#deviceAgeListTable').DataTable({
				"paging": true,
				"destroy": true,
				"searching": true,
				"processing": true,
				"serverSide": false,
				//"scrollY": 380,
				//"scrollX":true,
				//"scrollCollapse": true,
				dom: 'Bfrtip',
				buttons: [{
					"extend": 'csv',
					"text": '<span class="fa fa-file-excel-o" style="color:white;">&nbsp;CSV</span>',
					'className': 'btn btn-green',

					exportOptions: {
						columns: ':not(.details-control)'
					}
				}, ],
				"ajax": {
					"url": "<?php echo base_url(); ?>admin/certification/getDeviceDetailsByAge",
					"type": "POST",
					"data": {
						'status': status
					},
					"dataSrc": "data"
				},
				"columns": [{
						"className": 'details-control',
						"orderable": false,
						"data": null,
						"defaultContent": ''
					},
					{
						"data": "nhdin"
					},
					{
						"data": "product_type"
					},
					{
						"data": "product_brand"
					},
					{
						"data": "device_name"
					},
					{
						"data": function(data) {
							return data.nhmod + '-' + data.ram + '-' + data.rom + '-' + data.color;
						}
					},
					{
						"data": "stock_type"
					},
					{
						"data": "is_p2p"
					},
					{
						"data": "device_sub_category"
					},
					{
						"data": "stock_subtype"
					},
					{
						"data": "saletype"
					},
					{
						"data": "othervendor_id"
					},
					{
						"data": "bin_number"
					},
					{
						"data": "age"
					},
					{
						"data": "age_bracket"
					},
					{
						"data": function(data) {
							const startDate = data.issued_date;
							const endDate = new Date();

							if(startDate == null)
								return ''

							const diffInMs = new Date(endDate) - new Date(startDate)
							const diffInDays = Math.floor(diffInMs / (1000 * 60 * 60 * 24));
							if(diffInDays == NaN){
								return ''
							}
							return diffInDays
						}
					},
					{
						"data": "warehouse"
					},
					{
						"data": function(data) {
							const status = data.status;
							
							if(status == "LOST"){
								return "CLAIM"
							} else{
								return data.status
							}
						}
						
					},

					// {
					// 	"data": "status"
					// },
					{
						"data": "certification_grade"
					},
					{
						"data": "bac"
					},
					{
						"data": "issued_category"
					},
					{
						"data": "issued_date"
					},
					{
						"data": "certified_date"
					},
					{
						"data": "batch_no"
					},
					{
						"data": "batch_category"
					},
				]
			});


		}
	})
</script>