<!-- Form to Upload Multiple Images -->
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-primary" data-collapsed="0">
            <div class="panel-heading">
                <div class="panel-title">
                    <i class="entypo-plus-circled"></i>
                    Upload Open Box Images
                </div>
            </div>
            <div class="panel-body">
                <form action="<?php echo base_url(); ?>admin/assets_dealerapp/uploadOpenBoxImages" method="post" enctype="multipart/form-data" id="form-upload-openbox-images">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="field-1" class="control-label">Upload Images</label>
                                <input type="file" name="userfile[]" multiple="multiple" accept=".jpg" class="form-control" id="field-1" placeholder="Upload Images">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Upload</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('#form-upload-openbox-images').on('submit', function(e) {
            e.preventDefault();
            var form = $(this);
            var formData = new FormData(form[0]);

            // check uploaded files is jpg or not
            var files = $('#field-1')[0].files;
            console.log(files);
            var error = '';
            var form_error = false;
            for (var i = 0; i < files.length; i++) {
                var file = files[i];
                if (file.type != 'image/jpeg') {
                    toastr.error("You can only upload jpg files");
                    form_error = true;
                    break;
                }
                if (file.size > 1048576) {
                    toastr.error("You can only upload file up to 1 MB");
                    form_error = true;
                    break;
                }
            }

            if (form_error) {
                return false;
            }

            $.ajax({
                url: "<?php echo base_url(); ?>admin/Assets_dealerapp/uploadOpenBoxImages",
                type: "POST",
                data: formData,
                dataType: 'json',
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    if (response.status) {
                        toastr.success(response.message);
                        $('#form-upload-openbox-images')[0].reset();
                        location.reload();
                        return true;
                    } else {
                        toastr.error(response.message);
                        return false;
                    }
                }
            });
        });
    });
</script>
<!-- Form to Upload Multiple Images -->