<!-- Data Table With Image Name, Image, and Delete Button -->
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Images</h3>
            </div>
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped DataTables" style="width: 100%;" id="openbox_image_table">
                        <thead>
                            <tr>
                                <th>Image Name</th>
                                <th>Product Name</th>
                                <th>Image</th>
                                <th>Delete</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {

        function getImagesList() {
            $("#openbox_image_table").DataTable({
                "destroy": true,
                "processing": true,
                "serverSide": false,
                "pageLength": 10,
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/assets_dealerapp/openboxImagesList",
                    "dataType": "json",
                    "type": "POST",
                    "dataSrc": "data",
                    "data": {}
                },
                "columns": [{
                        "data": "image_name",
                        "className": "image_name_cls"
                    },
                    {
                        "data": "product_name"
                    },
                    {
                        "data": function(data) {
                            return '<img src="<?php echo base_url(); ?>assets/images/openbox/' + data.image_name + '.jpg" width="80" height="80">';
                        }
                    },
                    {
                        "data": function(data) {
                            return '<a href="#" class="btn btn-danger btn-xs" onclick="deleteOpenBoxImage(this)"><i class="fa fa-trash"></i></a>';
                        }
                    }
                ]
            });
        }
        getImagesList()
    })

    function deleteOpenBoxImage(e) {
        let image_name = $(e).closest('tr').find('.image_name_cls').text();
        
        $.ajax({
            url: "<?php echo base_url(); ?>admin/assets_dealerapp/deleteOpenBoxImage",
            type: "POST",
            data: {
                image_name: image_name
            },
            dataType: 'json',
            success: function(response) {
                if (response.status == '1') {
                    toastr.success(response.message);
                    // reload the page
                    location.reload();
                    return true
                } else {
                    toastr.error(response.message);
                    return false
                }
            }
        });
    }
</script>