<style>
    /* row 3x1 for small devices 3x3 for large devices */
    @media (max-width: 767px) {
        .row {
            flex-direction: column;
            margin-bottom: 10px;
        }

        .pane {
            margin-bottom: 10px;
            padding: auto;
        }
    }

    #modal_view_data .modal-dialog {
        width: 90%;
    }
    
    .left {
        text-align: left;
    }
    .right {
        text-align: right;
    }
    .center {
        text-align: center;
    }
    

    .cards_container .panel:nth-of-type(7) .panel-heading,
    .cards_container .panel:nth-of-type(1) .panel-heading {
        background-color: #7bacea;
    }
    .cards_container .panel:nth-of-type(8) .panel-heading,
    .cards_container .panel:nth-of-type(2) .panel-heading {
        background-color: #dfc96a;
    }
    .cards_container .panel:nth-of-type(3) .panel-heading {
        background-color: #6dda86;
    }
    .cards_container .panel:nth-of-type(4) .panel-heading {
        background-color: #b588e0;
    }
    .cards_container .panel:nth-of-type(5) .panel-heading {
        background-color: #e47b7b;
    }
    .cards_container .panel:nth-of-type(6) .panel-heading {
        background-color: #6bd4db;
    }
    .panel-row {
        display: flex;
        flex-wrap: wrap;
    }
    .panel {
        width: 100%;
        min-width: 340px;
        padding: 15px;
        border: none;
        box-shadow: none;
        display: flex;
        flex-direction: column;
    }
    .panel-row .panel .panel-heading {
        border-radius: 20px 20px 0 0;
        padding: 20px 20px 15px;
    }
    .panel-row .panel .panel-body {
        flex: 1 1 50%;
        border: 2px solid #ccc;
        border-top: none;
        border-radius: 0 0 20px 20px;
    }
    
    .panel-row .panel .panel-heading .title {
        display: inline-block;
        margin: 0;
    }
    .time_filter {
        display: inline-block;
        float: right;
    }
    .time_filter > span {
        display: inline-block;
    }
    .time_filter .date_show {
        margin-right: 15px;
    }
    .time_filter .span-period {
        /* background-color: #FFF; */
        color: #CCC;
        padding: 0;
    }
    .time_filter .time_period {
        background-color: #fff;
        display: inline-block;
        padding: 0 5px;
        min-width: 20px;
        text-align: center;
        color: #ccc;
        font-weight: 700;
        cursor: pointer;
        border-radius: 3px;
        font-size: 14px;
    }
    .time_filter .time_period.active {
        color: #f00;
        border-radius: 2px;
    }
    .time_filter .time_period:hover {
        background-color: #f85858;
        color: #fff;
        transform: scale(1, 1.1);
        border-radius: 2px;
    }

    .tfooter td {
        background-color: cadetblue;
        color: #FFF;
        padding: 5px;
        font-weight: 700;

    }
    
    .panel.main_search {
        width: 100%;
        display: block;
        background-color: #f4e4e4;
        border-radius: 15px;
    }
    .panel.main_search .time_filter {
        display: inline-block;
        float: none;
    }

    table tr th {
        background-color: #9fc5d4;
    }

    /* Spinner */
    .overlay {
        position: relative;
        top: 0;
        z-index: 100;
        min-width: 340px;
        max-width: 400px;
        height: 150px;
        display: none;
        background: rgba(250, 250, 250, 0.6);
        margin: auto;
    }
    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
    }
    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }
    @keyframes sp-anime {
        100% {
            transform: rotate(360deg);
        }
    }

    .is-hide {
        display: none;
    }


    /* .toggle__tr_zero {
        float: right;
        position: relative;
        top: -5px;
        cursor: pointer;
    } */

    .date_period {
        text-align: right;
    }
    .date_period .date_field {
        display: inline-block;
        border-radius: 5px;
    }
    .date_period .date_field + .date_field {
        margin-left: 10px;
    }

    table tbody tr {
        position: relative;
    }
    table tbody tr td .options_div {
        background-color: #9abcbaad;
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        text-align: right;
        /* display: flex;
        justify-content: space-evenly;
        align-items: center; */
    }
    table tbody tr td .options_div .btn {
        color: #1e0da9;
        font-size: 20px;
    }

    table tr th {
        text-transform: initial;
        padding: 5px 10px;
        line-height: 1.2;
    }
    table tr.tr_negative td {
        background-color: #f00;
        color: #fff;
    }
</style>


<!-- Page Spinner-->
<div class="page_spinner" style="display: none;">
    <div class="inner_block">
        <div class="spinner_element"></div>
    </div>
</div>

<div class="page_dashboard_variance_perc">

    <div class="page_heading" style="margin-top: -30px; padding: 0 30px;">
        <h3>Dashboard Variance %</h3>
    </div>

    <div class="page_search_filter" style="margin-bottom: 15px; padding: 0 20px;">

        <div class="panel main_search" data-card_type="all">
            <div class="row" style="display: flex; align-items: center">
                <div class="col-md-6">
                    <div class="periodic_search">
                        
                        <div class="time_filter">
                            <span class="date_show"></span>
                            <span class="span-period">
                                <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                                <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                                <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                                <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                                <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="date_period">
                        <input type="date" class="form-control date_field date_period_frm" style="width: 150px;">
                        <input type="date" class="form-control date_field date_period_to" style="width: 150px;">
                    </div>
                </div>
            </div>
        </div>
        
    </div>

    <div class="pane">
        <div class="panel-row cards_container">
            
            <div class="panel panel-warning sales_cw" data-card_type="sales_cw">
                <div class="panel-heading">
                    <h5 class="title">Sales - Category Wise</h5>
                    
                    <!-- <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div> -->
                </div>
                <div class="panel-body">
                    <table style="width: 100%;" class="table table-striped" id="sales_cw_tbl">
                        <tr class="thead">
                            <th class="left"></th>
                            <th class="center" colspan="2">Actuals</th>
                            
                            <th class="center" colspan="2">Budget</th>
                            
                            <th class="center" colspan="2">Variance</th>
                        </tr>
                        <tr class="thead">
                            <th class="left">Category</th>
                            <th class="right">Qty</th>
                            <th class="right">Amt</th>
                            
                            <th class="right">Qty</th>
                            <th class="right">Amt</th>
                            
                            <th class="right">Qty %</th>
                            <th class="right">Amt %</th>
                        </tr>
                    </table>
                    <div class="overlay">
                        <div class="cv-spinner">
                            <div class="spinner"></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel panel-success sales_sc" data-card_type="sales_sc">
                <div class="panel-heading">
                    <h5 class="title">Sales - Sales Channel Wise</h5>
                    
                    <!-- <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div> -->
                </div>
                <div class="panel-body">
                    <table style="width: 100%;" class="table table-striped" id="sales_sc_tbl">
                        <tr class="thead">
                            <th class="left"></th>
                            <th class="center" colspan="2">Actuals</th>
                            
                            <th class="center" colspan="2">Budget</th>
                            
                            <th class="center" colspan="2">Variance</th>
                        </tr>
                        <tr class="thead">
                            <th class="left">Category</th>
                            <th class="right">Qty</th>
                            <th class="right">Amt</th>
                            
                            <th class="right">Qty</th>
                            <th class="right">Amt</th>
                            
                            <th class="right">Qty %</th>
                            <th class="right">Amt %</th>
                        </tr>
                    </table>
                    <div class="overlay">
                        <div class="cv-spinner">
                            <div class="spinner"></div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="panel panel-info sales_o_sc" data-card_type="sales_o_sc">
                <div class="panel-heading">
                    <h5 class="title">Sales - Online Channel Wise</h5>
                    
                    <!-- <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div> -->
                </div>
                <div class="panel-body">
                    <table style="width: 100%;" class="table table-striped" id="sales_sc_o_tbl">
                        <tr>
                            <th class="left">Channel</th>
                            <!-- <th class="right">No. of<br>Invoices</th> -->
                            <th class="right">Qty</th>
                            <th class="right">Amt.</th>
                        </tr>
                    </table>
                    <div class="overlay">
                        <div class="cv-spinner">
                            <div class="spinner"></div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

</div>



<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment.min.js"></script>

<script>
    //get Current Url
    <?php if (base_url() == 'http://erp_new/') { ?>
        var base_url = "http://localhost:4007";
        // var base_url = "http://localhost:3000";
    <?php } else { ?>
        var base_url = "https://insight.sloyd.in";
    <?php } ?>
    
    const ERP_BASE_URL = '<?php echo base_url(); ?>';
    
    var panel_methods = {
        // 'purchase_cw': getPurchaseCategoryWiseData,
        'sales_cw': getSalesCategoryWiseData,
        'sales_sc': getSalesChannelWiseData,
        'sales_o_sc': getSalesOnlineChannelWiseData,
        // 'sr_cw': getSalesReturnStatusData,
        // 'claims_sw': getClaimsStatusData,
        // 'so_sw': getSalesOrderStatusData,
        // 'cert_sw': getCertificationStatusData
    };
    

    $(function() {
        // Calling all Functions 
        // $.each(panel_methods, function(i, v) {
        //     v();
        // });
        
        get_Budget_Data('D');

        // Set MainSearch DateFields with default dates
        set_DateFields_Search('D');
    });

    $('.panel .panel-heading .title').addClass('toggle__tr_zero');

    $('.toggle__tr_zero').on('click', function() {
        id = $(this).parents('.panel').find('table .tr_zero');
        if (id.is(':visible')) {
            id.hide();
            $(this).find('.fa').removeClass('fa-eye-slash').addClass('fa-eye');
        } else {
            id.show();
            $(this).find('.fa').removeClass('fa-eye').addClass('fa-eye-slash');
        }
    });

    $('.date_period').on('change', function() {
        $('.periodic_search .span-period span').removeClass('active');

        let period_type = 'CSTM';

        // $.each(panel_methods, function(i, v) {
        //     // v(period_type);
        // });

        get_Budget_Data(period_type);
    });
    
    function tables_common_functionality(table) {
        hide_zerovalue_tablerows(table);
        put_Download_Options(table);
    }
    
    function hide_zerovalue_tablerows(table) {
        table = (typeof table == 'object')? table : $(table);

        table.find('tr').each(function(i, v) {
            if (i == 0) return true;
            if ($(this).hasClass('thead')) return true;
            
            td_non_zero = 0;
            td_negative = 0;
            td_budget_nonzero = 0;
            $(this).find('td:nth-of-type(n+2)').each(function(i, v) {
                let is_currency = $(this).hasClass('currency');
                let num = parseFloat($(this).text().trim());
                if (num != 0) {
                    td_non_zero++;
                }
                if ((i>1 && i<4) && (num >0)) {
                    td_budget_nonzero++;
                }
                if ((i > 4) && (num < 100)) {
                    td_negative++;
                }
                // console.log('i ' + i);
                // console.log('num ' + num);
                // console.log('td_budget_nonzero-' + td_budget_nonzero);

                // console.log(num + ' --> ' + IND_Number_Format(num, is_currency) );
                // $(this).text( IND_Number_Format(num, is_currency) );
            });

            if (td_non_zero == 0 && (!$(this).hasClass('tfooter')) ) {
                $(this).addClass('tr_zero').hide();
            }
            if (td_negative > 0 && td_budget_nonzero > 0 && (!$(this).hasClass('tfooter')) ) {
                $(this).addClass('tr_negative');
            }
        });
    }

    function put_Download_Options(table) {
        table = (typeof table == 'object')? table : $(table);

        let html = '<span class="options_div" style="display:none;">'
                 + '  <span class="btn btn_view"> <i class="fa fa-eye" aria-hidden="true"></i> </span>'
                 + '  <span class="btn btn_download"> <i class="fa fa-download" aria-hidden="true"></i> </span>'
                 + '</span>';
        table.find('tbody tr td:nth-last-of-type(1)').append(html);

    }

    function IND_Number_Format(num, is_currency = false) {
        var options = {};
        if (is_currency) {
            options = {
                style: 'currency',
                currency: 'INR'
            }
        }
        const curr = num.toLocaleString('en-IN', options);
        return curr;
    }
    
    $(".span-period .time_period").on('click', (e) => {
        let card_type = $(e.target).parents('.panel').data('card_type');
        let period_type = $(e.target).data('tp').trim();

        $(e.target).parents('.span-period').find('.time_period').removeClass('active');
        
        if (card_type == 'all') {
            // $.each(panel_methods, function(i, v) {
            //     v(period_type);
            // });

            get_Budget_Data(period_type);
            
            $(e.target).addClass('active');
            
            // Set MainSearch DateFields with selected period dates
            set_DateFields_Search(period_type);

        } else {
            // panel_methods[card_type](period_type);

            // // Set MainSearch DateFields Empty
            // set_DateFields_Search();
        }
    });
    
    // Set MainSearch DateFields
    function set_DateFields_Search(period_type) {
        
        if (!isValidString(period_type)) {
            $('.date_period .date_period_frm').val('');
            $('.date_period .date_period_to').val('');
            $('.periodic_search .span-period span').removeClass('active');
        }

        if (isValidString(period_type)) {
            let period = getPeriod(period_type);
            let start_date = moment(period.start_date).format('YYYY-MM-DD');
            let end_date = moment(period.end_date).format('YYYY-MM-DD');
            
            $('.date_period .date_period_frm').val(start_date);
            $('.date_period .date_period_to').val(end_date);
        }
        
    }

    // Highlighting each card period type
    function highlight_PeriodType(table, period_type) {
        table = (typeof table == 'object')? table : $(table);

        let span_period = table.parents('.panel').find('.span-period span');
        span_period.removeClass('active');

        span_period.each(function(i, v) {
            if ($(this).text().trim() == period_type) {
                $(this).addClass('active');
            }
        });
    }
    

    //Convert Day/Week/Month/Quarter/Year to Start Date and End Date
    function getPeriod(period_type) {
        if (period_type == 'D') {
            start_date = moment().format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'W') {
            start_date = moment().startOf('week').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'M') {
            start_date = moment().startOf('month').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'Q') {
            // Get Financial Quarter
            start_date = moment().startOf('quarter').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'YTD') {
            //Start From First April
            start_date = moment().year(moment().year()).month(3).date(1).format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'CSTM') {
            start_date = $('.date_period .date_period_frm').val();
            end_date = $('.date_period .date_period_to').val();

            if (start_date == '') {
                start_date = moment().format('YYYY-MM-DD');
            }
            if (end_date == '') {
                end_date = moment().format('YYYY-MM-DD');
            }
            if (start_date == '' && end_date == '') {
                alert('Invalid Date Period');
                $('.periodic_search .span-period span:nth-of-type(1)').addClass('active');
            }
            
        } else {
            return false;
        }

        return {
            start_date: start_date,
            end_date: end_date
        }
    }

    function get_Budget_Data(period_type = 'D') {
        
        let period = getPeriod(period_type);
        
        $('.page_spinner').show();
        
        $.ajax({
            url: ERP_BASE_URL + '/admin/Reports/get_Budget_Data',
            type: 'POST',
            data: JSON.stringify(period),
            dataType: 'json',
            success: function(data) {
                $('.page_spinner').hide();
                
                console.log(JSON.stringify(data));

                getSalesCategoryWiseData(period_type, data.catg_wise);
                getSalesChannelWiseData(period_type, data.sc_wise);
            },
            error: function(data) {
                $('.page_spinner').hide();
                console.log(data);
            }
        });
    }

    function fill_SalesCategoryWise_Table(budget_data, actuals_data) {
        let device_cats = <?php echo json_encode(DEVICE_CATEGORY) ?>;
        // let device_cats = <?php //echo json_encode( array('PREXO', 'OPEN BOX') ) ?>;
        let total_count = 0;
        let total_amount_actuals = 0;
        let total_quantity_actuals = 0;
        
        let total_amount_budgt = 0;
        let total_quantity_budgt = 0;
        
        let total_amount = 0;
        let total_quantity = 0;
        
        // Remove all rows except first Two
        $('#sales_cw_tbl tr').slice(2).remove();

        device_cats.forEach((element) => {
            if (element == 'PRELOVED') {
                return true
            }
            let row = '<tr>'

            if (budget_data.hasOwnProperty('qty_' + element.replace(' ', '').toLowerCase())) {
                let budgt_qty = budget_data['qty_' + element.replace(' ', '').toLowerCase()];
                let budgt_rev = budget_data['rev_' + element.replace(' ', '').toLowerCase()];

                let actuals_qty = 0;
                let actuals_rev = 0;
                if (actuals_data.hasOwnProperty(element)) {
                    actuals_qty = actuals_data[element].quantity;
                    actuals_rev = actuals_data[element].amount;
                }

                let qty_diff = actuals_qty / budgt_qty * 100;
                let rev_diff = actuals_rev / budgt_rev * 100;

                row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                row += '<td class="right">' + actuals_qty + '</td>'
                row += '<td class="right currency">' + actuals_rev.toFixed(2) + '</td>';
                
                row += '<td class="right">' + budgt_qty + '</td>'
                row += '<td class="right currency">' + budgt_rev.toFixed(2) + '</td>';

                row += '<td class="right">' + qty_diff.toFixed(2) + '</td>'
                row += '<td class="right currency">' + rev_diff.toFixed(2) + '</td>';
                
                
                total_quantity_actuals += + actuals_qty;
                total_amount_actuals += + actuals_rev.toFixed(2);
                
                total_quantity_budgt += + budgt_qty;
                total_amount_budgt += + budgt_rev.toFixed(2);
                
                total_quantity += + qty_diff;
                total_amount += + rev_diff.toFixed(2);

            } else {
                row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                row += '<td class="right">0</td>'
                row += '<td class="right currency">0</td>'
                
                row += '<td class="right">0</td>'
                row += '<td class="right currency">0</td>'
                
                row += '<td class="right">0</td>'
                row += '<td class="right currency">0</td>'
            }
            
            row += '</tr>'
            $('#sales_cw_tbl').append(row)
        })

        let row = '<tr class="tfooter">'
        row += '<td class="left row_element" data-element="">Total</td>'
        row += '<td class="right">' + total_quantity_actuals + '</td>'
        row += '<td class="right currency">' + total_amount_actuals.toFixed(2) + '</td>'
        
        row += '<td class="right">' + total_quantity_budgt + '</td>'
        row += '<td class="right currency">' + total_amount_budgt.toFixed(2) + '</td>'
        
        row += '<td class="right">' + total_quantity.toFixed(2) + '</td>'
        row += '<td class="right currency">' + total_amount.toFixed(2) + '</td>'
        
        row += '</tr>'

        $('#sales_cw_tbl').parent().find('div.overlay').fadeOut(100)
        $('#sales_cw_tbl').append(row);

        tables_common_functionality('#sales_cw_tbl');
    }

    function fill_SalesChannelWise_Table(budget_data, actuals_data, type = 'offline') {
        let channels = ['OFFLINE', 'ONLINE', 'DEALERAPP', 'EXPORT'];
        // let channels = ['OFFLINE', 'ONLINE'];

        if (type == 'online') {
            channels = <?= json_encode(ONLINE_CHANNELS) ?>;
            channels.splice(2, 0, 'FBA');

            // Remove all rows except first Two
            $('#sales_sc_o_tbl tr').slice(2).remove();
            // $('#sales_sc_o_tbl').parent().find('div.overlay').fadeIn(100);
        } else {
            // Remove all rows except first Two
            $('#sales_sc_tbl tr').slice(2).remove();
            // $('#sales_sc_tbl').parent().find('div.overlay').fadeIn(100)

        }

        let total_count = 0;
        let total_amount_actuals = 0;
        let total_quantity_actuals = 0;
        
        let total_amount_budgt = 0;
        let total_quantity_budgt = 0;

        let total_amount = 0;
        let total_quantity = 0;

        channels.forEach((element) => {
            if ( $.inArray(element, ['PRELOVED', 'DEALERAPP']) != -1 ) {
                return true
            }

            let row = '<tr>';

            if (budget_data.hasOwnProperty('qty_' + element.toLowerCase())) {
                let budgt_qty = budget_data['qty_' + element.toLowerCase()];
                let budgt_rev = budget_data['rev_' + element.toLowerCase()];

                let actuals_qty = 0;
                let actuals_rev = 0;
                if (actuals_data.hasOwnProperty(element)) {
                    actuals_qty = actuals_data[element].quantity;
                    actuals_rev = actuals_data[element].amount;
                }

                let qty_diff = actuals_qty / budgt_qty * 100;
                let rev_diff = actuals_rev / budgt_rev * 100;

                row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                row += '<td class="right">' + actuals_qty + '</td>'
                row += '<td class="right currency">' + actuals_rev.toFixed(2) + '</td>';
                
                row += '<td class="right">' + budgt_qty + '</td>'
                row += '<td class="right currency">' + budgt_rev.toFixed(2) + '</td>';

                row += '<td class="right">' + qty_diff.toFixed(2) + '</td>'
                row += '<td class="right currency">' + rev_diff.toFixed(2) + '</td>'

                total_quantity_actuals += + actuals_qty;
                total_amount_actuals += + actuals_rev.toFixed(2);
                
                total_quantity_budgt += + budgt_qty;
                total_amount_budgt += + budgt_rev.toFixed(2);
                
                total_quantity += + qty_diff;
                total_amount += + rev_diff.toFixed(2);
            } else {
                row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                row += '<td class="right">0</td>'
                row += '<td class="right currency">0</td>'
                
                row += '<td class="right">0</td>'
                row += '<td class="right currency">0</td>'
                
                row += '<td class="right">0</td>'
                row += '<td class="right currency">0</td>'
            }
            row += '</tr>'

            if (type == 'online') {
                $('#sales_sc_o_tbl').append(row)
            } else {
                $('#sales_sc_tbl').append(row)
            }

        })

        let row = '<tr class="tfooter">'
        row += '<td class="left row_element" data-element="">Total</td>'
        row += '<td class="right">' + total_quantity_actuals + '</td>'
        row += '<td class="right currency">' + total_amount_actuals.toFixed(2) + '</td>'
        
        row += '<td class="right">' + total_quantity_budgt + '</td>'
        row += '<td class="right currency">' + total_amount_budgt.toFixed(2) + '</td>'
        
        row += '<td class="right">' + total_quantity.toFixed(2) + '</td>'
        row += '<td class="right currency">' + total_amount.toFixed(2) + '</td>'
        
        row += '</tr>'

        if (type == 'online') {
            $('#sales_sc_o_tbl').parent().find('div.overlay').fadeOut(100)
            $('#sales_sc_o_tbl').append(row)
            tables_common_functionality('#sales_sc_o_tbl');
        } else {
            $('#sales_sc_tbl').parent().find('div.overlay').fadeOut(100)
            $('#sales_sc_tbl').append(row)
            tables_common_functionality('#sales_sc_tbl');
        }
    }


    function getSalesCategoryWiseData(date_period = 'D', budget_data) {
        highlight_PeriodType('#sales_cw_tbl', date_period);
        // Remove all rows except first Two
        $('#sales_cw_tbl tr').slice(2).remove();
        $('#sales_cw_tbl').parent().find('div.overlay').fadeIn(100)
        let period = getPeriod(date_period)

        if (!period) return false;

        let start_date = moment(period.start_date).format('DD/MM/YYYY');
        let end_date = moment(period.end_date).format('DD/MM/YYYY');
        $('#sales_cw_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
        
        // let csv_url = 'admin/Reports/downloadCsvReportsInvoiceItemWithPurchase';
        // let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        // let to_date = moment(period.end_date).format('YYYY-MM-DD');
        // $('#sales_cw_tbl tbody').attr('data-frm_date', frm_date);
        // $('#sales_cw_tbl tbody').attr('data-to_date', to_date);
        // $('#sales_cw_tbl tbody').attr('data-csv_url', csv_url);
        // $('#sales_cw_tbl tbody').attr('data-element_type', 'catg');


        let jsonObject = JSON.stringify(period);

        $.ajax({
            url: encodeURI(base_url + '/sales/sales_category_wise'),
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                fill_SalesCategoryWise_Table(budget_data, data);
            },
            error: function(error) {
                $('#sales_cw_tbl').parent().find('div.overlay').fadeOut(100)
                console.log(error)
            }
        })
        
    }

    function getSalesOnlineChannelWiseData(period_type = 'D', budget_data) {
        getSalesChannelWiseData(period_type, budget_data, 'online')
    }
    function getSalesChannelWiseData(date_period = 'D', budget_data, type = 'offline') {
        let period = getPeriod(date_period)
        let url = encodeURI(base_url + '/sales/sales_channel_wise')
        let start_date = moment(period.start_date).format('DD/MM/YYYY');
        let end_date = moment(period.end_date).format('DD/MM/YYYY');

        let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        let to_date = moment(period.end_date).format('YYYY-MM-DD');

        if (type == 'online') {
            highlight_PeriodType('#sales_sc_o_tbl', date_period);
            url = encodeURI(base_url + '/sales/sales_channel_wise/' + type)
            // Remove all rows except first Two
            $('#sales_sc_o_tbl tr').slice(2).remove();
            $('#sales_sc_o_tbl').parent().find('div.overlay').fadeIn(100)
            $('#sales_sc_o_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
            
            let csv_url = 'admin/Reports/downloadCsvReportsInvoiceItemWithPurchase';
            $('#sales_sc_o_tbl tbody').attr('data-frm_date', frm_date);
            $('#sales_sc_o_tbl tbody').attr('data-to_date', to_date);
            $('#sales_sc_o_tbl tbody').attr('data-csv_url', csv_url);
            $('#sales_sc_o_tbl tbody').attr('data-element_type', 'scw_o');
        } else {
            highlight_PeriodType('#sales_sc_tbl', date_period);
            // Remove all rows except first Two
            $('#sales_sc_tbl tr').slice(2).remove();
            $('#sales_sc_tbl').parent().find('div.overlay').fadeIn(100)
            $('#sales_sc_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
            
            let csv_url = 'admin/Reports/downloadCsvReportsInvoiceItemWithPurchase';
            $('#sales_sc_tbl tbody').attr('data-frm_date', frm_date);
            $('#sales_sc_tbl tbody').attr('data-to_date', to_date);
            $('#sales_sc_tbl tbody').attr('data-csv_url', csv_url);
            $('#sales_sc_tbl tbody').attr('data-element_type', 'scw');
        }

        if (!period) return false;


        let jsonObject = JSON.stringify(period)

        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                fill_SalesChannelWise_Table(budget_data, data);
            },
            error: function(error) {
                if (type == 'online') {
                    $('#sales_sc_o_tbl').parent().find('div.overlay').fadeOut(100)
                } else {
                    $('#sales_sc_tbl').parent().find('div.overlay').fadeOut(100)
                }
                console.log(error)
            }
        });

    }


</script>