<style>
    /* row 3x1 for small devices 3x3 for large devices */
    @media (max-width: 767px) {
        .row {
            flex-direction: column;
            margin-bottom: 10px;
        }

        .pane {
            margin-bottom: 10px;
            padding: auto;
        }
    }

    #modal_view_data .modal-dialog {
        width: 90%;
    }
    
    .left {
        text-align: left;
    }
    .right {
        text-align: right;
    }
    .center {
        text-align: center;
    }
    

    .cards_container .panel:nth-of-type(7) .panel-heading,
    .cards_container .panel:nth-of-type(1) .panel-heading {
        background-color: #7bacea;
    }
    .cards_container .panel:nth-of-type(8) .panel-heading,
    .cards_container .panel:nth-of-type(2) .panel-heading {
        background-color: #dfc96a;
    }
    .cards_container .panel:nth-of-type(3) .panel-heading {
        background-color: #6dda86;
    }
    .cards_container .panel:nth-of-type(4) .panel-heading {
        background-color: #b588e0;
    }
    .cards_container .panel:nth-of-type(5) .panel-heading {
        background-color: #e47b7b;
    }
    .cards_container .panel:nth-of-type(6) .panel-heading {
        background-color: #6bd4db;
    }
    .panel-row {
        display: flex;
        flex-wrap: wrap;
    }
    .panel {
        width: 100%;
        min-width: 340px;
        padding: 15px;
        border: none;
        box-shadow: none;
        display: flex;
        flex-direction: column;
    }
    .panel-row .panel .panel-heading {
        border-radius: 20px 20px 0 0;
        padding: 20px 20px 15px;
    }
    .panel-row .panel .panel-body {
        flex: 1 1 50%;
        border: 2px solid #ccc;
        border-top: none;
        border-radius: 0 0 20px 20px;
    }
    
    .panel-row .panel .panel-heading .title {
        display: inline-block;
        margin: 0;
    }
    .time_filter {
        display: inline-block;
        float: right;
    }
    .time_filter > span {
        display: inline-block;
    }
    .time_filter .date_show {
        margin-right: 15px;
    }
    .time_filter .span-period {
        /* background-color: #FFF; */
        color: #CCC;
        padding: 0;
    }
    .time_filter .time_period {
        background-color: #fff;
        display: inline-block;
        padding: 0 5px;
        min-width: 20px;
        text-align: center;
        color: #ccc;
        font-weight: 700;
        cursor: pointer;
        border-radius: 3px;
        font-size: 14px;
    }
    .time_filter .time_period.active {
        color: #f00;
        border-radius: 2px;
    }
    .time_filter .time_period:hover {
        background-color: #f85858;
        color: #fff;
        transform: scale(1, 1.1);
        border-radius: 2px;
    }
    .periodic_search.not_all_affected .time_filter .time_period.active {
        color: #ccc;
        border-radius: 3px;
    }

    .tfooter td {
        background-color: cadetblue;
        color: #FFF;
        padding: 5px;
        font-weight: 700;

    }
    
    .page_search_filter.element_sticky {
        position: fixed;
        top: 56px;
        width: 80%;
        z-index: 100;
    }
    .panel.main_search {
        width: 100%;
        display: block;
        background-color: #f4e4e4;
        border-radius: 15px;
    }
    .panel.main_search .time_filter {
        display: inline-block;
        float: none;
    }

    table tr th {
        background-color: #9fc5d4;
    }

    /* Spinner */
    .overlay {
        position: relative;
        top: 0;
        z-index: 100;
        min-width: 340px;
        max-width: 400px;
        height: 150px;
        display: none;
        background: rgba(250, 250, 250, 0.6);
        margin: auto;
    }
    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
    }
    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }
    @keyframes sp-anime {
        100% {
            transform: rotate(360deg);
        }
    }

    .is-hide {
        display: none;
    }


    /* .toggle__tr_zero {
        float: right;
        position: relative;
        top: -5px;
        cursor: pointer;
    } */

    .date_period {
        text-align: right;
    }
    .date_period .date_field {
        display: inline-block;
        border-radius: 5px;
    }
    .date_period .date_field + .date_field {
        margin-left: 10px;
    }
    
    .date_period.not_all_affected .date_field {
        background-color: #e76767;
        color: #fff;
    }
    .dates_rel {
        margin: 5px;
        cursor: pointer;
        color: #999;
    }
    .dates_rel.active {
        color: #f00;
        transform: scale(1.5);
    }

    table tbody tr {
        position: relative;
    }
    table tbody tr td .options_div {
        background-color: #9abcbaad;
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        text-align: right;
        /* display: flex;
        justify-content: space-evenly;
        align-items: center; */
    }
    table tbody tr td .options_div .btn {
        color: #1e0da9;
        font-size: 20px;
    }

    table tr th {
        text-transform: initial;
        padding: 5px 10px;
        line-height: 1.2;
    }
    table tr.tr_negative td {
        background-color: #f00;
        color: #fff;
    }

    
    /** Auto-Refresh DIV CSS */
    .auto_refresh_div {
        display: inline-block;
        position: fixed;
        top: 50px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 500;
        text-transform: initial;
    }
    .auto_refresh_info {
        text-align: center;
        background-color: #aeffe1;
        color: #666;
        padding: 10px 15px;
        border-radius: 10px;
        display: flex;
        align-items: center;
    }
    .auto_refresh_info .last_updated_info p.lbl {
        margin: 0;
        font-size: 12px;
        line-height: 1;
        margin-bottom: 3px;
        letter-spacing: 1px;
        font-style: italic;
    }
    .auto_refresh_info .last_updated_info .last_updated_at {
        margin: 0;
        line-height: 1;
        font-size: 16px;
        color: #c52b2b;
        font-weight: bold;
    }
    .auto_refresh_info .switch_refresh {
        margin-left: 15px;
    }
    .auto_refresh_div .alert_info {
        color: #fff;
        background-color: #f00;
        border-radius: 5px;
        text-align: center;
    }
    .auto_refresh_div .alert_info .msg {
        animation: anim_flash 1s linear infinite;
    }
    .auto_refresh_div .alert_info .close {
        font-size: 14px;
        margin-right: 15px;
        margin-top: 3px;
    }
    .auto_refresh_div .alert_info .close .fa {
        color: #000;
    }
    @keyframes anim_flash {
        0%, 50%, 100% {
            opacity: 1;
        }
        25%, 75% {
            opacity: 0;
        }
    }

    /* table th.lbl_amt {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    } */
    table th.lbl_amt span:nth-of-type(2) {
        font-size: 10px;
        position: absolute;
        bottom: 0px;
        display: none;
    }
    table tr td:nth-of-type(n+2) {
        font-size: 16px;
        font-weight: bold;
    }
</style>

<!-- Slider Switch CSS -->
<style>
    .slider_switch {
    position: relative;
    display: inline-block;
    width: 45px;
    height: 20px;
    }

    .slider_switch input { 
    opacity: 0;
    width: 0;
    height: 0;
    }

    .slider_switch .sw_slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    -webkit-transition: .4s;
    transition: .4s;
    }

    .slider_switch .sw_slider:before {
    position: absolute;
    content: "";
    height: 15px;
    width: 15px;
    left: 2px;
    bottom: 2px;
    background-color: white;
    -webkit-transition: .4s;
    transition: .4s;
    }

    .slider_switch input:checked + .sw_slider {
    background-color: #2196F3;
    }

    .slider_switch input:focus + .sw_slider {
    box-shadow: 0 0 1px #2196F3;
    }

    .slider_switch input:checked + .sw_slider:before {
    -webkit-transform: translateX(26px);
    -ms-transform: translateX(26px);
    transform: translateX(26px);
    }

    /* Rounded sliders */
    .slider_switch .sw_slider.round {
    border-radius: 34px;
    }

    .slider_switch .sw_slider.round:before {
    border-radius: 50%;
    }
</style>


<!-- Page Spinner-->
<div class="page_spinner" style="display: none;">
    <div class="inner_block">
        <div class="spinner_element"></div>
    </div>
</div>

<div class="page_dashboard_variance">

    <div class="page_heading" style="margin-top: -30px; padding: 0 30px;">
        <h3>Dashboard Variance</h3>
    </div>

    
    <div class="auto_refresh_div">
        <div class="auto_refresh_info">
            <div class="last_updated_info">
                <p class="lbl">Last Refreshed at: </p>
                <p class="last_updated_at"></p>
            </div>

            <label class="slider_switch switch_refresh">
                <input type="checkbox" checked>
                <span class="sw_slider round"></span>
            </label>
        </div>

        <p class="alert_info" style="display: none;">
            <span class="msg">Auto-Refresh is Disabled</span>
            <span class="close"><i class="fa fa-times" aria-hidden="true"></i></span>
        </p>
    </div>

    <div class="page_search_filter" style="margin-bottom: 15px; padding: 0 20px;">

        <div class="panel main_search" data-card_type="all">
            <div class="row" style="display: flex; align-items: center">
                <div class="col-md-6">
                    <div class="periodic_search">
                        
                        <div class="time_filter">
                            <span class="date_show"></span>
                            <span class="span-period">
                                <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                                <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                                <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                                <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                                <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="date_period">
                        <input type="date" class="form-control date_field date_period_frm" style="width: 150px;">
                        <span class="dates_rel fa fa-arrows-h" aria-hidden="true" style="margin: 5px; cursor: pointer;"></span>
                        <input type="date" class="form-control date_field date_period_to" style="width: 150px;">
                    </div>
                </div>
            </div>
        </div>
        
    </div>

    <p style="color: red; margin: 5px 15px; text-transform: initial;">NOTE: Amount displayed in Lakh</p>

    <div class="pane">
        <div class="panel-row cards_container">
            
            <div class="panel panel-warning sales_cw" data-card_type="sales_cw">
                <div class="panel-heading">
                    <h5 class="title">Sales - Category Wise</h5>
                    
                    <!-- <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div> -->
                </div>
                <div class="panel-body">
                    <table style="width: 100%;" class="table table-striped" id="sales_cw_tbl">
                        <tr class="thead">
                            <th class="left"></th>
                            <th class="center" colspan="2">Actuals</th>
                            
                            <th class="center" colspan="2">Budget</th>
                            
                            <th class="center" colspan="2">Variance Abs</th>
                            <th class="center" colspan="2">Variance %</th>
                        </tr>
                        <tr class="thead">
                            <th class="left">Category</th>
                            <th class="right">Qty</th>
                            <th class="right lbl_amt"><span>Amt</span> <span>(lakhs)</span></th>
                            
                            <th class="right">Qty</th>
                            <th class="right lbl_amt"><span>Amt</span> <span>(lakhs)</span></th>
                            
                            <th class="right">Qty</th>
                            <th class="right lbl_amt"><span>Amt</span> <span>(lakhs)</span></th>
                            
                            <th class="right">Qty %</th>
                            <th class="right">Amt %</th>
                        </tr>
                    </table>
                    <div class="overlay">
                        <div class="cv-spinner">
                            <div class="spinner"></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel panel-success sales_sc" data-card_type="sales_sc">
                <div class="panel-heading">
                    <h5 class="title">Sales - Sales Channel Wise</h5>
                    
                    <!-- <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div> -->
                </div>
                <div class="panel-body">
                    <table style="width: 100%;" class="table table-striped" id="sales_sc_tbl">
                        <tr class="thead">
                            <th class="left"></th>
                            <th class="center" colspan="2">Actuals</th>
                            
                            <th class="center" colspan="2">Budget</th>
                            
                            <th class="center" colspan="2">Variance Abs</th>
                            <th class="center" colspan="2">Variance %</th>
                        </tr>
                        <tr class="thead">
                            <th class="left">Category</th>
                            <th class="right">Qty</th>
                            <th class="right lbl_amt"><span>Amt</span> <span>(lakhs)</span></th>
                            
                            <th class="right">Qty</th>
                            <th class="right lbl_amt"><span>Amt</span> <span>(lakhs)</span></th>
                            
                            <th class="right">Qty</th>
                            <th class="right lbl_amt"><span>Amt</span> <span>(lakhs)</span></th>
                            
                            <th class="right">Qty %</th>
                            <th class="right">Amt %</th>
                        </tr>
                    </table>
                    <div class="overlay">
                        <div class="cv-spinner">
                            <div class="spinner"></div>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </div>

</div>



<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment.min.js"></script>

<script>
    //get Current Url
    <?php if (base_url() == 'http://erp_new/') { ?>
        var base_url = "http://localhost:4007";
        // var base_url = "http://localhost:3000";
    <?php } else { ?>
        var base_url = "https://insight.sloyd.in";
    <?php } ?>
    
    const ERP_BASE_URL = '<?php echo base_url(); ?>';
    
    var panel_methods = {
        // 'purchase_cw': getPurchaseCategoryWiseData,
        'sales_cw': getSalesCategoryWiseData,
        'sales_sc': getSalesChannelWiseData,
        // 'sales_o_sc': getSalesOnlineChannelWiseData,
        // 'sr_cw': getSalesReturnStatusData,
        // 'claims_sw': getClaimsStatusData,
        // 'so_sw': getSalesOrderStatusData,
        // 'cert_sw': getCertificationStatusData
    };
    
    const AUTO_REFRESH_TIME = 15 * 60 * 1000; // 15 Minutes

    $(function() {
        // get_Budget_Data('D');

        // Set MainSearch DateFields with default dates
        set_DateFields_Search('D');
    });

    $(window).on('scroll', function() {
        let window_scrollTop = $(window).scrollTop();
        let element_offset_Top = $('.page_search_filter').offset().top;

        if (window_scrollTop >= 30) {
            $('.page_search_filter').addClass('element_sticky');
        } else {
            $('.page_search_filter').removeClass('element_sticky');
        }
    });
    
    $('.panel .panel-heading .title').addClass('toggle__tr_zero');

    $('.toggle__tr_zero').on('click', function() {
        id = $(this).parents('.panel').find('table .tr_zero');
        if (id.is(':visible')) {
            id.hide();
            $(this).find('.fa').removeClass('fa-eye-slash').addClass('fa-eye');
        } else {
            id.show();
            $(this).find('.fa').removeClass('fa-eye').addClass('fa-eye-slash');
        }
    });

    $('.dates_rel').off().on('click', function() {
        if ($(this).hasClass('active')) {
            $(this).removeClass('active');
        } else {
            $(this).addClass('active');

            let parent = $(this).parents('.date_period');
            let dt_frm = parent.find('.date_period_frm');
            let dt_to = parent.find('.date_period_to');
            if (dt_frm.val().trim() != '') {
                dt_to.val(dt_frm.val().trim()).trigger('change');
            } else if (dt_to.val().trim() != '') {
                dt_frm.val(dt_to.val().trim()).trigger('change');
            }
        }
    });

    $('.date_period .date_field').on('change', function() {
        $('.periodic_search .span-period span').removeClass('active');

        let parent = $(this).parents('.date_period');

        if (parent.find('.dates_rel').hasClass('active')) {
            $('.date_period .date_field').val( $(this).val() );
        }

        Do_Custom_MainSearch();
    });
    
    $(".span-period .time_period").on('click', (e) => {
        let card_type = $(e.target).parents('.panel').data('card_type');
        let period_type = $(e.target).data('tp').trim();

        $(e.target).parents('.span-period').find('.time_period').removeClass('active');
        
        if (card_type == 'all') {
            $(e.target).addClass('active');
            $('.dates_rel').removeClass('active');
            
            // Set MainSearch DateFields with selected period dates
            set_DateFields_Search(period_type);

        } else {
            // panel_methods[card_type](period_type);

            // // Set MainSearch DateFields Empty
            // set_DateFields_Search();
        }
    });
    
    // Set MainSearch DateFields
    function set_DateFields_Search(period_type) {
        
        if (!isValidString(period_type)) {
            $('.date_period, .periodic_search').addClass('not_all_affected');
        }

        if (isValidString(period_type)) {
            let period = getPeriod(period_type);
            let start_date = moment(period.start_date).format('YYYY-MM-DD');
            let end_date = moment(period.end_date).format('YYYY-MM-DD');
            
            $('.date_period .date_period_frm').val(start_date);
            $('.date_period .date_period_to').val(end_date);
            
            // $('.date_period, .periodic_search').removeClass('not_all_affected');
            Do_Custom_MainSearch();
        }
    }

    function Do_Custom_MainSearch() {
        let period_type = 'CSTM';
        get_Budget_Data(period_type);
        
        $('.date_period, .periodic_search').removeClass('not_all_affected');

        set_AutoRefresh_Time();
    }

    function set_AutoRefresh_Time() {

        /** Auto-Refresh Time */
        var dt = new Date(); 
        let last_refreshed_at = str_pad(dt.getDate(), 2, '0') + "/"
                    + str_pad(dt.getMonth()+1, 2, '0')  + "/" 
                    + dt.getFullYear() + " @ "  
                    + str_pad(dt.getHours(), 2, '0') + ":"  
                    + str_pad(dt.getMinutes(), 2, '0') + ":" 
                    + str_pad(dt.getSeconds(), 2, '0');

        let next_auto_refresh = Date.now() + AUTO_REFRESH_TIME;
        localStorage.setItem('next_auto_refresh', next_auto_refresh);
        
        console.log('Last AutoRefresh: ' + last_refreshed_at);
        console.log('Next AutoRefresh: ' + new Date(next_auto_refresh));

        $('.last_updated_at').text(last_refreshed_at);
        
        auto_Refresh_Data();
    }

    function auto_Refresh_Data() {
        let next_auto_refresh = parseInt(localStorage.getItem('next_auto_refresh'));
        if (!isValidString(next_auto_refresh)) {
            return false;
        }

        let diff_time = Date.now() - next_auto_refresh;
        if (diff_time >= 0) {
            
            if ($('.switch_refresh input[type="checkbox"]').is(':checked')) {
                Do_Custom_MainSearch();
            } else {
                console.log('Auto-Refresh is Disabled');
                $('.auto_refresh_div .alert_info').show();

                localStorage.setItem('next_auto_refresh', (Date.now() + AUTO_REFRESH_TIME));
                auto_Refresh_Data();
            }
            
        } else {
            setTimeout(function() {
                auto_Refresh_Data();
            }, Math.abs(diff_time));
        }
    }

    $('.switch_refresh input[type="checkbox"]').on('change', function() {
        
        if (!$(this).is(':checked')) {
            $('.auto_refresh_div .alert_info').show();
            console.log('Auto-Refresh Disabled');

            // let opt = confirm("Are you sure to disable Auto-Refresh ?");
            // if (opt) {
            //     $(this).prop('checked', false);
            //     $('.auto_refresh_div .alert_info').show();

            //     console.log('Auto-Refresh Disabled');
            // } else {
            //     $(this).prop('checked', true);
            //     $('.auto_refresh_div .alert_info').hide();
            // }
        } else {
            $('.auto_refresh_div .alert_info').hide();
            /** Calling API calls */
            Do_Custom_MainSearch();
        }
    });

    $('.alert_info .close').on('click', function() {
        $(this).parents('.alert_info').hide();
    });
    
    function tables_common_functionality(table) {
        hide_zerovalue_tablerows(table);
        put_Download_Options(table);
    }
    
    function hide_zerovalue_tablerows(table) {
        table = (typeof table == 'object')? table : $(table);

        table.find('tr').each(function(i, v) {
            if (i == 0) return true;
            if ($(this).hasClass('thead')) return true;
            
            td_non_zero = 0;
            td_negative = 0;
            $(this).find('td:nth-of-type(n+2)').each(function(i, v) {
                let is_currency = $(this).hasClass('currency');
                let num = parseFloat($(this).text().trim());
                if (num != 0) {
                    td_non_zero++;
                }
                if ((i > 3) && (num < 0)) {
                    td_negative++;
                }
                
                /** Convert Currency into Lakhs */
                if (is_currency) {
                    num = (num / 100000).toFixed(1);
                }
                $(this).text( IND_Number_Format(num, is_currency) );
            });

            if (td_non_zero == 0 && (!$(this).hasClass('tfooter')) ) {
                $(this).addClass('tr_zero').hide();
            }
            if (td_negative > 0 && (!$(this).hasClass('tfooter')) ) {
                $(this).addClass('tr_negative');
            }
        });
    }

    function put_Download_Options(table) {
        table = (typeof table == 'object')? table : $(table);

        let html = '<span class="options_div" style="display:none;">'
                 + '  <span class="btn btn_view"> <i class="fa fa-eye" aria-hidden="true"></i> </span>'
                 + '  <span class="btn btn_download"> <i class="fa fa-download" aria-hidden="true"></i> </span>'
                 + '</span>';
        table.find('tbody tr td:nth-last-of-type(1)').append(html);

    }

    function IND_Number_Format(num, is_currency = false) {
        var options = {};
        if (is_currency) {
            options = {
                style: 'currency',
                currency: 'INR'
            }
        }
        const curr = num.toLocaleString('en-IN', options);
        return curr;
    }

    // Highlighting each card period type
    function highlight_PeriodType(table, period_type) {
        table = (typeof table == 'object')? table : $(table);

        let span_period = table.parents('.panel').find('.span-period span');
        span_period.removeClass('active');

        span_period.each(function(i, v) {
            if ($(this).text().trim() == period_type) {
                $(this).addClass('active');
            }
        });
    }
    

    //Convert Day/Week/Month/Quarter/Year to Start Date and End Date
    function getPeriod(period_type) {
        if (period_type == 'D') {
            start_date = moment().format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'W') {
            start_date = moment().startOf('week').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'M') {
            start_date = moment().startOf('month').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'Q') {
            // Get Financial Quarter
            start_date = moment().startOf('quarter').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'YTD') {
            //Start From First April
            let crnt_mnth = new Date().getMonth();
            if (crnt_mnth >= 3) {
                start_date = moment().year(moment().year()).month(3).date(1).format('YYYY-MM-DD');
            } else {
                start_date = moment().year(moment().year()-1).month(3).date(1).format('YYYY-MM-DD');
            }
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'CSTM') {
            start_date = $('.date_period .date_period_frm').val();
            end_date = $('.date_period .date_period_to').val();

            if (start_date == '') {
                start_date = moment().format('YYYY-MM-DD');
            }
            if (end_date == '') {
                end_date = moment().format('YYYY-MM-DD');
            }
            if (start_date == '' && end_date == '') {
                alert('Invalid Date Period');
                $('.periodic_search .span-period span:nth-of-type(1)').addClass('active');
            }
            
        } else {
            return false;
        }

        return {
            start_date: start_date,
            end_date: end_date
        }
    }

    function get_Budget_Data(period_type = 'D') {
        
        let period = getPeriod(period_type);
        
        $('.page_spinner').show();
        
        $.ajax({
            url: ERP_BASE_URL + '/admin/Reports/get_Budget_Data',
            type: 'POST',
            data: JSON.stringify(period),
            dataType: 'json',
            success: function(data) {
                $('.page_spinner').hide();
                
                // console.log(JSON.stringify(data));

                getSalesCategoryWiseData(period_type, data.catg_wise);
                getSalesChannelWiseData(period_type, data.sc_wise);
            },
            error: function(data) {
                $('.page_spinner').hide();
                console.log(data);
            }
        });
    }

    function fill_SalesCategoryWise_Table(budget_data, actuals_data) {
        let device_cats = <?php echo json_encode(DEVICE_CATEGORY) ?>;
        // let device_cats = <?php //echo json_encode( array('PREXO', 'OPEN BOX') ) ?>;
        let total_count = 0;
        let total_amount_actuals = 0;
        let total_quantity_actuals = 0;
        
        let total_amount_budgt = 0;
        let total_quantity_budgt = 0;
        
        let total_amount = 0;
        let total_quantity = 0;
        
        // Remove all rows except first Two
        $('#sales_cw_tbl tr').slice(2).remove();

        device_cats.forEach((element) => {
            if (element == 'PRELOVED--') {
                return true
            }

            let budgt_qty = 0;
            let budgt_rev = 0;
            if (budget_data.hasOwnProperty('qty_' + element.replace(' ', '').toLowerCase())) {
                budgt_qty = budget_data['qty_' + element.replace(' ', '').toLowerCase()];
                budgt_rev = budget_data['rev_' + element.replace(' ', '').toLowerCase()];
            }
            
            let actuals_qty = 0;
            let actuals_rev = 0;
            if (actuals_data.hasOwnProperty(element)) {
                actuals_qty = actuals_data[element].quantity;
                actuals_rev = actuals_data[element].amount;
            }

            let qty_diff = actuals_qty - budgt_qty;
            let rev_diff = actuals_rev - budgt_rev;

            let qty_perc = (budgt_qty == 0)? 0 : (actuals_qty / budgt_qty * 100);
            let rev_perc = (budgt_rev == 0)? 0 : (actuals_rev / budgt_rev * 100);

            let row = '<tr>'
            row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
            row += '<td class="right">' + actuals_qty + '</td>';
            row += '<td class="right currency">' + actuals_rev.toFixed(2) + '</td>';
            
            row += '<td class="right">' + budgt_qty + '</td>';
            row += '<td class="right currency">' + budgt_rev.toFixed(2) + '</td>';

            row += '<td class="right">' + qty_diff + '</td>';
            row += '<td class="right currency">' + rev_diff.toFixed(2) + '</td>';

            row += '<td class="right">' + qty_perc.toFixed(0) + '</td>';
            row += '<td class="right">' + rev_perc.toFixed(0) + '</td>';
            
            row += '</tr>'
            
            total_quantity_actuals += + actuals_qty;
            total_amount_actuals += + actuals_rev.toFixed(2);
            
            total_quantity_budgt += + budgt_qty;
            total_amount_budgt += + budgt_rev.toFixed(2);
            
            total_quantity += + qty_diff;
            total_amount += + rev_diff.toFixed(2);
            
            $('#sales_cw_tbl').append(row);
        });

        let t_qty_perc = (total_quantity_budgt == 0)? 0 : (total_quantity_actuals / total_quantity_budgt * 100).toFixed(0);
        let t_rev_perc = (total_amount_budgt == 0)? 0 : (total_amount_actuals / total_amount_budgt * 100).toFixed(0);

        let row = '<tr class="tfooter">'
        row += '<td class="left row_element" data-element="">Total</td>';
        row += '<td class="right">' + total_quantity_actuals + '</td>';
        row += '<td class="right currency">' + total_amount_actuals.toFixed(2) + '</td>';
        
        row += '<td class="right">' + total_quantity_budgt + '</td>';
        row += '<td class="right currency">' + total_amount_budgt.toFixed(2) + '</td>';
        
        row += '<td class="right">' + total_quantity + '</td>';
        row += '<td class="right currency">' + total_amount.toFixed(2) + '</td>';
        
        row += '<td class="right">' + t_qty_perc + '</td>';
        row += '<td class="right">' + t_rev_perc + '</td>';
        
        row += '</tr>'

        $('#sales_cw_tbl').parent().find('div.overlay').fadeOut(100)
        $('#sales_cw_tbl').append(row);

        tables_common_functionality('#sales_cw_tbl');
    }

    function fill_SalesChannelWise_Table(budget_data, actuals_data, type = 'offline') {
        let channels = ['OFFLINE', 'ONLINE', 'DEALERAPP', 'EXPORT'];
        // let channels = ['OFFLINE', 'ONLINE'];

        if (type == 'online') {
            channels = <?= json_encode(ONLINE_CHANNELS) ?>;
            channels.splice(2, 0, 'FBA');

            // Remove all rows except first Two
            $('#sales_sc_o_tbl tr').slice(2).remove();
            // $('#sales_sc_o_tbl').parent().find('div.overlay').fadeIn(100);
        } else {
            // Remove all rows except first Two
            $('#sales_sc_tbl tr').slice(2).remove();
            // $('#sales_sc_tbl').parent().find('div.overlay').fadeIn(100);
        }

        let total_count = 0;
        let total_amount_actuals = 0;
        let total_quantity_actuals = 0;
        
        let total_amount_budgt = 0;
        let total_quantity_budgt = 0;

        let total_amount = 0;
        let total_quantity = 0;

        channels.forEach((element) => {
            if ( $.inArray(element, ['PRELOVED--']) != -1 ) {
                return true
            }
            if ((type == 'online') && ($.inArray(element, ['PRELOVED', 'DEALERAPP']) != -1)) {
                return true;
            }

            let budgt_qty = 0;
            let budgt_rev = 0;
            if (budget_data.hasOwnProperty('qty_' + element.toLowerCase())) {
                budgt_qty = budget_data['qty_' + element.toLowerCase()];
                budgt_rev = budget_data['rev_' + element.toLowerCase()];
            }

            let actuals_qty = 0;
            let actuals_rev = 0;
            if (actuals_data.hasOwnProperty(element)) {
                actuals_qty = actuals_data[element].quantity;
                actuals_rev = actuals_data[element].amount;
            }

            let qty_diff = actuals_qty - budgt_qty;
            let rev_diff = actuals_rev - budgt_rev;

            let qty_perc = (budgt_qty == 0)? 0 : (actuals_qty / budgt_qty * 100);
            let rev_perc = (budgt_rev == 0)? 0 : (actuals_rev / budgt_rev * 100);

            let row = '<tr>';

            row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>';
            row += '<td class="right">' + actuals_qty + '</td>';
            row += '<td class="right currency">' + actuals_rev.toFixed(2) + '</td>';
            
            row += '<td class="right">' + budgt_qty + '</td>';
            row += '<td class="right currency">' + budgt_rev.toFixed(2) + '</td>';

            row += '<td class="right">' + qty_diff + '</td>';
            row += '<td class="right currency">' + rev_diff.toFixed(2) + '</td>';

            row += '<td class="right">' + qty_perc.toFixed(0) + '</td>';
            row += '<td class="right">' + rev_perc.toFixed(0) + '</td>';

            row += '</tr>';

            total_quantity_actuals += + actuals_qty;
            total_amount_actuals += + actuals_rev.toFixed(2);
            
            total_quantity_budgt += + budgt_qty;
            total_amount_budgt += + budgt_rev.toFixed(2);
            
            total_quantity += + qty_diff;
            total_amount += + rev_diff.toFixed(2);

            if (type == 'online') {
                $('#sales_sc_o_tbl').append(row)
            } else {
                $('#sales_sc_tbl').append(row)
            }

        });

        let t_qty_perc = (total_quantity_budgt == 0)? 0 : (total_quantity_actuals / total_quantity_budgt * 100).toFixed(0);
        let t_rev_perc = (total_amount_budgt == 0)? 0 : (total_amount_actuals / total_amount_budgt * 100).toFixed(0);

        let row = '<tr class="tfooter">'
        row += '<td class="left row_element" data-element="">Total</td>'
        row += '<td class="right">' + total_quantity_actuals + '</td>'
        row += '<td class="right currency">' + total_amount_actuals.toFixed(2) + '</td>'
        
        row += '<td class="right">' + total_quantity_budgt + '</td>'
        row += '<td class="right currency">' + total_amount_budgt.toFixed(2) + '</td>'
        
        row += '<td class="right">' + total_quantity + '</td>'
        row += '<td class="right currency">' + total_amount.toFixed(2) + '</td>'
        
        row += '<td class="right">' + t_qty_perc + '</td>';
        row += '<td class="right">' + t_rev_perc + '</td>';
        
        row += '</tr>'

        if (type == 'online') {
            $('#sales_sc_o_tbl').parent().find('div.overlay').fadeOut(100)
            $('#sales_sc_o_tbl').append(row)
            tables_common_functionality('#sales_sc_o_tbl');
        } else {
            $('#sales_sc_tbl').parent().find('div.overlay').fadeOut(100)
            $('#sales_sc_tbl').append(row)
            tables_common_functionality('#sales_sc_tbl');
        }
    }


    function getSalesCategoryWiseData(date_period = 'D', budget_data) {
        highlight_PeriodType('#sales_cw_tbl', date_period);
        // Remove all rows except first Two
        $('#sales_cw_tbl tr').slice(2).remove();
        $('#sales_cw_tbl').parent().find('div.overlay').fadeIn(100)
        let period = getPeriod(date_period)

        if (!period) return false;

        let start_date = moment(period.start_date).format('DD/MM/YYYY');
        let end_date = moment(period.end_date).format('DD/MM/YYYY');
        $('#sales_cw_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
        
        // let csv_url = 'admin/Reports/downloadCsvReportsInvoiceItemWithPurchase';
        // let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        // let to_date = moment(period.end_date).format('YYYY-MM-DD');
        // $('#sales_cw_tbl tbody').attr('data-frm_date', frm_date);
        // $('#sales_cw_tbl tbody').attr('data-to_date', to_date);
        // $('#sales_cw_tbl tbody').attr('data-csv_url', csv_url);
        // $('#sales_cw_tbl tbody').attr('data-element_type', 'catg');


        let jsonObject = JSON.stringify(period);

        $.ajax({
            url: encodeURI(base_url + '/sales/sales_category_wise'),
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                fill_SalesCategoryWise_Table(budget_data, data);
            },
            error: function(error) {
                $('#sales_cw_tbl').parent().find('div.overlay').fadeOut(100)
                console.log(error)
            }
        })
        
    }

    function getSalesChannelWiseData(date_period = 'D', budget_data, type = 'offline') {
        let period = getPeriod(date_period)
        let url = encodeURI(base_url + '/sales/sales_channel_wise')
        let start_date = moment(period.start_date).format('DD/MM/YYYY');
        let end_date = moment(period.end_date).format('DD/MM/YYYY');

        let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        let to_date = moment(period.end_date).format('YYYY-MM-DD');

        if (type == 'online') {
            highlight_PeriodType('#sales_sc_o_tbl', date_period);
            url = encodeURI(base_url + '/sales/sales_channel_wise/' + type)
            // Remove all rows except first Two
            $('#sales_sc_o_tbl tr').slice(2).remove();
            $('#sales_sc_o_tbl').parent().find('div.overlay').fadeIn(100)
            $('#sales_sc_o_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
            
            let csv_url = 'admin/Reports/downloadCsvReportsInvoiceItemWithPurchase';
            $('#sales_sc_o_tbl tbody').attr('data-frm_date', frm_date);
            $('#sales_sc_o_tbl tbody').attr('data-to_date', to_date);
            $('#sales_sc_o_tbl tbody').attr('data-csv_url', csv_url);
            $('#sales_sc_o_tbl tbody').attr('data-element_type', 'scw_o');
        } else {
            highlight_PeriodType('#sales_sc_tbl', date_period);
            // Remove all rows except first Two
            $('#sales_sc_tbl tr').slice(2).remove();
            $('#sales_sc_tbl').parent().find('div.overlay').fadeIn(100)
            $('#sales_sc_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
            
            let csv_url = 'admin/Reports/downloadCsvReportsInvoiceItemWithPurchase';
            $('#sales_sc_tbl tbody').attr('data-frm_date', frm_date);
            $('#sales_sc_tbl tbody').attr('data-to_date', to_date);
            $('#sales_sc_tbl tbody').attr('data-csv_url', csv_url);
            $('#sales_sc_tbl tbody').attr('data-element_type', 'scw');
        }

        if (!period) return false;


        let jsonObject = JSON.stringify(period)

        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                fill_SalesChannelWise_Table(budget_data, data);
            },
            error: function(error) {
                if (type == 'online') {
                    $('#sales_sc_o_tbl').parent().find('div.overlay').fadeOut(100)
                } else {
                    $('#sales_sc_tbl').parent().find('div.overlay').fadeOut(100)
                }
                console.log(error)
            }
        });

    }

</script>

<script>
    function str_pad(str, max, pad_string='0') {
        str = str.toString();
        return str.length < max ? str_pad(pad_string + str, max) : str;
    }
</script>
