<style>
    .card {
        background-color: #fff;
        border-radius: 10px;
        border: none;
        position: relative;
        margin-bottom: 30px;
        box-shadow: 0 0.46875rem 2.1875rem rgba(90, 97, 105, 0.1), 0 0.9375rem 1.40625rem rgba(90, 97, 105, 0.1), 0 0.25rem 0.53125rem rgba(90, 97, 105, 0.12), 0 0.125rem 0.1875rem rgba(90, 97, 105, 0.1);
    }

    .l-bg-cherry {
        background: linear-gradient(to right, #493240, #f09) !important;
        color: #fff;
    }

    .l-bg-blue-dark {
        background: linear-gradient(to right, #373b44, #4286f4) !important;
        color: #fff;
    }

    .l-bg-green-dark {
        background: linear-gradient(to right, #0a504a, #38ef7d) !important;
        color: #fff;
    }

    .l-bg-orange-dark {
        background: linear-gradient(to right, #a86008, #ffba56) !important;
        color: #fff;
    }

    .card .card-statistic-3 .card-icon-large .fas,
    .card .card-statistic-3 .card-icon-large .far,
    .card .card-statistic-3 .card-icon-large .fab,
    .card .card-statistic-3 .card-icon-large .fal {
        font-size: 110px;
    }

    .card .card-statistic-3 .card-icon {
        text-align: center;
        line-height: 50px;
        margin-left: 15px;
        color: #000;
        position: absolute;
        right: -5px;
        top: 20px;
        opacity: 0.1;
    }

    .l-bg-cyan {
        background: linear-gradient(135deg, #289cf5, #84c0ec) !important;
        color: #fff;
    }

    .l-bg-green {
        background: linear-gradient(135deg, #23bdb8 0%, #43e794 100%) !important;
        color: #fff;
    }

    .l-bg-orange {
        background: linear-gradient(to right, #f9900e, #ffba56) !important;
        color: #fff;
    }

    .l-bg-cyan {
        background: linear-gradient(135deg, #289cf5, #84c0ec) !important;
        color: #fff;
    }

    .text-right {
        margin-right: 20px;
        float: right;

    }

    .text-left {
        margin-left: 20px;
        float: left;
    }

    .card-title {
        margin-left: 20px;
        text-align: center;
    }
</style>
<!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.1/css/all.min.css" integrity="sha256-mmgLkCYLUQbXn0B1SRqzHar6dCnv9oZFPEC1g1cwlkk=" crossorigin="anonymous" /> -->

<div class="col-md-12 ">
    <h3>Sales Report</h3>
    <div class="row ">
        <div class="col-xl-3 col-lg-3">
            <div class="card l-bg-cherry" onclick="getChart('day_sales')">
                <div class="card-statistic-3 p-4">
                    <div class="card-icon card-icon-large"><i class="fas fa-shopping-cart"></i></div>
                    <div class="mb-4 top-margin">
                        <h3 class="card-title mb-0">Today</h3>
                    </div>
                    <div class="row align-items-center mb-2 d-flex">
                        <div class="col-8">
                            <h3 class="d-flex align-items-center mb-0" style="margin-left: 20px;">
                                ₹<span id="today_sales_value"></span> Lakhs
                            </h3>
                        </div>
                        <div class="col-2 text-right">
                            <h3 class="text-units"><span id="today_sales_units"></span> units</h3>
                        </div>
                    </div>
                    <div class="progress mt-1 " data-height="8" style="height: 8px;">
                        <div class="progress-bar l-bg-cyan" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-3">
            <div class="card l-bg-blue-dark" onclick="getChart('week_sales')">
                <div class="card-statistic-3 p-4">
                    <div class="card-icon card-icon-large"><i class="fas fa-users"></i></div>
                    <div class="mb-4">
                        <h3 class="card-title mb-0">Week</h3>
                    </div>
                    <div class="row align-items-center mb-2 d-flex">
                        <div class="col-8">
                            <h3 class="d-flex align-items-center mb-0" style="margin-left: 20px;">
                                ₹<span id="week_sales_value"></span> Lakhs
                            </h3>
                        </div>
                        <div class="col-2 text-right">
                            <h3 class="text-units"><span id="week_sales_units"></span> units</h3>
                        </div>
                    </div>
                    <div class="progress mt-1 " data-height="8" style="height: 8px;">
                        <div class="progress-bar l-bg-green" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-3">
            <div class="card l-bg-green-dark" onclick="getChart('month_sales')">
                <div class="card-statistic-3 p-4">
                    <div class="card-icon card-icon-large"><i class="fas fa-ticket-alt"></i></div>
                    <div class="mb-4">
                        <h3 class="card-title mb-0">Month</h3>
                    </div>
                    <div class="row align-items-center mb-2 d-flex">
                        <div class="col-8">
                            <h3 class="d-flex align-items-center mb-0" style="margin-left: 20px;">
                                ₹<span id="month_sales_value"></span> Lakhs
                            </h3>
                        </div>
                        <div class="col-2 text-right">
                            <h3 class="text-units"><span id="month_sales_units"></span> units</h3>
                        </div>

                    </div>
                    <div class="progress mt-1 " data-height="8" style="height: 8px;">
                        <div class="progress-bar l-bg-orange" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-3">
            <div class="card l-bg-orange-dark" onclick="getChart('year_sales')">
                <div class="card-statistic-3 p-4">
                    <div class="card-icon card-icon-large"><i class="fas fa-dollar-sign"></i></div>
                    <div class="mb-4">
                        <h3 class="card-title mb-0">YTD</h3>
                    </div>
                    <div class="row align-items-center mb-2 d-flex">
                        <div class="col-8">
                            <h3 class="d-flex align-items-center mb-0" style="margin-left: 20px;">
                                ₹<span id="year_sales_value"></span> Cr
                            </h3>
                        </div>
                        <div class="col-4 text-right">
                            <h3 class="text-units"><span id="year_sales_units"></span> units</h3>
                        </div>
                    </div>
                    <div class="progress mt-1 " data-height="8" style="height: 8px;">
                        <div class="progress-bar l-bg-cyan" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="col-md-12 ">
    <h3>Purchase Report</h3>
    <div class="row ">
        <div class="col-xl-3 col-lg-3">
            <div class="card l-bg-cherry" onclick="getChart('week_purchase')">
                <div class="card-statistic-3 p-4">
                    <div class="card-icon card-icon-large"><i class="fas fa-shopping-cart"></i></div>
                    <div class="mb-4 top-margin">
                        <h3 class="card-title mb-0">Today</h3>
                    </div>
                    <div class="row align-items-center mb-2 d-flex">
                        <div class="col-8">
                            <h3 class="d-flex align-items-center mb-0" style="margin-left: 20px;">
                                ₹<span id="today_purchase_value"></span> Lakhs
                            </h3>
                        </div>

                        <div class="col-2 text-right">
                            <h3 class="text-units"><span id="today_purchase_units"></span> units</h3>
                        </div>
                    </div>
                    <div class="progress mt-1 " data-height="8" style="height: 8px;">
                        <div class="progress-bar l-bg-cyan" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-3">
            <div class="card l-bg-blue-dark" onclick="getChart('week_purchase')">
                <div class="card-statistic-3 p-4">
                    <div class="card-icon card-icon-large"><i class="fas fa-users"></i></div>
                    <div class="mb-4">
                        <h3 class="card-title mb-0">Week</h3>
                    </div>
                    <div class="row align-items-center mb-2 d-flex">
                        <div class="col-8">
                            <h3 class="d-flex align-items-center mb-0" style="margin-left: 20px;">
                                ₹<span id="week_purchase_value"></span> Lakhs
                            </h3>
                        </div>
                        <div class="col-2 text-right">
                            <h3 class="text-units"><span id="week_purchase_units"></span> units</h3>
                        </div>
                    </div>
                    <div class="progress mt-1 " data-height="8" style="height: 8px;">
                        <div class="progress-bar l-bg-green" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-3">
            <div class="card l-bg-green-dark" onclick="getChart('month_purchase')">
                <div class="card-statistic-3 p-4">
                    <div class="card-icon card-icon-large"><i class="fas fa-ticket-alt"></i></div>
                    <div class="mb-4">
                        <h3 class="card-title mb-0">Month</h3>
                    </div>
                    <div class="row align-items-center mb-2 d-flex">
                        <div class="col-8">
                            <h3 class="d-flex align-items-center mb-0" style="margin-left: 20px;">
                                ₹<span id="month_purchase_value"></span> Lakhs
                            </h3>
                        </div>
                        <div class="col-2 text-right">
                            <h3 class="text-units"><span id="month_purchase_units"></span> units</h3>
                        </div>
                    </div>
                    <div class="progress mt-1 " data-height="8" style="height: 8px;">
                        <div class="progress-bar l-bg-orange" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-3">
            <div class="card l-bg-orange-dark" onclick="getChart('year_purchase')">
                <div class="card-statistic-3 p-4">
                    <div class="card-icon card-icon-large"><i class="fas fa-dollar-sign"></i></div>
                    <div class="mb-4">
                        <h3 class="card-title mb-0">YTD</h3>
                    </div>
                    <div class="row align-items-center mb-2 d-flex">
                        <div class="col-8">
                            <h3 class="d-flex align-items-center mb-0" style="margin-left: 20px;">
                                ₹<span id="year_purchase_value"></span> Cr
                            </h3>
                        </div>
                        <div class="col-4 text-right">
                            <h3 class="text-units"><span id="year_purchase_units"></span> units</h3>
                        </div>
                    </div>
                    <div class="progress mt-1 " data-height="8" style="height: 8px;">
                        <div class="progress-bar l-bg-cyan" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-1"></div>
    <div class="col-md-10" style="margin-left: 15px;" id="chart_div_main">
        <div class="panel panel-custom menu" style="height: 600px; overflow-y: scroll;">
            <header class="panel-heading mb0">
                <h3 class="panel-title" id="chart_title"></h3>
            </header>
            <canvas id="purchase_summary_chart"></canvas>
        </div>
    </div>
</div>
<script>
    getSalesSummary()
    getPurchaseSummary()
    var week_days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']
    var chart_week_sales_value = []
    var chart_week_sales_count = []
    var chart_month_sales_value = []
    var chart_month_sales_count = []
    var chart_year_sales_value = []
    var chart_year_sales_count = []

    var chart_week_purchase_value = []
    var chart_week_purchase_count = []
    var chart_month_purchase_value = []
    var chart_month_purchase_count = []
    var chart_year_purchase_value = []
    var chart_year_purchase_count = []

    function getChart(type = '') {

        var elmnt = document.getElementById("chart_div_main");
        elmnt.scrollIntoView();
        var months = ['Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec', 'Jan', 'Feb', 'Mar']
        if (type == 'month_sales') {
            var date_arr = []
            for (i = 1; i <= 31; i++) {
                date_arr.push(i)
            }
            //$("#chart_title").text("Sales Week")
            chartwrite_main(date_arr, chart_month_sales_value, chart_month_sales_count, 'Sales Amount in Lakhs', 'Sales Units')
        }

        if (type == 'day_sales' || type == 'week_sales') {
            chartwrite_main(week_days, chart_week_sales_value, chart_week_sales_count, 'Sales Amount in Lakhs', 'Sales Units')
        }

        if (type == 'year_sales') {
            chartwrite_main(months, chart_year_sales_value, chart_year_sales_count, 'Sales Amount in Lakhs', 'Sales Units')
        }

        if (type == 'month_purchase') {
            var date_arr = []
            for (i = 1; i <= 31; i++) {
                date_arr.push(i)
            }
            chartwrite_main(date_arr, chart_month_purchase_value, chart_month_purchase_count, 'Purchase Amount in Lakhs', 'Purchase Units')
        }

        if (type == 'day_purchase' || type == 'week_purchase') {
            chartwrite_main(week_days, chart_week_purchase_value, chart_week_purchase_count, 'Purchase Amount in Lakhs', 'Purchase Units')
        }

        if (type == 'year_purchase') {
            chartwrite_main(months, chart_year_purchase_value, chart_year_purchase_count, 'Purchase Amount in Lakhs', 'Purchase Units')
        }
    }

    function getSalesSummary() {

        $.ajax({
            "url": "<?= base_url() ?>admin/Analytics/getSalesDashboardSummary",
            "method": "GET",
            "data": {},
            "dataType": "json",
            "success": function(data) {

                if (data.status != 1) {
                    return false
                }
                let year_values = data.result.year_value/100
                year_values = year_values.toFixed(2)
                $("#today_sales_value").text(data.result.today_value)
                $("#today_sales_units").text(data.result.today_qty)
                $("#week_sales_value").text(data.result.week_value)
                $("#week_sales_units").text(data.result.week_qty)
                $("#month_sales_value").text(data.result.month_value)
                $("#month_sales_units").text(data.result.month_qty)
                $("#year_sales_value").text(year_values)
                $("#year_sales_units").text(data.result.year_qty)

                //Chart Data
                var week_chart_sales_amount = data.charts.week_chart_sales_amount
                var week_chart_sales_qty = data.charts.week_chart_sales_qty
                var month_chart_sales_amount = data.charts.month_chart_sales_amount
                var month_chart_sales_qty = data.charts.month_chart_sales_qty
                var year_chart_sales_amount = data.charts.year_chart_sales_amount
                var year_chart_sales_qty = data.charts.year_chart_sales_qty

                $.each(week_days, function(i, v) {
                    if (week_chart_sales_amount[week_days[i]] != null && week_chart_sales_amount[week_days[i]] != undefined) {
                        chart_week_sales_value.push((week_chart_sales_amount[week_days[i]] / 100000).toFixed(2))
                        chart_week_sales_count.push(week_chart_sales_qty[week_days[i]])
                    } else {
                        chart_week_sales_value.push('0')
                        chart_week_sales_count.push('0')
                    }

                })

                for (let index = 1; index < 31; index++) {
                    let ind_val = ''
                    if (index <= 9) {
                        ind_val = "0" + index
                    } else {
                        ind_val = index
                    }
                    if (month_chart_sales_amount[ind_val] != null && month_chart_sales_amount[ind_val] != undefined) {
                        chart_month_sales_value.push((month_chart_sales_amount[ind_val] / 100000).toFixed(2))
                        chart_month_sales_count.push(month_chart_sales_qty[ind_val])

                    } else {
                        chart_month_sales_value.push('0')
                        chart_month_sales_count.push('0')
                    }
                }
                //Year Month Start From April
                for (let index = 4; index < 13; index++) {

                    if (year_chart_sales_amount[index] != null && year_chart_sales_amount[index] != undefined) {
                        chart_year_sales_value.push((year_chart_sales_amount[index] / 100000).toFixed(2))
                        chart_year_sales_count.push(year_chart_sales_qty[index])
                    } else {
                        chart_year_sales_value.push('0')
                        chart_year_sales_count.push('0')
                    }
                }
                for (let index = 1; index < 4; index++) {

                    if (year_chart_sales_amount[index] != null && year_chart_sales_amount[index] != undefined) {
                        chart_year_sales_value.push((year_chart_sales_amount[index] / 100000).toFixed(2))
                        chart_year_sales_count.push(year_chart_sales_qty[index] / 100000)

                    } else {
                        chart_year_sales_value.push('0')
                        chart_year_sales_count.push('0')
                    }
                }
                //chartwrite_main(week_days, chart_sales_data)
            }
        })
    }

    function getPurchaseSummary() {

        $.ajax({
            "url": "<?= base_url() ?>admin/Analytics/getPurchaseDashboardSummary",
            "method": "GET",
            "data": {},
            "dataType": "json",
            "success": function(data) {
                if (data.status != 1) {
                    return false
                }
                let year_values = data.result.year_value/100
                year_values = year_values.toFixed(2)
                $("#today_purchase_value").text(data.result.today_value)
                $("#yesterday_purchase_value").text(data.result.yesterday_value)
                $("#today_purchase_units").text(data.result.today_qty)
                $("#week_purchase_value").text(data.result.week_value)
                $("#last_week_purchase_value").text(data.result.last_week_value)
                $("#week_purchase_units").text(data.result.week_qty)
                $("#month_purchase_value").text(data.result.month_value)
                $("#last_month_purchase_value").text(data.result.last_month_value)
                $("#month_purchase_units").text(data.result.month_qty)
                $("#year_purchase_value").text(year_values)
                $("#year_purchase_units").text(data.result.year_qty)


                //Chart Data
                var week_chart_purchase_amount = data.charts.week_chart_purchase_amount
                var week_chart_purchase_qty = data.charts.week_chart_purchase_qty
                var month_chart_purchase_amount = data.charts.month_chart_purchase_amount
                var month_chart_purchase_qty = data.charts.month_chart_purchase_qty
                var year_chart_purchase_amount = data.charts.year_chart_purchase_amount
                var year_chart_purchase_qty = data.charts.year_chart_purchase_qty

                $.each(week_days, function(i, v) {

                    if (week_chart_purchase_amount[week_days[i]] != null && week_chart_purchase_amount[week_days[i]] != undefined) {
                        chart_week_purchase_value.push((week_chart_purchase_amount[week_days[i]] / 100000).toFixed(2))
                        chart_week_purchase_count.push(week_chart_purchase_qty[week_days[i]])
                    } else {
                        chart_week_purchase_value.push('0')
                        chart_week_purchase_count.push('0')
                    }

                })

                for (let index = 1; index <= 31; index++) {
                    let ind_val = ''
                    if (index <= 9) {
                        ind_val = "0" + index
                    } else {
                        ind_val = index
                    }
                    if (month_chart_purchase_amount[ind_val] != null && month_chart_purchase_amount[ind_val] != undefined) {
                        chart_month_purchase_value.push((month_chart_purchase_amount[ind_val] / 100000).toFixed(2))
                        chart_month_purchase_count.push(month_chart_purchase_qty[ind_val])

                    } else {
                        chart_month_purchase_value.push('0')
                        chart_month_purchase_count.push('0')
                    }
                }
                //Year Month Start From April
                for (let index = 4; index < 13; index++) {

                    if (year_chart_purchase_amount[index] != null && year_chart_purchase_amount[index] != undefined) {
                        chart_year_purchase_value.push((year_chart_purchase_amount[index] / 100000).toFixed(2))
                        chart_year_purchase_count.push(year_chart_purchase_qty[index])
                    } else {
                        chart_year_purchase_value.push('0')
                        chart_year_purchase_count.push('0')
                    }
                }
                for (let index = 1; index < 4; index++) {

                    if (year_chart_purchase_amount[index] != null && year_chart_purchase_amount[index] != undefined) {
                        chart_year_purchase_value.push((year_chart_purchase_amount[index] / 100000).toFixed(2))
                        chart_year_purchase_count.push(year_chart_purchase_qty[index])

                    } else {
                        chart_year_purchase_value.push('0')
                        chart_year_purchase_count.push('0')
                    }
                }
            }
        })
    }

    var myChart;

    function chartwrite_main(labels, value, count, label1 = '', label2 = '') {
        console.log(value)
        var ctx = document.getElementById("purchase_summary_chart").getContext('2d');
        var background1 = [
            'rgba(255, 99, 132, 0.5)',
            'rgba(54, 162, 235, 0.5)',
            'rgba(255, 206, 86, 0.5)',
            'rgba(75, 192, 192, 0.5)',
            'rgba(153, 102, 255, 0.5)',
            'rgba(255, 159, 64, 0.5)',
            'rgba(0, 128, 128, 0.5)',
            'rgba(218,165,32, 0.5)',
            'rgba(100,149,237, 0.5)',
            'rgba(72,61,139, 0.5)',
            'rgba(210,180,140, 0.5)',
            'rgba(119,136,153, 0.5)',
            'rgba(199,21,133, 0.5)',
            'rgba(0,199,140, 0.5)',
            'rgba(255, 99, 132, 0.5)',
            'rgba(54, 162, 235, 0.5)',
            'rgba(255, 206, 86, 0.5)',
            'rgba(75, 192, 192, 0.5)',
            'rgba(153, 102, 255, 0.5)',
            'rgba(255, 159, 64, 0.5)',
            'rgba(0, 128, 128, 0.5)',
            'rgba(218,165,32, 0.5)',
            'rgba(100,149,237, 0.5)',
            'rgba(72,61,139, 0.5)',
            'rgba(210,180,140, 0.5)',
            'rgba(119,136,153, 0.5)',
            'rgba(199,21,133, 0.5)',
            'rgba(0,199,140, 0.5)',
        ];
        var background2 = [
            'rgba(0, 128, 128, 0.5)',
            'rgba(218,165,32, 0.5)',
            'rgba(100,149,237, 0.5)',
            'rgba(72,61,139, 0.5)',
            'rgba(210,180,140, 0.5)',
            'rgba(119,136,153, 0.5)',
            'rgba(199,21,133, 0.5)',
            'rgba(0,199,140, 0.5)',
            'rgba(255, 99, 132, 0.5)',
            'rgba(54, 162, 235, 0.5)',
            'rgba(255, 206, 86, 0.5)',
            'rgba(75, 192, 192, 0.5)',
            'rgba(153, 102, 255, 0.5)',
            'rgba(255, 159, 64, 0.5)',
            'rgba(0, 128, 128, 0.5)',
            'rgba(218,165,32, 0.5)',
            'rgba(100,149,237, 0.5)',
            'rgba(72,61,139, 0.5)',
            'rgba(210,180,140, 0.5)',
            'rgba(119,136,153, 0.5)',
            'rgba(199,21,133, 0.5)',
            'rgba(0,199,140, 0.5)',
            'rgba(255, 99, 132, 0.5)',
            'rgba(54, 162, 235, 0.5)',
            'rgba(255, 206, 86, 0.5)',
            'rgba(75, 192, 192, 0.5)',
            'rgba(153, 102, 255, 0.5)',
            'rgba(255, 159, 64, 0.5)',
        ];
        var border_color = [
            'rgba(255,99,132,1)',
            'rgba(54, 162, 235, 1)',
            'rgba(255, 206, 86, 1)',
            'rgba(75, 192, 192, 1)',
            'rgba(153, 102, 255, 1)',
            'rgba(255, 159, 64, 1)',
            'rgba(0, 128, 128, 1)',
            'rgba(218,165,32, 1)',
            'rgba(100,149,237, 1)',
            'rgba(72,61,139, 1)',
            'rgba(210,180,140, 1)',
            'rgba(119,136,153, 1)',
            'rgba(199,21,133, 1)',
            'rgba(0,199,140, 1)'
        ];
        if(myChart){
            myChart.destroy()
        }
         myChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [{
                        label: label1,
                        data: value,
                        backgroundColor: background1,
                        borderColor: border_color,
                        borderWidth: 1
                    },
                    {
                        label: label2,
                        data: count,
                        backgroundColor: background2,
                        borderColor: border_color,
                        borderWidth: 1,
                        hidden: true
                    },
                ]
            },
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true
                        }
                    }]
                }
            }
        });
    }
</script>