<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src = "https://html2canvas.hertzen.com/dist/html2canvas.min.js" type="text/javascript"></script>
</head>

<style>
    /* row 3x1 for small devices 3x3 for large devices */
    @media (max-width: 767px) {
        .row {
            flex-direction: column;
            margin-bottom: 10px;
        }

        .pane {
            margin-bottom: 10px;
            padding: auto;
        }
    }

    #modal_view_data .modal-dialog {
        width: 90%;
    }
    
    table thead tr th.left,
    .left {
        text-align: left;
    }
    table thead tr th.right,
    .right {
        text-align: right;
    }
    

    .cards_container .panel:nth-of-type(8) .panel-heading,
    .cards_container .panel:nth-of-type(1) .panel-heading {
        background-color: #7bacea;
    }
    .cards_container .panel:nth-of-type(9) .panel-heading,
    .cards_container .panel:nth-of-type(2) .panel-heading {
        background-color: #dfc96a;
    }
    .cards_container .panel:nth-of-type(3) .panel-heading {
        background-color: #6dda86;
    }
    .cards_container .panel:nth-of-type(4) .panel-heading {
        background-color: #b588e0;
    }
    .cards_container .panel:nth-of-type(5) .panel-heading {
        background-color: #e47b7b;
    }
    .cards_container .panel:nth-of-type(6) .panel-heading {
        background-color: #e47bbd;
    }
    .cards_container .panel:nth-of-type(7) .panel-heading {
        background-color: #6bd4db;
    }

    .panel-row {
        display: flex;
        flex-wrap: wrap;
    }
    .panel {
        width: 50%;
        min-width: 340px;
        padding: 15px;
        border: none;
        box-shadow: none;
        display: flex;
        flex-direction: column;
    }
    .panel-row .panel .panel-heading {
        border-radius: 20px 20px 0 0;
        padding: 20px 20px 15px;
        position: relative;
    }
    .panel-row .panel .panel-body {
        flex: 1 1 50%;
        border: 2px solid #ccc;
        border-top: none;
        border-radius: 0 0 20px 20px;
    }
    .panel-row .panel .panel-body .panel_body_inner {
        max-height: 300px;
        overflow-y: auto;
    }
    
    .action_btns_div .btn_send_to_cliqbot {
        display: inline-block;
        position: absolute;
        right: 10px;
        bottom: -10px;
        cursor: pointer;
        color: #933df2;
    }
    .action_btns_div .btn_send_to_cliqbot:hover {
        color: #f64343;
    }
    .panel-row .panel .panel-heading .title {
        display: inline-block;
        margin: 0;
    }
    .time_filter {
        display: inline-block;
        float: right;
    }
    .time_filter > span {
        display: inline-block;
    }
    .time_filter .date_show {
        margin-right: 15px;
    }
    .time_filter .span-period {
        /* background-color: #FFF; */
        color: #CCC;
        padding: 0;
    }
    .time_filter .time_period {
        background-color: #fff;
        display: inline-block;
        padding: 0 5px;
        min-width: 20px;
        text-align: center;
        color: #ccc;
        font-weight: 700;
        cursor: pointer;
        border-radius: 3px;
        font-size: 14px;
    }
    .time_filter .time_period.active {
        color: #f00;
        border-radius: 2px;
    }
    .time_filter .time_period:hover {
        background-color: #f85858;
        color: #fff;
        transform: scale(1, 1.1);
        border-radius: 2px;
    }
    .periodic_search.not_all_affected .time_filter .time_period.active {
        color: #ccc;
        border-radius: 3px;
    }

    .tfooter td {
        background-color: cadetblue;
        color: #FFF;
        padding: 5px;
        font-weight: 700;

    }
    
    .page_search_filter.element_sticky {
        position: fixed;
        top: 56px;
        width: 80%;
        z-index: 100;
    }
    .sidemenu_custom.sm_collapse .page_search_filter.element_sticky {
        width: 91.5%;
    }
    .panel.main_search {
        width: 100%;
        display: block;
        background-color: #f4e4e4;
        border-radius: 15px;
    }
    .panel.main_search .time_filter {
        display: inline-block;
        float: none;
    }

    table tr th {
        background-color: #9fc5d4;
    }

    /* Spinner */
    .overlay {
        position: relative;
        top: 0;
        z-index: 100;
        min-width: 340px;
        max-width: 400px;
        height: 150px;
        display: none;
        background: rgba(250, 250, 250, 0.6);
        margin: auto;
    }
    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
    }
    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }
    @keyframes sp-anime {
        100% {
            transform: rotate(360deg);
        }
    }

    .is-hide {
        display: none;
    }


    /* .toggle__tr_zero {
        float: right;
        position: relative;
        top: -5px;
        cursor: pointer;
    } */

    .date_period {
        text-align: right;
    }
    .date_period .date_field {
        display: inline-block;
        border-radius: 5px;
    }
    .date_period .date_field + .date_field {
        margin-left: 10px;
    }
    .date_period.not_all_affected .date_field {
        background-color: #e76767;
        color: #fff;
    }

    .dates_rel {
        margin: 5px;
        cursor: pointer;
        color: #999;
    }
    .dates_rel.active {
        color: #f00;
        transform: scale(1.5);
    }


    table tbody tr {
        position: relative;
    }
    table tbody tr td .options_div {
        background-color: #9abcbaad;
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        text-align: right;
        /* display: flex;
        justify-content: space-evenly;
        align-items: center; */
    }
    table tbody tr td .options_div .btn {
        color: #1e0da9;
        font-size: 20px;
    }

    table tr th {
        text-transform: initial;
        padding: 5px 10px;
        line-height: 1.2;
    }

    table#sr_cnt_amz_api tbody tr.AMAZON,
    table#sales_cnt_amz_api tbody tr.AMAZON,
    table#sales_sc_o_tbl tbody tr.AMAZON {
        background-color: #d2f0e9;
    }
    table#sales_sc_tbl tbody tr.ONLINE {
        /* background-color: #e2cef5; */
        border: 2px dashed #e2cef5;;
    }
    table#triage_prod_tbl thead tr:nth-of-type(2) th {
        background-color: #b7c4c9;
    }
    table#triage_prod_tbl thead tr:nth-of-type(1) th:nth-last-of-type(n),
    table#triage_prod_tbl thead tr:nth-of-type(2) th:nth-last-of-type(3n),
    table#triage_prod_tbl tbody tr td:nth-last-of-type(3n) {
        border-left: 1px solid #e5e5e5;
    }

    
    /** Auto-Refresh DIV CSS */
    .auto_refresh_div {
        display: inline-block;
        position: fixed;
        top: 50px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 500;
        text-transform: initial;
    }
    .auto_refresh_info {
        text-align: center;
        background-color: #aeffe1;
        color: #666;
        padding: 10px 15px;
        border-radius: 10px;
        display: flex;
        align-items: center;
    }
    .auto_refresh_info .last_updated_info p.lbl {
        margin: 0;
        font-size: 12px;
        line-height: 1;
        margin-bottom: 3px;
        letter-spacing: 1px;
        font-style: italic;
    }
    .auto_refresh_info .last_updated_info .last_updated_at {
        margin: 0;
        line-height: 1;
        font-size: 16px;
        color: #c52b2b;
        font-weight: bold;
    }
    .auto_refresh_info .switch_refresh {
        margin-left: 15px;
    }
    .auto_refresh_div .alert_info {
        color: #fff;
        background-color: #f00;
        border-radius: 5px;
        text-align: center;
    }
    .auto_refresh_div .alert_info .msg {
        animation: anim_flash 1s linear infinite;
    }
    .auto_refresh_div .alert_info .close {
        font-size: 14px;
        margin-right: 15px;
        margin-top: 3px;
    }
    .auto_refresh_div .alert_info .close .fa {
        color: #000;
    }
    @keyframes anim_flash {
        0%, 50%, 100% {
            opacity: 1;
        }
        25%, 75% {
            opacity: 0;
        }
    }
</style>

<!-- Slider Switch CSS -->
<style>
    .slider_switch {
    position: relative;
    display: inline-block;
    width: 45px;
    height: 20px;
    }

    .slider_switch input { 
    opacity: 0;
    width: 0;
    height: 0;
    }

    .slider_switch .sw_slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    -webkit-transition: .4s;
    transition: .4s;
    }

    .slider_switch .sw_slider:before {
    position: absolute;
    content: "";
    height: 15px;
    width: 15px;
    left: 2px;
    bottom: 2px;
    background-color: white;
    -webkit-transition: .4s;
    transition: .4s;
    }

    .slider_switch input:checked + .sw_slider {
    background-color: #2196F3;
    }

    .slider_switch input:focus + .sw_slider {
    box-shadow: 0 0 1px #2196F3;
    }

    .slider_switch input:checked + .sw_slider:before {
    -webkit-transform: translateX(26px);
    -ms-transform: translateX(26px);
    transform: translateX(26px);
    }

    /* Rounded sliders */
    .slider_switch .sw_slider.round {
    border-radius: 34px;
    }

    .slider_switch .sw_slider.round:before {
    border-radius: 50%;
    }
</style>

<!-- Page Spinner-->
<div class="page_spinner" style="display: none;">
    <div class="inner_block">
        <div class="spinner_element"></div>
    </div>
</div>

<div class="page_dashboard_actuals" id = "erp_dashboard">
<div class="page_heading" style="margin-top: -30px; padding: 0 30px; float:right">
        <button type="button" class="btn btn-success" style="margin-top:23px; height:34px" id="dashboard_snap" value="search">SEND BOT</button>
    </div>
    <div class="page_heading" style="margin-top: -30px; padding: 0 30px;">
        <h3>Dashboard Actuals</h3>
    </div>
    <div class="auto_refresh_div">
        <div class="auto_refresh_info">
            <div class="last_updated_info">
                    <p class="lbl">Last Refreshed at: </p>
                    <p class="last_updated_at"></p>
            </div>

            <label class="slider_switch switch_refresh">
                <input type="checkbox" checked>
                <span class="sw_slider round"></span>
            </label>
        </div>

        <p class="alert_info" style="display: none;">
            <span class="msg">Auto-Refresh is Disabled</span>
            <span class="close"><i class="fa fa-times" aria-hidden="true"></i></span>
        </p>
    </div>

    <div class="page_search_filter" style="margin-bottom: 15px; padding: 0 20px;">

        <div class="panel main_search" data-card_type="all">
            <div class="row" style="display: flex; align-items: center">
                <div class="col-md-6">
                    <div class="periodic_search">
                        
                        <div class="time_filter">
                            <span class="date_show"></span>
                            <span class="span-period">
                                <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                                <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                                <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                                <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                                <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="date_period">
                        <input type="date" class="form-control date_field date_period_frm" style="width: 150px;">
                        <span class="dates_rel fa fa-arrows-h" aria-hidden="true" style="margin: 5px; cursor: pointer;"></span>
                        <input type="date" class="form-control date_field date_period_to" style="width: 150px;">
                    </div>
                </div>
            </div>
        </div>
        
    </div>

    <div class="pane">
        <div class="panel-row cards_container">
            
            <div class="panel panel-primary purchase_cw" data-card_type="purchase_cw" data-card_id="1" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Purchase - Category Wise</h5>

                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" class="table table-striped" id="purchase_cw_tbl">
                            <thead>
                                <tr>
                                    <th class="left">Category</th>
                                    <th class="right">Invoice<br>Qty</th>
                                    <th class="right">Inward<br>Qty</th>
                                    <th class="right">Amt.</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                        <!-- <div class="no_data_found" style="display: none;">
                            <div class="inner_block">
                                <p class="no_data_msg">No Data</p>
                            </div>
                        </div> -->
                    </div>
                </div>
            </div>

            <div class="panel panel-warning sales_cw" data-card_type="sales_cw" data-card_id="2" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Sales - Category Wise</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" class="table table-striped" id="sales_cw_tbl">
                            <tr>
                                <th class="left">Category</th>
                                <th class="right">No. of<br>Invoices</th>
                                <th class="right">Qty</th>
                                <th class="right">Amt.</th>
                            </tr>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel panel-success sales_sc" data-card_type="sales_sc" data-card_id="3" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Sales - Sales Channel Wise</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" class="table table-striped" id="sales_sc_tbl">
                            <tr>
                                <th class="left">Channel</th>
                                <th class="right">No. of<br>Invoices</th>
                                <th class="right">Qty</th>
                                <th class="right">Amt.</th>
                            </tr>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="panel panel-info sales_o_sc" data-card_type="sales_o_sc" data-card_id="4" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Sales - Online Channel Wise</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" class="table table-striped" id="sales_sc_o_tbl">
                            <tr>
                                <th class="left">Channel</th>
                                <th class="right">No. of<br>Invoices</th>
                                <th class="right">Qty</th>
                                <th class="right">Amt.</th>
                            </tr>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="panel panel-info sales_o_sc_api" data-card_type="sales_o_sc_api" data-card_id="5" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Shipped Sales - Online (API Data)</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" class="table table-striped" id="sales_cnt_amz_api">
                            <tr>
                                <th class="left">Channel</th>
                                <th class="right">No. of<br>Invoices</th>
                                <th class="right">Qty</th>
                                <th class="right">Amt.</th>
                            </tr>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="panel panel-info sr_o_sc_api" data-card_type="sr_o_sc_api" data-card_id="6" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Sale Returns - Online (API Data)</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" class="table table-striped" id="sr_cnt_amz_api">
                            <tr>
                                <th class="left">Channel</th>
                                <th class="right">No. of<br>Invoices</th>
                                <th class="right">Qty</th>
                                <!-- <th class="right">Amt.</th> -->
                            </tr>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="panel panel-primary purchase_return_cw" data-card_type="purchase_return_cw" data-card_id="9" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Purchase Return - Category Wise</h5>

                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" class="table table-striped" id="purchase_return_cw_tbl">
                            <thead>
                                <tr>
                                    <th class="left">Category</th>
                                    <!-- <th class="right">Invoice<br>Qty</th> -->
                                    <th class="right">Return<br>Qty</th>
                                    <th class="right">Return<br>Value</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                        <!-- <div class="no_data_found" style="display: none;">
                            <div class="inner_block">
                                <p class="no_data_msg">No Data</p>
                            </div>
                        </div> -->
                    </div>
                </div>
            </div>

            <div class="panel panel-primary sr_cw" data-card_type="sr_cw" data-card_id="10" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Sales Return</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" class="table table-striped" id="sr_status_tbl">
                            <tr>
                                <th class="left">Status</th>
                                <th class="right">No. of<br>Returns</th>
                                <th class="right">Qty</th>
                                <th class="right">Amt.</th>
                            </tr>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel panel-danger claims_sw" data-card_type="claims_sw" data-card_id="11" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Claims</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" id="claims_status_tbl" class="table table-striped">
                            <tr>
                                <th class="left">Status</th>
                                <th class="right">No. of<br>Claims</th>
                                <th class="right">Claim<br>Amt</th>
                                <th class="right">Approved<br>Amt</th>
                            </tr>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="panel panel-info so_sw" data-card_type="so_sw" data-card_id="12" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Sales Orders</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" id="so_log_tbl" class="table table-striped">
                            <tr>
                                <th class="left">Status</th>
                                <th class="right">No. of<br>S.O.</th>
                                <th class="right">Qty</th>
                                <th class="right">Amt</th>
                            </tr>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel panel-success certf_prod" data-card_type="certf_prod" data-card_id="13" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Certification</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>

                    <div class="action_btns_div">
                        <span class="btn_send_to_cliqbot" data-tbl="#cert_prod_tbl">
                            <i class="fa fa-paper-plane" aria-hidden="true"></i>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" id="cert_prod_tbl" class="table table-striped">
                            <thead>
                                <tr>
                                    <th class="left">Category</th>
                                    <th class="right">Allocated</th>
                                    <th class="right">Processed</th>
                                    <th class="right">Pending</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel panel-success triage_prod" data-card_type="triage_prod" data-card_id="14" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Triage</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>

                    <div class="action_btns_div">
                        <span class="btn_send_to_cliqbot" data-tbl="#triage_prod_tbl">
                            <i class="fa fa-paper-plane" aria-hidden="true"></i>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" id="triage_prod_tbl" class="table table-striped">
                            <thead>
                                <tr class="non_zero_rule">
                                    <th colspan="1" class="left"></th>
                                    <th colspan="3" class="center">Allocated</th>
                                    <th colspan="3" class="center">Repaired</th>
                                </tr>
                                <tr class="non_zero_rule">
                                    <!-- <th class="left">Sno</th> -->
                                    <th class="left">Name</th>
                                    <th class="right">Openbox</th>
                                    <th class="right">Prexo</th>
                                    <th class="right">Total</th>
                                    <th class="right">Openbox</th>
                                    <th class="right">Prexo</th>
                                    <th class="right">Total</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="panel panel-warning export_sales_div" data-card_type="export_sales_div" data-card_id="7" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Export Sales - Category Wise</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" class="table table-striped" id="export_sales_tbl">
                            <tr>
                                <th class="left">Category</th>
                                <th class="right">No. of<br>Invoices</th>
                                <th class="right">Qty</th>
                                <th class="right">Amt.</th>
                            </tr>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="panel panel-warning noida_sales_cw_div" data-card_type="noida_sales_cw_div" data-card_id="8" data-search_src="">
                <div class="panel-heading">
                    <h5 class="title">Noida Sales - Category Wise</h5>
                    
                    <div class="time_filter">
                        <span class="date_show"></span>
                        <span class="span-period">
                            <span class="time_period time_d active" data-tp="D" title="Today">D</span>
                            <span class="time_period time_w" data-tp="W" title="Current Week">W</span>
                            <span class="time_period time_m" data-tp="M" title="Current Month">M</span>
                            <span class="time_period time_q" data-tp="Q" title="Current Quarter">Q</span>
                            <span class="time_period time_y" data-tp="YTD" title="Current Year">YTD</span>
                        </span>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="panel_body_inner">
                        <table style="width: 100%;" class="table table-striped" id="noida_sales_cw_tbl">
                            <tr>
                                <th class="left">Category</th>
                                <th class="right">No. of<br>Invoices</th>
                                <th class="right">Qty</th>
                                <th class="right">Amt.</th>
                            </tr>
                        </table>
                        <div class="overlay">
                            <div class="cv-spinner">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

</div>




<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment.min.js"></script>

<script>
    //get Current Url
    <?php if (base_url() == 'http://erp_new/') { ?>
        var base_url = "http://localhost:4007";
        // var base_url = "http://localhost:3000";
    <?php } else { ?>
        var base_url = "https://insight.sloyd.in";
    <?php } ?>
    
    const ERP_BASE_URL = '<?php echo base_url(); ?>';
    
    var panel_methods = {
        'purchase_cw': getPurchaseCategoryWiseData,
        'sales_cw': getSalesCategoryWiseData,
        'sales_sc': getSalesChannelWiseData,
        'sales_o_sc': getSalesOnlineChannelWiseData,
        'sales_o_sc_api': getSalesOnlineChannelWiseData_AmazonApi,
        'sr_o_sc_api': getSaleReturns_OnlineChannelWiseData_AmazonApi,
        'export_sales_div': getExportSales_CatgWise_Data,
        'noida_sales_cw_div': getNoidaSales_CatgWise_Data,
        'purchase_return_cw': getPurchaseReturnCategoryWiseData,
        'sr_cw': getSalesReturnStatusData,
        'claims_sw': getClaimsStatusData,
        'so_sw': getSalesOrderStatusData,
        'certf_prod': getCertificationStatusData,
        'triage_prod': getTriageStatusData,
    };
    
    const AUTO_REFRESH_TIME = 15 * 60 * 1000; // 15 Minutes

    $(function() {
        maintain_AccessLog();

        // Set MainSearch DateFields with default dates
        set_DateFields_Search('D');
        
    });

    function maintain_AccessLog() {
        window.localStorage.setItem('access_log_id', <?php echo $access_log_id; ?>);
        window.localStorage.setItem('access_updated_time', Date.now());

        update_AccessLog();
    }
    function update_AccessLog() {
        let req_obj = {
            access_log_id : window.localStorage.getItem('access_log_id')
        };

        $.ajax({
            url : encodeURI(ERP_BASE_URL + "/admin/Analytics/update_Dashboard_AccessLog"),
            type: 'POST',
            dataType: 'json',
            data: JSON.stringify(req_obj),
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                if (data.status) {
                    window.localStorage.setItem('access_updated_time', Date.now());
                    window.localStorage.setItem('access_updated_date', data.access_updated_date);

                    setTimeout(function() {
                        update_AccessLog();
                    }, 20000);
                }
            },
            error: function(data) {
                console.log(data);
            }
        });
    }

    $(window).on('scroll', function() {
        let window_scrollTop = $(window).scrollTop();
        let element_offset_Top = $('.page_search_filter').offset().top;

        if (window_scrollTop >= 30) {
            $('.page_search_filter').addClass('element_sticky');
        } else {
            $('.page_search_filter').removeClass('element_sticky');
        }
    });

    $('.panel .panel-heading .title').addClass('toggle__tr_zero');

    $('.toggle__tr_zero').on('click', function() {
        id = $(this).parents('.panel').find('table .tr_zero');
        if (id.is(':visible')) {
            id.hide();
            $(this).find('.fa').removeClass('fa-eye-slash').addClass('fa-eye');
        } else {
            id.show();
            $(this).find('.fa').removeClass('fa-eye').addClass('fa-eye-slash');
        }
    });

    $('.dates_rel').off().on('click', function() {
        if ($(this).hasClass('active')) {
            $(this).removeClass('active');
        } else {
            $(this).addClass('active');

            let parent = $(this).parents('.date_period');
            let dt_frm = parent.find('.date_period_frm');
            let dt_to = parent.find('.date_period_to');
            if (dt_frm.val().trim() != '') {
                dt_to.val(dt_frm.val().trim()).trigger('change');
            } else if (dt_to.val().trim() != '') {
                dt_frm.val(dt_to.val().trim()).trigger('change');
            }
        }
    });

    $('.date_period .date_field').on('change', function() {
        $('.periodic_search .span-period span').removeClass('active');

        let parent = $(this).parents('.date_period');

        if (parent.find('.dates_rel').hasClass('active')) {
            $('.date_period .date_field').val( $(this).val() );
        }

        Do_Custom_MainSearch();
    });
    
    $(".span-period .time_period").on('click', (e) => {
        let card_type = $(e.target).parents('.panel').data('card_type');
        let period_type = $(e.target).data('tp').trim();

        $(e.target).parents('.span-period').find('.time_period').removeClass('active');
        
        if (card_type == 'all') {
            $(e.target).addClass('active');
            $('.dates_rel').removeClass('active');
            
            // Set MainSearch DateFields with selected period dates
            set_DateFields_Search(period_type);
            $('.panel[data-card_type]').data('search_src', 'main');

        } else {
            panel_methods[card_type](period_type);

            // Set MainSearch DateFields Empty
            set_DateFields_Search();

            $('.panel[data-card_type='+ card_type +']').data('search_src', 'self');
        }
    });
    
    // Set MainSearch DateFields
    function set_DateFields_Search(period_type) {
        
        if (!isValidString(period_type)) {
            $('.date_period, .periodic_search').addClass('not_all_affected');
        }

        if (isValidString(period_type)) {
            let period = getPeriod(period_type);
            let start_date = moment(period.start_date).format('YYYY-MM-DD');
            let end_date = moment(period.end_date).format('YYYY-MM-DD');
            
            $('.date_period .date_period_frm').val(start_date);
            $('.date_period .date_period_to').val(end_date);

            // $('.date_period, .periodic_search').removeClass('not_all_affected');
            Do_Custom_MainSearch();
        }
    }

    function Do_Custom_MainSearch() {
        let period_type = 'CSTM';

        $.each(panel_methods, function(i, v) {
            v(period_type);
        });
        
        $('.date_period, .periodic_search').removeClass('not_all_affected');

        Track_User_Usage('all');

        set_AutoRefresh_Time();
    }

    function set_AutoRefresh_Time() {

        /** Auto-Refresh Time */
        var dt = new Date(); 
        let last_refreshed_at = str_pad(dt.getDate(), 2, '0') + "/"
                    + str_pad(dt.getMonth()+1, 2, '0')  + "/" 
                    + dt.getFullYear() + " @ "  
                    + str_pad(dt.getHours(), 2, '0') + ":"  
                    + str_pad(dt.getMinutes(), 2, '0') + ":" 
                    + str_pad(dt.getSeconds(), 2, '0');

        let next_auto_refresh = Date.now() + AUTO_REFRESH_TIME;
        localStorage.setItem('next_auto_refresh', next_auto_refresh);
        
        console.log('Last AutoRefresh: ' + last_refreshed_at);
        console.log('Next AutoRefresh: ' + new Date(next_auto_refresh));

        $('.last_updated_at').text(last_refreshed_at);
        
        auto_Refresh_Data();
    }

    function auto_Refresh_Data() {
        let next_auto_refresh = parseInt(localStorage.getItem('next_auto_refresh'));
        if (!isValidString(next_auto_refresh)) {
            return false;
        }

        let diff_time = Date.now() - next_auto_refresh;
        if (diff_time >= 0) {
            
            if ($('.switch_refresh input[type="checkbox"]').is(':checked')) {
                Do_Custom_MainSearch();
            } else {
                console.log('Auto-Refresh is Disabled');
                $('.auto_refresh_div .alert_info').show();

                localStorage.setItem('next_auto_refresh', (Date.now() + AUTO_REFRESH_TIME));
                auto_Refresh_Data();
            }
            
        } else {
            setTimeout(function() {
                auto_Refresh_Data();
            }, Math.abs(diff_time));
        }
    }

    $('.switch_refresh input[type="checkbox"]').on('change', function() {
        
        if (!$(this).is(':checked')) {
            $('.auto_refresh_div .alert_info').show();
            console.log('Auto-Refresh Disabled');

            // let opt = confirm("Are you sure to disable Auto-Refresh ?");
            // if (opt) {
            //     $(this).prop('checked', false);
            //     $('.auto_refresh_div .alert_info').show();

            //     console.log('Auto-Refresh Disabled');
            // } else {
            //     $(this).prop('checked', true);
            //     $('.auto_refresh_div .alert_info').hide();
            // }
        } else {
            $('.auto_refresh_div .alert_info').hide();
            /** Calling API calls */
            Do_Custom_MainSearch();
        }
    });

    $('.alert_info .close').on('click', function() {
        $(this).parents('.alert_info').hide();
    });

    function custom_Amazon_Row(table) {
        table = (typeof table == 'object')? table : $(table);

        table.find('tr.AMAZON td.count').text( parseInt(table.find('tr.SELLERFLEX td.count').text()) + parseInt(table.find('tr.FBA td.count').text()) );
        table.find('tr.AMAZON td.quantity').text( parseInt(table.find('tr.SELLERFLEX td.quantity').text()) + parseInt(table.find('tr.FBA td.quantity').text()) );
        table.find('tr.AMAZON td.amount').text( parseInt(table.find('tr.SELLERFLEX td.amount').text()) + parseInt(table.find('tr.FBA td.amount').text()) );
    }
    
    function tables_common_functionality(table_id) {
        hide_zerovalue_tablerows(table_id);
        put_Download_Options(table_id);

        Track_User_Usage(table_id);
    }

    function put_DateRange_inCard(table_id) {
        let panel = $(table_id).parents('.panel[data-card_type]');

        let start_date = moment(panel.data('start_date')).format('DD/MM/YYYY');
        let end_date = moment(panel.data('end_date')).format('DD/MM/YYYY');
        $(table_id).parents('.panel[data-card_type]').find('span.date_show').text(`${start_date} - ${end_date}`);
    }
    
    function hide_zerovalue_tablerows(table, skip_indexes = [0]) {
        table = (typeof table == 'object')? table : $(table);

        table.find('tr').each(function(i, v) {
            if ($.inArray(i, skip_indexes) != -1 || $(this).hasClass('non_zero_rule')) return true;
            
            td_non_zero = 0;
            $(this).find('td:nth-of-type(n+2)').each(function() {
                let is_currency = $(this).hasClass('currency');
                let num = parseFloat($(this).text().trim());
                if (num > 0) {
                    td_non_zero++;
                }
                // console.log(num + ' --> ' + IND_Number_Format(num, is_currency) );
                $(this).text( IND_Number_Format(num, is_currency) );
            });

            if (td_non_zero == 0 && (!$(this).hasClass('tfooter')) ) {
                $(this).addClass('tr_zero').hide();
            }
        });
    }

    function put_Download_Options(table_id) {
        table_id = (typeof table_id == 'object')? table_id : $(table_id);

        let html = '<span class="options_div" style="display:none;">'
                 + '  <span class="btn btn_view"> <i class="fa fa-eye" aria-hidden="true"></i> </span>'
                 + '  <span class="btn btn_download"> <i class="fa fa-download" aria-hidden="true"></i> </span>'
                 + '</span>';
        table_id.find('tbody tr td:nth-last-of-type(1)').append(html);

    }

    function IND_Number_Format(num, is_currency = false) {
        var options = {};
        if (is_currency) {
            options = {
                style: 'currency',
                currency: 'INR'
            }
        }
        const curr = num.toLocaleString('en-IN', options);
        return curr;
    }

    // Highlighting each card period type
    function highlight_PeriodType(table_id, period_type) {
        table_id = (typeof table_id == 'object')? table_id : $(table_id);

        let span_period = table_id.parents('.panel').find('.span-period span');
        span_period.removeClass('active');

        span_period.each(function(i, v) {
            if ($(this).text().trim() == period_type) {
                $(this).addClass('active');
            }
        });
    }
    

    //Convert Day/Week/Month/Quarter/Year to Start Date and End Date
    function getPeriod(period_type) {
        if (period_type == 'D') {
            start_date = moment().format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'W') {
            start_date = moment().startOf('week').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'M') {
            start_date = moment().startOf('month').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'Q') {
            // Get Financial Quarter
            start_date = moment().startOf('quarter').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'YTD') {
            //Start From First April
            let crnt_mnth = new Date().getMonth();
            if (crnt_mnth >= 3) {
                start_date = moment().year(moment().year()).month(3).date(1).format('YYYY-MM-DD');
            } else {
                start_date = moment().year(moment().year()-1).month(3).date(1).format('YYYY-MM-DD');
            }
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'CSTM') {
            start_date = $('.date_period .date_period_frm').val();
            end_date = $('.date_period .date_period_to').val();

            if (start_date == '') {
                start_date = moment().format('YYYY-MM-DD');
            }
            if (end_date == '') {
                end_date = moment().format('YYYY-MM-DD');
            }
            if (start_date == '' && end_date == '') {
                alert('Invalid Date Period');
                $('.periodic_search .span-period span:nth-of-type(1)').addClass('active');
            }
            
        } else {
            return false;
        }

        return {
            start_date: start_date,
            end_date: end_date
        }
    }


    function getPurchaseCategoryWiseData(date_period = 'D') {
        let table_id = '#purchase_cw_tbl';

        highlight_PeriodType(table_id, date_period);
        // Remove all rows except first one
        $(table_id +' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100)
        let period = getPeriod(date_period)

        if (!period) return false;

        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);

        let csv_url = 'admin/Reports/downloadCsvReportsDevicesWithSales';
        let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        let to_date = moment(period.end_date).format('YYYY-MM-DD');
        $(table_id +' tbody').attr('data-frm_date', frm_date);
        $(table_id +' tbody').attr('data-to_date', to_date);
        $(table_id +' tbody').attr('data-csv_url', csv_url);
        $(table_id +' tbody').attr('data-element_type', '');
        $(table_id +' tbody').addClass('dwnld_options');

        let jsonObject = JSON.stringify(period)

        $.ajax({
            url: encodeURI(base_url + '/purchase/purchase_category_wise'),
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                let device_cats = <?= json_encode(DEVICE_CATEGORY) ?>;
                let total_inward = 0;
                let total_invoice = 0;
                let total_amount = 0;

                $(table_id +' tr').slice(1).remove();

                device_cats.forEach((element) => {
                    if (element == 'PRELOVED') {
                        return true
                    }
                    let row = '<tr>'

                    if (data.hasOwnProperty(element)) {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                        row += '<td class="right">' + data[element].invoice_qty + '</td>'
                        row += '<td class="right">' + data[element].inward_qty + '</td>'
                        row += '<td class="right currency">' + data[element].amount.toFixed(2) + '</td>'

                        total_inward += +data[element].inward_qty;
                        total_invoice += +data[element].invoice_qty;
                        total_amount += +data[element].amount;
                    } else {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                        row += '<td class="right">0</td>'
                        row += '<td class="right">0</td>'
                        row += '<td class="right currency">0</td>'
                    }

                    row += '</tr>'
                    $(table_id +' tbody').append(row)
                });

                let row = '<tr class="tfooter">'
                row += '<td class="left row_element" data-element="">Total</td>'
                row += '<td class="right">' + total_invoice + '</td>'
                row += '<td class="right">' + total_inward + '</td>'
                row += '<td class="right currency">' + total_amount.toFixed(2) + '</td>'
                row += '</tr>'
                $(table_id).parent().find('div.overlay').fadeOut(100);
                $(table_id).append(row);

                tables_common_functionality(table_id);
            },
            error: function(error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(error)
            }
        })
    }

    function getPurchaseReturnCategoryWiseData(date_period = 'D') {
        let table_id = '#purchase_return_cw_tbl';

        highlight_PeriodType(table_id, date_period);
        // Remove all rows except first one
        $(table_id +' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100)
        let period = getPeriod(date_period)

        if (!period) return false;

        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);

        let csv_url = 'admin/Reports/downloadCsvReportsDevicesWithSales';
        let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        let to_date = moment(period.end_date).format('YYYY-MM-DD');
        $(table_id +' tbody').attr('data-frm_date', frm_date);
        $(table_id +' tbody').attr('data-to_date', to_date);
        $(table_id +' tbody').attr('data-csv_url', csv_url);
        $(table_id +' tbody').attr('data-element_type', '');
        $(table_id +' tbody').addClass('dwnld_options');

        let jsonObject = JSON.stringify(period)

        $.ajax({
            url: encodeURI(base_url + '/purchase/purchase_return_category_wise'),
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                let device_cats = <?= json_encode(DEVICE_CATEGORY) ?>;
                let total_inward = 0;
                let total_invoice = 0;
                let total_amount = 0;
                
                $(table_id +' tr').slice(1).remove();

                device_cats.forEach((element) => {
                    if (element == 'PRELOVED') {
                        return true
                    }
                    let row = '<tr>'

                    if (data.hasOwnProperty(element)) {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                        // row += '<td class="right">' + data[element].invoice_qty + '</td>'
                        row += '<td class="right">' + data[element].return_qty + '</td>'
                        row += '<td class="right currency">' + data[element].return_value.toFixed(2) + '</td>'

                        // total_invoice += +data[element].invoice_qty;
                        total_inward += +data[element].return_qty;
                        total_amount += +data[element].return_value;
                    } else {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                        // row += '<td class="right">0</td>'
                        row += '<td class="right">0</td>'
                        row += '<td class="right currency">0</td>'
                    }

                    row += '</tr>'
                    $(table_id +' tbody').append(row)
                });

                let row = '<tr class="tfooter">'
                row += '<td class="left row_element" data-element="">Total</td>'
                // row += '<td class="right">' + total_invoice + '</td>'
                row += '<td class="right">' + total_inward + '</td>'
                row += '<td class="right currency">' + total_amount.toFixed(2) + '</td>'
                row += '</tr>'
                $(table_id).parent().find('div.overlay').fadeOut(100);
                $(table_id).append(row);

                tables_common_functionality(table_id);
            },
            error: function(error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(error)
            }
        })
    }

    function getSalesCategoryWiseData(date_period = 'D') {
        let table_id = '#sales_cw_tbl';

        highlight_PeriodType(table_id, date_period);
        // Remove all rows except first one
        $(table_id +' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100)
        let period = getPeriod(date_period)

        if (!period) return false;

        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);
        
        let csv_url = 'admin/Reports/downloadCsvReportsInvoiceItemWithPurchase';
        let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        let to_date = moment(period.end_date).format('YYYY-MM-DD');
        $(table_id +' tbody').attr('data-frm_date', frm_date);
        $(table_id +' tbody').attr('data-to_date', to_date);
        $(table_id +' tbody').attr('data-csv_url', csv_url);
        $(table_id +' tbody').attr('data-element_type', 'catg');
        // $(table_id +' tbody').attr('data-branch', 'HYD');
        $(table_id +' tbody').addClass('dwnld_options');

        let jsonObject = JSON.stringify(period);

        $.ajax({
            url: encodeURI(base_url + '/sales/sales_category_wise'),
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                let device_cats = <?= json_encode(DEVICE_CATEGORY) ?>;
                let total_count = 0;
                let total_amount = 0;
                let total_quantity = 0;
                
                $(table_id +' tr').slice(1).remove();

                device_cats.forEach((element) => {
                    if (element == 'PRELOVED--') {
                        return true
                    }
                    let row = '<tr>'

                    if (data.hasOwnProperty(element)) {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                        row += '<td class="right">' + data[element].count + '</td>'
                        row += '<td class="right">' + data[element].quantity + '</td>'
                        row += '<td class="right currency">' + data[element].amount.toFixed(2) + '</td>'

                        total_count += +data[element].count;
                        total_quantity += +data[element].quantity;
                        total_amount += +data[element].amount.toFixed(2);
                    } else {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                        row += '<td class="right">0</td>'
                        row += '<td class="right">0</td>'
                        row += '<td class="right currency">0</td>'
                    }
                    row += '</tr>'
                    $(table_id).append(row)
                })

                let row = '<tr class="tfooter">'
                row += '<td class="left row_element" data-element="">Total</td>'
                row += '<td class="right">' + total_count + '</td>'
                row += '<td class="right">' + total_quantity + '</td>'
                row += '<td class="right currency">' + total_amount.toFixed(2) + '</td>'
                row += '</tr>'

                $(table_id).parent().find('div.overlay').fadeOut(100)
                $(table_id).append(row);

                tables_common_functionality(table_id);
            },
            error: function(error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(error)
            }
        })
    }

    function getSalesOnlineChannelWiseData(period_type = 'D') {
        getSalesChannelWiseData(period_type, 'online')
    }
    function getSalesChannelWiseData(date_period = 'D', type = 'offline') {
        let table_id = (type == 'online')? '#sales_sc_o_tbl' : '#sales_sc_tbl';

        highlight_PeriodType(table_id, date_period);

        let period = getPeriod(date_period);
        
        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);

        // Remove all rows except first one
        $(table_id +' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100)
        $(table_id).parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`);

        
        let url = encodeURI(base_url + '/sales/sales_channel_wise');
        let csv_url = 'admin/Reports/downloadCsvReportsInvoiceItemWithPurchase';
        let element_type = 'scw';

        if (type == 'online') {
            url = encodeURI(base_url + '/sales/sales_channel_wise/' + type);
            csv_url = 'admin/Reports/downloadCsvReportsInvoiceItemWithPurchase';
            element_type = 'scw_o';
        }
        
        let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        let to_date = moment(period.end_date).format('YYYY-MM-DD');

        $(table_id +' tbody').attr('data-frm_date', frm_date);
        $(table_id +' tbody').attr('data-to_date', to_date);
        $(table_id +' tbody').attr('data-csv_url', csv_url);
        $(table_id +' tbody').attr('data-element_type', element_type);
        $(table_id +' tbody').addClass('dwnld_options');

        if (!period) return false;

        let jsonObject = JSON.stringify(period)

        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                let channels = ['OFFLINE', 'ONLINE', 'DEALERAPP', 'EXPORT'];

                if (type == 'online') {
                    channels = <?= json_encode(ONLINE_CHANNELS) ?>;
                    channels.splice(2, 0, 'FBA');
                }

                let total_count = 0;
                let total_amount = 0;
                let total_quantity = 0;

                var html = '';

                channels.forEach((element) => {
                    if ( $.inArray(element, ['PRELOVED--']) != -1 ) {
                        return true;
                    }
                    if ((type == 'online') && ($.inArray(element, ['PRELOVED', 'DEALERAPP']) != -1)) {
                        return true;
                    }
                    let element_abr = element;
                    if (type == 'online') {
                        if ($.inArray(element, ['AMAZON']) != -1) {
                            element_abr = 'AMAZON - TOTAL';
                        }
                        if ($.inArray(element, ['SELLERFLEX', 'FBA']) != -1) {
                            element_abr = 'AMAZON - ' + element;
                        }
                    }

                    var csv_url = '';
                    if (element == 'FBA') {
                        csv_url = 'admin/Reports/downloadCsvReportsEcomInvoiceItem';
                    }

                    var row = '<tr class="'+ element +'" data-csv_url="'+ csv_url +'">';

                    if (data.hasOwnProperty(element)) {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element_abr + '</td>'
                        row += '<td class="right count" data-val="'+ data[element].count +'">' + data[element].count + '</td>'
                        row += '<td class="right quantity" data-val="'+ data[element].quantity +'">' + data[element].quantity + '</td>'
                        row += '<td class="right amount currency" data-val="'+ data[element].amount.toFixed(2) +'">' + data[element].amount.toFixed(2) + '</td>'

                        total_count += +data[element].count;
                        total_quantity += +data[element].quantity;
                        total_amount += +data[element].amount;
                    } else {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element_abr + '</td>'
                        row += '<td class="right count" data-val="0">0</td>'
                        row += '<td class="right quantity" data-val="0">0</td>'
                        row += '<td class="right amount currency" data-val="0">0</td>'
                    }
                    row += '</tr>';

                    html += row;
                });

                let row = '<tr class="tfooter">'
                row += '<td class="left row_element" data-element="">Total</td>'
                row += '<td class="right count" data-val="'+ total_count +'">' + total_count + '</td>'
                row += '<td class="right quantity" data-val="'+ total_quantity +'">' + total_quantity + '</td>'
                row += '<td class="right amount currency" data-val="'+ total_amount.toFixed(2) +'">' + total_amount.toFixed(2) + '</td>'
                row += '</tr>'

                html += row;

                $(table_id +' tr').slice(1).remove();
                $(table_id).parent().find('div.overlay').fadeOut(100);
                $(table_id).append(html);

                if (type == 'online') {
                    $(table_id +' tbody tr.AMAZON').addClass('no_dwnld_data');
                    custom_Amazon_Row(table_id);
                } else {
                    $(table_id +' tbody tr.ONLINE').addClass('no_dwnld_data');
                }
                
                tables_common_functionality(table_id);
            },
            error: function(error) {
                $(table_id).parent().find('div.overlay').fadeOut(100);
                console.log(error)
            }
        })
    }
    
    function getSalesOnlineChannelWiseData_AmazonApi(date_period = 'D') {
        let table_id = '#sales_cnt_amz_api';
        
        highlight_PeriodType(table_id, date_period);

        let period = getPeriod(date_period);
        if (!period) return false;
        
        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);

        let url = encodeURI(ERP_BASE_URL + "/admin/Reports/getAmazon_Sales");

        let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        let to_date = moment(period.end_date).format('YYYY-MM-DD');

        // Remove all rows except first one
        $(table_id +' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100)
        
        let csv_url = '';
        $(table_id +' tbody').attr('data-frm_date', frm_date);
        $(table_id +' tbody').attr('data-to_date', to_date);
        // $(table_id +' tbody').attr('data-csv_url', csv_url);
        // $(table_id +' tbody').attr('data-element_type', 'scw_o');
        // $(table_id +' tbody').addClass('dwnld_options');

        let jsonObject = JSON.stringify(period);

        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                if (!data.status) {
                    data = [];
                }
                data = data.data;
                console.log(data);
                channels = ['AMAZON', 'SELLERFLEX', 'FBA'];

                let total_count = 0;
                let total_amount = 0;
                let total_quantity = 0;

                var html = '';

                channels.forEach((element) => {
                    if ($.inArray(element, ['PRELOVED', 'DEALERAPP']) != -1) {
                        return true;
                    }
                    let element_abr = element;
                    if ($.inArray(element, ['AMAZON']) != -1) {
                        element_abr = 'AMAZON - TOTAL';
                    }
                    if ($.inArray(element, ['SELLERFLEX', 'FBA']) != -1) {
                        element_abr = 'AMAZON - ' + element;
                    }

                    var csv_url = '';
                    // if (element == 'FBA') {
                    //     csv_url = 'admin/Reports/downloadCsvReportsEcomInvoiceItem';
                    // }

                    var row = '<tr class="'+ element +'" data-csv_url="'+ csv_url +'">';

                    if (data.hasOwnProperty(element)) {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element_abr + '</td>'
                        row += '<td class="right count" data-val="'+ data[element].total_invoices +'">' + data[element].total_invoices + '</td>'
                        row += '<td class="right quantity" data-val="'+ data[element].total_qty +'">' + data[element].total_qty + '</td>'
                        row += '<td class="right amount currency" data-val="'+ data[element].total_amount +'">' + data[element].total_amount + '</td>'

                        if (element != 'AMAZON') {
                            total_count += +data[element].total_invoices;
                            total_quantity += +data[element].total_qty;
                            total_amount += +data[element].total_amount;
                        }
                    } else {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element_abr + '</td>'
                        row += '<td class="right count" data-val="0">0</td>'
                        row += '<td class="right quantity" data-val="0">0</td>'
                        row += '<td class="right amount currency" data-val="0">0</td>'
                    }
                    row += '</tr>';

                    html += row;

                });

                let row = '<tr class="tfooter">'
                row += '<td class="left row_element" data-element="">Total</td>'
                row += '<td class="right count" data-val="'+ total_count +'">' + total_count + '</td>'
                row += '<td class="right quantity" data-val="'+ total_quantity +'">' + total_quantity + '</td>'
                row += '<td class="right amount currency" data-val="'+ total_amount +'">' + total_amount + '</td>'
                row += '</tr>'

                html += row;

                $(table_id +' tr').slice(1).remove();
                $(table_id).parent().find('div.overlay').fadeOut(100);
                $(table_id).append(html);
                $(table_id +' tbody tr.AMAZON').addClass('no_dwnld_data');
                tables_common_functionality(table_id);
            },
            error: function(error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(error)
            }
        })
    }
    
    function getSaleReturns_OnlineChannelWiseData_AmazonApi(date_period = 'D') {
        let table_id = '#sr_cnt_amz_api';
        
        highlight_PeriodType(table_id, date_period);

        let period = getPeriod(date_period);
        if (!period) return false;
        
        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);

        let url = encodeURI(ERP_BASE_URL + "/admin/Reports/getAmazon_Returns")
        
        let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        let to_date = moment(period.end_date).format('YYYY-MM-DD');

        // Remove all rows except first one
        $(table_id +' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100)
        
        let csv_url = '';
        $(table_id +' tbody').attr('data-frm_date', frm_date);
        $(table_id +' tbody').attr('data-to_date', to_date);
        // $(table_id +' tbody').attr('data-csv_url', csv_url);
        // $(table_id +' tbody').attr('data-element_type', 'scw_o');
        // $(table_id +' tbody').addClass('dwnld_options');
        
        let jsonObject = JSON.stringify(period);

        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                if (!data.status) {
                    data = [];
                }
                data = data.data;
                console.log(data);
                // channels = ['AMAZON', 'SELLERFLEX', 'FBA'];
                channels = ['FBA'];

                let total_count = 0;
                let total_amount = 0;
                let total_quantity = 0;

                var html = '';

                channels.forEach((element) => {
                    if ($.inArray(element, ['PRELOVED', 'DEALERAPP']) != -1) {
                        return true;
                    }
                    let element_abr = element;
                    if ($.inArray(element, ['AMAZON']) != -1) {
                        element_abr = 'AMAZON - TOTAL';
                    }
                    if ($.inArray(element, ['SELLERFLEX', 'FBA']) != -1) {
                        element_abr = 'AMAZON - ' + element;
                    }

                    var csv_url = '';
                    // if (element == 'FBA') {
                    //     csv_url = 'admin/Reports/downloadCsvReportsEcomInvoiceItem';
                    // }

                    var row = '<tr class="'+ element +'" data-csv_url="'+ csv_url +'">';

                    if (data.hasOwnProperty(element)) {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element_abr + '</td>'
                        row += '<td class="right count" data-val="'+ data[element].total_invoices +'">' + data[element].total_invoices + '</td>'
                        row += '<td class="right quantity" data-val="'+ data[element].total_qty +'">' + data[element].total_qty + '</td>'
                        // row += '<td class="right amount currency" data-val="'+ data[element].total_amount +'">' + data[element].total_amount + '</td>'

                        if (element != 'AMAZON') {
                            total_count += +data[element].total_invoices;
                            total_quantity += +data[element].total_qty;
                            // total_amount += +data[element].total_amount;
                        }
                    } else {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element_abr + '</td>'
                        row += '<td class="right count" data-val="0">0</td>'
                        row += '<td class="right quantity" data-val="0">0</td>'
                        // row += '<td class="right amount currency" data-val="0">0</td>'
                    }
                    row += '</tr>';

                    html += row;

                });

                let row = '<tr class="tfooter">'
                row += '<td class="left row_element" data-element="">Total</td>'
                row += '<td class="right count" data-val="'+ total_count +'">' + total_count + '</td>'
                row += '<td class="right quantity" data-val="'+ total_quantity +'">' + total_quantity + '</td>'
                // row += '<td class="right amount currency" data-val="'+ total_amount +'">' + total_amount + '</td>'
                row += '</tr>'

                html += row;

                $(table_id +' tr').slice(1).remove();
                $(table_id).parent().find('div.overlay').fadeOut(100);
                $(table_id).append(html);
                $(table_id +' tbody tr.AMAZON').addClass('no_dwnld_data');
                tables_common_functionality(table_id);
            },
            error: function(error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(error)
            }
        })
    }

    function getSalesReturnStatusData(period_type = 'D') {
        let table_id = '#sr_status_tbl';

        highlight_PeriodType(table_id, period_type);
        // Remove all rows except first one
        $(table_id +' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100);

        let period = getPeriod(period_type);
        if (!period) return false;
        
        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);
        
        let csv_url = 'admin/Reports/downloadCsvReportsSalesreturnItem';
        let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        let to_date = moment(period.end_date).format('YYYY-MM-DD');
        $(table_id +' tbody').attr('data-frm_date', frm_date);
        $(table_id +' tbody').attr('data-to_date', to_date);
        $(table_id +' tbody').attr('data-csv_url', csv_url);
        $(table_id +' tbody').attr('data-element_type', 'status');
        $(table_id +' tbody').addClass('dwnld_options');
        
        let jsonObject = JSON.stringify(period);

        $.ajax({
            type: 'POST',
            url: encodeURI(base_url + "/returns/returns_status_wise"),
            data: jsonObject,
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            success: function(data) {
                let status = ['IN_TRANSIT', 'WH_PENDING', 'FINANCE_PENDING', 'CN_CREATED']
                let totalQty = 0;
                let totalAmt = 0;
                let totalCount = 0;

                var html = '';

                status.forEach((element) => {
                    let row_element = data[element];
                    var rowData = '<tr>';

                    if (data.hasOwnProperty(element)) {
                        rowData += '<td class="left row_element" data-element="'+ element +'">' + element.replace('_', ' ') + '</td>'
                        rowData += '<td class="right">' + data[element].count + '</td>'
                        rowData += '<td class="right">' + data[element].quantity + '</td>'
                        rowData += '<td class="right currency">' + data[element].amount.toFixed(2) + '</td>'

                        totalQty += +row_element.quantity;
                        totalAmt += +row_element.amount;
                        totalCount += +row_element.count;
                    } else {
                        rowData += '<td class="left row_element" data-element="'+ element +'">' + element.replace('_', ' ') + '</td>'
                        rowData += '<td class="right">0</td>'
                        rowData += '<td class="right">0</td>'
                        rowData += '<td class="right currency">0</td>'
                    }

                    rowData += '</tr>';

                    html += rowData;
                    // $("#sr_status_tbl").append(rowData);
                })
                let row = '<tr class="tfooter">'
                row += '<td class="left row_element" data-element="">Total</td>'
                row += '<td class="right">' + totalCount + '</td>'
                row += '<td class="right">' + totalQty + '</td>'
                row += '<td class="right currency">' + totalAmt.toFixed(2) + '</td>'
                row += '</tr>';

                html += row;
                
                $(table_id +' tr').slice(1).remove();
                $(table_id).parent().find('div.overlay').fadeOut(100)
                $("#sr_status_tbl").append(html);

                tables_common_functionality(table_id);
            },
            error: function(xhr, status, error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(xhr);
                console.log(status);
                console.log(error);
            }
        });
    }

    function getClaimsStatusData(period_type = 'D') {
        let table_id = '#claims_status_tbl';

        highlight_PeriodType(table_id, period_type);
        // Remove all rows except first one
        $(table_id +' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100);

        let period = getPeriod(period_type);
        if (!period) return false;
        
        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);

        let jsonObject = JSON.stringify(period);

        $.ajax({
            type: 'POST',
            url: encodeURI(base_url + "/returns/claims_status_wise"),
            data: jsonObject,
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            success: function(data) {
                let status = ['PENDING', 'APPROVED', 'REJECTED', 'FINANCE_REJECTED', 'SETTLED']
                let totalClaims = 0
                let totalApproved = 0
                let totalClaimed = 0

                var html = '';

                status.forEach((element) => {
                    let st = element;
                    if (element == 'PENDING') {
                        st = 'Pending From Marketplace'
                    } else if (element == 'APPROVED') {
                        st = 'Approved By Marketplace'
                    } else if (element == 'REJECTED') {
                        st = 'Rejected By Marketplace'
                    }

                    var rowData = '<tr>';
                    if (data.hasOwnProperty(element)) {
                        let obj = data[element];

                        rowData += '<td class="left">' + st.replace('_', ' ') + '</td>'
                        rowData += '<td class="center">' + obj.t_claims + '</td>'
                        rowData += '<td class="right currency">' + parseFloat(gvv(obj.t_claim_amount, 0)).toFixed(2) + '</td>'
                        rowData += '<td class="right currency">' + parseFloat(gvv(obj.t_approved_amount, 0)).toFixed(2) + '</td>'

                        totalClaims += +obj.t_claims;
                        totalClaimed += +obj.t_claim_amount;
                        totalApproved += +obj.t_approved_amount;
                    } else {
                        rowData += '<td class="left">' + st.replace('_', ' ') + '</td>'
                        rowData += '<td class="center">0</td>'
                        rowData += '<td class="right currency">0</td>'
                        rowData += '<td class="right currency">0</td>'
                    }

                    rowData += '</tr>';

                    html += rowData;
                    // $("#claims_status_tbl").append(rowData);
                })
                let row = '<tr class="tfooter">'
                row += '<td class="left">Total</td>'
                row += '<td class="center">' + totalClaims + '</td>'
                row += '<td class="right currency">' + totalClaimed.toFixed(2) + '</td>'
                row += '<td class="right currency">' + totalApproved.toFixed(2) + '</td>'
                row += '</tr>';

                html += row;

                $(table_id +' tr').slice(1).remove();
                $(table_id).parent().find('div.overlay').fadeOut(100)
                $("#claims_status_tbl").append(html);

                tables_common_functionality(table_id);
            },
            error: function(xhr, status, error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(xhr);
                console.log(status);
                console.log(error);
            }
        });
    }

    function getSalesOrderStatusData(period_type = 'D') {
        let table_id = '#so_log_tbl';

        highlight_PeriodType(table_id, period_type);

        // Remove all rows except first one
        $(table_id +' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100);

        let period = getPeriod(period_type);
        if (!period) return false;

        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);

        let jsonObject = JSON.stringify(period)

        $.ajax({
            type: 'POST',
            url: encodeURI(base_url + "/sales/so_daily_log"),
            data: jsonObject,
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            success: function(data) {
                let status = ['FINANCE_PENDING', 'FINANCE_APPROVED', 'INVOICED']
                let totalQty = 0;
                let totalAmt = 0;
                let totalCount = 0;

                var html = '';

                status.forEach((element) => {
                    let row_element = data[element];
                    var rowData = '<tr>';
                    rowData += '<td class="left">' + element.replace('_', ' ') + '</td>';
                    rowData += '<td class="right">' + row_element.count + '</td>';
                    rowData += '<td class="right">' + row_element.quantity + '</td>';
                    rowData += '<td class="right currency">' + row_element.amount.toFixed(2) + '</td>';
                    rowData += '</tr>';

                    totalQty += +row_element.quantity;
                    totalAmt += +row_element.amount;
                    totalCount += +row_element.count;

                    html += rowData;
                    // $("#so_log_tbl").append(rowData);
                })

                $(table_id +' tr').slice(1).remove();
                $(table_id).parent().find('div.overlay').fadeOut(100);
                $("#so_log_tbl").append(html);

                tables_common_functionality(table_id);
            },
            error: function(xhr, status, error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(xhr);
                console.log(status);
                console.log(error);
            }
        });
    }

    function getCertificationStatusData(period_type = 'D') {
        let table_id = '#cert_prod_tbl';

        highlight_PeriodType(table_id, period_type);

        // Remove all rows except first one
        $(table_id +' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100);

        let period = getPeriod(period_type);
        if (!period) return false;

        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);
        
        // let csv_url = 'admin/Reports/dashboard_certification_report';
        // let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        // let to_date = moment(period.end_date).format('YYYY-MM-DD');
        // $(table_id +' tbody').attr('data-frm_date', frm_date);
        // $(table_id +' tbody').attr('data-to_date', to_date);
        // $(table_id +' tbody').attr('data-csv_url', csv_url);
        // $(table_id +' tbody').attr('data-element_type', '');
        // $(table_id +' tbody').addClass('dwnld_options');

        let jsonObject = JSON.stringify(period);

        $.ajax({
            type: 'POST',
            url: encodeURI(base_url + "/operations/certification_productivity"),
            data: jsonObject,
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            success: function(data) {
                let total_allocated = 0
                let total_processed = 0
                let total_pending = 0

                var html = '';
                $.each(data, function(i, v) {
                    html += '<tr>'
                            + '    <td class="left">'+ i +'</td>'
                            + '    <td class="right">'+ v['Allocated'] +'</td>'
                            + '    <td class="right">'+ v['Processed'] +'</td>'
                            + '    <td class="right">'+ v['Pending'] +'</td>'
                            + '</tr>';

                    total_allocated += v['Allocated'];
                    total_processed += v['Processed'];
                    total_pending += v['Pending'];
                });

                html += '<tr class="tfooter">'
                        + '    <td class="left">Total</td>'
                        + '    <td class="right">'+ total_allocated +'</td>'
                        + '    <td class="right">'+ total_processed +'</td>'
                        + '    <td class="right">'+ total_pending +'</td>'
                        + '</tr>';

                $("#cert_prod_tbl tbody").html(html);
                $(table_id).parent().find('div.overlay').fadeOut(100);

                tables_common_functionality(table_id);
            },
            error: function(xhr, status, error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(xhr);
                console.log(status);
                console.log(error);
            }
        });
    }

    function getTriageStatusData(period_type = 'D') {
        let table_id = '#triage_prod_tbl';
        
        highlight_PeriodType(table_id, period_type);

        // Remove all rows except first one
        $(table_id +' tr').slice(2).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100);

        let period = getPeriod(period_type);
        if (!period) return false;

        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);

        let req_obj = {
            from_date: period.start_date,
            to_date: period.end_date
        };

		// let url = 'https://optimiage.sloyd.in/admin/Web_api/serviceEngineerData';
        $("#triage_prod_tbl tbody").html('');

        $.ajax({
            type: 'POST',
            // url: url,
            url: encodeURI(ERP_BASE_URL + "/admin/Reports/getTriageStatistics"),
            data: JSON.stringify(req_obj),
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            success: function(data) {
                if (!data.status) {
                    toastr.error('Error in fetching Triage Data');
                    return false;
                }

                let total_allocated_opb = 0
                let total_allocated_prexo = 0
                let total_allocated_both = 0
                let total_repaired_opb = 0
                let total_repaired_prexo = 0
                let total_repaired_both = 0

                var html = '';
                $.each(data.data, function(i, v) {
                    html += '<tr>'
                            // + '    <td class="left">'+ (i+1) +'</td>'
                            + '    <td class="left">'+ v['username'] +'</td>'
                            + '    <td class="right">'+ v['openbox_attempted'] +'</td>'
                            + '    <td class="right">'+ v['prexo_attempted'] +'</td>'
                            + '    <td class="right">'+ v['total_attempted'] +'</td>'
                            + '    <td class="right">'+ v['openbox_done'] +'</td>'
                            + '    <td class="right">'+ v['prexo_done'] +'</td>'
                            + '    <td class="right">'+ v['total_done'] +'</td>'
                            + '</tr>';

                    total_allocated_opb += v['openbox_attempted'];
                    total_allocated_prexo += v['prexo_attempted'];
                    total_allocated_both += v['total_attempted'];

                    total_repaired_opb += v['openbox_done'];
                    total_repaired_prexo += v['prexo_done'];
                    total_repaired_both += v['total_done'];
                });

                html += '<tr class="tfooter">'
                        + '    <td colspan="1" class="center">Total</td>'
                        + '    <td class="right">'+ total_allocated_opb +'</td>'
                        + '    <td class="right">'+ total_allocated_prexo +'</td>'
                        + '    <td class="right">'+ total_allocated_both +'</td>'
                        + '    <td class="right">'+ total_repaired_opb +'</td>'
                        + '    <td class="right">'+ total_repaired_prexo +'</td>'
                        + '    <td class="right">'+ total_repaired_both +'</td>'
                        + '</tr>';

                $("#triage_prod_tbl tbody").html(html);
                $(table_id).parent().find('div.overlay').fadeOut(100);

                tables_common_functionality(table_id);
            },
            error: function(xhr, status, error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(xhr);
                console.log(status);
                console.log(error);
            }
        });
    }

    function getExportSales_CatgWise_Data(date_period = 'D') {
        let table_id = '#export_sales_tbl';
        
        highlight_PeriodType(table_id, date_period);
        let url = encodeURI(ERP_BASE_URL + "/admin/Reports/getExportSales_CatgWise");
        
        // Remove all rows except first one
        $(table_id + ' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100);

        let period = getPeriod(date_period);
        if (!period) return false;

        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);
        
        let csv_url = 'admin/Reports/downloadCsvReportsInvoiceItemWithPurchase';
        let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        let to_date = moment(period.end_date).format('YYYY-MM-DD');

        $(table_id + ' tbody').attr('data-frm_date', frm_date);
        $(table_id + ' tbody').attr('data-to_date', to_date);
        $(table_id + ' tbody').attr('data-csv_url', csv_url);
        $(table_id + ' tbody').attr('data-element_type', 'catg');
        $(table_id + ' tbody').attr('data-branch', 'HYD');
        $(table_id + ' tbody').attr('data-extra_params', 'sc=EXPORT');
        $(table_id + ' tbody').addClass('dwnld_options');

        let jsonObject = JSON.stringify(period);

        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                if (!data.status) {
                    data = [];
                }
                data = data.data;
                
                let device_cats = <?= json_encode(DEVICE_CATEGORY) ?>;
                
                let total_count = 0;
                let total_amount = 0;
                let total_quantity = 0;
                
                $(table_id + ' tr').slice(1).remove();

                var html = '';

                device_cats.forEach((element) => {
                    if (element == 'PRELOVED') {
                        return true
                    }
                    let row = '<tr class="'+ element +'" data-csv_url="'+ csv_url +'">'

                    if (data.hasOwnProperty(element)) {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                        row += '<td class="right count" data-val="'+ data[element].total_invoices +'">' + data[element].total_invoices + '</td>'
                        row += '<td class="right quantity" data-val="'+ data[element].total_qty +'">' + data[element].total_qty + '</td>'
                        row += '<td class="right amount currency" data-val="'+ data[element].total_amount +'">' + data[element].total_amount + '</td>'

                        total_count += +data[element].total_invoices;
                        total_quantity += +data[element].total_qty;
                        total_amount += +data[element].total_amount;
                    } else {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                        row += '<td class="right count">0</td>'
                        row += '<td class="right quantity">0</td>'
                        row += '<td class="right amount currency">0</td>'
                    }
                    row += '</tr>';

                    html += row;
                    $(table_id).append(row)
                })

                let row = '<tr class="tfooter">'
                row += '<td class="left row_element" data-element="">Total</td>'
                row += '<td class="right count" data-val="'+ total_count +'">' + total_count + '</td>'
                row += '<td class="right quantity" data-val="'+ total_quantity +'">' + total_quantity + '</td>'
                row += '<td class="right amount currency" data-val="'+ total_amount +'">' + total_amount + '</td>'
                row += '</tr>'
                
                html += row;

                $(table_id + ' tr').slice(1).remove();
                $(table_id).parent().find('div.overlay').fadeOut(100);
                $(table_id).append(html);

                tables_common_functionality(table_id);
            },
            error: function(error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(error)
            }
        })
    }

    function getNoidaSales_CatgWise_Data(date_period = 'D') {
        let table_id = '#noida_sales_cw_tbl';

        highlight_PeriodType(table_id, date_period);
        let url = encodeURI(ERP_BASE_URL + "/admin/Reports/getNoidaSales_CatgWise");
        
        // Remove all rows except first one
        $(table_id + ' tr').slice(1).remove();
        $(table_id).parent().find('div.overlay').fadeIn(100);

        let period = getPeriod(date_period);
        if (!period) return false;

        $(table_id).parents('.panel[data-card_type]').data('start_date', period.start_date);
        $(table_id).parents('.panel[data-card_type]').data('end_date', period.end_date);
        put_DateRange_inCard(table_id);
        
        let csv_url = 'admin/Reports/downloadCsvReportsInvoiceItemWithPurchase';
        let frm_date = moment(period.start_date).format('YYYY-MM-DD');
        let to_date = moment(period.end_date).format('YYYY-MM-DD');
        $(table_id + ' tbody').attr('data-frm_date', frm_date);
        $(table_id + ' tbody').attr('data-to_date', to_date);
        $(table_id + ' tbody').attr('data-csv_url', csv_url);
        $(table_id + ' tbody').attr('data-element_type', 'catg');
        $(table_id + ' tbody').attr('data-branch', 'NOIDA');
        $(table_id + ' tbody').addClass('dwnld_options');

        let jsonObject = JSON.stringify(period);

        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                if (!data.status) {
                    data = [];
                }
                data = data.data;
                
                let device_cats = <?= json_encode(DEVICE_CATEGORY) ?>;
                
                let total_count = 0;
                let total_amount = 0;
                let total_quantity = 0;
                
                $(table_id + ' tr').slice(1).remove();

                var html = '';

                device_cats.forEach((element) => {
                    if (element == 'PRELOVED') {
                        return true
                    }
                    let row = '<tr class="'+ element +'" data-csv_url="'+ csv_url +'">'

                    if (data.hasOwnProperty(element)) {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                        row += '<td class="right count" data-val="'+ data[element].total_invoices +'">' + data[element].total_invoices + '</td>'
                        row += '<td class="right quantity" data-val="'+ data[element].total_qty +'">' + data[element].total_qty + '</td>'
                        row += '<td class="right amount currency" data-val="'+ data[element].total_amount +'">' + data[element].total_amount + '</td>'

                        total_count += +data[element].total_invoices;
                        total_quantity += +data[element].total_qty;
                        total_amount += +data[element].total_amount;
                    } else {
                        row += '<td class="left row_element" data-element="'+ element +'">' + element + '</td>'
                        row += '<td class="right count">0</td>'
                        row += '<td class="right quantity">0</td>'
                        row += '<td class="right amount currency">0</td>'
                    }
                    row += '</tr>';

                    html += row;
                    $(table_id).append(row)
                })

                let row = '<tr class="tfooter">'
                row += '<td class="left row_element" data-element="">Total</td>'
                row += '<td class="right count" data-val="'+ total_count +'">' + total_count + '</td>'
                row += '<td class="right quantity" data-val="'+ total_quantity +'">' + total_quantity + '</td>'
                row += '<td class="right amount currency" data-val="'+ total_amount +'">' + total_amount + '</td>'
                row += '</tr>'
                
                html += row;

                $(table_id + ' tr').slice(1).remove();
                $(table_id).parent().find('div.overlay').fadeOut(100);
                $(table_id).append(html);

                tables_common_functionality(table_id);
            },
            error: function(error) {
                $(table_id).parent().find('div.overlay').fadeOut(100)
                console.log(error)
            }
        })
    }

    
    $('table tbody').on('mouseover', 'tr td', function() {
        if ($(this).parents('tbody').hasClass('dwnld_options')) {
            $(this).parents('tr:not(.no_dwnld_data)').find('.options_div').show();
        }
    });
    $('table tbody').on('mouseout', 'tr td', function() {
        if ($(this).parents('tbody').hasClass('dwnld_options')) {
            $(this).parents('tr').find('.options_div').hide();
        }
    });

    $('table tbody').on('click', '.options_div .btn', function() {
        let tr_url = $(this).parents('tr').data('csv_url');
        let url = isValidString(tr_url)? tr_url : $(this).parents('tbody').data('csv_url');

        let status = '';
        let frm_date = $(this).parents('tbody').data('frm_date');
        let to_date = $(this).parents('tbody').data('to_date');
        let element_type = $(this).parents('tbody').data('element_type');
        let branch = $(this).parents('tbody').data('branch');
        let extra_params = $(this).parents('tbody').data('extra_params');
        let element = $(this).parents('tr').find('.row_element').data('element');
        let output_type = $(this).hasClass('btn_view')? 'data':'';

        let req_obj = {
            'status': status,
            'from_date': frm_date,
            'to_date': to_date,
            'element': element,
            'element_type': element_type,
            'branch': branch,
            'output_type': output_type
        }
        
        if (isValidString(extra_params)) {
            let temp_arr = extra_params.split('&');
            $.each(temp_arr, function(i,v) {
                let temp = v.split('=');
                if (temp.length > 0) {
                    req_obj[temp[0]] = temp[1];
                }
            });
        }

        if (output_type == '') {
            // let data = 'status='+status+'&from_date='+frm_date+'&to_date='+to_date+'&element='+element+'&output_type='+output_type;
            let url_get = ERP_BASE_URL + url + '?';
            $.each(req_obj, function(i, v) {
                url_get += i + '=' + v + '&';
            });

            console.log(url_get);

            window.location.href = url_get;

            Track_User_Usage('#'+ $(this).parents('table').attr('id'), 'reports');

        } else {

            $('.page_spinner').show();

            $.ajax({
                url: ERP_BASE_URL + url,
                type: 'GET',
                data: req_obj,
                dataType: 'json',
                success: function(data) {
                    $('.page_spinner').hide();
                    
                    fill_view_table(data);
                },
                error: function(data) {
                    $('.page_spinner').hide();
                    console.log(data);
                }
            });
        }
        
    });

    function fill_view_table(data) {
        let thead_data = data.titles;

        var tbody_data = data.body;

        // console.log(JSON.stringify(thead_data));
        // console.log(JSON.stringify(tbody_data));

        var html = '<div style="width: 100%; overflow-x:auto;">';
        html     += '<table class="table-responsive" id="dashboard_data_table">'
                 + '  <thead>'
                 + '    <tr>';

        $.each(thead_data, function(i, v) {
            html +=  '<th>'+ v +'</th>';
        });
        
        html +=  '    </tr>'
               + '  </thead>'
               + ''
               + '  <tbody>'
               + '  </tbody>'
               + '</table>';
        html += '</div>';

        $('#modal_view_data .modal_body_content').html(html);
        $('#modal_view_data').modal();

        $('#dashboard_data_table').DataTable({
            processing: true,
            serverSide: false,
            // scrollX: true,
			"dom": 'Bfrtip',
			"buttons": [{
				"extend": 'csv',
				"text": '<span class="fa fa-download" style="color:white;"></span>',
				'className': 'btn btn-green down_btn',

				// exportOptions: {
				// 	columns: ':not(.no_dwnld)'
				// }
			}],
            data: tbody_data
        });
    }

    $('.btn_send_to_cliqbot').on('click', function() {
        let tbl = $(this).data('tbl');
        let src = '';
        if (tbl == '#cert_prod_tbl') {
            src = 'certf';
        }

        var data = [];
        let temp = {};
        $(tbl +' thead tr th').each(function(i, v) {
            temp[i] = $(this).text().trim();
        });
        data.push(temp);

        $(tbl +' tbody tr').each(function(i, v) {
            let temp = {};
            $(this).find('td').each(function(i, v) {
                temp[i] = $(this).text().trim();
            });
            data.push(temp);
        });

        // console.log(JSON.stringify(data));

        sendStatsToCliqBot(data, src);
    });

    function sendStatsToCliqBot(req_data, src) {
        req_data = {
            'data': req_data,
            'src': src
        }

        $('.page_spinner').show();

        $.ajax({
            url: ERP_BASE_URL + 'admin/Analytics/createStatsImage',
            type: 'POST',
            data: req_data,
            dataType: 'json',
            success: function(data) {
                $('.page_spinner').hide();

                if (data.status) {
                    let html = '<div class="text-center">'
                             + '    <img src="'+ data.img_locn +'" />'
                             + '    <br />'
                             + '    <button class="btn btn-success btn_confsendtoCliqbot" data-img_locn="'+ data.img_locn +'" data-img_about="'+ data.img_about +'">Confirm Send to Cliq Bot</button>'
                             + '</div>';

                    $('#modal_display_info .modal_body_content').html(html);

                    $('#modal_display_info').modal();
                }
            },
            error: function(data) {
                $('.page_spinner').hide();
                console.log(data);
            }
        })
    }

    setTimeout(function() {
        $('#modal_display_info').on('click', '.btn_confsendtoCliqbot', function() {

            let img_locn = $(this).data('img_locn');
            let img_about = $(this).data('img_about');

            if (!isValidString(img_locn) || !isValidString(img_about)) {
                return false;
            }

            let req_data = {
                'img_locn': img_locn,
                'img_about': img_about
            }

            confirm_sendImage_toCliqBot(req_data);

        });
    }, 5000);

    function confirm_sendImage_toCliqBot(req_data) {
        $('#modal_display_info').modal('hide');

        $('.page_spinner').show();

        $.ajax({
            url: ERP_BASE_URL + 'admin/Analytics/sendStatsToCliqBot',
            type: 'POST',
            data: req_data,
            dataType: 'json',
            success: function(data) {
                $('.page_spinner').hide();
                
                console.log('ChatBot Response: ' + JSON.stringify(data));

                if (data.status) {
                    toastr('success', data.message);
                } else {
                    toastr('error', data.message);
                }
            },
            error: function(data) {
                $('.page_spinner').hide();
                console.log(data);
            }
        });
    }

    function Track_User_Usage(table_id, card_access_type = 'search') {
        var card_id;
        var from_date;
        var to_date;
        
        if (table_id == 'all') {
            card_id = 0;
            
            from_date = $('.date_period .date_period_frm').val();
            to_date = $('.date_period .date_period_to').val();
            
        } else {
            table_id = (typeof table_id == 'object')? table_id : $(table_id);

            let panel = table_id.parents('.panel[data-card_type]');
            if (panel.data('search_src') != 'self' && (card_access_type != 'reports')) {
                /** Ignore this call */
                return false;
            }

            from_date = panel.data('start_date');
            to_date = panel.data('end_date');

            card_id = panel.data('card_id');
            if (isValidString(card_id)) {
                card_id = parseInt(card_id);
            } else {
                console.log('Error in fetching Card ID');
                return false;
            }
        }

        if (card_id >= 0) {
            // console.log(card_id);
            // console.log(from_date);
            // console.log(to_date);

            let req_obj = {
                access_log_id: window.localStorage.getItem('access_log_id'),
                card_id: card_id,
                from_date: from_date,
                to_date: to_date,
                card_access_type: card_access_type,
            }

            $.ajax({
                url: ERP_BASE_URL + 'admin/Analytics/update_DashboardCards_AccessLog',
                type: 'POST',
                data: JSON.stringify(req_obj),
                dataType: 'json',
                success: function(data) {
                    console.log(data.message);
                    // if (data.status) {
                    //     toastr.success(data.message);
                    // } else {
                    //     toastr.error(data.message);
                    // }
                },
                error: function(data) {
                    console.log(data);
                }
            });

        }
    }

</script>

<script>
    function str_pad(str, max, pad_string='0') {
        str = str.toString();
        return str.length < max ? str_pad(pad_string + str, max) : str;
    }

    function sendToCliq() {
        html2canvas($("#erp_dashboard")[0]).then((canvas) => {
    
        var imgData = canvas.toDataURL('image/jpeg');
        
        $.ajax({
            url : '<?= base_url() ?>admin/Analytics/Save',
            type: 'post',
            dataType: 'text',
            data: JSON.stringify(imgData),
        })
    });
}
</script>
