<style>
    /* row 3x1 for small devices 3x3 for large devices */
    @media (max-width: 767px) {
        .row {
            flex-direction: column;
            margin-bottom: 10px;
        }

        .pane {
            margin-bottom: 10px;
            padding: auto;
        }
    }

    .panel {
        margin: 10px;
        width: 30%;
        min-width: 340px;
    }

    .left {
        text-align: left;
    }

    .right {
        text-align: right;
    }

    .span-period {
        float: right;
        background-color: #FFF;
        color: #CCC;
        padding: 5px;
    }

    .span-period span {
        color: #ccc;
        font-weight: 700;
    }

    .span-period span.active {
        color: #F00;
    }

    .span-period span:hover {
        color: #00F;
        cursor: pointer;
    }

    .tfooter td {
        background-color: cadetblue;
        color: #FFF;
        padding: 5px;
        font-weight: 700;

    }

    table tr th {
        background-color: #9fc5d4;
    }

    /* Spinner */
    .overlay {
        position: relative;
        top: 0;
        z-index: 100;
        min-width: 340px;
        max-width: 400px;
        height: 250px;
        display: none;
        background: rgba(250, 250, 250, 0.6);
    }

    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }

    @keyframes sp-anime {
        100% {
            transform: rotate(360deg);
        }
    }

    .is-hide {
        display: none;
    }
</style>
<div class="pane" style="width: 100%;overflow-x:auto;">
    <div class="row panel-row" style="display:inline-flex; width:100%;margin-left:10px;">
        <div class="panel panel-primary">
            <div class="panel-heading">
                Purchase - Category Wise
                <div>
                    <span class="left date_show"></span>
                    <span class="span-period">
                        |<span class="purchase-cw-d active" title="Today"> D </span>
                        |<span class="purchase-cw-w" title="Current Week"> W </span>
                        |<span class="purchase-cw-m" title="Current Month"> M </span>
                        |<span class="purchase-cw-q" title="Current Quarter"> Q </span>
                        |<span class="purchase-cw-y" title="Current Year"> YTD </span>|
                    </span>
                </div>
            </div>
            <div class="panel-body">
                <table style="width: 100%;" class="table table-striped" id="purchase_cw_tbl">
                    <tr>
                        <th class="left">Category</th>
                        <th class="right">Invoice<br>Qty</th>
                        <th class="right">Inward<br>Qty</th>
                        <th class="right">Amt.</th>
                    </tr>
                </table>
                <div class="overlay">
                    <div class="cv-spinner">
                        <div class="spinner"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="panel panel-warning">
            <div class="panel-heading">
                Sales - Category Wise
                <div>
                    <span class="left date_show"></span>
                    <span class="span-period">
                        |<span class="sales-cw-d active" title="Today"> D </span>
                        |<span class="sales-cw-w" title="Current Week"> W </span>
                        |<span class="sales-cw-m" title="Current Month"> M </span>
                        |<span class="sales-cw-q" title="Current Quarter"> Q </span>
                        |<span class="sales-cw-y" title="Current Year"> YTD </span>|
                    </span>
                </div>
            </div>
            <div class="panel-body">
                <table style="width: 100%;" class="table table-striped" id="sales_cw_tbl">
                    <tr>
                        <th class="left">Category</th>
                        <th class="right">No. of<br>Invoices</th>
                        <th class="right">Qty</th>
                        <th class="right">Amt.</th>
                    </tr>
                </table>
                <div class="overlay">
                    <div class="cv-spinner">
                        <div class="spinner"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="panel panel-success">
            <div class="panel-heading">
                Sales - Sales Channel Wise
                <div>
                    <span class="left date_show"></span>
                    <span class="span-period">
                        |<span class="sales-sc-d active" title="Today"> D </span>
                        |<span class="sales-sc-w" title="Current Week"> W </span>
                        |<span class="sales-sc-m" title="Current Month"> M </span>
                        |<span class="sales-sc-q" title="Current Quarter"> Q </span>
                        |<span class="sales-sc-y" title="Current Year"> YTD </span>|
                    </span>
                </div>
            </div>
            <div class="panel-body">
                <table style="width: 100%;" class="table table-striped" id="sales_sc_tbl">
                    <tr>
                        <th class="left">Channel</th>
                        <th class="right">No. of<br>Invoices</th>
                        <th class="right">Qty</th>
                        <th class="right">Amt.</th>
                    </tr>
                </table>
                <div class="overlay">
                    <div class="cv-spinner">
                        <div class="spinner"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row panel-row" style="display:inline-flex; width:100%;margin-left:10px;">
        <div class="panel panel-success">
            <div class="panel-heading">
                Sales - Online Channel Wise
                <div>
                    <span class="left date_show"></span>
                    <span class="span-period">
                        |<span class="sales-o-sc-d active" title="Today"> D </span>
                        |<span class="sales-o-sc-w" title="Current Week"> W </span>
                        |<span class="sales-o-sc-m" title="Current Month"> M </span>
                        |<span class="sales-o-sc-q" title="Current Quarter"> Q </span>
                        |<span class="sales-o-sc-y" title="Current Year"> YTD </span>|
                    </span>
                </div>
            </div>
            <div class="panel-body">
                <table style="width: 100%;" class="table table-striped" id="sales_sc_o_tbl">
                    <tr>
                        <th class="left">Channel</th>
                        <th class="right">No. of<br>Invoices</th>
                        <th class="right">Qty</th>
                        <th class="right">Amt.</th>
                    </tr>
                </table>
                <div class="overlay">
                    <div class="cv-spinner">
                        <div class="spinner"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="panel panel-info">
            <div class="panel-heading">
                Sales Return
                <div>
                    <span class="left date_show"></span>
                    <span class="span-period">
                        |<span class="sr-cw-d active" title="Today"> D </span>
                        |<span class="sr-cw-w" title="Current Week"> W </span>
                        |<span class="sr-cw-m" title="Current Month"> M </span>
                        |<span class="sr-cw-q" title="Current Quarter"> Q </span>
                        |<span class="sr-cw-y" title="Current Year"> YTD </span>|
                    </span>
                </div>
            </div>
            <div class="panel-body">
                <table style="width: 100%;" class="table table-striped" id="sr_status_tbl">
                    <tr>
                        <th class="left">Status</th>
                        <th class="right">No. of<br>Returns</th>
                        <th class="right">Qty</th>
                        <th class="right">Amt.</th>
                    </tr>
                </table>
                <div class="overlay">
                    <div class="cv-spinner">
                        <div class="spinner"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="panel panel-danger">
            <div class="panel-heading">
                Claims
                <div>
                    <span class="left date_show"></span>
                    <span class="span-period">
                        |<span class="claims-sw-d active" title="Today"> D </span>
                        |<span class="claims-sw-w" title="Current Week"> W </span>
                        |<span class="claims-sw-m" title="Current Month"> M </span>
                        |<span class="claims-sw-q" title="Current Quarter"> Q </span>
                        |<span class="claims-sw-y" title="Current Year"> YTD </span>|
                    </span>
                </div>
            </div>
            <div class="panel-body">
                <table style="width: 100%;" id="claims_status_tbl" class="table table-striped">
                    <tr>
                        <th class="left">Status</th>
                        <th class="right">No. of<br>Claims</th>
                        <th class="right">Claim<br>Amt</th>
                        <th class="right">Approved<br>Amt</th>
                    </tr>
                </table>
                <div class="overlay">
                    <div class="cv-spinner">
                        <div class="spinner"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row panel-row" style="display:inline-flex; width:100%;margin-left:10px;">
        <div class="panel panel-info">
            <div class="panel-heading">
                Sales Orders
                <div>
                    <span class="left date_show"></span>
                    <span class="span-period">
                        |<span class="so-sw-d active" title="Today"> D </span>
                        |<span class="so-sw-w" title="Current Week"> W </span>
                        |<span class="so-sw-m" title="Current Month"> M </span>
                        |<span class="so-sw-q" title="Current Quarter"> Q </span>
                        |<span class="so-sw-y" title="Current Year"> YTD </span>|
                    </span>
                </div>
            </div>
            <div class="panel-body">
                <table style="width: 100%;" id="so_log_tbl" class="table table-striped">
                    <tr>
                        <th class="left">Status</th>
                        <th class="right">No. of<br>S.O.</th>
                        <th class="right">Qty</th>
                        <th class="right">Amt</th>
                    </tr>
                </table>
                <div class="overlay">
                    <div class="cv-spinner">
                        <div class="spinner"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="panel panel-success">
            <div class="panel-heading">
                Certification
                <div>
                    <span class="left date_show"></span>
                    <span class="span-period">
                        |<span class="cert-sw-d active" title="Today"> D </span>
                        |<span class="cert-sw-w" title="Current Week"> W </span>
                        |<span class="cert-sw-m" title="Current Month"> M </span>
                        |<span class="cert-sw-q" title="Current Quarter"> Q </span>
                        |<span class="cert-sw-y" title="Current Year"> YTD </span>|
                    </span>
                </div>
            </div>
            <div class="panel-body">
                <table style="width: 100%;" id="cert_prod_tbl" class="table table-striped">
                    <tr>
                        <th class="left">Status</th>
                        <th class="right">Quantity</th>
                    </tr>
                </table>
                <div class="overlay">
                    <div class="cv-spinner">
                        <div class="spinner"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment.min.js"></script>

<script>

    //get Current Url
    <?php if (base_url() == 'http://localhost/erp/') { ?>
        var base_url = "http://localhost:4007";
    <?php } else { ?>
        var base_url = "https://insight.sloyd.in";
    <?php } ?>
    
    $(".span-period span").on('click', (e) => {
        // get class list
        var classes = e.target.classList;
        // remove all active classes
        $(e.target).parent().find('span').removeClass('active');
        // if class name starts with 'sales-sc'
        $(e.target).addClass('active');
        let period_type = $(e.target).text().trim()

        //check class type
        if (classes[0].startsWith('sales-sc')) {
            getSalesChannelWiseData(period_type);
        }

        if (classes[0].startsWith('sales-cw')) {
            getSalesCategoryWiseData(period_type);
        }

        if (classes[0].startsWith('sales-o-sc')) {
            getSalesChannelWiseData(period_type, 'online');
        }

        if (classes[0].startsWith('sr-cw')) {
            getSalesReturnStatusData(period_type);
        }

        if (classes[0].startsWith('claims')) {
            getClaimsStatusData(period_type);
        }

        if (classes[0].startsWith('so')) {
            getSalesOrderStatusData(period_type);
        }

        if (classes[0].startsWith('cert')) {
            getCertificationStatusData(period_type);
        }

        if (classes[0].startsWith('purchase')) {
            getPurchaseCategoryWiseData(period_type);
        }
    })
    
    //Function Calls 
    getSalesOrderStatusData()
    getPurchaseCategoryWiseData()
    getSalesCategoryWiseData()
    getSalesChannelWiseData()
    getSalesChannelWiseData('D', 'online')
    getSalesReturnStatusData()
    getClaimsStatusData()
    getCertificationStatusData()

    //Convert Day/Week/Month/Quarter/Year to Start Date and End Date
    function getPeriod(period_type) {
        if (period_type == 'D') {
            start_date = moment().format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'W') {
            start_date = moment().startOf('week').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'M') {
            start_date = moment().startOf('month').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'Q') {
            // Get Financial Quarter
            start_date = moment().startOf('quarter').format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else if (period_type == 'YTD') {
            //Start From First April
            start_date = moment().year(moment().year()).month(3).date(1).format('YYYY-MM-DD');
            end_date = moment().format('YYYY-MM-DD');
        } else {
            return false;
        }

        return {
            start_date: start_date,
            end_date: end_date
        }
    }

    function getPurchaseCategoryWiseData(date_period = 'D') {
        // Remove all rows except first one
        $('#purchase_cw_tbl tr').slice(1).remove();
        $('#purchase_cw_tbl').parent().find('div.overlay').fadeIn(100)
        let period = getPeriod(date_period)

        if (!period) return false;

        let start_date = moment(period.start_date).format('DD/MM');
        let end_date = moment(period.end_date).format('DD/MM');
        $('#purchase_cw_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
        let jsonObject = JSON.stringify(period)

        $.ajax({
            url: encodeURI(base_url + '/purchase/purchase_category_wise'),
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                let device_cats = <?= json_encode(DEVICE_CATEGORY) ?>;
                let total_inward = 0;
                let total_invoice = 0;
                let total_amount = 0;

                device_cats.forEach((element) => {
                    if (element == 'PRELOVED') {
                        return true
                    }
                    let row = '<tr>'

                    if (data.hasOwnProperty(element)) {
                        row += '<td class="left">' + element + '</td>'
                        row += '<td class="right">' + data[element].invoice_qty + '</td>'
                        row += '<td class="right">' + data[element].inward_qty + '</td>'
                        row += '<td class="right">' + data[element].amount.toFixed(2) + '</td>'

                        total_inward += +data[element].inward_qty;
                        total_invoice += +data[element].invoice_qty;
                        total_amount += +data[element].amount;
                    } else {
                        row += '<td class="left">' + element + '</td>'
                        row += '<td class="right">0</td>'
                        row += '<td class="right">0</td>'
                        row += '<td class="right">0</td>'
                    }

                    row += '</tr>'
                    $('#purchase_cw_tbl').append(row)
                })

                let row = '<tr class="tfooter">'
                row += '<td class="left">Total</td>'
                row += '<td class="right">' + total_invoice + '</td>'
                row += '<td class="right">' + total_inward + '</td>'
                row += '<td class="right">' + total_amount.toFixed(2) + '</td>'
                row += '</tr>'
                $('#purchase_cw_tbl').parent().find('div.overlay').fadeOut(100)
                $('#purchase_cw_tbl').append(row)
            },
            error: function(error) {
                $('#purchase_cw_tbl').parent().find('div.overlay').fadeOut(100)
                console.log(error)
            }
        })
    }

    function getSalesCategoryWiseData(date_period = 'D') {
        // Remove all rows except first one
        $('#sales_cw_tbl tr').slice(1).remove();
        $('#sales_cw_tbl').parent().find('div.overlay').fadeIn(100)
        let period = getPeriod(date_period)

        if (!period) return false;

        let start_date = moment(period.start_date).format('DD/MM');
        let end_date = moment(period.end_date).format('DD/MM');
        $('#sales_cw_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
        let jsonObject = JSON.stringify(period)

        $.ajax({
            url: encodeURI(base_url + '/sales/sales_category_wise'),
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                let device_cats = <?= json_encode(DEVICE_CATEGORY) ?>;
                let total_count = 0;
                let total_amount = 0;
                let total_quantity = 0;

                device_cats.forEach((element) => {
                    if (element == 'PRELOVED') {
                        return true
                    }
                    let row = '<tr>'

                    if (data.hasOwnProperty(element)) {
                        row += '<td class="left">' + element + '</td>'
                        row += '<td class="right">' + data[element].count + '</td>'
                        row += '<td class="right">' + data[element].quantity + '</td>'
                        row += '<td class="right">' + data[element].amount.toFixed(2) + '</td>'

                        total_count += +data[element].count;
                        total_quantity += +data[element].quantity;
                        total_amount += +data[element].amount.toFixed(2);
                    } else {
                        row += '<td class="left">' + element + '</td>'
                        row += '<td class="right">0</td>'
                        row += '<td class="right">0</td>'
                        row += '<td class="right">0</td>'
                    }
                    row += '</tr>'
                    $('#sales_cw_tbl').append(row)
                })

                let row = '<tr class="tfooter">'
                row += '<td class="left">Total</td>'
                row += '<td class="right">' + total_count + '</td>'
                row += '<td class="right">' + total_quantity + '</td>'
                row += '<td class="right">' + total_amount.toFixed(2) + '</td>'
                row += '</tr>'

                $('#sales_cw_tbl').parent().find('div.overlay').fadeOut(100)
                $('#sales_cw_tbl').append(row)
            },
            error: function(error) {
                $('#sales_cw_tbl').parent().find('div.overlay').fadeOut(100)
                console.log(error)
            }
        })
    }

    function getSalesChannelWiseData(date_period = 'D', type = '') {
        let period = getPeriod(date_period)
        let url = encodeURI(base_url + '/sales/sales_channel_wise')
        let start_date = moment(period.start_date).format('DD/MM');
        let end_date = moment(period.end_date).format('DD/MM');

        if (type == 'online') {
            url = encodeURI(base_url + '/sales/sales_channel_wise/' + type)
            // Remove all rows except first one
            $('#sales_sc_o_tbl tr').slice(1).remove();
            $('#sales_sc_o_tbl').parent().find('div.overlay').fadeIn(100)
            $('#sales_sc_o_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
        } else {
            // Remove all rows except first one
            $('#sales_sc_tbl tr').slice(1).remove();
            $('#sales_sc_tbl').parent().find('div.overlay').fadeIn(100)
            $('#sales_sc_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
        }

        if (!period) return false;

        let jsonObject = JSON.stringify(period)

        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: jsonObject,
            contentType: 'application/json; charset=utf-8',
            success: function(data) {
                let channels = ['OFFLINE', 'ONLINE', 'DEALERAPP']

                if (type == 'online') {
                    channels = <?= json_encode(ONLINE_CHANNELS) ?>;
                }

                let total_count = 0;
                let total_amount = 0;
                let total_quantity = 0;

                channels.forEach((element) => {
                    if (element == 'PRELOVED') {
                        return true
                    }
                    let row = '<tr>'

                    if (data.hasOwnProperty(element)) {
                        row += '<td class="left">' + element + '</td>'
                        row += '<td class="right">' + data[element].count + '</td>'
                        row += '<td class="right">' + data[element].quantity + '</td>'
                        row += '<td class="right">' + data[element].amount.toFixed(2) + '</td>'

                        total_count += +data[element].count;
                        total_quantity += +data[element].quantity;
                        total_amount += +data[element].amount;
                    } else {
                        row += '<td class="left">' + element + '</td>'
                        row += '<td class="right">0</td>'
                        row += '<td class="right">0</td>'
                        row += '<td class="right">0</td>'
                    }
                    row += '</tr>'

                    if (type == 'online') {
                        $('#sales_sc_o_tbl').append(row)
                    } else {
                        $('#sales_sc_tbl').append(row)
                    }

                })

                let row = '<tr class="tfooter">'
                row += '<td class="left">Total</td>'
                row += '<td class="right">' + total_count + '</td>'
                row += '<td class="right">' + total_quantity + '</td>'
                row += '<td class="right">' + total_amount.toFixed(2) + '</td>'
                row += '</tr>'

                if (type == 'online') {
                    $('#sales_sc_o_tbl').parent().find('div.overlay').fadeOut(100)
                    $('#sales_sc_o_tbl').append(row)
                } else {
                    $('#sales_sc_tbl').parent().find('div.overlay').fadeOut(100)
                    $('#sales_sc_tbl').append(row)
                }
            },
            error: function(error) {
                if (type == 'online') {
                    $('#sales_sc_o_tbl').parent().find('div.overlay').fadeOut(100)
                } else {
                    $('#sales_sc_tbl').parent().find('div.overlay').fadeOut(100)
                }
                console.log(error)
            }
        })
    }

    function getSalesOrderStatusData(period_type = 'D') {
        // Remove all rows except first one
        $('#so_log_tbl tr').slice(1).remove();
        $('#so_log_tbl').parent().find('div.overlay').fadeIn(100)
        let period = getPeriod(period_type);

        if (!period) return false;

        let start_date = moment(period.start_date).format('DD/MM');
        let end_date = moment(period.end_date).format('DD/MM');
        $('#so_log_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
        let jsonObject = JSON.stringify(period)

        $.ajax({
            type: 'POST',
            url: encodeURI(base_url + "/sales/so_daily_log"),
            data: jsonObject,
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            success: function(data) {
                let status = ['FINANCE_PENDING', 'FINANCE_APPROVED', 'INVOICED']
                let totalQty = 0;
                let totalAmt = 0;
                let totalCount = 0;

                status.forEach((element) => {
                    let row_element = data[element];
                    var rowData = '<tr>';
                    rowData += '<td class="left">' + element.replace('_', ' ') + '</td>';
                    rowData += '<td class="right">' + row_element.count + '</td>';
                    rowData += '<td class="right">' + row_element.quantity + '</td>';
                    rowData += '<td class="right">' + row_element.amount.toFixed(2) + '</td>';
                    rowData += '</tr>';

                    totalQty += +row_element.quantity;
                    totalAmt += +row_element.amount;
                    totalCount += +row_element.count;
                    $("#so_log_tbl").append(rowData);
                })

                $('#so_log_tbl').parent().find('div.overlay').fadeOut(100)
            },
            error: function(xhr, status, error) {
                $('#so_log_tbl').parent().find('div.overlay').fadeOut(100)
                console.log(xhr);
                console.log(status);
                console.log(error);
            }
        });
    }

    function getSalesReturnStatusData(period_type = 'D') {
        // Remove all rows except first one
        $('#sr_status_tbl tr').slice(1).remove();
        $('#sr_status_tbl').parent().find('div.overlay').fadeIn(100)
        let period = getPeriod(period_type);

        if (!period) return false;

        let start_date = moment(period.start_date).format('DD/MM');
        let end_date = moment(period.end_date).format('DD/MM');
        $('#sr_status_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
        let jsonObject = JSON.stringify(period);

        $.ajax({
            type: 'POST',
            url: encodeURI(base_url + "/returns/returns_status_wise"),
            data: jsonObject,
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            success: function(data) {
                let status = ['IN_TRANSIT', 'WH_PENDING', 'FINANCE_PENDING', 'CN_CREATED']
                let totalQty = 0;
                let totalAmt = 0;
                let totalCount = 0;

                status.forEach((element) => {
                    let row_element = data[element];
                    var rowData = '<tr>';

                    if (data.hasOwnProperty(element)) {
                        rowData += '<td class="left">' + element.replace('_', ' ') + '</td>'
                        rowData += '<td class="right">' + data[element].count + '</td>'
                        rowData += '<td class="right">' + data[element].quantity + '</td>'
                        rowData += '<td class="right">' + data[element].amount.toFixed(2) + '</td>'

                        totalQty += +row_element.quantity;
                        totalAmt += +row_element.amount;
                        totalCount += +row_element.count;
                    } else {
                        rowData += '<td class="left">' + element.replace('_', ' ') + '</td>'
                        rowData += '<td class="right">0</td>'
                        rowData += '<td class="right">0</td>'
                        rowData += '<td class="right">0</td>'
                    }

                    rowData += '</tr>';
                    $("#sr_status_tbl").append(rowData);
                })
                let row = '<tr class="tfooter">'
                row += '<td class="left">Total</td>'
                row += '<td class="right">' + totalCount + '</td>'
                row += '<td class="right">' + totalQty + '</td>'
                row += '<td class="right">' + totalAmt.toFixed(2) + '</td>'
                row += '</tr>'
                $('#sr_status_tbl').parent().find('div.overlay').fadeOut(100)
                $("#sr_status_tbl").append(row);
            },
            error: function(xhr, status, error) {
                $('#sr_status_tbl').parent().find('div.overlay').fadeOut(100)
                console.log(xhr);
                console.log(status);
                console.log(error);
            }
        });
    }

    function getClaimsStatusData(period_type = 'D') {
        // Remove all rows except first one
        $('#claims_status_tbl tr').slice(1).remove();
        $('#claims_status_tbl').parent().find('div.overlay').fadeIn(100)
        let period = getPeriod(period_type);

        if (!period) return false;

        let start_date = moment(period.start_date).format('DD/MM');
        let end_date = moment(period.end_date).format('DD/MM');
        $('#claims_status_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
        let jsonObject = JSON.stringify(period);

        $.ajax({
            type: 'POST',
            url: encodeURI(base_url + "/returns/claims_status_wise"),
            data: jsonObject,
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            success: function(data) {
                let status = ['PENDING', 'APPROVED', 'REJECTED', 'FINANCE_REJECTED', 'SETTLED']
                let totalClaims = 0
                let totalApproved = 0
                let totalClaimed = 0

                status.forEach((element) => {
                    let row_element = data[element];
                    var rowData = '<tr>';
                    let st = element

                    if (element == 'PENDING') {
                        st = 'Pending From Marketplace'
                    }

                    if (element == 'APPROVED') {
                        st = 'Approved By Marketplace'
                    }

                    if (element == 'REJECTED') {
                        st = 'Rejected By Marketplace'
                    }
                    if (data.hasOwnProperty(element)) {
                        rowData += '<td class="left">' + st.replace('_', ' ') + '</td>'
                        rowData += '<td class="right">' + data[element].count + '</td>'
                        rowData += '<td class="right">' + data[element].claim_amount.toFixed(2) + '</td>'
                        rowData += '<td class="right">' + data[element].approved_amount.toFixed(2) + '</td>'

                        totalClaimed += +row_element.claim_amount;
                        totalApproved += +row_element.approved_amount;
                        totalClaims += +row_element.count;
                    } else {
                        rowData += '<td class="left">' + st.replace('_', ' ') + '</td>'
                        rowData += '<td class="right">0</td>'
                        rowData += '<td class="right">0</td>'
                        rowData += '<td class="right">0</td>'
                    }

                    rowData += '</tr>';
                    $("#claims_status_tbl").append(rowData);
                })
                let row = '<tr class="tfooter">'
                row += '<td class="left">Total</td>'
                row += '<td class="right">' + totalClaims + '</td>'
                row += '<td class="right">' + totalClaimed.toFixed(2) + '</td>'
                row += '<td class="right">' + totalApproved.toFixed(2) + '</td>'
                row += '</tr>'

                $('#claims_status_tbl').parent().find('div.overlay').fadeOut(100)
                $("#claims_status_tbl").append(row);
            },
            error: function(xhr, status, error) {
                $('#claims_status_tbl').parent().find('div.overlay').fadeOut(100)
                console.log(xhr);
                console.log(status);
                console.log(error);
            }
        });
    }

    function getCertificationStatusData(period_type = 'D') {
        // Remove all rows except first one
        $('#cert_prod_tbl tr').slice(1).remove();
        $('#cert_prod_tbl').parent().find('div.overlay').fadeIn(100)
        let period = getPeriod(period_type);

        if (!period) return false;

        let start_date = moment(period.start_date).format('DD/MM');
        let end_date = moment(period.end_date).format('DD/MM');
        $('#cert_prod_tbl').parent().parent().find('span.date_show').text(`${start_date} - ${end_date}`)
        let jsonObject = JSON.stringify(period);

        $.ajax({
            type: 'POST',
            url: encodeURI(base_url + "/operations/certification_productivity"),
            data: jsonObject,
            contentType: "application/json; charset=utf-8",
            dataType: 'json',
            success: function(data) {
                let status = ['ASSIGNED', 'ATTEMPTED', 'UNATTEMPTED']
                let totalCount = 0

                status.forEach((element) => {
                    let row_element = data[element];
                    var rowData = '<tr>';

                    if (data.hasOwnProperty(element)) {
                        rowData += '<td class="left">' + element.replace('_', ' ') + '</td>'
                        rowData += '<td class="right">' + data[element] + '</td>'

                        totalCount += +data[element];
                    } else {
                        rowData += '<td class="left">' + element.replace('_', ' ') + '</td>'
                        rowData += '<td class="right">0</td>'
                    }

                    rowData += '</tr>';
                    $("#cert_prod_tbl").append(rowData);
                })
        
                $('#cert_prod_tbl').parent().find('div.overlay').fadeOut(100)
                $("#cert_prod_tbl").append(row);
            },
            error: function(xhr, status, error) {
                $('#cert_prod_tbl').parent().find('div.overlay').fadeOut(100)
                console.log(xhr);
                console.log(status);
                console.log(error);
            }
        });
    }

</script>