

<div class="body_bulkupload_budgettarget">

	<div class="container-fluid">

		<div class="row">
			<div class="col-md-8">
				<h4>Budget Target</h4>
			</div>
			<div class="col-md-4">
				<a type="button" href="<?php echo base_url(); ?>assets/sample/budget_targets_template.csv" class="btn btn-primary" >Sample Template</a>
			</div>
		</div>

		<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;"> 
			<div class="col-md-6  col-sm-6 col-xs-6" style="padding:0px">

				<div class="form_bulkupload" id="budgettarget_bulkupload_form">
					<div class="form-group">
						<label class="col-md-5 control-label">Financial Year</label>
						<div class="col-md-7">
							<select class="form-control select_finyear">
								<?php 
									$Num_of_FinYears = 1;
									
									for($i=0; $i>-$Num_of_FinYears; $i--) { 
										$fin_year = get_FinancialYear($i);
									?>
									<option value="<?= $fin_year; ?>"><?= $fin_year; ?></option>
								<?php } ?>
							</select>
						</div> 
					</div>
					<br/>
					
					<div class="form-group">
						<label class="col-md-5 control-label">File</label>
						<div class="col-md-7">
							<input type="file" class="form-control-file custom-file-input" name="input_bulkupload_budgettarget" id="input_bulkupload_budgettarget">
						</div> 
					</div>
					<br/>
					
					<div class="form-group">
						<div class="col-md-12 text-center">
							<button type="button" class="btn btn-primary btn_submit" onclick="bulkUpload_BudgetTarget('#budgettarget_bulkupload_form')" >Bulk Update</button>
						</div> 
					</div>
				</div>

			</div>
		</div>

	</div>

</div>

<script type="text/javascript" language="javascript">
	
	function bulkUpload_BudgetTarget(form_id) {
		var columns_allowed = 20;

		form_id = (typeof form_id == 'object')? form_id : $(form_id);
		var isValid = true;

		let fin_year = form_id.find('.select_finyear').val();
		if (!isValidString(fin_year)) {
			alert('Please select Financial Year');
			return false;
		}

		var budget_data = [];
		
		var fileUpload = document.getElementById("input_bulkupload_budgettarget");
        var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;

        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
		        var reader = new FileReader();
                reader.onload = function (e) {
				    var rows = e.target.result.split("\n");
						
					for (var i = 2; i < rows.length; i++) {
						var cells = rows[i].split(",");
						
                    	if (cells.length > 1) {
							if (cells.length != columns_allowed) {
								alert("Total "+ columns_allowed +" columns should be there in uploading file");
								isValid = false;
								return false;
							}

							budget_data.push({
								'fin_month': cells[0].trim(),
								'qty_offl__amz_ob': cells[1].trim(),
								'qty_offl__fk_rvp': cells[2].trim(),
								'qty_offl__prexo_seltrue': cells[3].trim(),
								'qty_offl__bundles': cells[4].trim(),
								'qty_online__amz_ob': cells[5].trim(),
								'qty_online__fk_rvp': cells[6].trim(),
								'qty_online__prexo_seltrue': cells[7].trim(),
								'qty_offl__prexo_p2p': cells[8].trim(),
								'qty_offl__prexo_open': cells[9].trim(),
								'rev_offl__amz_ob': cells[10].trim(),
								'rev_offl__fk_rvp': cells[11].trim(),
								'rev_offl__prexo_seltrue': cells[12].trim(),
								'rev_offl__bundles': cells[13].trim(),
								'rev_online__amz_ob': cells[14].trim(),
								'rev_online__fk_rvp': cells[15].trim(),
								'rev_online__prexo_seltrue': cells[16].trim(),
								'rev_offl__prexo_p2p': cells[17].trim(),
								'rev_offl__prexo_open': cells[18].trim(),
								// 'rev_total': cells[19].trim().replace('\r', '')
							});
						}
					}
					if (!isValid) return false;

					let req_data = {
						'budget_data': budget_data,
						'fin_year': fin_year
					}
					
					$.ajax({
						url: '<?php echo base_url(); ?>admin/Reports/save_budget_data',
						type: 'POST',
						data: JSON.stringify(req_data),
						dataType: 'json',
						success:function(data){
							if (data.status) {
								toastr.success(data.message);

							} else {
								toastr.error(data.message);
							}
						},
						error:function(data){
							alert('Upload failed.');
						}			
					});
		        }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }
 
</script>
