<style>
    td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
    }

    tr {
        height: 30px;
    }

    th,
    td {
        white-space: nowrap;
    }
</style>

<div style="width: 100%; overflow-x: auto;">
    <table class="table table-striped DataTables" style="margin-left:15px; width:100%; white-space:nowrap;" id="batch_WiseList_table">
        <thead>
            <tr style="margin-left:5px; width:100%;">
                <th>DATE</th>
                <th>BATCH NO</th>
                <th>CATEGORY</th>
                <th>PRODUCT TYPE</th>
                <th>INWARD</th>
                <th>CIP</th>
                <th>CERTIFIED</th>
                <th>IN STOCK</th>
                <th>RFS</th>
                <th>FAULTED</th>
                <th>SOLD</th>
                <th>RETURN</th>
                <th>TRIAGE</th>
                <th>IN SERVICE</th>
                <th>FOR SERVICE</th>
                <th>FULLFILMENT</th>
                <th>BER</th>
                <th>RTV</th>
                <th>HOLD</th>
                <th>CLAIM</th>
                <!--<th>OTHER</th>-->
                <th>TOTAL</th>
            </tr>
        </thead>
    </table>
</div>
<script>
    var stockList_table;
    var department_id = getUserdata('department_id')

    function getUserdata(attribute) {

        var a = '';
        $.ajax({
            "url": "<?= base_url() ?>Web_api/getUserData/" + attribute,
            "type": "GET",
            "dataType": "json",
            "async": false,
            "success": function(data) {
                a = data.result;
            }
        })
        return a;
    }


    $(document).ready(function() {

        batchWiseDetails()

        function batchWiseDetails() {

            batch_WiseList_table = $('#batch_WiseList_table').DataTable({
                "width": "100%",
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "autoWidth": true,
                "aaSorting": [],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Analytics/batchWiseDetails",
                    "data": {},
                    "type": "GET",
                    "dataSrc": "data"
                },
                "dom": 'Bfrtip',
                "buttons": [{
                    "extend": 'csv',
                    "text": '<span class="fa fa-download" style="color:white;"></span>',
                    'className': 'btn btn-green down_btn',

                    "exportOptions": {
                        "columns": ':not(.details-control)'
                    }
                }],
                "columns": [

                    {
                        "data": "grndate"
                    },
                    {
                        "data": "batch_no"
                    },
                    {
                        "data": "stock_type"
                    },
                    {
                        "data": "product_type"
                    },
                    {
                        "data": "INWARD"
                    },
                    {
                        "data": "CIP"
                    },
                    {
                        "data": "CERTIFIED"
                    },
                    {
                        "data": "IN_STOCK"
                    },
                    {
                        "data": "RFS"
                    },
                    {
                        "data": "FAULTED"
                    },
                    {
                        "data": "SOLD"
                    },
                    {
                        "data": "RETURN"
                    },
                    {
                        "data": "TRIAGE"
                    },
                    {
                        "data": "IN_SERVICE"
                    },
                    {
                        "data": "FOR_SERVICE"
                    },
                    {
                        "data": "FFC"
                    },
                    {
                        "data": "BER"
                    },
                    {
                        "data": "RTV"
                    },
                    {
                        "data": "HOLD"
                    },
                    {
                        "data": "LOST"
                    },
                    // {
                    //     "data": function(data){
                    //         return data['total'] - data['IN_STOCK'] - data['RFS'] - data['FAULTED'] - data['SOLD'] - data['RETURN'] - data['IN_SERVICE'] - data['FFC']- data['TRIAGE']
                    //     }
                    // },
                    {
                        "data": "total"
                    },                ]
            });

        }



    })
</script>