<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 #stockList_table th, td { white-space: nowrap; text-align: left;}
</style>

<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;"> 
    <div class="col-md-6  col-sm-6 col-xs-6" style="padding:0px">
        
        <div class="form-group">
            <label class="col-lg-3 control-label">SELECT VARIANT</label>
            <div class="col-lg-8">
                <select id="stock_select_variant" class="form-control select_box"  style="width:100%">
                        <option value="">SELECT VARIANT</option>
                </select>
            </div> 
            <div class="col-lg-1">
                <button type="button" id="stock_add_button" class="btn btn-primary" onclick="addVariant()">Add</button>
            </div> 
        </div>
    </div>
</div>
<div style="width: 100%; overflow-x: auto; text-align: center;">
    <table class="table table-striped DataTables dt-body-center" style="margin-left:5px; width:100%; " id="stockList_table">
        <thead>
            <tr>
                <th></th>
                <th></th>
                <th>PRODUCT NAME</th>
                <th>TOTAL<br>STOCK</th>
                <th>RFS</th>
                <th>SOLD</th>
                <th>IN STOCK</th>
                <th>FAULTED</th>
                <th>OTHER<br>STOCK</th>	
                
            </tr>
        </thead>		
    </table>
</div>	
<script>

    dropdownVariant();
    var stockList_table;
    var department_id = getUserdata('department_id')

    function getUserdata(attribute){
    
        var a='';
        $.ajax({
            "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
            "type": "GET",
            "dataType": "json",
            "async": false,
            "success": function(data){
                a = data.result;
            }
        })
        return a;
}
    function dropdownVariant(){

        var option_str = ''
        $.ajax({
            type: "GET",
            url: "<?=base_url()?>admin/Analytics/getVariantList",
            data: {},
            dataType:"json",
            async: false,
            success: function(data){

                $.each(data.result, function(i,v){
                    option_str += '<option value="'+data.result[i].variant+'">'+data.result[i].name+'</option>'
                })
                
            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
        $("#stock_select_variant").append(option_str);
    }

    function addVariant(){

        var variant = $("#stock_select_variant").val()

        if(variant == '' || variant == 0 || variant == undefined || variant == null){
            toastr.error("Please Select a Variant")
            return false
        }

        $.ajax({
            "url": "<?=base_url()?>admin/Analytics/addVariantForStockOverview",
            "data": { "variant": variant},
            "method": "get",
            "dataType": "json",
            "success": function(data){
                        
                        if(data.status == 2){
                            toastr.error("Variant Already Added")
                            return false
                        }
                        if(data.status != 1){
                            toastr.error("Failed to Add Variant")
                            return false
                        }
                        toastr.success("Variant Added Successfully")
                        stockList_table.ajax.reload();
                        return true                       
                    }
        })
    }

    function removeVariant(variant_val){
        var variant = variant_val

        if(variant == '' || variant == 0 || variant == undefined || variant == null){
            toastr.error("Please Select a Variant")
            return false
        }

        $.ajax({
            "url": "<?=base_url()?>admin/Analytics/removeVariantForStockOverview",
            "data": { "variant": variant},
            "method": "get",
            "dataType": "json",
            "success": function(data){

                        if(data.status != 1){
                            toastr.error("Failed to Remove Variant")
                            return false
                        }
                        toastr.success("Variant Removed Successfully")
                        stockList_table.ajax.reload();
                        return true                       
                    }
        })
    }
$(document).ready(function(){

    getStockList()

    function getStockList(){

        stockList_table = $('#stockList_table').DataTable({
                        "width": "100%",
                        "paging":true,
                        "destroy":true,
                        "searching":true,
                        "processing": true,
                        "serverSide": false,  
                        //"scrollY": 390,
                       // "scrollX": "100%",
                       // "scrollCollapse": true,
                        "autoWidth": true,
                        "aaSorting": [],
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Analytics/getDeviceStockList",
							"data": {},
							"type": "GET",
                            "dataSrc": "data"
                        },
                        "columns": [
                            {
                             "data": function(data){
                                    if(department_id == 2){
                                        return '<span class="fa fa-trash" style="color:red; font-size:16px;" onclick="removeVariant(\''+data.variant+'\')"></span>'
                                    }else{
                                        return null
                                    }
                                }
                            },
                            {
                                "className":'details-control',
                                "data": null,
                                "defaultContent": ''
                            },
                            { "data": "device_name_ram_rom"},
                            { "data": "total_stock"},
                            { "data": "rfs" },	
                            { "data": "sold" },	
                            { "data": "in_stock" },
                            { "data": "faulted" },						
                            { "data": "other_stock" },
                        ]
        });

    }

    $('#stockList_table tbody').on('click', 'td.details-control', function () {
			var tr = $(this).closest('tr');
			var row = stockList_table.row( tr );
			if ( row.child.isShown() ) {
				row.child.hide();
				tr.removeClass('shown');
			}else {
				row.child( format(row.data()) ).show();
				tr.addClass('shown');
			}
		}) ;

})

        

		function format ( d ) {
			// `d` is the original data object for the row
			var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;margin-left:50px;">';
				$.ajax( {
				url: encodeURI("<?php echo base_url(); ?>admin/Analytics/getVariantSaletype?variant="+d.variant),
				type:"GET",
				dataType: 'json',
				async: false,
				success: function ( data ) {
					if(data.status != 1){
						childtable+='<tr><td>No Records Found</td></tr>';
					}else{
						childtable += '<th>STATUS</th><th>ONLINE</th><th>OFFLINE</th><th>OTHER</th>';
						childtable += 
                                '<tr>'+
                                    '<td>RFS</td>'+
                                    '<td>'+data.online.rfs+'</td>'+
                                    '<td>'+data.offline.rfs+'</td>'+
                                    '<td>'+data.other.rfs+'</td>'+
                                '</tr>'+
                                '<tr>'+
                                    '<td>SOLD</td>'+
                                    '<td>'+data.online.sold+'</td>'+
                                    '<td>'+data.offline.sold+'</td>'+
                                    '<td>'+data.other.sold+'</td>'+
                                '</tr>'+
                                '<tr>'+
                                    '<td>FAULTED</td>'+
                                    '<td>'+data.online.faulted+'</td>'+
                                    '<td>'+data.offline.faulted+'</td>'+
                                    '<td>'+data.other.faulted+'</td>'+
                                '</tr>'+
                                '<tr>'+
                                    '<td>HOLD</td>'+
                                    '<td>'+data.online.hold+'</td>'+
                                    '<td>'+data.offline.hold+'</td>'+
                                    '<td>'+data.other.hold+'</td>'+
                                '</tr>'+
                                '<tr>'+
                                    '<td>INSTOCK</td>'+
                                    '<td>'+data.online.in_stock+'</td>'+
                                    '<td>'+data.offline.in_stock+'</td>'+
                                    '<td>'+data.other.in_stock+'</td>'+
                                '</tr>';
					}
				}
			} );
				
			childtable +='</table>';
			return childtable
		}
</script>