<style>
	ul.caution_note_list {
		font-size: 12px;
		list-style: none;
		text-transform: none;
	}
	ul.caution_note_list > li {
		margin-bottom: 10px;
	}
	ul.caution_note_list li p {
		margin-bottom: 0px;
	}

	.btns_div .btn {
		text-transform: initial;
		border-radius: 10px;
	}

	.order_report_id {
		font-size: 20px;
		padding: 15px;
		color: #f05050;
	}
	.report_url_div {
		margin-left: 30px;
		max-height: 100px;
		overflow: auto;
	}
	.report_url_div .report_url {
		font-size: 10px;
		line-height: 1.4;
		display: inline-block;
	}
	.report_data label {
		display: block;
		margin-bottom: 5px;
		line-height: 1;
		font-size: 12px;
		font-style: italic;
	}
	.report_data .result_report_id,
	.report_data .result_status {
		color: #24b145;
		font-size: 16px;
		font-style: normal;
		margin-left: 10px;
	}
</style>

<?php 
	$report_type_arr = [
		'All Orders' => 'GET_FLAT_FILE_ALL_ORDERS_DATA_BY_ORDER_DATE_GENERAL',
		'Shipments' => 'GET_FBA_FULFILLMENT_CUSTOMER_SHIPMENT_SALES_DATA',
		'FBA_RETURNS' => 'GET_FBA_FULFILLMENT_CUSTOMER_RETURNS_DATA',
	];
?>


<!-- Page Spinner-->
<div class="page_spinner" style="display: none;">
    <div class="inner_block">
        <div class="spinner_element"></div>
    </div>
</div>

<div>
	<div class="row">
		<div class="col-md-8">
			<h4>Amazon API</h4>
		</div>
		<!-- <div class="col-md-4">
			<a type="button" href="<?php //echo base_url(); ?>assets/sample/devicecharging_status_template.csv" class="btn btn-primary" >Sample Template</a>
		</div> -->
	</div>

	<div class="page_container" style="padding:10px; text-align:left; text-transform:initial;">

		<div class="row">

			<div class="col-md-12 form-horizontal"> 
				<div class="col-md-12" style="padding: 15px; border: 2px dashed #ccc;">

					<div class="form_bulkupload" id="amazonapi_inputs_form">
						<div class="form-group">
							<label class="col-md-3 control-label">Report Type</label>
							<div class="col-md-7">
								<!-- <input type="text" class="form-control report_type" name="report_type" style="width: 500px;" value="GET_FBA_FULFILLMENT_CUSTOMER_SHIPMENT_SALES_DATA"> -->
								<select class="form-control report_type" name="report_type">
									<?php foreach($report_type_arr as $k => $v) { ?>
										<option value="<?php echo $v; ?>"><?php echo $k; ?></option>
									<?php } ?>
								</select>
							</div>
						</div>
						
						<div class="form-group">
							<label class="col-md-3 control-label">Period of Month</label>

							<div class="col-md-3">
								<select class="form-control sel_month" name="sel_month" onchange="DateRange('#amazonapi_inputs_form')" style="width: 150px;">
									<option value="">Select Month</option>
								<?php
									$mnth_arr = range(1, 12);
									foreach($mnth_arr as $m) {
										$month_name = DateTime::createFromFormat('!m', $m)->format('F');
										$m = str_pad($m, 2, '0', STR_PAD_LEFT); 
									?>
										<option value="<?php echo $m; ?>"><?php echo $m . ' - ' . $month_name; ?></option>
								<?php } ?>
								</select>
							</div>
							<div class="col-md-3">
								<select class="form-control sel_year" name="sel_year" onchange="DateRange('#amazonapi_inputs_form')" style="width: 150px;">
								<?php
									$year = (int) date('y');
									for($i = $year; $i >= 23; $i--) { ?>
										<option value="<?php echo '20'.$i; ?>"><?php echo '20'.$i ?></option>
									<?php } ?>
								</select>

							</div>
						</div>
						
						<div class="form-group">
							<label class="col-md-3 control-label">Date Range</label>
							<div class="col-md-3">
								<input type="date" class="form-control from_date" name="from_date" style="width: 150px;" disabled>
							</div>
							<div class="col-md-3">
								<input type="date" class="form-control to_date" name="to_date" style="width: 150px;" disabled>
							</div> 
						</div>
						
						<div class="form-group">
							<div class="col-md-9 col-md-offset-3">
								<div style="display: flex; align-items: center;">
									<input type="checkbox" id="force_new_report" name="force_new_report" value="Yes" style="margin-top: 0;">
									<label for="force_new_report" style="margin-left: 10px; margin-bottom: 0; cursor: pointer;">Force New Report</label>
								</div>
							</div>
						</div>
						
						<div class="form-group" style="margin-top: 50px;">
							<div class="col-md-12 text-left">
								<!-- <button type="button" class="btn btn-danger btn_clear" onclick="clearFields_AmazonApi('#amazonapi_inputs_form')" >Clear</button> -->
								<button type="button" class="btn btn-danger btn_submit" onclick="generate_OrderReport('#amazonapi_inputs_form')" >Generate Order Report</button>

								<label style="margin-left: 30px;">Report ID: <span class="order_report_id" data-report_id="0"></span></label>
							</div> 
						</div>
					</div>
					
				</div>

				<!-- <div class="col-md-6  col-sm-6 col-xs-6 hidden" style="padding:0px">
					<div>
						<ul class="caution_note_list">
							<li>
								<p class="info">Status Codes Description:</p>
								<ul class="sub_list">
									<li>1 - Charging Completed</li>
									<li>0 - Not Charged</li>
								</ul>
							</li>
						</ul>
					</div>
				</div> -->

			</div>

			
			<div class="col-md-12 ">
				<div class="col-md-12">
					
					<div class="fetch_report_div" style="margin-top: 50px; display: none1;">
						
						<div class="fetch_url_div" style="margin-bottom: 30px; display: flex; align-items: center;">
							<button type="button" class="btn btn-primary btn_fetch_report" onclick="fetch_generated_OrderReport()">Fetch Report URL</button>

							<div class="report_url_div" style="margin-left: 30px;">
								<label style="margin-bottom: 5px;">Report Document URL:</label>
								<a class="report_url" href=""></a>
							</div>
						</div>
						
						<div class="fetch_data_div" style="margin-bottom: 30px; display: flex; align-items: center;">
							<button type="button" class="btn btn-success btn_fetch_report_data" onclick="fetch_OrderReport_Data()">Fetch Report Data</button>

							<div class="report_data_div" style="margin-left: 30px;">
								<label style="margin-bottom: 5px;">Final Status:</label>
								<div class="report_data" style="display: none;">
									<label>Report ID: <span class="result_report_id"></span></label>
									<label>Final Status: <span class="result_status"></span></label>
								</div>
							</div>
						</div>

					</div>
				</div>
			</div>
		
		</div>

		<hr style="border: 3px solid #e4eaec">

	</div>
</div>						

<script type="text/javascript" language="javascript">
	
	let ajax_beforeSend = function() {
		$('.page_spinner').show();
	}
	let ajax_complete = function() {
		$('.page_spinner').hide();
	}

	$('#force_new_report').on('change', function() {
		if ($(this).is(':checked')) {
			let conf = window.confirm("Are you sure to request a New Report Document?");
			if (!conf) {
				$(this).prop('checked', false);
			}
		}
	});

	function clearFields_AmazonApi(form_id) {
		form_id = (typeof form_id == 'object')? form_id : $(form_id);

		// var fileUpload = document.getElementById("input_bulkupload_chargingdevice");
		
		form_id.find('input').val('');
		// fileUpload.files = [];
	}

	function DateRange(form_id) {
		form_id = (typeof form_id == 'object')? form_id : $(form_id);
		
		let sel_year = form_id.find('.sel_year').val();
		let sel_month = form_id.find('.sel_month').val();

		form_id.find('.from_date').val(sel_year +'-'+ sel_month +'-01');
		if (sel_month == '12') {
			sel_year = parseInt(sel_year) + 1;
			sel_month = '01';
			form_id.find('.to_date').val(sel_year +'-'+ sel_month +'-01');
		} else {
			sel_month = parseInt(sel_month) + 1 + '';
			sel_month = (sel_month.length == 1)? '0'+sel_month : sel_month;
			form_id.find('.to_date').val(sel_year +'-'+ sel_month +'-01');
		}
	}
 
	function generate_OrderReport(form_id) {
		form_id = (typeof form_id == 'object')? form_id : $(form_id);
		var isValid = true;

		var report_type = form_id.find('.report_type').val();
		var from_date = form_id.find('.from_date').val();
		var to_date = form_id.find('.to_date').val();
		var force_new_report = form_id.find('#force_new_report').is(':checked');
		if (!isValidString(report_type)) {
			alert('Please enter Report Name');
			return false;
		}
		if (!isValidString(from_date)) {
			alert('Please enter From Date');
			return false;
		}
		if (!isValidString(to_date)) {
			alert('Please enter To Date');
			return false;
		}

		let req_data = {
			'report_type' : report_type,
			'from_date' : from_date,
			'to_date' : to_date,
			'force_new_report' : force_new_report
		};

		if (force_new_report) {
			let conf = window.confirm("Are you sure to request a New Report Document?");
			if (!conf) {
				return false;
			}
		}
		
		$('.order_report_id').text('').data('report_id', 0);
		$('.fetch_report_div .report_url').text('').attr('href', '');
		$('.fetch_report_div .report_data span').text('');
		$('.fetch_report_div .report_data').hide();
		$('.fetch_report_div').hide();

		$.ajax({
			url: '<?php echo base_url(); ?>admin/Amazon/generate_ReportOrderId',
			type: 'POST',
			data: JSON.stringify(req_data),
			dataType: 'json',
			beforeSend: ajax_beforeSend,
			complete: ajax_complete,
			success:function(data) {
				$('#force_new_report').prop('checked', false);

				if (data.status) {
					toastr.success(data.message);

					if (data.reportId > 0) {
						$('.order_report_id').text(data.reportId).data('report_id', data.reportId);
						$('.fetch_report_div').show();
					}

					// clearFields_AmazonApi(form_id);
				} else {
					toastr.error(data.message);
				}
			},
			error:function(data) {
				// alert('Something wrong');
			}
		});
		
    }

	function fetch_generated_OrderReport() {
		let req_data = {
			reportId: $('.order_report_id').data('report_id')
		};

		$('.fetch_report_div .report_url').text('');
		$('.fetch_report_div .report_data span').text('');
		$('.fetch_report_div .report_data').hide();

		$.ajax({
			url: '<?php echo base_url(); ?>admin/Amazon/fetch_generated_OrderReport',
			type: 'POST',
			data: JSON.stringify(req_data),
			dataType: 'json',
			beforeSend: ajax_beforeSend,
			complete: ajax_complete,
			success:function(data){
				if (data.status) {
					toastr.success(data.message);

					$('.fetch_report_div .report_url').text(data.url).attr('href', data.url);

				} else {
					toastr.error(data.message);
				}
			},
			error:function(data){
				// alert('Something wrong');
			}			
		});
    }

	function fetch_OrderReport_Data() {
		let req_data = {
			reportId: $('.order_report_id').data('report_id')
		};
		$('.fetch_report_div .report_data span').text('');
		$('.fetch_report_div .report_data').hide();

		$.ajax({
			url: '<?php echo base_url(); ?>admin/Amazon/fetch_OrderReport_Data',
			type: 'POST',
			data: JSON.stringify(req_data),
			dataType: 'json',
			beforeSend: ajax_beforeSend,
			complete: ajax_complete,
			success:function(data){
				if (data.status) {
					toastr.success(data.message);
				} else {
					toastr.error(data.message);
				}

				$('.fetch_report_div .result_report_id').html(req_data.reportId);
				$('.fetch_report_div .result_status').html(data.message);
				$('.fetch_report_div .report_data').show();

			},
			error:function(data){
				// alert('Something wrong');
			}			
		});
    }
 
</script>	 
