<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Vendor_Model extends MY_Model {

    public function getCustomers() {
        $this->db->select('vendor_id,name');
        $this->db->where_in('user_type', array('INDIVIDUAL', 'DEALER'));
        $result = $this->db->get('tbl_vendor')->result_array();

        return $result;
    }

    public function getSalesman() {
        $this->db->select('fullname,sales_code');
        $this->db->where_in('user_type', array('INDIVIDUAL', 'DEALER'));
        $result = $this->db->select('fullname,sales_code')->get('tbl_account_details')->result_array();

        return $result;
    }
	
	public function createVendors($vendors){
		$record[] = array();
		$last_id = $this->db->select_max('vendor_id','max')->get('tbl_vendor')->row()->max;
		$vendor_type = array("SLYSPB2B"=>"BULK",
							"SLYB-H-B2C"=>"INDIVIDUAL",
							"SLYB-H-B2B"=>"DEALER",
							"SLYSPPTR"=>"PARTNERS",
							"SLYB-H-ONL"=>"ONLINE",
							"SLYB-H-FF"=>"FULFILLMENT"
						);
		$index = 0;		
		foreach($vendors as $vendor){
			$last_id = $last_id + 1;
			$user_type = strtoupper($vendor['user_type']);
			$vendor_code = array_keys($vendor_type,$user_type)[0];
			
			if(empty($vendor_code)){
				return 'Invalid Customer Type for '.$vendor['name'];
			}

			$record[$index] = array(
				'added_userid'=>$this->session->userdata('user_id'),
				'name'=>$vendor['name'],
				'user_type'=>$user_type,
				'company'=>$vendor['company'],				
				'email'=>$vendor['email'],
				'mobile'=>$vendor['mobile'],
				'address'=>$vendor['address'],
				'city'=>$vendor['city'],
				'state'=>$vendor['state'],
				'pincode'=>$vendor['pincode'],
				'country'=>'INDIA',
				'vendor_code'=>$vendor_code.'-'.$last_id,				
				'used_type'=>'buyer',	
				'gst_no'=>$vendor['gst_no'], 	
			);			
			$index++;
		}
		
		$this->db->insert_batch('tbl_vendor',$record);		
		return "success";
	}
	
}
